# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{http_parser}
  s.version = "0.1.3"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Graham Batty"]
  s.date = %q{2010-03-17}
  s.description = %q{This gem provides a (hopefully) high quality http parser library that can
    build request information iteratively as data comes over the line without
    requiring the caller to maintain the entire body of the request as a single
    string in memory.}
  s.email = %q{graham@stormbrew.ca}
  s.extra_rdoc_files = ["LICENSE", "README.rdoc"]
  s.files = [".document", ".gitignore", "LICENSE", "README.rdoc", "Rakefile", "VERSION", "bench/bench_helper.rb", "bench/http_parser_bench.rb", "lib/http/native_parser.rb", "lib/http/parser.rb", "spec/http_parser_spec.rb", "spec/spec.opts", "spec/spec_helper.rb"]
  s.homepage = %q{http://github.com/stormbrew/http_parser}
  s.rdoc_options = ["--charset=UTF-8"]
  s.require_paths = ["lib"]
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{HTTP Parser Library}
  s.test_files = ["spec/http_parser_spec.rb", "spec/spec_helper.rb"]

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_development_dependency(%q<rspec>, [">= 1.2.9"])
    else
      s.add_dependency(%q<rspec>, [">= 1.2.9"])
    end
  else
    s.add_dependency(%q<rspec>, [">= 1.2.9"])
  end
end
