
if (CMAKE_VERSION VERSION_LESS 2.8.3)
    message(FATAL_ERROR "Qt 5 requires at least CMake version 2.8.3")
endif()

get_filename_component(_qt5WebEngine_install_prefix "/opt/local/libexec/qt5/lib/cmake/Qt5WebEngine/../../../" ABSOLUTE)

# For backwards compatibility only. Use Qt5WebEngine_VERSION instead.
set(Qt5WebEngine_VERSION_STRING 5.6.3)

set(Qt5WebEngine_LIBRARIES Qt5::WebEngine)

macro(_qt5_WebEngine_check_file_exists file)
    if(NOT EXISTS "${file}" )
        message(FATAL_ERROR "The imported target \"Qt5::WebEngine\" references the file
   \"${file}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()

macro(_populate_WebEngine_target_properties Configuration LIB_LOCATION IMPLIB_LOCATION)
    set_property(TARGET Qt5::WebEngine APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_qt5WebEngine_install_prefix}/lib/${LIB_LOCATION}")
    _qt5_WebEngine_check_file_exists(${imported_location})
    set_target_properties(Qt5::WebEngine PROPERTIES
        "INTERFACE_LINK_LIBRARIES" "${_Qt5WebEngine_LIB_DEPENDENCIES}"
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        # For backward compatibility with CMake < 2.8.12
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_Qt5WebEngine_LIB_DEPENDENCIES}"
    )

endmacro()

if (NOT TARGET Qt5::WebEngine)

    set(_Qt5WebEngine_OWN_INCLUDE_DIRS
      "${_qt5WebEngine_install_prefix}/lib/QtWebEngine.framework"
      "${_qt5WebEngine_install_prefix}/lib/QtWebEngine.framework/Headers"
    )
    set(Qt5WebEngine_PRIVATE_INCLUDE_DIRS
        "${_qt5WebEngine_install_prefix}/lib/QtWebEngine.framework/Versions/5/Headers/5.6.3/"
        "${_qt5WebEngine_install_prefix}/lib/QtWebEngine.framework/Versions/5/Headers/5.6.3/QtWebEngine"
    )

    foreach(_dir ${_Qt5WebEngine_OWN_INCLUDE_DIRS})
        _qt5_WebEngine_check_file_exists(${_dir})
    endforeach()


    set(Qt5WebEngine_INCLUDE_DIRS ${_Qt5WebEngine_OWN_INCLUDE_DIRS})

    set(Qt5WebEngine_DEFINITIONS -DQT_WEBENGINE_LIB)
    set(Qt5WebEngine_COMPILE_DEFINITIONS QT_WEBENGINE_LIB)
    set(_Qt5WebEngine_MODULE_DEPENDENCIES "WebEngineCore;Quick;Gui;Qml;Core")


    set(_Qt5WebEngine_FIND_DEPENDENCIES_REQUIRED)
    if (Qt5WebEngine_FIND_REQUIRED)
        set(_Qt5WebEngine_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt5WebEngine_FIND_DEPENDENCIES_QUIET)
    if (Qt5WebEngine_FIND_QUIETLY)
        set(_Qt5WebEngine_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt5WebEngine_FIND_VERSION_EXACT)
    if (Qt5WebEngine_FIND_VERSION_EXACT)
        set(_Qt5WebEngine_FIND_VERSION_EXACT EXACT)
    endif()

    set(Qt5WebEngine_EXECUTABLE_COMPILE_FLAGS "")

    foreach(_module_dep ${_Qt5WebEngine_MODULE_DEPENDENCIES})
        if (NOT Qt5${_module_dep}_FOUND)
            find_package(Qt5${_module_dep}
                5.6.3 ${_Qt5WebEngine_FIND_VERSION_EXACT}
                ${_Qt5WebEngine_DEPENDENCIES_FIND_QUIET}
                ${_Qt5WebEngine_FIND_DEPENDENCIES_REQUIRED}
                PATHS "/opt/local/libexec/qt5/lib/cmake/Qt5WebEngine/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT Qt5${_module_dep}_FOUND)
            set(Qt5WebEngine_FOUND False)
            return()
        endif()

        list(APPEND Qt5WebEngine_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
        list(APPEND Qt5WebEngine_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
        list(APPEND Qt5WebEngine_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
        list(APPEND Qt5WebEngine_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
        list(APPEND Qt5WebEngine_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
    endforeach()
    list(REMOVE_DUPLICATES Qt5WebEngine_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt5WebEngine_PRIVATE_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt5WebEngine_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt5WebEngine_COMPILE_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt5WebEngine_EXECUTABLE_COMPILE_FLAGS)

    set(_Qt5WebEngine_LIB_DEPENDENCIES "Qt5::WebEngineCore;Qt5::Quick;Qt5::Gui;Qt5::Qml;Qt5::Core")


    add_library(Qt5::WebEngine SHARED IMPORTED)
    set_property(TARGET Qt5::WebEngine PROPERTY FRAMEWORK 1)

    set_property(TARGET Qt5::WebEngine PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt5WebEngine_OWN_INCLUDE_DIRS})
    set_property(TARGET Qt5::WebEngine PROPERTY
      INTERFACE_COMPILE_DEFINITIONS QT_WEBENGINE_LIB)

    _populate_WebEngine_target_properties(RELEASE "QtWebEngine.framework/QtWebEngine" "" )




    file(GLOB pluginTargets "/opt/local/libexec/qt5/lib/cmake/Qt5WebEngine/Qt5WebEngine_*Plugin.cmake")

    macro(_populate_WebEngine_plugin_properties Plugin Configuration PLUGIN_LOCATION)
        set_property(TARGET Qt5::${Plugin} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

        set(imported_location "${_qt5WebEngine_install_prefix}/plugins/${PLUGIN_LOCATION}")
        _qt5_WebEngine_check_file_exists(${imported_location})
        set_target_properties(Qt5::${Plugin} PROPERTIES
            "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        )
    endmacro()

    if (pluginTargets)
        foreach(pluginTarget ${pluginTargets})
            include(${pluginTarget})
        endforeach()
    endif()




_qt5_WebEngine_check_file_exists("/opt/local/libexec/qt5/lib/cmake/Qt5WebEngine/Qt5WebEngineConfigVersion.cmake")

endif()
