# Interface methods for submodule: vnl_matrix_fixed
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate



# Interface methods for class: vnl_matrix_fixed
class vnl_matrix_fixedProxy():
	def size(self) -> int:
		""""""
		...

	def rows(self) -> int:
		""""""
		...

	def cols(self) -> int:
		""""""
		...

	def columns(self) -> int:
		""""""
		...

	def put(self, r: int, c: int, v: float) -> None:
		""""""
		...

	def get(self, r: int, c: int) -> float:
		""""""
		...

	@overload
	def set(self, r: int, c: int, v: float) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set(self, d) -> vnl_matrix_fixed:
		""""""
		...

	def __call__(self, r: int, c: int) -> float:
		""""""
		...

	def fill(self, arg0: float) -> vnl_matrix_fixed:
		""""""
		...

	def fill_diagonal(self, arg0: float) -> vnl_matrix_fixed:
		""""""
		...

	def set_diagonal(self, arg0: vnl_vector) -> vnl_matrix_fixed:
		""""""
		...

	def copy_in(self, arg0) -> vnl_matrix_fixed:
		""""""
		...

	def copy_out(self, arg0) -> None:
		""""""
		...

	def inplace_transpose(self) -> vnl_matrix_fixed:
		""""""
		...

	def transpose(self) -> vnl_matrix_fixed:
		""""""
		...

	def conjugate_transpose(self) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def update(self, arg0: vnl_matrix, top: int = 0, left: int = 0) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def update(self, m: vnl_matrix_fixed, top: int = 0, left: int = 0) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set_column(self, i: int, v) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set_column(self, i: int, value: float) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set_column(self, j: int, v: vnl_vector) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set_column(self, j: int, v: vnl_vector_fixed) -> vnl_matrix_fixed:
		""""""
		...

	def set_columns(self, starting_column: int, M: vnl_matrix) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set_row(self, i: int, v) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set_row(self, i: int, value: float) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set_row(self, i: int, arg1: vnl_vector) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def set_row(self, i: int, arg1: vnl_vector_fixed) -> vnl_matrix_fixed:
		""""""
		...

	@overload
	def extract(self, r: int, c: int, top: int = 0, left: int = 0) -> vnl_matrix:
		""""""
		...

	@overload
	def extract(self, sub_matrix: vnl_matrix, top: int = 0, left: int = 0) -> None:
		""""""
		...

	def get_row(self, row: int) -> vnl_vector_fixed:
		""""""
		...

	def get_column(self, col: int) -> vnl_vector_fixed:
		""""""
		...

	def get_rows(self, i: vnl_vector) -> vnl_matrix:
		""""""
		...

	def get_columns(self, i: vnl_vector) -> vnl_matrix:
		""""""
		...

	def get_n_rows(self, rowstart: int, n: int) -> vnl_matrix:
		""""""
		...

	def get_n_columns(self, colstart: int, n: int) -> vnl_matrix:
		""""""
		...

	def get_diagonal(self) -> vnl_vector:
		""""""
		...

	def flatten_row_major(self) -> vnl_vector_fixed:
		""""""
		...

	def flatten_column_major(self) -> vnl_vector_fixed:
		""""""
		...

	def set_identity(self) -> vnl_matrix_fixed:
		""""""
		...

	def flipud(self) -> vnl_matrix_fixed:
		""""""
		...

	def fliplr(self) -> vnl_matrix_fixed:
		""""""
		...

	def normalize_rows(self) -> vnl_matrix_fixed:
		""""""
		...

	def normalize_columns(self) -> vnl_matrix_fixed:
		""""""
		...

	def scale_row(self, row: int, value: float) -> vnl_matrix_fixed:
		""""""
		...

	def scale_column(self, col: int, value: float) -> vnl_matrix_fixed:
		""""""
		...

	def swap(self, that: vnl_matrix_fixed) -> None:
		""""""
		...

	def array_one_norm(self) -> float:
		""""""
		...

	def array_two_norm(self) -> float:
		""""""
		...

	def array_inf_norm(self) -> float:
		""""""
		...

	def absolute_value_sum(self) -> float:
		""""""
		...

	def absolute_value_max(self) -> float:
		""""""
		...

	def operator_one_norm(self) -> float:
		""""""
		...

	def operator_inf_norm(self) -> float:
		""""""
		...

	def frobenius_norm(self) -> float:
		""""""
		...

	def fro_norm(self) -> float:
		""""""
		...

	def rms(self) -> float:
		""""""
		...

	def min_value(self) -> float:
		""""""
		...

	def max_value(self) -> float:
		""""""
		...

	def arg_min(self) -> int:
		""""""
		...

	def arg_max(self) -> int:
		""""""
		...

	def mean(self) -> float:
		""""""
		...

	def empty(self) -> bool:
		""""""
		...

	@overload
	def is_identity(self) -> bool:
		""""""
		...

	@overload
	def is_identity(self, tol: float) -> bool:
		""""""
		...

	@overload
	def is_zero(self) -> bool:
		""""""
		...

	@overload
	def is_zero(self, tol: float) -> bool:
		""""""
		...

	def is_equal(self, rhs: vnl_matrix_fixed, tol: float) -> bool:
		""""""
		...

	def is_finite(self) -> bool:
		""""""
		...

	def has_nans(self) -> bool:
		""""""
		...

	def assert_size(self, arg0: int, arg1: int) -> None:
		""""""
		...

	def assert_finite(self) -> None:
		""""""
		...

	def read_ascii(self, s) -> bool:
		""""""
		...

	def data_block(self):
		""""""
		...

	def as_matrix(self) -> vnl_matrix:
		""""""
		...

	def begin(self):
		""""""
		...

	def end(self):
		""""""
		...

	def operator_eq(self, rhs: vnl_matrix_fixed) -> bool:
		""""""
		...

	def print(self, os) -> None:
		""""""
		...

	@staticmethod
	@overload
	def add(a, b, r) -> None:
		""""""
		...

	@staticmethod
	@overload
	def add(a, b: float, r) -> None:
		""""""
		...

	@staticmethod
	@overload
	def sub(a, b, r) -> None:
		""""""
		...

	@staticmethod
	@overload
	def sub(a, b: float, r) -> None:
		""""""
		...

	@staticmethod
	@overload
	def sub(a: float, b, r) -> None:
		""""""
		...

	@staticmethod
	@overload
	def mul(a, b, r) -> None:
		""""""
		...

	@staticmethod
	@overload
	def mul(a, b: float, r) -> None:
		""""""
		...

	@staticmethod
	@overload
	def div(a, b, r) -> None:
		""""""
		...

	@staticmethod
	@overload
	def div(a, b: float, r) -> None:
		""""""
		...

	@staticmethod
	def equal(a, b) -> bool:
		""""""
		...

