__version__   = "$Revision: 1.2 $"[11:-2]
__copyright__ = """Copyright (c) 2003 Not Another Corporation Incorporated
                   www.notanothercorporation.com"""
__license__   = """Licensed under the GNU LGPL

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__doc__ = """
** %(name)s **
File version %(version)s::
 
    %(copyright)s

    %(license)s

Part of the C{mongoose} package, provides the C{SafeReadOnlyMixin} object
which forces read-only retrieval of information from classes it is mixed into.

The information is is fixed when the object is created.

I{* $Id: safereadonlymixin.py,v 1.2 2003/09/24 17:03:31 philiplindsay Exp $ *}
""" % {'name':__name__, 'version':__version__, 'copyright':__copyright__,
       'license':__license__}


STR_FORMAT = "%s: %s"
class SafeReadOnlyMixin:
    """
    This turns classes into I{Safe} & I{ReadOnly} objects.

    I{Safe} because they never return an C{AttributeError}, if no attribute
    of the requested name is found the value C{None} is returned.

    I{ReadOnly} because once the values are set at the time of creation
    they cannot be changed. Note: If the objects I{themselves} are mutable
    then we don't stop that.
    """
    
    __metaclass__ = type # Either do this or turn this into a new-style class
                         # Enables the use of 'super' in inheriting classes.

    _info = {}
    
    def __init__(self, infoDict, wrapper = lambda x : x):
        """
        Sets the read-only values.

        @param infoDict: The dictionary of values.
        @param wrapper:  A function all values will be processed by before
                         storing. This enables the values to be cast to
                         known types, for example.
        """
        
        # TODO: Is there some way to do this formatting all in one hit?
        _formattedItems = []

        for (key, value) in infoDict.iteritems():
            self._info[key] = wrapper(value)
            _formattedItems.append(STR_FORMAT % (key, self._info[key]))

        _formattedItems.sort()
        self.__dict__['_str'] = "\n".join(_formattedItems)


    def __setattr__(self, name, value):
        """
        Causes the object to be read-only object.
        """
        pass


    def __getattr__(self, name):
        """
        Returns the value of the attribute C{name} or the value of
        C{None} if no attribute of the requested name is
        known.
        """
        return self._info.get(name, None)


    def __repr__(self):
        """
        The 'formal' representation of ourself.
        """
        return "<%s object at 0x%x %s>" % (self.__module__,
                                           id(self),
                                           str(self._info))

    def __str__(self):
        """
        The 'informal' string representation of ourself.

        (A nicely formatted dump of all our read-only values.)
        """
        return self.__dict__['_str']

