/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hpsf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;

public final class ReadTitle {
    private ReadTitle() {
    }

    public static void main(String[] args) throws IOException {
        String filename = args[0];
        POIFSReader r = new POIFSReader();
        r.registerListener(ReadTitle::processPOIFSReaderEvent, "\u0005SummaryInformation");
        r.read(new File(filename));
    }

    private static void processPOIFSReaderEvent(POIFSReaderEvent event) {
        SummaryInformation si;
        try {
            si = (SummaryInformation)PropertySetFactory.create((InputStream)event.getStream());
        }
        catch (Exception ex) {
            throw new RuntimeException("Property set stream \"" + event.getPath() + event.getName() + "\": " + ex);
        }
        String title = si.getTitle();
        System.out.println(title != null ? "Title: \"" + title + "\"" : "Document has no title.");
    }
}

