=head1 NAME

iPE::Model::Emission::BNTREE - Coding Sequence model for N-SCAN phylogenetic parameters.

=head1 DESCRIPTION

=head1 FUNCTIONS

=cut

package iPE::Model::Emission::BNTREE;
use iPE;
use iPE::Globals;
use iPE::Model;
use File::Temp;
use base ("iPE::Model::Emission::LUT");
use strict;

sub getZoeHeader { $_[0]->{zoeHeader_} }

sub normalize {
    my ($this) = @_;

    my $g = new iPE::Globals();

    my $order = $this->order > $this->targetOrder ? 
        $this->order : $this->targetOrder;

    my $phylo_text = $g->bntree->optimizeTuples(
        $this, $this->posCounts, $order, $this->name);

    # get rid of the header from the output.
    my @lines = split("\n", $phylo_text);
    $this->{zoeHeader_} = shift(@lines)."\n";

    $this->setParamString(join("\n", @lines));
}

sub outputPrepare { } # handled in normalize, no counts or prob output

=back

=head1 SEE ALSO

L<iPE::Model::Emission>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;

