/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_bn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u09a8\u09be\u0989\u09b0\u09c1";
        final String metaValue_TK = "\u099f\u09cb\u0995\u09c7\u09b2\u09be\u0989";
        final String metaValue_TV = "\u099f\u09c1\u09ad\u09be\u09b2\u09c1";
        final String metaValue_ar = "\u0986\u09b0\u09ac\u09bf";
        final String metaValue_bn = "\u09ac\u09be\u0982\u09b2\u09be";
        final String metaValue_ccp = "\u099a\u09be\u0995\u09ae\u09be";
        final String metaValue_ka = "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8";
        final String metaValue_el = "\u0997\u09cd\u09b0\u09bf\u0995";
        final String metaValue_gu = "\u0997\u09c1\u099c\u09b0\u09be\u099f\u09bf";
        final String metaValue_he = "\u09b9\u09bf\u09ac\u09cd\u09b0\u09c1";
        final String metaValue_jv = "\u099c\u09be\u09ad\u09be\u09a8\u09bf\u099c";
        final String metaValue_km = "\u0996\u09ae\u09c7\u09b0";
        final String metaValue_ko = "\u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8";
        final String metaValue_lo = "\u09b2\u09be\u0993";
        final String metaValue_ml = "\u09ae\u09be\u09b2\u09be\u09af\u09bc\u09be\u09b2\u09be\u09ae";
        final String metaValue_nqo = "\u098f\u09a8\u2019\u0995\u09cb";
        final String metaValue_or = "\u0993\u09a1\u09bc\u09bf\u09af\u09bc\u09be";
        final String metaValue_syr = "\u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u0995";
        final String metaValue_ta = "\u09a4\u09be\u09ae\u09bf\u09b2";
        final String metaValue_th = "\u09a5\u09be\u0987";
        final String metaValue_bo = "\u09a4\u09bf\u09ac\u09cd\u09ac\u09a4\u09bf";
        final String metaValue_uga = "\u0989\u0997\u09be\u09b0\u09bf\u099f\u09bf\u0995";
        final String metaValue_vai = "\u09ad\u09be\u0987";
        final String metaValue_peo = "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09ab\u09be\u09b0\u09cd\u09b8\u09bf";
        final Object[][] data = new Object[][] {
            { "001", "\u09aa\u09c3\u09a5\u09bf\u09ac\u09c0" },
            { "002", "\u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "003", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "005", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "009", "\u0993\u09b6\u09bf\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "011", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "013", "\u09ae\u09a7\u09cd\u09af \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "014", "\u09aa\u09c2\u09b0\u09cd\u09ac \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "015", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "017", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "018", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a8 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "019", "\u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "021", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "029", "\u0995\u09cd\u09af\u09be\u09b0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "030", "\u09aa\u09c2\u09b0\u09cd\u09ac \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "034", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "035", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09aa\u09c2\u09b0\u09cd\u09ac \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "039", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0987\u0989\u09b0\u09cb\u09aa" },
            { "053", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u09b2\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "054", "\u09ae\u09c7\u09b2\u09be\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "057", "\u09ae\u09be\u0987\u0995\u09cd\u09b0\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be \u0985\u099e\u09cd\u099a\u09b2" },
            { "061", "\u09aa\u09b2\u09bf\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "142", "\u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "143", "\u09ae\u09a7\u09cd\u09af \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "145", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u098f\u09b6\u09bf\u09af\u09bc\u09be" },
            { "150", "\u0987\u0989\u09b0\u09cb\u09aa" },
            { "151", "\u09aa\u09c2\u09b0\u09cd\u09ac \u0987\u0989\u09b0\u09cb\u09aa" },
            { "154", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0987\u0989\u09b0\u09cb\u09aa" },
            { "155", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0987\u0989\u09b0\u09cb\u09aa" },
            { "202", "\u0989\u09aa \u09b8\u09be\u09b9\u09be\u09b0\u09be\u09a8 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "419", "\u09b2\u09be\u09a4\u09bf\u09a8 \u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be" },
            { "AC", "\u0985\u09cd\u09af\u09be\u09b8\u09c7\u09a8\u09b6\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "AD", "\u0986\u09a8\u09cd\u09a1\u09cb\u09b0\u09be" },
            { "AE", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0986\u09b0\u09ac \u0986\u09ae\u09bf\u09b0\u09be\u09a4" },
            { "AF", "\u0986\u09ab\u0997\u09be\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "AG", "\u0985\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09bf\u0997\u09c1\u09af\u09bc\u09be \u0993 \u09ac\u09be\u09b0\u09ac\u09c1\u09a1\u09be" },
            { "AI", "\u0985\u09cd\u09af\u09be\u0999\u09cd\u0997\u09c1\u0987\u09b2\u09be" },
            { "AL", "\u0986\u09b2\u09ac\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "AM", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "AO", "\u0985\u09cd\u09af\u09be\u0999\u09cd\u0997\u09cb\u09b2\u09be" },
            { "AQ", "\u0985\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09be\u09b0\u09cd\u0995\u099f\u09bf\u0995\u09be" },
            { "AR", "\u0986\u09b0\u09cd\u099c\u09c7\u09a8\u09cd\u099f\u09bf\u09a8\u09be" },
            { "AS", "\u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be\u09a8 \u09b8\u09be\u09ae\u09cb\u09af\u09bc\u09be" },
            { "AT", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09bf\u09af\u09bc\u09be" },
            { "AU", "\u0985\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u09b2\u09bf\u09af\u09bc\u09be" },
            { "AW", "\u0986\u09b0\u09c1\u09ac\u09be" },
            { "AX", "\u0985\u09b2\u09be\u09a8\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "AZ", "\u0986\u099c\u09be\u09b0\u09ac\u09be\u0987\u099c\u09be\u09a8" },
            { "BA", "\u09ac\u09b8\u09a8\u09bf\u09af\u09bc\u09be \u0993 \u09b9\u09be\u09b0\u09cd\u099c\u09c7\u0997\u09cb\u09ad\u09bf\u09a8\u09be" },
            { "BB", "\u09ac\u09be\u09b0\u09cd\u09ac\u09be\u09a1\u09cb\u099c" },
            { "BD", "\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6" },
            { "BE", "\u09ac\u09c7\u09b2\u099c\u09bf\u09af\u09bc\u09be\u09ae" },
            { "BF", "\u09ac\u09c1\u09b0\u0995\u09bf\u09a8\u09be \u09ab\u09be\u09b8\u09cb" },
            { "BG", "\u09ac\u09c1\u09b2\u0997\u09c7\u09b0\u09bf\u09af\u09bc\u09be" },
            { "BH", "\u09ac\u09be\u09b9\u09be\u09b0\u09bf\u09a8" },
            { "BI", "\u09ac\u09c1\u09b0\u09c1\u09a8\u09cd\u09a1\u09bf" },
            { "BJ", "\u09ac\u09c7\u09a8\u09bf\u09a8" },
            { "BL", "\u09b8\u09c7\u09a8\u09cd\u099f \u09ac\u09be\u09b0\u09cd\u09a5\u09c7\u09b2\u09c7\u09ae\u09bf" },
            { "BM", "\u09ac\u09be\u09b0\u09ae\u09c1\u09a1\u09be" },
            { "BN", "\u09ac\u09cd\u09b0\u09c1\u09a8\u09c7\u0987" },
            { "BO", "\u09ac\u09b2\u09bf\u09ad\u09bf\u09af\u09bc\u09be" },
            { "BQ", "\u0995\u09cd\u09af\u09be\u09b0\u09bf\u09ac\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09c7\u09a6\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09b8" },
            { "BR", "\u09ac\u09cd\u09b0\u09be\u099c\u09bf\u09b2" },
            { "BS", "\u09ac\u09be\u09b9\u09be\u09ae\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "BT", "\u09ad\u09c1\u099f\u09be\u09a8" },
            { "BV", "\u09ac\u09cb\u09ad\u09c7\u099f \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "BW", "\u09ac\u09a4\u09b8\u09cb\u09af\u09bc\u09be\u09a8\u09be" },
            { "BY", "\u09ac\u09c7\u09b2\u09be\u09b0\u09c1\u09b6" },
            { "BZ", "\u09ac\u09c7\u09b2\u09bf\u099c" },
            { "CA", "\u0995\u09be\u09a8\u09be\u09a1\u09be" },
            { "CC", "\u0995\u09cb\u0995\u09cb\u09b8 (\u0995\u09bf\u09b2\u09bf\u0982) \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "CD", "\u0995\u0999\u09cd\u0997\u09cb-\u0995\u09bf\u09a8\u09b6\u09be\u09b8\u09be" },
            { "CF", "\u09ae\u09a7\u09cd\u09af \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09b0 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0" },
            { "CG", "\u0995\u0999\u09cd\u0997\u09cb - \u09ac\u09cd\u09b0\u09be\u099c\u09be\u09ad\u09bf\u09b2" },
            { "CH", "\u09b8\u09c1\u0987\u099c\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "CI", "\u0995\u09cb\u099f \u09a1\u09bf\u2018\u0986\u0987\u09ad\u09cb\u09b0" },
            { "CK", "\u0995\u09c1\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "CL", "\u099a\u09bf\u09b2\u09bf" },
            { "CM", "\u0995\u09cd\u09af\u09be\u09ae\u09c7\u09b0\u09c1\u09a8" },
            { "CN", "\u099a\u09c0\u09a8" },
            { "CO", "\u0995\u09b2\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "CP", "\u0995\u09cd\u09b2\u09bf\u09aa\u09be\u09b0\u099f\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "CR", "\u0995\u09cb\u09b8\u09cd\u099f\u09be\u09b0\u09bf\u0995\u09be" },
            { "CU", "\u0995\u09bf\u0989\u09ac\u09be" },
            { "CV", "\u0995\u09c7\u09aa \u09ad\u09be\u09b0\u09cd\u09a6\u09c7" },
            { "CW", "\u0995\u09c1\u09b0\u09be\u09b8\u09be\u0993" },
            { "CX", "\u0995\u09cd\u09b0\u09bf\u09b8\u09ae\u09be\u09b8 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "CY", "\u09b8\u09be\u0987\u09aa\u09cd\u09b0\u09be\u09b8" },
            { "CZ", "\u099a\u09c7\u0995\u09bf\u09af\u09bc\u09be" },
            { "DE", "\u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf" },
            { "DG", "\u09a6\u09bf\u09af\u09bc\u09c7\u0997\u09cb \u0997\u09be\u09b0\u09cd\u09b8\u09bf\u09af\u09bc\u09be" },
            { "DJ", "\u099c\u09bf\u09ac\u09c1\u09a4\u09bf" },
            { "DK", "\u09a1\u09c7\u09a8\u09ae\u09be\u09b0\u09cd\u0995" },
            { "DM", "\u09a1\u09cb\u09ae\u09bf\u09a8\u09bf\u0995\u09be" },
            { "DO", "\u09a1\u09cb\u09ae\u09c7\u09a8\u09bf\u0995\u09be\u09a8 \u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0" },
            { "DZ", "\u0986\u09b2\u099c\u09c7\u09b0\u09bf\u09af\u09bc\u09be" },
            { "EA", "\u0995\u09c1\u0989\u099f\u09be \u098f\u09ac\u0982 \u09ae\u09c7\u09b2\u09bf\u09b2\u09be" },
            { "EC", "\u0987\u0995\u09c1\u09af\u09bc\u09c7\u09a1\u09b0" },
            { "EE", "\u098f\u09b8\u09cd\u09a4\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "EG", "\u09ae\u09bf\u09b6\u09b0" },
            { "EH", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u09b8\u09be\u09b9\u09be\u09b0\u09be" },
            { "ER", "\u0987\u09b0\u09bf\u09a4\u09cd\u09b0\u09bf\u09af\u09bc\u09be" },
            { "ES", "\u09b8\u09cd\u09aa\u09c7\u09a8" },
            { "ET", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u09af\u09bc\u09be" },
            { "EU", "\u0987\u0989\u09b0\u09cb\u09aa\u09c0\u09af\u09bc \u0987\u0989\u09a8\u09bf\u09af\u09bc\u09a8" },
            { "EZ", "\u0987\u0989\u09b0\u09cb\u099c\u09cb\u09a8" },
            { "FI", "\u09ab\u09bf\u09a8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "FJ", "\u09ab\u09bf\u099c\u09bf" },
            { "FK", "\u09ab\u0995\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "FM", "\u09ae\u09be\u0987\u0995\u09cd\u09b0\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "FO", "\u09ab\u09cd\u09af\u09be\u09b0\u09cb \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "FR", "\u09ab\u09cd\u09b0\u09be\u09a8\u09cd\u09b8" },
            { "GA", "\u0997\u09cd\u09af\u09be\u09ac\u09a8" },
            { "GB", "\u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u099c\u09cd\u09af" },
            { "GD", "\u0997\u09cd\u09b0\u09c7\u09a8\u09be\u09a1\u09be" },
            { "GE", "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be" },
            { "GF", "\u09ab\u09b0\u09be\u09b8\u09c0 \u0997\u09be\u09af\u09bc\u09be\u09a8\u09be" },
            { "GG", "\u0997\u09be\u09b0\u09cd\u09a8\u09b8\u09bf" },
            { "GH", "\u0998\u09be\u09a8\u09be" },
            { "GI", "\u099c\u09bf\u09ac\u09cd\u09b0\u09be\u09b2\u09cd\u099f\u09be\u09b0" },
            { "GL", "\u0997\u09cd\u09b0\u09c0\u09a8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "GM", "\u0997\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "GN", "\u0997\u09bf\u09a8\u09bf" },
            { "GP", "\u0997\u09c1\u09af\u09bc\u09be\u09a6\u09c7\u09b2\u09cc\u09aa" },
            { "GQ", "\u09a8\u09bf\u09b0\u0995\u09cd\u09b7\u09c0\u09af\u09bc \u0997\u09bf\u09a8\u09bf" },
            { "GR", "\u0997\u09cd\u09b0\u09c0\u09b8" },
            { "GS", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be \u0993 \u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09b8\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u0989\u0987\u099a \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "GT", "\u0997\u09c1\u09af\u09bc\u09be\u09a4\u09c7\u09ae\u09be\u09b2\u09be" },
            { "GU", "\u0997\u09c1\u09af\u09bc\u09be\u09ae" },
            { "GW", "\u0997\u09bf\u09a8\u09bf-\u09ac\u09bf\u09b8\u09be\u0989" },
            { "GY", "\u0997\u09bf\u09af\u09bc\u09be\u09a8\u09be" },
            { "HK", "\u09b9\u0982\u0995\u0982 \u098f\u09b8\u098f\u0986\u09b0 \u099a\u09c0\u09a8\u09be" },
            { "HM", "\u09b9\u09be\u09b0\u09cd\u09a1 \u098f\u09ac\u0982 \u09ae\u09cd\u09af\u09be\u0995\u09a1\u09cb\u09a8\u09be\u09b2\u09cd\u09a1 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "HN", "\u09b9\u09a8\u09cd\u09a1\u09c1\u09b0\u09be\u09b8" },
            { "HR", "\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "HT", "\u09b9\u09be\u0987\u09a4\u09bf" },
            { "HU", "\u09b9\u09be\u0999\u09cd\u0997\u09c7\u09b0\u09bf" },
            { "IC", "\u0995\u09cd\u09af\u09be\u09a8\u09be\u09b0\u09bf \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "ID", "\u0987\u09a8\u09cd\u09a6\u09cb\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "IE", "\u0986\u09af\u09bc\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "IL", "\u0987\u099c\u09b0\u09be\u09af\u09bc\u09c7\u09b2" },
            { "IM", "\u0986\u0987\u09b2 \u0985\u09ab \u09ae\u09cd\u09af\u09be\u09a8" },
            { "IN", "\u09ad\u09be\u09b0\u09a4" },
            { "IO", "\u09ac\u09cd\u09b0\u09bf\u099f\u09bf\u09b6 \u09ad\u09be\u09b0\u09a4 \u09ae\u09b9\u09be\u09b8\u09be\u0997\u09b0\u09c0\u09af\u09bc \u0985\u099e\u09cd\u099a\u09b2" },
            { "IQ", "\u0987\u09b0\u09be\u0995" },
            { "IR", "\u0987\u09b0\u09be\u09a8" },
            { "IS", "\u0986\u0987\u09b8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "IT", "\u0987\u09a4\u09be\u09b2\u09bf" },
            { "JE", "\u099c\u09be\u09b0\u09cd\u09b8\u09bf" },
            { "JM", "\u099c\u09be\u09ae\u09be\u0987\u0995\u09be" },
            { "JO", "\u099c\u09b0\u09cd\u09a1\u09a8" },
            { "JP", "\u099c\u09be\u09aa\u09be\u09a8" },
            { "KE", "\u0995\u09c7\u09a8\u09bf\u09af\u09bc\u09be" },
            { "KG", "\u0995\u09bf\u09b0\u0997\u09bf\u099c\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "KH", "\u0995\u09ae\u09cd\u09ac\u09cb\u09a1\u09bf\u09af\u09bc\u09be" },
            { "KI", "\u0995\u09bf\u09b0\u09bf\u09ac\u09be\u09a4\u09bf" },
            { "KM", "\u0995\u09ae\u09cb\u09b0\u09cb\u09b8" },
            { "KN", "\u09b8\u09c7\u09a8\u09cd\u099f \u0995\u09bf\u099f\u09b8 \u0993 \u09a8\u09c7\u09ad\u09bf\u09b8" },
            { "KP", "\u0989\u09a4\u09cd\u09a4\u09b0 \u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be" },
            { "KR", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09cb\u09b0\u09bf\u09af\u09bc\u09be" },
            { "KW", "\u0995\u09c1\u09af\u09bc\u09c7\u09a4" },
            { "KY", "\u0995\u09c7\u09ae\u09cd\u09af\u09be\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "KZ", "\u0995\u09be\u099c\u09be\u0996\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "LA", "\u09b2\u09be\u0993\u09b8" },
            { "LB", "\u09b2\u09c7\u09ac\u09be\u09a8\u09a8" },
            { "LC", "\u09b8\u09c7\u09a8\u09cd\u099f \u09b2\u09c1\u09b8\u09bf\u09af\u09bc\u09be" },
            { "LI", "\u09b2\u09bf\u099a\u09c7\u09a8\u09b8\u09cd\u099f\u09c7\u0987\u09a8" },
            { "LK", "\u09b6\u09cd\u09b0\u09c0\u09b2\u0999\u09cd\u0995\u09be" },
            { "LR", "\u09b2\u09be\u0987\u09ac\u09c7\u09b0\u09bf\u09af\u09bc\u09be" },
            { "LS", "\u09b2\u09c7\u09b8\u09cb\u09a5\u09cb" },
            { "LT", "\u09b2\u09bf\u09a5\u09c1\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "LU", "\u09b2\u09be\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09b0\u09cd\u0997" },
            { "LV", "\u09b2\u09be\u099f\u09ad\u09bf\u09af\u09bc\u09be" },
            { "LY", "\u09b2\u09bf\u09ac\u09bf\u09af\u09bc\u09be" },
            { "MA", "\u09ae\u09cb\u09b0\u0995\u09cd\u0995\u09cb" },
            { "MC", "\u09ae\u09cb\u09a8\u09be\u0995\u09cb" },
            { "MD", "\u09ae\u09b2\u09a1\u09cb\u09ad\u09be" },
            { "ME", "\u09ae\u09a8\u09cd\u099f\u09bf\u09a8\u09bf\u0997\u09cd\u09b0\u09cb" },
            { "MF", "\u09b8\u09c7\u09a8\u09cd\u099f \u09ae\u09be\u09b0\u09cd\u099f\u09bf\u09a8" },
            { "MG", "\u09ae\u09be\u09a6\u09be\u0997\u09be\u09b8\u09cd\u0995\u09be\u09b0" },
            { "MH", "\u09ae\u09be\u09b0\u09cd\u09b6\u09be\u09b2 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "MK", "\u0989\u09a4\u09cd\u09a4\u09b0 \u09ae\u09cd\u09af\u09be\u09b8\u09c7\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "ML", "\u09ae\u09be\u09b2\u09bf" },
            { "MM", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 (\u09ac\u09be\u09b0\u09cd\u09ae\u09be)" },
            { "MN", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc\u09be" },
            { "MO", "\u09ae\u09cd\u09af\u09be\u0995\u09be\u0993 \u098f\u09b8\u098f\u0986\u09b0 \u099a\u09c0\u09a8" },
            { "MP", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09ae\u09be\u09b0\u09bf\u09af\u09bc\u09be\u09a8\u09be \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "MQ", "\u09ae\u09be\u09b0\u09cd\u099f\u09bf\u09a8\u09bf\u0995" },
            { "MR", "\u09ae\u09b0\u09bf\u09a4\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "MS", "\u09ae\u09a8\u09cd\u099f\u09b8\u09c7\u09b0\u09be\u099f" },
            { "MT", "\u09ae\u09be\u09b2\u09cd\u099f\u09be" },
            { "MU", "\u09ae\u09b0\u09bf\u09b6\u09be\u09b8" },
            { "MV", "\u09ae\u09be\u09b2\u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "MW", "\u09ae\u09be\u09b2\u09be\u0989\u0987" },
            { "MX", "\u09ae\u09c7\u0995\u09cd\u09b8\u09bf\u0995\u09cb" },
            { "MY", "\u09ae\u09be\u09b2\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "MZ", "\u09ae\u09cb\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u0995" },
            { "NA", "\u09a8\u09be\u09ae\u09bf\u09ac\u09bf\u09af\u09bc\u09be" },
            { "NC", "\u09a8\u09bf\u0989 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a1\u09cb\u09a8\u09bf\u09af\u09bc\u09be" },
            { "NE", "\u09a8\u09be\u0987\u099c\u09be\u09b0" },
            { "NF", "\u09a8\u09b0\u09ab\u09cb\u0995 \u09a6\u09cd\u09ac\u09c0\u09aa" },
            { "NG", "\u09a8\u09be\u0987\u099c\u09c7\u09b0\u09bf\u09af\u09bc\u09be" },
            { "NI", "\u09a8\u09bf\u0995\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09be" },
            { "NL", "\u09a8\u09c7\u09a6\u09be\u09b0\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09b8" },
            { "NO", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7" },
            { "NP", "\u09a8\u09c7\u09aa\u09be\u09b2" },
            { "NR", metaValue_NR },
            { "NU", "\u09a8\u09bf\u0989\u09af\u09bc\u09c7" },
            { "NZ", "\u09a8\u09bf\u0989\u099c\u09bf\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "OM", "\u0993\u09ae\u09be\u09a8" },
            { "PA", "\u09aa\u09be\u09a8\u09be\u09ae\u09be" },
            { "PE", "\u09aa\u09c7\u09b0\u09c1" },
            { "PF", "\u09ab\u09b0\u09be\u09b8\u09c0 \u09aa\u09b2\u09bf\u09a8\u09c7\u09b6\u09bf\u09af\u09bc\u09be" },
            { "PG", "\u09aa\u09be\u09aa\u09c1\u09af\u09bc\u09be \u09a8\u09bf\u0989 \u0997\u09bf\u09a8\u09bf" },
            { "PH", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09be\u0987\u09a8" },
            { "PK", "\u09aa\u09be\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "PL", "\u09aa\u09cb\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "PM", "\u09b8\u09c7\u09a8\u09cd\u099f \u09aa\u09bf\u09af\u09bc\u09c7\u09b0 \u0993 \u09ae\u09bf\u0995\u09c1\u09af\u09bc\u09c7\u09b2\u09a8" },
            { "PN", "\u09aa\u09bf\u099f\u0995\u09c7\u09af\u09bc\u09be\u09b0\u09cd\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "PR", "\u09aa\u09c1\u09af\u09bc\u09c7\u09b0\u09cd\u09a4\u09cb \u09b0\u09bf\u0995\u09cb" },
            { "PS", "\u09aa\u09cd\u09af\u09be\u09b2\u09c7\u09b8\u09cd\u099f\u09be\u0987\u09a8 \u09ad\u09c2\u0996\u09a3\u09cd\u09a1" },
            { "PT", "\u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09be\u09b2" },
            { "PW", "\u09aa\u09be\u09b2\u09be\u0989" },
            { "PY", "\u09aa\u09cd\u09af\u09be\u09b0\u09be\u0997\u09c1\u09af\u09bc\u09c7" },
            { "QA", "\u0995\u09be\u09a4\u09be\u09b0" },
            { "QO", "\u0986\u0989\u099f\u09b2\u09be\u0987\u09a8\u09bf\u0982 \u0993\u09b8\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "RE", "\u09b0\u09bf\u0987\u0989\u09a8\u09bf\u09af\u09bc\u09a8" },
            { "RO", "\u09b0\u09cb\u09ae\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "RS", "\u09b8\u09be\u09b0\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "RU", "\u09b0\u09be\u09b6\u09bf\u09af\u09bc\u09be" },
            { "RW", "\u09b0\u09c1\u09af\u09bc\u09be\u09a8\u09cd\u09a1\u09be" },
            { "SA", "\u09b8\u09cc\u09a6\u09bf \u0986\u09b0\u09ac" },
            { "SB", "\u09b8\u09b2\u09cb\u09ae\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "SC", "\u09b8\u09bf\u09b8\u09bf\u09b2\u09bf" },
            { "SD", "\u09b8\u09c1\u09a6\u09be\u09a8" },
            { "SE", "\u09b8\u09c1\u0987\u09a1\u09c7\u09a8" },
            { "SG", "\u09b8\u09bf\u0999\u09cd\u0997\u09be\u09aa\u09c1\u09b0" },
            { "SH", "\u09b8\u09c7\u09a8\u09cd\u099f \u09b9\u09c7\u09b2\u09c7\u09a8\u09be" },
            { "SI", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "SJ", "\u09b8\u09cd\u09ac\u09be\u09b2\u09ac\u09be\u09b0\u09cd\u09a1 \u0993 \u099c\u09be\u09a8 \u09ae\u09c7\u09af\u09bc\u09c7\u09a8" },
            { "SK", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u0995\u09bf\u09af\u09bc\u09be" },
            { "SL", "\u09b8\u09bf\u09af\u09bc\u09c7\u09b0\u09be \u09b2\u09bf\u0993\u09a8" },
            { "SM", "\u09b8\u09be\u09a8 \u09ae\u09be\u09b0\u09bf\u09a8\u09cb" },
            { "SN", "\u09b8\u09c7\u09a8\u09c7\u0997\u09be\u09b2" },
            { "SO", "\u09b8\u09cb\u09ae\u09be\u09b2\u09bf\u09af\u09bc\u09be" },
            { "SR", "\u09b8\u09c1\u09b0\u09bf\u09a8\u09be\u09ae" },
            { "SS", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09b8\u09c1\u09a6\u09be\u09a8" },
            { "ST", "\u09b8\u09be\u0993\u099f\u09cb\u09ae\u09be \u0993 \u09aa\u09cd\u09b0\u09bf\u09a8\u09cd\u09b8\u09bf\u09aa\u09bf" },
            { "SV", "\u098f\u09b2 \u09b8\u09be\u09b2\u09ad\u09c7\u09a6\u09b0" },
            { "SX", "\u09b8\u09bf\u09a8\u09cd\u099f \u09ae\u09be\u09b0\u09cd\u099f\u09c7\u09a8" },
            { "SY", "\u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be" },
            { "SZ", "\u0987\u09b8\u0993\u09af\u09bc\u09be\u09a4\u09bf\u09a8\u09bf" },
            { "TA", "\u099f\u09cd\u09b0\u09bf\u09b8\u09cd\u099f\u09be\u09a8 \u09a1\u09be \u0995\u09c1\u09a8\u09b9\u09be" },
            { "TC", "\u09a4\u09c1\u09b0\u09cd\u0995\u09b8 \u0993 \u0995\u09be\u0987\u0995\u09cb\u09b8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "TD", "\u099a\u09be\u09a6" },
            { "TF", "\u09ab\u09b0\u09be\u09b8\u09c0 \u09a6\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u099e\u09cd\u099a\u09b2" },
            { "TG", "\u099f\u09cb\u0997\u09cb" },
            { "TH", "\u09a5\u09be\u0987\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1" },
            { "TJ", "\u09a4\u09be\u099c\u09bf\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "TK", metaValue_TK },
            { "TL", "\u09a4\u09bf\u09ae\u09c1\u09b0-\u09b2\u09c7\u09b8\u09cd\u09a4\u09c7" },
            { "TM", "\u09a4\u09c1\u09b0\u09cd\u0995\u09ae\u09c7\u09a8\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "TN", "\u09a4\u09bf\u0989\u09a8\u09bf\u09b8\u09bf\u09af\u09bc\u09be" },
            { "TO", "\u099f\u09cb\u0999\u09cd\u0997\u09be" },
            { "TR", "\u09a4\u09c1\u09b0\u09b8\u09cd\u0995" },
            { "TT", "\u09a4\u09cd\u09b0\u09bf\u09a8\u09bf\u09a8\u09be\u09a6 \u0993 \u099f\u09cb\u09ac\u09cd\u09af\u09be\u0997\u09cb" },
            { "TV", metaValue_TV },
            { "TW", "\u09a4\u09be\u0987\u0993\u09af\u09bc\u09be\u09a8" },
            { "TZ", "\u09a4\u09be\u099e\u09cd\u099c\u09be\u09a8\u09bf\u09af\u09bc\u09be" },
            { "UA", "\u0987\u0989\u0995\u09cd\u09b0\u09c7\u09a8" },
            { "UG", "\u0989\u0997\u09be\u09a8\u09cd\u09a1\u09be" },
            { "UM", "\u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0\u09c7\u09b0 \u09aa\u09be\u09b0\u09cd\u09b6\u09cd\u09ac\u09ac\u09b0\u09cd\u09a4\u09c0 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "UN", "\u099c\u09be\u09a4\u09bf\u09b8\u0982\u0998" },
            { "US", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0" },
            { "UY", "\u0989\u09b0\u09c1\u0997\u09c1\u09af\u09bc\u09c7" },
            { "UZ", "\u0989\u099c\u09ac\u09c7\u0995\u09bf\u09b8\u09cd\u09a4\u09be\u09a8" },
            { "VA", "\u09ad\u09cd\u09af\u09be\u099f\u09bf\u0995\u09be\u09a8 \u09b8\u09bf\u099f\u09bf" },
            { "VC", "\u09b8\u09c7\u09a8\u09cd\u099f \u09ad\u09bf\u09a8\u09b8\u09c7\u09a8\u09cd\u099f \u0993 \u0997\u09cd\u09b0\u09c7\u09a8\u09be\u09a1\u09bf\u09a8\u09b8" },
            { "VE", "\u09ad\u09c7\u09a8\u09c7\u099c\u09c1\u09af\u09bc\u09c7\u09b2\u09be" },
            { "VG", "\u09ac\u09cd\u09b0\u09bf\u099f\u09bf\u09b6 \u09ad\u09be\u09b0\u09cd\u099c\u09bf\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "VI", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0\u09c0\u09af\u09bc \u09ad\u09be\u09b0\u09cd\u099c\u09bf\u09a8 \u09a6\u09cd\u09ac\u09c0\u09aa\u09aa\u09c1\u099e\u09cd\u099c" },
            { "VN", "\u09ad\u09bf\u09af\u09bc\u09c7\u09a4\u09a8\u09be\u09ae" },
            { "VU", "\u09ad\u09be\u09a8\u09c1\u09af\u09bc\u09be\u099f\u09c1" },
            { "WF", "\u0993\u09af\u09bc\u09be\u09b2\u09bf\u09b8 \u0993 \u09ab\u09c1\u099f\u09c1\u09a8\u09be" },
            { "WS", "\u09b8\u09be\u09ae\u09cb\u09af\u09bc\u09be" },
            { "XA", "\u09b8\u09bf\u0989\u09a1\u09cb-\u0985\u09cd\u09af\u09be\u0995\u09b8\u09c7\u09a8\u09cd\u099f" },
            { "XB", "\u09b8\u09bf\u0989\u09a1\u09cb-\u09ac\u09bf\u09a1\u09bf" },
            { "XK", "\u0995\u09b8\u09cb\u09ad\u09cb" },
            { "YE", "\u0987\u09af\u09bc\u09c7\u09ae\u09c7\u09a8" },
            { "YT", "\u09ae\u09be\u09af\u09bc\u09cb\u09a4\u09cd\u09a4\u09c7" },
            { "ZA", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be" },
            { "ZM", "\u099c\u09be\u09ae\u09cd\u09ac\u09bf\u09af\u09bc\u09be" },
            { "ZW", "\u099c\u09bf\u09ae\u09cd\u09ac\u09be\u09ac\u09cb\u09af\u09bc\u09c7" },
            { "ZZ", "\u0985\u099c\u09be\u09a8\u09be \u0985\u099e\u09cd\u099a\u09b2" },
            { "aa", "\u0986\u09ab\u09be\u09b0" },
            { "ab", "\u0986\u09ac\u0996\u09be\u099c\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ae", "\u0986\u09ac\u09c7\u09b8\u09cd\u09a4\u09c0\u09af\u09bc" },
            { "af", "\u0986\u09ab\u09cd\u09b0\u09bf\u0995\u09be\u09a8" },
            { "ak", "\u0986\u0995\u09be\u09a8" },
            { "am", "\u0986\u09ae\u09b9\u09be\u09b0\u09bf\u0995" },
            { "an", "\u0986\u09b0\u09cd\u0997\u09cb\u09a8\u09bf\u099c" },
            { "ar", metaValue_ar },
            { "as", "\u0985\u09b8\u09ae\u09c0\u09af\u09bc\u09be" },
            { "av", "\u0986\u09ad\u09c7\u09b0\u09bf\u0995" },
            { "ay", "\u0986\u09af\u09bc\u09ae\u09be\u09b0\u09be" },
            { "az", "\u0986\u099c\u09be\u09b0\u09ac\u09be\u0987\u099c\u09be\u09a8\u09c0" },
            { "ba", "\u09ac\u09be\u09b6\u0995\u09bf\u09b0" },
            { "be", "\u09ac\u09c7\u09b2\u09be\u09b0\u09c1\u09b6\u09bf\u09af\u09bc" },
            { "bg", "\u09ac\u09c1\u09b2\u0997\u09c7\u09b0\u09bf\u09af\u09bc" },
            { "bi", "\u09ac\u09bf\u09b8\u09b2\u09be\u09ae\u09be" },
            { "bm", "\u09ac\u09be\u09ae\u09ac\u09be\u09b0\u09be" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "\u09ac\u09cd\u09b0\u09c7\u099f\u09a8" },
            { "bs", "\u09ac\u09b8\u09a8\u09c0\u09af\u09bc" },
            { "ca", "\u0995\u09be\u09a4\u09be\u09b2\u09be\u09a8" },
            { "ce", "\u099a\u09c7\u099a\u09c7\u09a8" },
            { "ch", "\u099a\u09be\u09ae\u09cb\u09b0\u09cb" },
            { "co", "\u0995\u09b0\u09cd\u09b8\u09bf\u0995\u09be\u09a8" },
            { "cr", "\u0995\u09cd\u09b0\u09bf" },
            { "cs", "\u099a\u09c7\u0995" },
            { "cu", "\u099a\u09be\u09b0\u09cd\u099a \u09b8\u09cd\u09b2\u09be\u09ad\u09bf\u0995" },
            { "cv", "\u099a\u09c1\u09ac\u09be\u09b8" },
            { "cy", "\u0993\u09af\u09bc\u09c7\u09b2\u09b6" },
            { "da", "\u09a1\u09c7\u09a8\u09bf\u09b6" },
            { "de", "\u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8" },
            { "dv", "\u09a6\u09bf\u09ac\u09c7\u09b9\u09bf" },
            { "dz", "\u099c\u09cb\u0982\u0996\u09be" },
            { "ee", "\u0987\u0989\u09af\u09bc\u09bf" },
            { "el", metaValue_el },
            { "en", "\u0987\u0982\u09b0\u09c7\u099c\u09bf" },
            { "eo", "\u098f\u09b8\u09cd\u09aa\u09c7\u09b0\u09be\u09a8\u09cd\u09a4\u09cb" },
            { "es", "\u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6" },
            { "et", "\u098f\u09b8\u09cd\u09a4\u09cb\u09a8\u09c0\u09af\u09bc" },
            { "eu", "\u09ac\u09be\u09b8\u09cd\u0995" },
            { "fa", "\u09ab\u09be\u09b0\u09cd\u09b8\u09bf" },
            { "ff", "\u09ab\u09c1\u09b2\u09be\u09b9\u09cd" },
            { "fi", "\u09ab\u09bf\u09a8\u09bf\u09b6" },
            { "fj", "\u09ab\u09bf\u099c\u09bf\u09af\u09bc\u09be\u09a8" },
            { "fo", "\u09ab\u09c7\u09b0\u09cb\u0987\u09b8" },
            { "fr", "\u09ab\u09b0\u09be\u09b8\u09bf" },
            { "fy", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u09ab\u09cd\u09b0\u09bf\u09b8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ga", "\u0986\u0987\u09b0\u09bf\u09b6" },
            { "gd", "\u09b8\u09cd\u0995\u099f\u09bf\u09b6-\u0997\u09cd\u09af\u09c7\u09b2\u09bf\u0995" },
            { "gl", "\u0997\u09cd\u09af\u09be\u09b2\u09bf\u09b6\u09bf\u09af\u09bc" },
            { "gn", "\u0997\u09c1\u09af\u09bc\u09be\u09b0\u09be\u09a8\u09bf" },
            { "gu", metaValue_gu },
            { "gv", "\u09ae\u09cd\u09af\u09be\u0999\u09cd\u0995\u09b8" },
            { "ha", "\u09b9\u09be\u0989\u09b8\u09be" },
            { "he", metaValue_he },
            { "hi", "\u09b9\u09bf\u09a8\u09cd\u09a6\u09bf" },
            { "ho", "\u09b9\u09bf\u09b0\u09bf \u09ae\u09cb\u09a4\u09c1" },
            { "hr", "\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09c0\u09af\u09bc" },
            { "ht", "\u09b9\u09be\u0987\u09a4\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09b0\u09c7\u0993\u09b2" },
            { "hu", "\u09b9\u09be\u0999\u09cd\u0997\u09c7\u09b0\u09c0\u09af\u09bc" },
            { "hy", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09bf\u09af\u09bc" },
            { "hz", "\u09b9\u09c7\u09b0\u09c7\u09b0\u09cb" },
            { "ia", "\u0987\u09a8\u09cd\u099f\u09be\u09b0\u09b2\u09bf\u0999\u09cd\u0997\u09c1\u09af\u09bc\u09be" },
            { "id", "\u0987\u09a8\u09cd\u09a6\u09cb\u09a8\u09c7\u09b6\u09c0\u09af\u09bc" },
            { "ie", "\u0987\u09a8\u09cd\u099f\u09be\u09b0\u09b2\u09bf\u0999\u09cd\u0997" },
            { "ig", "\u0987\u0997\u09cd\u200c\u09ac\u09cb" },
            { "ii", "\u09b8\u09bf\u099a\u09c1\u09af\u09bc\u09be\u09a8 \u09af\u09bc\u09bf" },
            { "ik", "\u0987\u09a8\u09c1\u09aa\u09bf\u09af\u09bc\u09be\u0995" },
            { "io", "\u0987\u09a1\u09cb" },
            { "is", "\u0986\u0987\u09b8\u09b2\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09c0\u09af\u09bc" },
            { "it", "\u0987\u09a4\u09be\u09b2\u09bf\u09af\u09bc" },
            { "iu", "\u0987\u09a8\u09c1\u0995\u09cd\u099f\u09bf\u099f\u09c1\u099f" },
            { "ja", "\u099c\u09be\u09aa\u09be\u09a8\u09bf" },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "\u0995\u0999\u09cd\u0997\u09cb" },
            { "ki", "\u0995\u09bf\u0995\u09c1\u09af\u09bc\u09c1" },
            { "kj", "\u0995\u09cb\u09af\u09bc\u09be\u09a8\u09bf\u09af\u09bc\u09be\u09ae\u09be" },
            { "kk", "\u0995\u09be\u099c\u09be\u0996" },
            { "kl", "\u0995\u09be\u09b2\u09be\u09b2\u09cd\u09b2\u09bf\u09b8\u09c1\u099f" },
            { "km", metaValue_km },
            { "kn", "\u0995\u09a8\u09cd\u09a8\u09a1\u09bc" },
            { "ko", metaValue_ko },
            { "kr", "\u0995\u09be\u09a8\u09c1\u09b0\u09bf" },
            { "ks", "\u0995\u09be\u09b6\u09cd\u09ae\u09c0\u09b0\u09bf" },
            { "ku", "\u0995\u09c1\u09b0\u09cd\u09a6\u09bf\u09b6" },
            { "kv", "\u0995\u09cb\u09ae\u09bf" },
            { "kw", "\u0995\u09b0\u09cd\u09a3\u09bf\u09b6" },
            { "ky", "\u0995\u09bf\u09b0\u09cd\u0997\u09bf\u099c" },
            { "la", "\u09b2\u09be\u09a4\u09bf\u09a8" },
            { "lb", "\u09b2\u09c1\u0995\u09cd\u09b8\u09c7\u09ae\u09ac\u09be\u09b0\u09cd\u0997\u09c0\u09af\u09bc" },
            { "lg", "\u0997\u09be\u09a8\u09cd\u09a1\u09be" },
            { "li", "\u09b2\u09bf\u09ae\u09cd\u09ac\u09c1\u09b0\u09cd\u0997\u09bf\u09b6" },
            { "ln", "\u09b2\u09bf\u0999\u09cd\u0997\u09be\u09b2\u09be" },
            { "lo", metaValue_lo },
            { "lt", "\u09b2\u09bf\u09a5\u09c1\u09af\u09bc\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "lu", "\u09b2\u09c1\u09ac\u09be-\u0995\u09be\u099f\u09be\u0999\u09cd\u0997\u09be" },
            { "lv", "\u09b2\u09be\u09a4\u09cd\u200c\u09ad\u09c0\u09af\u09bc" },
            { "mg", "\u09ae\u09be\u09b2\u09be\u0997\u09be\u09b8\u09bf" },
            { "mh", "\u09ae\u09be\u09b0\u09cd\u09b6\u09be\u09b2\u09bf\u099c" },
            { "mi", "\u09ae\u09be\u0993\u09b0\u09bf" },
            { "mk", "\u09ae\u09cd\u09af\u09be\u09b8\u09bf\u09a1\u09cb\u09a8\u09c0\u09af\u09bc" },
            { "ml", metaValue_ml },
            { "mn", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09bf\u09af\u09bc" },
            { "mr", "\u09ae\u09be\u09b0\u09be\u09a0\u09bf" },
            { "ms", "\u09ae\u09be\u09b2\u09af\u09bc" },
            { "mt", "\u09ae\u09b2\u09cd\u099f\u09bf\u09af\u09bc" },
            { "my", "\u09ac\u09b0\u09cd\u09ae\u09bf" },
            { "na", metaValue_NR },
            { "nb", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09cb\u0995\u09ae\u09be\u09b2" },
            { "nd", "\u0989\u09a4\u09cd\u09a4\u09b0 \u098f\u09a8\u09cd\u09a6\u09c7\u09ac\u09c7\u09b2\u09c7" },
            { "ne", "\u09a8\u09c7\u09aa\u09be\u09b2\u09c0" },
            { "ng", "\u098f\u09a8\u09cd\u09a6\u09cb\u0999\u09cd\u0997\u09be" },
            { "nl", "\u0993\u09b2\u09a8\u09cd\u09a6\u09be\u099c" },
            { "nn", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09a8\u09bf\u09a8\u09b0\u09cd\u09b8\u09cd\u0995" },
            { "no", "\u09a8\u09b0\u0993\u09af\u09bc\u09c7\u099c\u09c0\u09af\u09bc" },
            { "nr", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u098f\u09a8\u09a1\u09c7\u09ac\u09c7\u09b2\u09c7" },
            { "nv", "\u09a8\u09be\u09ad\u09be\u099c\u09cb" },
            { "ny", "\u09a8\u09be\u09af\u09bc\u09be\u099e\u09cd\u099c\u09be" },
            { "oc", "\u0985\u0995\u09cd\u09b8\u09bf\u099f\u09be\u09a8" },
            { "oj", "\u0993\u099c\u09bf\u09ac\u0993\u09af\u09bc\u09be" },
            { "om", "\u0985\u09b0\u09cb\u09ae\u09cb" },
            { "or", metaValue_or },
            { "os", "\u0993\u09b8\u09c7\u099f\u09bf\u0995" },
            { "pa", "\u09aa\u09be\u099e\u09cd\u099c\u09be\u09ac\u09c0" },
            { "pi", "\u09aa\u09be\u09b2\u09bf" },
            { "pl", "\u09aa\u09cb\u09b2\u09bf\u09b6" },
            { "ps", "\u09aa\u09be\u09b6\u09a4\u09c1" },
            { "pt", "\u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09c0\u099c" },
            { "qu", "\u0995\u09c7\u099a\u09c1\u09af\u09bc\u09be" },
            { "rm", "\u09b0\u09cb\u09ae\u09be\u09a8\u09cd\u09b8" },
            { "rn", "\u09b0\u09c1\u09a8\u09cd\u09a6\u09bf" },
            { "ro", "\u09b0\u09cb\u09ae\u09be\u09a8\u09c0\u09af\u09bc" },
            { "ru", "\u09b0\u09c1\u09b6" },
            { "rw", "\u0995\u09bf\u09a8\u09af\u09bc\u09be\u09b0\u09cb\u09af\u09bc\u09be\u09a8\u09cd\u09a1\u09be" },
            { "sa", "\u09b8\u0982\u09b8\u09cd\u0995\u09c3\u09a4" },
            { "sc", "\u09b8\u09be\u09b0\u09cd\u09a1\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sd", "\u09b8\u09bf\u09a8\u09cd\u09a7\u09bf" },
            { "se", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09be\u09ae\u09bf" },
            { "sg", "\u09b8\u09be\u0999\u09cd\u0997\u09cb" },
            { "sh", "\u09b8\u09be\u09b0\u09cd\u09ac\u09cb-\u0995\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u09b6\u09bf\u09af\u09bc" },
            { "si", "\u09b8\u09bf\u0982\u09b9\u09b2\u09c0" },
            { "sk", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09be\u0995" },
            { "sl", "\u09b8\u09cd\u09b2\u09cb\u09ad\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "sm", "\u09b8\u09be\u09ae\u09cb\u09af\u09bc\u09be\u09a8" },
            { "sn", "\u09b6\u09cb\u09a8\u09be" },
            { "so", "\u09b8\u09cb\u09ae\u09be\u09b2\u09bf" },
            { "sq", "\u0986\u09b2\u09ac\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "sr", "\u09b8\u09be\u09b0\u09cd\u09ac\u09c0\u09af\u09bc" },
            { "ss", "\u09b8\u09cb\u09af\u09bc\u09be\u09a4\u09bf" },
            { "st", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a8 \u09b8\u09cb\u09a5\u09cb" },
            { "su", "\u09b8\u09c1\u09a6\u09be\u09a8\u09c0" },
            { "sv", "\u09b8\u09c1\u0987\u09a1\u09bf\u09b6" },
            { "sw", "\u09b8\u09cb\u09af\u09bc\u09be\u09b9\u09bf\u09b2\u09bf" },
            { "ta", metaValue_ta },
            { "te", "\u09a4\u09c7\u09b2\u09c1\u0997\u09c1" },
            { "tg", "\u09a4\u09be\u099c\u09bf\u0995" },
            { "th", metaValue_th },
            { "ti", "\u09a4\u09bf\u0997\u09b0\u09bf\u09a8\u09bf\u09af\u09bc\u09be" },
            { "tk", "\u09a4\u09c1\u09b0\u09cd\u0995\u09ae\u09c7\u09a8\u09c0" },
            { "tl", "\u09a4\u09be\u0997\u09be\u09b2\u0997" },
            { "tn", "\u09b8\u09cb\u09af\u09bc\u09be\u09a8\u09be" },
            { "to", "\u099f\u09cb\u0999\u09cd\u0997\u09be\u09a8" },
            { "tr", "\u09a4\u09c1\u09b0\u09cd\u0995\u09c0" },
            { "ts", "\u09b8\u0999\u09cd\u0997\u09be" },
            { "tt", "\u09a4\u09be\u09a4\u09be\u09b0" },
            { "tw", "\u099f\u09cb\u09af\u09bc\u09be\u0987" },
            { "ty", "\u09a4\u09be\u09b9\u09bf\u09a4\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ug", "\u0989\u0987\u0998\u09c1\u09b0" },
            { "uk", "\u0987\u0989\u0995\u09cd\u09b0\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "ur", "\u0989\u09b0\u09cd\u09a6\u09c1" },
            { "uz", "\u0989\u099c\u09ac\u09c7\u0995" },
            { "ve", "\u09ad\u09c7\u09a8\u09cd\u09a1\u09be" },
            { "vi", "\u09ad\u09bf\u09af\u09bc\u09c7\u09a4\u09a8\u09be\u09ae\u09c0" },
            { "vo", "\u09ad\u09cb\u09b2\u09be\u09aa\u09c1\u0995" },
            { "wa", "\u0993\u09af\u09bc\u09be\u09b2\u09c1\u09a8" },
            { "wo", "\u0993\u09b2\u09cb\u09ab" },
            { "xh", "\u099c\u09cb\u09b8\u09be" },
            { "yi", "\u0987\u09a6\u09cd\u09a6\u09bf\u09b6" },
            { "yo", "\u0987\u0993\u09b0\u09c1\u09ac\u09be" },
            { "za", "\u099d\u09c1\u09cd\u09af\u09bc\u09be\u0999" },
            { "zh", "\u099a\u09c0\u09a8\u09be" },
            { "zu", "\u099c\u09c1\u09b2\u09c1" },
            { "ace", "\u0985\u09cd\u09af\u09be\u099a\u09be\u0987\u09a8\u09bf\u099c" },
            { "ach", "\u0986\u0995\u09cb\u09b2\u09bf" },
            { "ada", "\u0985\u09a6\u09be\u0997\u09cd\u09ae\u09c7" },
            { "ady", "\u0986\u09a6\u09c7\u0997\u09c7" },
            { "afh", "\u0986\u09ab\u09cd\u09b0\u09bf\u09b9\u09bf\u09b2\u09bf" },
            { "agq", "\u098f\u0998\u09c7\u09ae" },
            { "ain", "\u0986\u0987\u09a8\u09c1" },
            { "akk", "\u0986\u0995\u09cd\u0995\u09be\u09a6\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ale", "\u0986\u09b2\u09c7\u0989\u09a4" },
            { "alt", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a8 \u0986\u09b2\u09a4\u09be\u0987" },
            { "ang", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0987\u0982\u09b0\u09c7\u099c\u09c0" },
            { "ann", "\u0993\u09ac\u09cb\u09b2\u09cb" },
            { "anp", "\u0986\u0999\u09cd\u0997\u09bf\u0995\u09be" },
            { "arc", "\u0986\u09b0\u09be\u09ae\u09be\u0987\u0995" },
            { "arn", "\u09ae\u09be\u09aa\u09c1\u099a\u09c7" },
            { "arp", "\u0986\u09b0\u09be\u09aa\u09be\u09b9\u09cb" },
            { "ars", "\u09a8\u099c\u09a6\u09bf \u0986\u09b0\u09ac\u09bf" },
            { "arw", "\u0986\u09b0\u09be\u0993\u09af\u09bc\u09be\u0995" },
            { "asa", "\u0986\u09b8\u09c1" },
            { "ast", "\u0986\u09b8\u09cd\u09a4\u09c1\u09b0\u09bf\u09af\u09bc" },
            { "atj", "\u0986\u099f\u09bf\u0995\u09be\u09ae\u09c7\u0995\u09bf\u0989" },
            { "awa", "\u0986\u0993\u09af\u09bc\u09be\u09a7\u09bf" },
            { "bal", "\u09ac\u09c7\u09b2\u09c1\u099a\u09c0" },
            { "ban", "\u09ac\u09be\u09b2\u09bf\u09a8\u09c0\u09af\u09bc" },
            { "bas", "\u09ac\u09be\u09b8\u09be" },
            { "bej", "\u09ac\u09c7\u099c\u09be" },
            { "bem", "\u09ac\u09c7\u09ae\u09cd\u09ac\u09be" },
            { "bez", "\u09ac\u09c7\u09a8\u09be" },
            { "bgc", "\u09b9\u09b0\u09bf\u09af\u09bc\u09be\u09a8\u09ad\u09bf" },
            { "bgn", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u09ac\u09be\u09b2\u09cb\u099a\u09bf" },
            { "bho", "\u09ad\u09cb\u099c\u09aa\u09c1\u09b0\u09bf" },
            { "bik", "\u09ac\u09bf\u0995\u09cb\u09b2" },
            { "bin", "\u09ac\u09bf\u09a8\u09bf" },
            { "bla", "\u09b8\u09bf\u0995\u09b8\u09bf\u0995\u09be" },
            { "bra", "\u09ac\u09cd\u09b0\u09be\u099c" },
            { "brx", "\u09ac\u09cb\u09a1\u09bc\u09cb" },
            { "bua", "\u09ac\u09c1\u09b0\u09bf\u09af\u09bc\u09be\u09a4" },
            { "bug", "\u09ac\u09c1\u0997\u09bf\u09a8\u09bf\u099c" },
            { "byn", "\u09ac\u09cd\u09b2\u09bf\u09a8" },
            { "cad", "\u0995\u09cd\u09af\u09be\u09a1\u09cb" },
            { "car", "\u0995\u09cd\u09af\u09be\u09b0\u09bf\u09ac" },
            { "cay", "\u0995\u09be\u09af\u09bc\u09c1\u0997\u09be" },
            { "cch", "\u0986\u09a4\u09cd\u09b8\u09be\u09ae" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u099a\u09c7\u09ac\u09c1\u09af\u09bc\u09be\u09a8\u09cb" },
            { "cgg", "\u099a\u09bf\u0997\u09be" },
            { "chb", "\u099a\u09bf\u09ac\u099a\u09be" },
            { "chg", "\u099a\u09be\u0997\u09be\u09a4\u09be\u0987" },
            { "chk", "\u099a\u09c1\u0995\u09bf\u099c" },
            { "chm", "\u09ae\u09be\u09b0\u09bf" },
            { "chn", "\u099a\u09bf\u09a8\u09c1\u0995 \u099c\u09be\u09b0\u09cd\u0997\u09a8" },
            { "cho", "\u099a\u0995\u099f\u09be\u0993" },
            { "chp", "\u099a\u09bf\u09aa\u09c7\u0993\u09af\u09bc\u09be\u09a8" },
            { "chr", "\u099a\u09c7\u09b0\u09cb\u0995\u09c0" },
            { "chy", "\u099a\u09c7\u0987\u09af\u09bc\u09c7\u09a8" },
            { "ckb", "\u09ae\u09a7\u09cd\u09af \u0995\u09c1\u09b0\u09cd\u09a6\u09bf\u09b6" },
            { "clc", "\u099a\u09bf\u09b2\u0995\u09cb\u099f\u09bf\u09a8" },
            { "cop", "\u0995\u09aa\u099f\u09bf\u0995" },
            { "crg", "\u09ae\u09bf\u099a\u09bf\u09ab" },
            { "crh", "\u0995\u09cd\u09b0\u09bf\u09ae\u09bf\u09af\u09bc\u09be\u09a8 \u09a4\u09c1\u09b0\u09cd\u0995\u09bf" },
            { "crj", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u09aa\u09c2\u09b0\u09cd\u09ac \u0995\u09cd\u09b0\u09c0" },
            { "crk", "\u09aa\u09cd\u09b2\u09c7\u09a8\u09b8 \u0995\u09cd\u09b0\u09c0" },
            { "crl", "\u0989\u09a4\u09cd\u09a4\u09b0 \u09aa\u09c2\u09b0\u09cd\u09ac \u0995\u09cd\u09b0\u09c0" },
            { "crm", "\u09ae\u09c1\u09b8 \u0995\u09cd\u09b0\u09c0" },
            { "crr", "\u0995\u09cd\u09af\u09be\u09b0\u09cb\u09b2\u09bf\u09a8\u09be \u0985\u09cd\u09af\u09be\u09b2\u09cd\u0997\u0999\u09cd\u0995\u09c1\u0987\u09af\u09bc\u09be\u09a8" },
            { "crs", "\u09b8\u09c7\u09b8\u09c7\u09b2\u0993\u09af\u09bc\u09be \u0995\u09cd\u09b0\u09c7\u0993\u09b2 \u09ab\u09cd\u09b0\u09c7\u099e\u09cd\u099a" },
            { "csb", "\u0995\u09be\u09b6\u09c1\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "csw", "\u09b8\u09cb\u09af\u09bc\u09be\u09ae\u09cd\u09aa\u09bf \u0995\u09cd\u09b0\u09c0" },
            { "dak", "\u09a1\u09be\u0995\u09cb\u099f\u09be" },
            { "dar", "\u09a6\u09be\u09b0\u09cd\u0997\u0993\u09af\u09bc\u09be" },
            { "dav", "\u09a4\u09be\u0987\u09a4\u09be" },
            { "del", "\u09a1\u09c7\u09b2\u09be\u0993\u09af\u09bc\u09c7\u09b0" },
            { "den", "\u09b8\u09cd\u09b2\u09cd\u09af\u09be\u09ad" },
            { "dgr", "\u09a6\u09cb\u0997\u09cd\u09b0\u09c0\u09ac" },
            { "din", "\u09a1\u09bf\u0982\u0995\u09be" },
            { "dje", "\u099c\u09be\u09b0\u09cd\u09ae\u09be" },
            { "doi", "\u09a1\u09cb\u0997\u09b0\u09bf" },
            { "dsb", "\u09a8\u09bf\u09ae\u09cd\u09a8\u09a4\u09b0 \u09b8\u09cb\u09b0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "dua", "\u09a6\u09c1\u09af\u09bc\u09be\u09b2\u09be" },
            { "dum", "\u09ae\u09a7\u09cd\u09af \u09a1\u09be\u099a" },
            { "dyo", "\u099c\u09cb\u09b2\u09be-\u09ab\u09a8\u09c0" },
            { "dyu", "\u09a1\u09bf\u0989\u09b2\u09be" },
            { "dzg", "\u09a6\u09be\u099c\u09be\u0997\u09be" },
            { "ebu", "\u098f\u09ae\u09cd\u09ac\u09c1" },
            { "efi", "\u098f\u09ab\u09bf\u0995" },
            { "egy", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc" },
            { "eka", "\u0987\u0995\u09be\u099c\u09c1\u0995" },
            { "elx", "\u098f\u09b2\u09be\u09ae\u09be\u0987\u099f" },
            { "enm", "\u09ae\u09a7\u09cd\u09af \u0987\u0982\u09b0\u09c7\u099c\u09bf" },
            { "ewo", "\u0987\u0993\u09a8\u09cd\u09a1\u09cb" },
            { "fan", "\u09ab\u09cd\u09af\u09be\u0999\u09cd\u0997" },
            { "fat", "\u09ab\u09be\u09a8\u09cd\u09a4\u09bf" },
            { "fil", "\u09ab\u09bf\u09b2\u09bf\u09aa\u09bf\u09a8\u09cb" },
            { "fon", "\u09ab\u09a8" },
            { "frc", "\u0995\u09be\u099c\u09c1\u09a8 \u09ab\u09b0\u09be\u09b8\u09bf" },
            { "frm", "\u09ae\u09a7\u09cd\u09af \u09ab\u09b0\u09be\u09b8\u09bf" },
            { "fro", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09ab\u09b0\u09be\u09b8\u09bf" },
            { "frr", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09ab\u09cd\u09b0\u09bf\u09b8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "frs", "\u09aa\u09c2\u09b0\u09cd\u09ac \u09ab\u09cd\u09b0\u09bf\u09b8\u09bf\u09af\u09bc" },
            { "fur", "\u09ab\u09cd\u09b0\u09bf\u0989\u09b2\u09bf\u0993" },
            { "gaa", "\u0997\u09be" },
            { "gag", "\u0997\u09be\u0997\u09be\u0989\u099c" },
            { "gan", "gan" },
            { "gay", "\u0997\u09be\u09af\u09bc\u09cb" },
            { "gba", "\u09ac\u09be\u09af\u09bc\u09be" },
            { "gez", "\u0997\u09c0\u099c" },
            { "gil", "\u0997\u09bf\u09b2\u09ac\u09be\u09b0\u09cd\u099f\u09bf\u099c" },
            { "gmh", "\u09ae\u09a7\u09cd\u09af-\u0989\u099a\u09cd\u099a \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf" },
            { "goh", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0989\u099a\u09cd\u099a \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf" },
            { "gon", "\u0997\u09cb\u09a8\u09cd\u09a1\u09bf" },
            { "gor", "\u0997\u09cb\u09b0\u09cb\u09a8\u09cd\u09a4\u09be\u09b2\u09cb" },
            { "got", "\u0997\u09a5\u09bf\u0995" },
            { "grb", "\u0997\u09cd\u09b0\u09c7\u09ac\u09cb" },
            { "grc", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0997\u09cd\u09b0\u09c0\u0995" },
            { "gsw", "\u09b8\u09c1\u0987\u09b8 \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8" },
            { "guz", "\u0997\u09c1\u09b8\u09c0" },
            { "gwi", "\u0997\u0993\u0987\u099a\u09cd\u2019\u0987\u09a8" },
            { "hai", "\u09b9\u09be\u0987\u09a1\u09be" },
            { "haw", "\u09b9\u09be\u0993\u09af\u09bc\u09be\u0987\u09af\u09bc\u09be\u09a8" },
            { "hax", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3\u09c0 \u09b9\u09be\u09af\u09bc\u09a6\u09be" },
            { "hil", "\u09b9\u09bf\u09b2\u09bf\u0997\u09cd\u09af\u09be\u09af\u09bc\u09a8\u09cb\u09a8" },
            { "hit", "\u09b9\u09bf\u099f\u09cd\u099f\u09bf\u099f" },
            { "hmn", "\u09b9\u09cd\u200c\u09ae\u09cb\u0999" },
            { "hsb", "\u0989\u099a\u09cd\u099a \u09b8\u09cb\u09b0\u09cd\u09ac\u09bf\u09af\u09bc\u09be\u09a8" },
            { "hsn", "Xiang \u099a\u09c0\u09a8\u09be" },
            { "hup", "\u09b9\u09c1\u09aa\u09be" },
            { "hur", "\u09b9\u09be\u09b2\u09cd\u0995\u09cb\u09ae\u09c7\u09b2\u09c7\u09ae" },
            { "iba", "\u0987\u09ac\u09be\u09a8" },
            { "ibb", "\u0987\u09ac\u09bf\u09ac\u09bf\u0993" },
            { "ikt", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc \u0987\u09a8\u09c1\u0995\u09cd\u099f\u09bf\u099f\u09c1\u099f" },
            { "ilo", "\u0987\u09b2\u09cb\u0995\u09cb" },
            { "inh", "\u0987\u0999\u09cd\u0997\u09c1\u09b6" },
            { "jbo", "\u09b2\u09cb\u099c\u09ac\u09be\u09a8" },
            { "jgo", "\u0997\u09cb\u09ae\u09cd\u09ac\u09be" },
            { "jmc", "\u09ae\u09be\u0995\u09be\u09ae\u09c7" },
            { "jpr", "\u099c\u09c1\u09a6\u09c7\u0993 \u09ab\u09be\u09b0\u09cd\u09b8\u09bf" },
            { "jrb", "\u099c\u09c1\u09a6\u09c7\u0993 \u0986\u09b0\u09ac\u09bf" },
            { "kaa", "\u0995\u09be\u09b0\u09be-\u0995\u09be\u09b2\u09cd\u09aa\u09be\u0995" },
            { "kab", "\u0995\u09be\u09ac\u09be\u0987\u09b2\u09c7" },
            { "kac", "\u0995\u09be\u099a\u09bf\u09a8" },
            { "kaj", "\u099c\u099c\u09c1" },
            { "kam", "\u0995\u09be\u09ae\u09cd\u09ac\u09be" },
            { "kaw", "\u0995\u09be\u0989\u0987" },
            { "kbd", "\u0995\u09be\u09ac\u09be\u09b0\u09cd\u09a1\u09bf\u09af\u09bc\u09be\u09a8" },
            { "kcg", "\u099f\u09bf\u09af\u09bc\u09be\u09aa" },
            { "kde", "\u09ae\u09be\u0995\u09cb\u09a8\u09cd\u09a6\u09c7" },
            { "kea", "\u0995\u09be\u09ac\u09c1\u09ad\u09be\u09b0\u09a6\u09bf\u09af\u09bc\u09be\u09a8\u09c1" },
            { "kfo", "\u0995\u09cb\u09b0\u09cb" },
            { "kgp", "\u0995\u09c7\u0987\u09a8\u0997\u09cd\u09af\u09be\u0982" },
            { "kha", "\u0996\u09be\u09b6\u09bf" },
            { "kho", "\u0996\u09cb\u099f\u09be\u09a8\u09bf\u099c" },
            { "khq", "\u0995\u09cb\u09af\u09bc\u09b0\u09be \u099a\u09c0\u09a8\u09bf" },
            { "kkj", "\u0995\u09be\u0995\u09cb" },
            { "kln", "\u0995\u09be\u09b2\u09c7\u09a8\u099c\u09bf\u09a8" },
            { "kmb", "\u0995\u09bf\u09ae\u09cd\u09ac\u09c1\u09a8\u09cd\u09a6\u09c1" },
            { "koi", "\u0995\u09ae\u09bf-\u09aa\u09be\u09b0\u09ae\u09bf\u0986\u0995" },
            { "kok", "\u0995\u09cb\u0999\u09cd\u0995\u09be\u09a8\u09bf" },
            { "kos", "\u0995\u09cb\u09b8\u09cd\u09b0\u09be\u0987\u09a8" },
            { "kpe", "\u0995\u09cd\u200c\u09aa\u09c7\u09b2\u09cd\u09b2\u09c7" },
            { "krc", "\u0995\u09be\u09b0\u099a\u09c7-\u09ac\u09be\u09b2\u09cd\u0995\u09be\u09b0" },
            { "krl", "\u0995\u09be\u09b0\u09c7\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "kru", "\u0995\u09c1\u09b0\u09c1\u0996" },
            { "ksb", "\u09b6\u09be\u09ae\u09cd\u09ac\u09be\u09b2\u09be" },
            { "ksf", "\u09ac\u09be\u09ab\u09bf\u09af\u09bc\u09be" },
            { "ksh", "\u0995\u09b2\u09cb\u0997\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "kum", "\u0995\u09c1\u09ae\u09bf\u09af\u09bc\u09be\u0995" },
            { "kut", "\u0995\u09c1\u099f\u09c7\u09a8\u09be\u0987" },
            { "kwk", "\u0995\u09cb\u09af\u09bc\u09be\u0995\u2019\u0993\u09af\u09bc\u09be\u09b2\u09be" },
            { "lad", "\u09b2\u09be\u09a6\u09bf\u09a8\u09cb" },
            { "lag", "\u09b2\u09be\u0999\u09cd\u0997\u09bf" },
            { "lah", "\u09b2\u09be\u09a8\u09cd\u09a1\u09be" },
            { "lam", "\u09b2\u09be\u09ae\u09cd\u09ac\u09be" },
            { "lez", "\u09b2\u09c7\u099c\u0998\u09bf\u09af\u09bc\u09be\u09a8" },
            { "lil", "\u09b2\u09bf\u09b2\u09cd\u09b2\u09c1\u09af\u09bc\u09c7\u099f" },
            { "lkt", "\u09b2\u09be\u0995\u09cb\u099f\u09be" },
            { "lmo", "\u09b2\u09ae\u09cd\u09ac\u09be\u09b0\u09cd\u09a1" },
            { "lol", "\u09ae\u09cb\u0999\u09cd\u0997\u09cb" },
            { "lou", "\u09b2\u09c1\u0987\u09b8\u09bf\u09af\u09bc\u09be\u09a8\u09be \u0995\u09cd\u09b0\u09c7\u0993\u09b2" },
            { "loz", "\u09b2\u09cb\u099c\u09bf" },
            { "lrc", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b2\u09c1\u09b0\u09bf" },
            { "lsm", "\u09b8\u09be\u09ae\u09bf\u09af\u09bc\u09be" },
            { "lua", "\u09b2\u09c1\u09ac\u09be-\u09b2\u09c1\u09b2\u09c1\u09af\u09bc\u09be" },
            { "lui", "\u09b2\u09c1\u0987\u09b8\u09c7\u09a8\u09cb" },
            { "lun", "\u09b2\u09c1\u09a8\u09cd\u09a1\u09be" },
            { "luo", "\u09b2\u09c1\u09af\u09bc\u09cb" },
            { "lus", "\u09ae\u09bf\u099c\u09cb" },
            { "luy", "\u09b2\u09c1\u0987\u09af\u09bc\u09be" },
            { "mad", "\u09ae\u09be\u09a6\u09c1\u09b0\u09c7\u099c" },
            { "mag", "\u09ae\u09be\u0997\u09be\u09b9\u09bf" },
            { "mai", "\u09ae\u09c8\u09a5\u09bf\u09b2\u09bf" },
            { "mak", "\u09ae\u09cd\u09af\u09be\u0995\u09be\u09b8\u09be\u09b0" },
            { "man", "\u09ae\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09bf\u0999\u09cd\u0997\u09cb" },
            { "mas", "\u09ae\u09be\u09b8\u09be\u0987" },
            { "mdf", "\u09ae\u09cb\u0995\u09b6\u09be" },
            { "mdr", "\u09ae\u09cd\u09af\u09be\u09a3\u09cd\u09a1\u09be\u09b0" },
            { "men", "\u09ae\u09c7\u09a8\u09cd\u09a1\u09c7" },
            { "mer", "\u09ae\u09c7\u09b0\u09c1" },
            { "mfe", "\u09ae\u09b0\u09bf\u09b8\u09bf\u09af\u09bc\u09c7\u09a8" },
            { "mga", "\u09ae\u09a7\u09cd\u09af \u0986\u0987\u09b0\u09bf\u09b6" },
            { "mgh", "\u09ae\u09be\u0996\u09c1\u09af\u09bc\u09be-\u09ae\u09c7\u09a4\u09cd\u09a4\u09cb" },
            { "mgo", "\u09ae\u09c7\u099f\u09be" },
            { "mic", "\u09ae\u09bf\u0995\u09ae\u09cd\u09af\u09be\u0995" },
            { "min", "\u09ae\u09bf\u09a8\u09be\u0982\u0995\u09be\u09ac\u09be\u0989" },
            { "mnc", "\u09ae\u09be\u099e\u09cd\u099a\u09c1" },
            { "mni", "\u09ae\u09a3\u09bf\u09aa\u09c1\u09b0\u09c0" },
            { "moe", "\u0987\u09a8\u09cd\u09a8\u09c1-\u098f\u09ae\u09c1\u09a8" },
            { "moh", "\u09ae\u09cb\u09b9\u09be\u0993\u0995" },
            { "mos", "\u09ae\u09b8\u09bf" },
            { "mua", "\u09ae\u09c1\u09a6\u09be\u0999\u09cd\u0997" },
            { "mul", "\u098f\u0995\u09be\u09a7\u09bf\u0995 \u09ad\u09be\u09b7\u09be" },
            { "mus", "\u09ae\u09c1\u09b8\u09cd\u0995\u09cb\u0997\u09c0" },
            { "mwl", "\u09ae\u09bf\u09b0\u09be\u09a8\u09cd\u09a1\u09bf\u099c" },
            { "mwr", "\u09ae\u09be\u09b0\u09cb\u09af\u09bc\u09be\u09b0\u09bf" },
            { "myv", "\u098f\u09b0\u099c\u09bf\u09af\u09bc\u09be" },
            { "mzn", "\u09ae\u09be\u099c\u09be\u09a8\u09a6\u09c7\u09b0\u09be\u09a8\u09bf" },
            { "nap", "\u09a8\u09c7\u09af\u09bc\u09be\u09aa\u09cb\u09b2\u09bf\u099f\u09be\u09a8" },
            { "naq", "\u09a8\u09be\u09ae\u09be" },
            { "nds", "\u09a8\u09bf\u09ae\u09cd\u09a8 \u099c\u09be\u09b0\u09cd\u09ae\u09be\u09a8\u09bf" },
            { "new", "\u09a8\u09c7\u0993\u09af\u09bc\u09be\u09b0\u09bf" },
            { "nia", "\u09a8\u09bf\u09af\u09bc\u09be\u09b8" },
            { "niu", "\u09a8\u09bf\u0989\u09af\u09bc\u09be\u09a8" },
            { "nmg", "\u0995\u09cb\u09af\u09bc\u09be\u09b8\u09bf\u0993" },
            { "nnh", "\u09a8\u0997\u09bf\u09af\u09bc\u09c7\u09ae\u09cd\u09ac\u09c1\u09a8" },
            { "nog", "\u09a8\u09cb\u0997\u09be\u0987" },
            { "non", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09a8\u09b0\u09cd\u09b8" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09cb\u09a5\u09cb" },
            { "nus", "\u09a8\u09c1\u09af\u09bc\u09be\u09b0" },
            { "nwc", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09a8\u09c7\u0993\u09af\u09bc\u09be\u09b0\u09c0" },
            { "nym", "\u09a8\u09cd\u09af\u09be\u09af\u09bc\u09be\u09ae\u0993\u09af\u09bc\u09c7\u099c\u09bf" },
            { "nyn", "\u09a8\u09cd\u09af\u09be\u09af\u09bc\u09be\u0999\u09cd\u0995\u09cb\u09b2\u09c7" },
            { "nyo", "\u09a8\u09cd\u09af\u09cb\u09b0\u09cb" },
            { "nzi", "\u098f\u09a8\u099c\u09bf\u09ae\u09be" },
            { "ojb", "\u0989\u09a4\u09cd\u09a4\u09b0 \u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0993\u099c\u09bf\u09ac\u09cb\u09af\u09bc\u09be" },
            { "ojc", "\u09ae\u09a7\u09cd\u09af \u0993\u099c\u09bf\u09ac\u09c1\u09af\u09bc\u09be" },
            { "ojs", "\u0993\u099c\u09bf-\u0995\u09cd\u09b0\u09c0" },
            { "ojw", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae \u0993\u099c\u09bf\u09ac\u09cb\u09af\u09bc\u09be" },
            { "oka", "\u0993\u0995\u09be\u09a8\u09be\u0997\u09be\u09a8" },
            { "osa", "\u0993\u09b8\u09c7\u099c" },
            { "ota", "\u0985\u099f\u09cb\u09ae\u09be\u09a8 \u09a4\u09c1\u09b0\u09cd\u0995\u09bf" },
            { "pag", "\u09aa\u09be\u0999\u09cd\u0997\u09be\u09b8\u09bf\u09a8\u09be\u09a8" },
            { "pal", "\u09aa\u09be\u09b9\u09cd\u09b2\u09be\u09ad\u09bf" },
            { "pam", "\u09aa\u09be\u09ae\u09cd\u09aa\u09be\u0999\u09cd\u0997\u09be" },
            { "pap", "\u09aa\u09be\u09aa\u09bf\u09af\u09bc\u09be\u09ae\u09c7\u09a8\u09cd\u099f\u09cb" },
            { "pau", "\u09aa\u09be\u09b2\u09be\u09af\u09bc\u09c1\u09af\u09bc\u09be\u09a8" },
            { "pcm", "\u09a8\u09be\u0987\u099c\u09c7\u09b0\u09bf\u09af\u09bc \u09aa\u09bf\u099c\u09bf\u09a8" },
            { "peo", metaValue_peo },
            { "phn", "\u09ab\u09cb\u09a8\u09bf\u09b6\u09c0\u09af\u09bc\u09be\u09a8" },
            { "pis", "\u09aa\u09bf\u099c\u09bf\u09a8" },
            { "pon", "\u09aa\u09cb\u09b9\u09cd\u09a8\u09aa\u09c7\u0987\u09af\u09bc\u09be\u09a8" },
            { "pqm", "\u09ae\u09be\u09b2\u09bf\u09b8\u09c7\u099f-\u09aa\u09be\u09b8\u09be\u09ae\u09be\u0995\u09c1\u09af\u09bc\u09cb\u09a1\u09cd\u09a1\u09bf" },
            { "prg", "\u09aa\u09cd\u09b0\u09c1\u09b6\u09bf\u09af\u09bc\u09be\u09a8" },
            { "pro", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09aa\u09cd\u09b0\u09cb\u09ad\u09c7\u09a8\u09b8\u09be\u09b2" },
            { "quc", "\u0995\u09bf\u2018\u099a\u09c7" },
            { "raj", "\u09b0\u09be\u099c\u09b8\u09cd\u09a5\u09be\u09a8\u09c0" },
            { "rap", "\u09b0\u09be\u09aa\u09be\u09a8\u09c1\u0987" },
            { "rar", "\u09b0\u09be\u09b0\u09cb\u099f\u09cb\u0982\u0997\u09be\u09a8" },
            { "rhg", "\u09b0\u09cb\u09b9\u09bf\u0999\u09cd\u0997\u09be" },
            { "rof", "\u09b0\u09ae\u09cd\u09ac\u09cb" },
            { "rom", "\u09b0\u09cb\u09ae\u09be\u09a8\u09bf" },
            { "rup", "\u0986\u09b0\u09cb\u09ae\u09c7\u09a8\u09bf\u09af\u09bc" },
            { "rwk", "\u09b0\u09be\u0993\u09af\u09bc\u09be" },
            { "sad", "\u09b8\u09be\u09a8\u09cd\u09a6\u09be\u0993\u09af\u09bc\u09c7" },
            { "sah", "\u09b6\u09be\u0996\u09be" },
            { "sam", "\u09b8\u09be\u09ae\u09be\u09b0\u09bf\u099f\u09be\u09a8 \u0986\u09b0\u09be\u09ae\u09bf\u0995" },
            { "saq", "\u09b8\u09be\u09ae\u09ac\u09c1\u09b0\u09c1" },
            { "sas", "\u09b8\u09be\u09b8\u09be\u0995" },
            { "sat", "\u09b8\u09be\u0981\u0993\u09a4\u09be\u09b2\u09bf" },
            { "sba", "\u0997\u09be\u09ae\u09cd\u09ac\u09c7" },
            { "sbp", "\u09b8\u09be\u0999\u09cd\u0997\u09c1" },
            { "scn", "\u09b8\u09bf\u09b8\u09bf\u09b2\u09bf\u09af\u09bc\u09be\u09a8" },
            { "sco", "\u09b8\u09cd\u0995\u099f\u09b8" },
            { "sdh", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3 \u0995\u09c1\u09b0\u09cd\u09a6\u09bf\u09b6" },
            { "seh", "\u09b8\u09c7\u09a8\u09be" },
            { "sel", "\u09b8\u09c7\u09b2\u09cd\u0995\u09c1\u09aa" },
            { "ses", "\u0995\u09cb\u09af\u09bc\u09b0\u09be\u09ac\u09cb\u09b0\u09cb \u09b8\u09c7\u09a8\u09cd\u09a8\u09bf" },
            { "sga", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0986\u0987\u09b0\u09bf\u09b6" },
            { "shi", "\u09a4\u09be\u099a\u09c7\u09b2\u09b9\u09bf\u09a4" },
            { "shn", "\u09b6\u09be\u09a8" },
            { "sid", "\u09b8\u09bf\u09a1\u09be\u09ae\u09cb" },
            { "slh", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3\u09c0 \u09b2\u09c1\u09b6\u09c1\u099f\u09b8\u09c0\u09a1" },
            { "sma", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09be\u09ae\u09bf" },
            { "smj", "\u09b2\u09c1\u09b2\u09c7 \u09b8\u09be\u09ae\u09bf" },
            { "smn", "\u0987\u09a8\u09be\u09b0\u09bf \u09b8\u09be\u09ae\u09bf" },
            { "sms", "\u09b8\u09cd\u0995\u09cb\u09b2\u09cd\u099f \u09b8\u09be\u09ae\u09bf" },
            { "snk", "\u09b8\u09cb\u09a8\u09bf\u0999\u09cd\u0995\u09c7" },
            { "sog", "\u09b8\u09cb\u0997\u09a1\u09bf\u09af\u09bc\u09be\u09a8" },
            { "srn", "\u09b8\u09cd\u09b0\u09be\u09a8\u09be\u09a8 \u099f\u09cb\u0999\u09cd\u0997\u09cb" },
            { "srr", "\u09b8\u09c7\u09b0\u09c7\u09b0" },
            { "ssy", "\u09b8\u09be\u09b9\u09cb" },
            { "str", "\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u099f\u09b8 \u09b8\u09be\u09b2\u09bf\u09b8" },
            { "suk", "\u09b8\u09c1\u0995\u09c1\u09ae\u09be" },
            { "sus", "\u09b8\u09c1\u09b8\u09c1" },
            { "sux", "\u09b8\u09c1\u09ae\u09c7\u09b0\u09c0\u09af\u09bc" },
            { "swb", "\u0995\u09ae\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8" },
            { "syc", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09b8\u09bf\u09b0\u09bf\u0993" },
            { "syr", metaValue_syr },
            { "tce", "\u09a6\u0995\u09cd\u09b7\u09bf\u09a3\u09c0 \u099f\u09c1\u099a\u09cb\u09a8" },
            { "tem", "\u099f\u09be\u0987\u09ae\u09cd\u09a8\u09c7" },
            { "teo", "\u09a4\u09c7\u09b8\u09cb" },
            { "ter", "\u09a4\u09c7\u09b0\u09c7\u09a8\u09cb" },
            { "tet", "\u09a4\u09c7\u09a4\u09c1\u09ae" },
            { "tgx", "\u09a4\u09be\u0997\u09bf\u09b6" },
            { "tht", "\u09a4\u09be\u09b9\u09cd\u09b2\u09a4\u09be\u09a8" },
            { "tig", "\u099f\u09be\u0987\u0997\u09cd\u09b0\u09c7" },
            { "tiv", "\u099f\u09bf\u09ad" },
            { "tkl", metaValue_TK },
            { "tlh", "\u0995\u09cd\u09b2\u09bf\u0999\u09cd\u0997\u09a8" },
            { "tli", "\u09a4\u09cd\u09b2\u09bf\u0999\u09cd\u0997\u09bf\u099f" },
            { "tmh", "\u09a4\u09be\u09ae\u09be\u09b6\u09c7\u0995" },
            { "tog", "\u09a8\u09be\u09af\u09bc\u09be\u09b8\u09be \u099f\u09cb\u0999\u09cd\u0997\u09be" },
            { "tok", "\u099f\u09cb\u0995\u09bf \u09aa\u09cb\u09a8\u09be" },
            { "tpi", "\u099f\u09cb\u0995 \u09aa\u09bf\u09b8\u09bf\u09a8" },
            { "trv", "\u09a4\u09be\u09b0\u09cb\u0995\u09cb" },
            { "tsi", "\u09b8\u09bf\u09ae\u09b6\u09bf\u09af\u09bc\u09be\u09a8" },
            { "ttm", "\u0989\u09a4\u09cd\u09a4\u09b0\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u099f\u09c1\u099a\u09cb\u09a8" },
            { "tum", "\u09a4\u09c1\u09ae\u09cd\u09ac\u09c1\u0995\u09be" },
            { "tvl", metaValue_TV },
            { "twq", "\u09a4\u09be\u09b8\u09be\u0993\u09af\u09bc\u09be\u0995" },
            { "tyv", "\u099f\u09c1\u09ad\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "tzm", "\u09b8\u09c7\u09a8\u09cd\u099f\u09cd\u09b0\u09be\u09b2 \u0986\u099f\u09b2\u09be\u09b8 \u09a4\u09be\u09ae\u09be\u099c\u09bf\u0997\u09be\u09a4" },
            { "udm", "\u0989\u09a1\u09ae\u09c1\u09b0\u09cd\u099f" },
            { "uga", metaValue_uga },
            { "umb", "\u0989\u09ae\u09cd\u09ac\u09c1\u09a8\u09cd\u09a6\u09c1" },
            { "und", "\u0985\u099c\u09be\u09a8\u09be \u09ad\u09be\u09b7\u09be" },
            { "vai", metaValue_vai },
            { "vot", "\u09ad\u09cb\u099f\u09bf\u0995" },
            { "vun", "\u09ad\u09c1\u099e\u09cd\u099c\u09cb" },
            { "wae", "\u0993\u09af\u09bc\u09be\u09b2\u09b8\u09be\u09b0" },
            { "wal", "\u0993\u09b2\u09be\u09af\u09bc\u099f\u09cd\u099f\u09be" },
            { "war", "\u0993\u09af\u09bc\u09be\u09b0\u09c7" },
            { "was", "\u0993\u09af\u09bc\u09be\u09b6\u09cb" },
            { "wbp", "\u0993\u09af\u09bc\u09be\u09b0\u09cd\u09b2\u09aa\u09bf\u09b0\u09bf" },
            { "wuu", "\u0989 \u099a\u09c0\u09a8\u09be" },
            { "xal", "\u0995\u09be\u09b2\u09cd\u09ae\u09be\u0987\u0995" },
            { "xog", "\u09b8\u09cb\u0997\u09be" },
            { "yao", "\u0987\u09af\u09bc\u09be\u0993" },
            { "yap", "\u0987\u09af\u09bc\u09be\u09aa\u09c7\u09b8\u09c7" },
            { "yav", "\u0987\u09af\u09bc\u09be\u0999\u09cd\u0997\u09ac\u09c7\u09a8" },
            { "ybb", "\u0987\u09af\u09bc\u09c7\u09ae\u09cd\u09ac\u09be" },
            { "yrl", "\u09a8\u09b9\u09bf\u0982\u0997\u09be\u099f\u09c1" },
            { "yue", "\u0995\u09cd\u09af\u09be\u09a8\u09cd\u099f\u09cb\u09a8\u09bf\u099c" },
            { "zap", "\u099c\u09be\u09aa\u09cb\u099f\u09c7\u0995" },
            { "zbl", "\u099a\u09bf\u09a4\u09cd\u09b0 \u09ad\u09be\u09b7\u09be" },
            { "zen", "\u099c\u09c7\u09a8\u09be\u0997\u09be" },
            { "zgh", "\u0986\u09a6\u09b0\u09cd\u09b6 \u09ae\u09b0\u0995\u09cd\u0995\u09cb\u09a8 \u09a4\u09be\u09ae\u09be\u099c\u09bf\u0997\u09be\u09a4" },
            { "zun", "\u099c\u09c1\u09a8\u09bf" },
            { "zxx", "\u09ad\u09be\u09b7\u09be\u09ad\u09bf\u09a4\u09cd\u09a4\u09bf\u0995 \u09ac\u09bf\u09b7\u09af\u09bc\u09ac\u09b8\u09cd\u09a4\u09c1 \u09a8\u09c7\u0987" },
            { "zza", "\u099c\u09be\u099c\u09be" },
            { "Adlm", "\u0986\u09a6\u09b2\u09be\u09ae" },
            { "Arab", metaValue_ar },
            { "Aran", "\u09a8\u09be\u09b8\u09cd\u09a4\u09be\u09b2\u09bf\u0995" },
            { "Armi", "\u0986\u09b0\u09ae\u09bf" },
            { "Armn", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc" },
            { "Avst", "\u0986\u09ad\u09c7\u09b8\u09a4\u09be\u09a8" },
            { "Bali", "\u09ac\u09be\u09b2\u09c0\u09af\u09bc" },
            { "Batk", "\u09ac\u09be\u099f\u09be\u0995" },
            { "Beng", metaValue_bn },
            { "Blis", "\u09ac\u09cd\u09b2\u09bf\u09b8\u09aa\u09cd\u09b0\u09a4\u09c0\u0995" },
            { "Bopo", "\u09ac\u09cb\u09aa\u09cb\u09ae\u09cb\u09ab\u09cb" },
            { "Brah", "\u09ac\u09cd\u09b0\u09be\u09b9\u09cd\u09ae\u09c0" },
            { "Brai", "\u09ac\u09cd\u09b0\u09c7\u0987\u09b2" },
            { "Bugi", "\u09ac\u09c1\u0997\u09bf" },
            { "Buhd", "\u09ac\u09c1\u09b9\u09bf\u09a1" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u09b8\u0982\u09af\u09c1\u0995\u09cd\u09a4 \u0995\u09be\u09a8\u09be\u09a1\u09bf\u09af\u09bc\u09be\u09a8 \u0985\u09cd\u09af\u09be\u09ac\u09cb\u09b0\u09bf\u099c\u09bf\u09a8\u09be\u09b2 \u09b8\u09bf\u09b2\u09c7\u09ac\u09bf\u0995\u09cd\u09b8" },
            { "Cari", "\u0995\u09cd\u09af\u09be\u09b0\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Cham", "\u099a\u09cd\u09af\u09be\u09ae" },
            { "Cher", "\u099a\u09c7\u09b0\u09cb\u0995\u09bf" },
            { "Cirt", "\u0995\u09bf\u09b0\u09cd\u099f" },
            { "Copt", "\u0995\u09cb\u09aa\u09cd\u099f\u09bf\u0995" },
            { "Cprt", "\u09b8\u09be\u0987\u09aa\u09cd\u09b0\u09cb\u09af\u09bc\u09c7\u099f" },
            { "Cyrl", "\u09b8\u09bf\u09b0\u09bf\u09b2\u09bf\u0995" },
            { "Cyrs", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u099a\u09be\u09b0\u09cd\u099a \u09b8\u09cd\u09b2\u09be\u09ad\u09cb\u09a8\u09bf\u0995 \u09b8\u09bf\u09b0\u09bf\u09b2\u09bf\u0995" },
            { "Deva", "\u09a6\u09c7\u09ac\u09a8\u0997\u09b0\u09bf" },
            { "Dsrt", "\u09a6\u09c7\u09b8\u09c7\u09b0\u09be\u09a4" },
            { "Egyd", "\u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc \u09a1\u09c7\u09ae\u09cb\u099f\u09bf\u0995" },
            { "Egyh", "\u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc \u09b9\u09be\u09af\u09bc\u09b0\u09c7\u099f\u09bf\u0995" },
            { "Egyp", "\u09ae\u09bf\u09b6\u09b0\u09c0\u09af\u09bc \u09b9\u09be\u09af\u09bc\u09be\u09b0\u09cb\u0997\u09cd\u09b2\u09bf\u09aa" },
            { "Ethi", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u09af\u09bc" },
            { "Geok", "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc \u0996\u09c1\u09ce\u09b8\u09c1\u09b0\u09bf" },
            { "Geor", metaValue_ka },
            { "Glag", "\u0997\u09cd\u09b2\u09be\u0997\u09cb\u09b2\u09bf\u099f\u09bf\u0995" },
            { "Goth", "\u0997\u09cb\u09a5\u09bf\u0995" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0997\u09c1\u09b0\u09c1\u09ae\u09c1\u0996\u09bf" },
            { "Hanb", "\u09b9\u09cd\u09af\u09be\u09a8-\u09ac\u09cb\u09aa\u09cb\u09ae\u09cb\u09ab\u09cb" },
            { "Hang", "\u09b9\u09be\u0999\u09cd\u0997\u09c1\u09b2" },
            { "Hani", "\u09b9\u09cd\u09af\u09be\u09a8" },
            { "Hano", "\u09b9\u09cd\u09af\u09be\u09a8\u09c1\u09a8\u09c1" },
            { "Hans", "\u09b8\u09b0\u09b2\u09c0\u0995\u09c3\u09a4" },
            { "Hant", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09ac\u09be\u09b9\u09c0" },
            { "Hebr", metaValue_he },
            { "Hira", "\u09b9\u09bf\u09b0\u09be\u0997\u09be\u09a8\u09be" },
            { "Hmng", "\u09ab\u09be\u09b9\u09be\u0993 \u09ae\u0999" },
            { "Hrkt", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u0985\u0995\u09cd\u09b7\u09b0\u09ae\u09be\u09b2\u09be" },
            { "Hung", "\u09aa\u09c1\u09b0\u09cb\u09a8\u09cb \u09b9\u09be\u0999\u09cd\u0997\u09c7\u09b0\u09c0\u09af\u09bc" },
            { "Inds", "\u09b8\u09bf\u09a8\u09cd\u09a7\u09c1" },
            { "Ital", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u0987\u09a4\u09be\u09b2\u09bf" },
            { "Jamo", "\u099c\u09cd\u09af\u09be\u09ae\u09cb" },
            { "Java", metaValue_jv },
            { "Jpan", "\u099c\u09be\u09aa\u09be\u09a8\u09c0" },
            { "Kali", "\u0995\u09be\u09af\u09bc\u09be\u09b9 \u09b2\u09bf" },
            { "Kana", "\u0995\u09be\u099f\u09be\u0995\u09be\u09a8\u09be" },
            { "Khar", "\u0996\u09b0\u09cb\u09b7\u09cd\u09a0\u09c0" },
            { "Khmr", metaValue_km },
            { "Knda", "\u0995\u09be\u09a8\u09be\u09a1\u09bc\u09be" },
            { "Kore", metaValue_ko },
            { "Kthi", "\u0995\u09be\u0987\u09a5\u09bf" },
            { "Lana", "\u09b2\u09be\u09a8\u09cd\u09a8\u09be" },
            { "Laoo", metaValue_lo },
            { "Latf", "\u09ab\u09cd\u09b0\u09be\u0995\u09cd\u099f\u09c1\u09b0 \u09b2\u09cd\u09af\u09be\u099f\u09bf\u09a8" },
            { "Latg", "\u0997\u09cd\u09af\u09be\u09b2\u09bf\u0995 \u09b2\u09cd\u09af\u09be\u099f\u09bf\u09a8" },
            { "Latn", "\u09b2\u09cd\u09af\u09be\u099f\u09bf\u09a8" },
            { "Lepc", "\u09b2\u09c7\u09aa\u09cd\u099a\u09be" },
            { "Limb", "\u09b2\u09bf\u09ae\u09cd\u09ac\u09c1" },
            { "Lina", "\u09b2\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09b0 \u098f" },
            { "Linb", "\u09b2\u09bf\u09a8\u09bf\u09af\u09bc\u09be\u09b0 \u09ac\u09bf" },
            { "Lyci", "\u09b2\u09be\u0987\u09b8\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Lydi", "\u09b2\u09be\u0987\u09a1\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Mand", "\u09ae\u09cd\u09af\u09be\u09a8\u09cd\u09a1\u09be\u09af\u09bc\u09c0\u09a8" },
            { "Mani", "\u09ae\u09cd\u09af\u09be\u09a8\u09bf\u099a\u09be\u0987\u09a8" },
            { "Maya", "\u09ae\u09be\u09af\u09bc\u09be\u09a8 \u09b9\u09be\u09af\u09bc\u09be\u09b0\u09cb\u0997\u09cd\u09b2\u09bf\u09aa" },
            { "Mero", "\u09ae\u09c7\u09b0\u09cb\u0987\u099f\u09bf\u0995" },
            { "Mlym", metaValue_ml },
            { "Mong", "\u09ae\u09cb\u0999\u09cd\u0997\u09cb\u09b2\u09c0\u09af\u09bc" },
            { "Moon", "\u09ae\u09c1\u09a8" },
            { "Mtei", "\u09ae\u09c7\u0987\u099f\u09c7\u0987 \u09ae\u09be\u09af\u09bc\u09c7\u0995" },
            { "Mymr", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "\u0993\u0998\u09be\u09ae" },
            { "Olck", "\u0993\u09b2 \u099a\u09bf\u0995\u09bf" },
            { "Orkh", "\u0985\u09b0\u09cd\u0996\u09cb\u09a8" },
            { "Orya", metaValue_or },
            { "Osma", "\u0993\u09b8\u09ae\u09be\u09a8\u09bf\u09af\u09bc" },
            { "Perm", "\u09aa\u09cd\u09b0\u09be\u099a\u09c0\u09a8 \u09aa\u09be\u09b0\u09cd\u09ae\u09bf\u0995" },
            { "Phag", "\u09ab\u09be\u0997\u09cd\u09b8-\u09aa\u09be" },
            { "Phli", "\u0996\u09a6\u09bf\u09a4 \u09aa\u09be\u09b9\u09b2\u09ad\u09bf" },
            { "Phlp", "\u09b8\u09b2\u09cd\u099f\u09be\u09b0 \u09aa\u09be\u09b9\u09b2\u09ad\u09bf" },
            { "Phlv", "\u09aa\u09c1\u09b8\u09cd\u09a4\u0995 \u09aa\u09be\u09b9\u09b2\u09ad\u09bf" },
            { "Phnx", "\u09ab\u09bf\u09a8\u09bf\u09b6\u09bf\u09af\u09bc" },
            { "Plrd", "\u09aa\u09cb\u09b2\u09be\u09b0\u09cd\u09a1 \u09a7\u09cd\u09ac\u09a8\u09bf\u0995" },
            { "Prti", "\u09aa\u09be\u09b0\u09cd\u09a5\u09bf\u09af\u09bc\u09a8" },
            { "Rjng", "\u09b0\u09c7\u099c\u09cd\u09af\u09be\u0999\u09cd\u0997" },
            { "Rohg", "\u09b9\u09be\u09a8\u09bf\u09ab\u09bf" },
            { "Roro", "\u09b0\u09cb\u0999\u09cd\u0997\u09cb\u09b0\u09cb\u0999\u09cd\u0997\u09cb" },
            { "Runr", "\u09b0\u09c1\u09a8\u09bf\u0995" },
            { "Samr", "\u09b8\u09ae\u09c7\u09b0\u09bf\u099f\u09a8" },
            { "Sara", "\u09b8\u09be\u09b0\u09be\u09a4\u09bf" },
            { "Saur", "\u09b8\u09cc\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0" },
            { "Sgnw", "\u099a\u09bf\u09b9\u09cd\u09a8 \u09b2\u09bf\u0996\u09a8" },
            { "Shaw", "\u09b8\u09be\u09ad\u09bf\u09af\u09bc\u09be\u09a8" },
            { "Sinh", "\u09b8\u09bf\u0982\u09b9\u09b2\u09bf" },
            { "Sund", "\u09b8\u09c1\u09a8\u09cd\u09a6\u09be\u09a8\u09bf\u099c" },
            { "Sylo", "\u09b8\u09bf\u09b2\u09c7\u099f\u09bf \u09a8\u09be\u0997\u09b0\u09bf" },
            { "Syrc", metaValue_syr },
            { "Syre", "\u098f\u09b8\u09cd\u099f\u09cd\u09b0\u09c7\u0999\u09cd\u0997\u09c7\u09b2\u09cb \u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u0995" },
            { "Syrj", "\u09aa\u09b6\u09cd\u099a\u09bf\u09ae\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u0995" },
            { "Syrn", "\u09aa\u09c2\u09b0\u09cd\u09ac\u09be\u099e\u09cd\u099a\u09b2\u09c0\u09af\u09bc \u09b8\u09bf\u09b0\u09bf\u09af\u09bc\u09be\u0995" },
            { "Tagb", "\u099f\u09be\u0997\u09cb\u0993\u09af\u09bc\u09be\u09a8\u09be" },
            { "Tale", "\u09a4\u09be\u0987\u09b2\u09c7" },
            { "Talu", "\u09a8\u09a4\u09c1\u09a8 \u09a4\u09be\u0987 \u09b2\u09c1" },
            { "Taml", metaValue_ta },
            { "Tavt", "\u09a4\u09be\u0987 \u09ad\u09bf\u09af\u09bc\u09c7\u09ce" },
            { "Telu", "\u09a4\u09c7\u09b2\u09c7\u0997\u09c1" },
            { "Teng", "\u09a4\u09c7\u0999\u09cd\u0997\u09cb\u09af\u09bc\u09be\u09b0" },
            { "Tfng", "\u09a4\u09bf\u09ab\u09bf\u09a8\u09be\u0997" },
            { "Tglg", "\u099f\u09be\u0997\u09be\u09b2\u0997" },
            { "Thaa", "\u09a5\u09be\u09a8\u09be" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "\u09a6\u09c3\u09b6\u09cd\u09af\u09ae\u09be\u09a8 \u09ad\u09be\u09b7\u09be" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "\u09b8\u09c1\u09ae\u09c7\u09b0-\u0986\u0995\u09cd\u0995\u09be\u09a6\u09c0\u09af\u09bc \u0995\u09c0\u09b2\u0995\u09b0\u09c2\u09aa" },
            { "Yiii", "\u0987" },
            { "Zinh", "\u0995\u09be\u0987" },
            { "Zmth", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u099a\u09bf\u09b9\u09cd\u09a8" },
            { "Zsye", "\u0987\u09ae\u09cb\u099c\u09bf" },
            { "Zsym", "\u09aa\u09cd\u09b0\u09a4\u09c0\u0995" },
            { "Zxxx", "\u0985\u09b2\u09bf\u0996\u09bf\u09a4" },
            { "Zyyy", "\u09b8\u09be\u09a7\u09be\u09b0\u09a8" },
            { "Zzzz", "\u0985\u099c\u09be\u09a8\u09be \u09b2\u09bf\u09aa\u09bf" },
            { "en_US", "\u0987\u0982\u09b0\u09c7\u099c\u09bf (\u0986\u09ae\u09c7\u09b0\u09bf\u0995\u09be)" },
            { "es_ES", "\u09b8\u09cd\u09aa\u09cd\u09af\u09be\u09a8\u09bf\u09b6 (\u0987\u0989\u09b0\u09cb\u09aa)" },
            { "fa_AF", "\u09a6\u09be\u09b0\u09bf" },
            { "nl_BE", "\u09ab\u09cd\u09b2\u09c7\u09ae\u09bf\u09b6" },
            { "pt_PT", "\u09aa\u09b0\u09cd\u09a4\u09c1\u0997\u09c0\u099c (\u0987\u0989\u09b0\u09cb\u09aa)" },
            { "ro_MD", "\u09ae\u09b2\u09a6\u09be\u09ad\u09bf\u09af\u09bc" },
            { "sw_CD", "\u0995\u0999\u09cd\u0997\u09cb \u09b8\u09cb\u09af\u09bc\u09be\u09b9\u09bf\u09b2\u09bf" },
            { "ar_001", "\u0986\u09a7\u09c1\u09a8\u09bf\u0995 \u0986\u09a6\u09b0\u09cd\u09b6 \u0986\u09b0\u09ac\u09bf" },
            { "key.ca", "\u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "key.cf", "\u09ae\u09c1\u09a6\u09cd\u09b0\u09cd\u09af\u09be \u09ab\u09b0\u09ae\u09cd\u09af\u09be\u099f" },
            { "key.co", "\u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "key.cu", "\u09ae\u09c1\u09a6\u09cd\u09b0\u09be" },
            { "key.hc", "\u09b8\u09ae\u09af\u09bc\u09c7\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac (\u09e7\u09e8 \u09ac\u09be \u09e8\u09ea)" },
            { "key.lb", "\u09b2\u09be\u0987\u09a8 \u09ac\u09bf\u09ad\u09be\u099c\u0995 \u09b6\u09c8\u09b2\u09c0" },
            { "key.ms", "\u09aa\u09b0\u09bf\u09ae\u09be\u09aa \u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae" },
            { "key.nu", "\u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "key.tz", "\u09b8\u09ae\u09af\u09bc \u099c\u09cb\u09a8" },
            { "key.va", "\u09b8\u09cd\u09a5\u09be\u09a8\u09c0\u09af\u09bc \u09ad\u09bf\u09a8\u09cd\u09a8\u09a4\u09be" },
            { "nds_NL", "\u09b2\u09cb \u09b8\u09cd\u09af\u09be\u0995\u09cd\u09b8\u09a8" },
            { "type.ca.roc", "\u09ae\u09bf\u0999\u09cd\u0997\u09c1\u0993 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.co.eor", "\u0987\u0989\u09b0\u09cb\u09aa\u09c0\u09af\u09bc \u0995\u09cd\u09b0\u09ae \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8\u09c7\u09b0 \u09a8\u09bf\u09af\u09bc\u09ae\u09be\u09ac\u09b2\u09c0" },
            { "type.hc.h11", "\u09e7\u09e8 \u0998\u09a3\u09cd\u099f\u09be\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac\u09c7 (\u09e6\u2013\u09e7\u09e7)" },
            { "type.hc.h12", "\u09e7\u09e8 \u0998\u09a3\u09cd\u099f\u09be\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac\u09c7 (\u09e7\u2013\u09e7\u09e8)" },
            { "type.hc.h23", "\u09e8\u09ea \u0998\u09a3\u09cd\u099f\u09be\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac\u09c7 (\u09e6\u2013\u09e8\u09e9)" },
            { "type.hc.h24", "\u09e8\u09ea \u0998\u09a3\u09cd\u099f\u09be\u09b0 \u09b9\u09bf\u09b8\u09be\u09ac\u09c7 (\u09e7\u2013\u09e8\u09ea)" },
            { "type.m0.bgn", "\u0987\u0989\u098f\u09b8 \u09ac\u09bf\u099c\u09bf\u098f\u09a8 \u09ac\u09b0\u09cd\u09a3\u09be\u09a8\u09cd\u09a4\u09b0\u09a3" },
            { "type.nu.ahom", "\u0985\u09b9\u09ae \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.arab", "\u0986\u09b0\u09ac\u09bf-\u09ad\u09be\u09b0\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.armn", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.bali", "\u09ac\u09be\u09b2\u09bf\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.beng", "\u09ac\u09be\u0982\u09b2\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.brah", "\u09ac\u09cd\u09b0\u09be\u09b9\u09cd\u09ae\u09c0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.cakm", "\u099a\u09be\u0995\u09ae\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.cham", "\u099a\u09be\u09ae \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.cyrl", "\u09b8\u09bf\u09b0\u09bf\u09b2\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.deva", "\u09a6\u09c7\u09ac\u09a8\u09be\u0997\u09b0\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.ethi", "\u0987\u09a5\u09bf\u09af\u09bc\u09cb\u09aa\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.geor", "\u099c\u09b0\u09cd\u099c\u09bf\u09af\u09bc\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.gonm", "\u09ae\u09be\u09b8\u09be\u09b0\u09be\u09ae \u0997\u09a8\u09cd\u09a1\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.grek", "\u0997\u09cd\u09b0\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.gujr", "\u0997\u09c1\u099c\u09b0\u09be\u09a4\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.guru", "\u0997\u09c1\u09b0\u09c1\u09ae\u09c1\u0996\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hans", "\u09b8\u09b0\u09b2\u09bf\u0995\u09c3\u09a4 \u099a\u09c8\u09a8\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hant", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09be\u09ac\u09be\u09b9\u09c0 \u099a\u09c8\u09a8\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hebr", "\u09b9\u09bf\u09ac\u09cd\u09b0\u09c1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hmng", "\u09aa\u09be\u09b9\u09af\u09bc\u09be \u09ae\u0982 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.java", "\u099c\u09be\u09ad\u09be\u09a8\u09bf\u099c \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.jpan", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.kali", "\u0995\u09be\u09af\u09bc\u09be\u09b9 \u09b2\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.khmr", "\u0996\u09c7\u09ae\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.knda", "\u0995\u09a8\u09cd\u09a8\u09a1\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.lana", "\u099f\u09be\u0987 \u09a5\u09be\u09ae \u09b9\u09cb\u09b0\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.laoo", "\u09b2\u09be\u0993 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.latn", "\u0993\u09af\u09bc\u09c7\u09b8\u09cd\u099f\u09be\u09b0\u09cd\u09a8 \u09a1\u09bf\u099c\u09bf\u099f" },
            { "type.nu.lepc", "\u09b2\u09c7\u09aa\u099a\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.limb", "\u09b2\u09bf\u09ae\u09cd\u09ac\u09c1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mlym", "\u09ae\u09be\u09b2\u09af\u09bc\u09be\u09b2\u09ae \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.modi", "\u09ae\u09cb\u09a6\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mong", "\u09ae\u0999\u09cd\u0997\u09cb\u09b2\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mroo", "\u09ae\u09cd\u09b0\u09cb \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mtei", "\u09ae\u09bf\u099f\u09bf\u0987 \u09ae\u09be\u09af\u09bc\u09c7\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mymr", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.nkoo", "\u098f\u09a8\u2019\u0995\u09cb \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.olck", "\u0993\u09b2 \u099a\u09bf\u0995\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.orya", "\u0993\u09a1\u09bc\u09bf\u09af\u09bc\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.osma", "\u0993\u09b8\u09ae\u09be\u09a8\u09bf\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.saur", "\u09b8\u09cc\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.shrd", "\u09b8\u09be\u09b0\u09a6\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.sind", "\u0995\u09c1\u09a6\u09af\u09bc\u09be\u09a6\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.sinh", "\u09b8\u09bf\u0982\u09b9\u09b2\u09c0 \u09b2\u09bf\u09a5 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.sora", "\u09b8\u09cb\u09b0\u09be \u09b8\u09ae\u09cd\u09aa\u09c7\u0982 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.sund", "\u09b8\u09c1\u09a6\u09be\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.takr", "\u09a4\u09be\u0995\u09cd\u09b0\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.talu", "\u09a8\u09a4\u09c1\u09a8 \u09a4\u09be\u0987 \u09b2\u09bf\u0989 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.taml", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09ac\u09be\u09b9\u09c0 \u09a4\u09be\u09ae\u09bf\u09b2 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.telu", "\u09a4\u09c7\u09b2\u09c1\u0997\u09c1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.thai", "\u09a5\u09be\u0987 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.tibt", "\u09a4\u09bf\u09ac\u09cd\u09ac\u09a4\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.tirh", "\u09a4\u09bf\u09b0\u09b9\u09c1\u09a4\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.vaii", "\u09ad\u09be\u0987 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.wara", "\u0993\u09af\u09bc\u09be\u09b0\u09c7\u0982 \u09b8\u09bf\u099f\u09bf \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.dangi", "\u09a6\u09be\u0999\u09cd\u0997\u09c0 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.co.ducet", "\u09a1\u09bf\u09ab\u09b2\u09cd\u099f \u0987\u0989\u09a8\u09bf\u0995\u09cb\u09a1 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "type.co.emoji", "\u0987\u09ae\u09cb\u099c\u09bf \u09ac\u09be\u099b\u09be\u0987 \u0995\u09cd\u09b0\u09ae" },
            { "type.lb.loose", "\u0986\u09b2\u0997\u09be \u09b2\u09be\u0987\u09a8 \u09ac\u09bf\u09ad\u09be\u099c\u0995 \u09b6\u09c8\u09b2\u09c0" },
            { "type.nu.roman", "\u09b0\u09cb\u09ae\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.coptic", "\u0995\u09aa\u099f\u09bf\u0995 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.ca.hebrew", "\u09b9\u09bf\u09ac\u09cd\u09b0\u09c1 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.ca.indian", "\u09ad\u09be\u09b0\u09a4\u09c0\u09af\u09bc \u099c\u09be\u09a4\u09c0\u09af\u09bc \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "type.co.compat", "\u0986\u0997\u09c7\u09b0 \u09ac\u09be\u099b\u09be\u0987\u09af\u09bc\u09c7\u09b0 \u0995\u09cd\u09b0\u09ae, \u09b8\u09be\u09ae\u099e\u09cd\u099c\u09b8\u09cd\u09af\u09c7\u09b0 \u099c\u09a8\u09cd\u09af" },
            { "type.co.pinyin", "\u09aa\u09bf\u09a8\u09bf\u09a8 \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae" },
            { "type.co.search", "\u09b8\u09be\u09a7\u09be\u09b0\u09a3-\u0989\u09a6\u09cd\u09a6\u09c7\u09b6\u09cd\u09af\u09c7 \u0985\u09a8\u09c1\u09b8\u09a8\u09cd\u09a7\u09be\u09a8" },
            { "type.co.stroke", "\u0986\u09ac\u09b0\u09cd\u09a4\u09bf\u09a4 \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae" },
            { "type.co.unihan", "\u09b0\u09be\u09a1\u09bf\u0995\u09c7\u09b2 \u09b8\u09cd\u099f\u09cd\u09b0\u09cb\u0995 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "type.co.zhuyin", "\u099d\u09c1\u0987\u09a8 \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae" },
            { "type.d0.fwidth", "\u09aa\u09c2\u09b0\u09cd\u09a3\u09aa\u09cd\u09b0\u09b8\u09cd\u09a5 \u09aa\u09b0\u09cd\u09af\u09a8\u09cd\u09a4" },
            { "type.d0.hwidth", "\u0985\u09b0\u09cd\u09a7\u09aa\u09cd\u09b0\u09b8\u09cd\u09a5 \u09aa\u09b0\u09cd\u09af\u09a8\u09cd\u09a4" },
            { "type.lb.normal", "\u09b8\u09be\u09a7\u09be\u09b0\u09a3 \u09b2\u09be\u0987\u09a8 \u09ac\u09bf\u09ad\u09be\u099c\u0995 \u09b6\u09c8\u09b2\u09c0" },
            { "type.lb.strict", "\u099f\u09be\u0987\u099f \u09b2\u09be\u0987\u09a8 \u09ac\u09bf\u09ad\u09be\u099c\u0995 \u09b6\u09c8\u09b2\u09c0" },
            { "type.m0.ungegn", "\u0987\u0989\u098f\u09a8 \u099c\u09bf\u0987\u099c\u09bf\u098f\u09a8 \u09ac\u09b0\u09cd\u09a3\u09be\u09a8\u09cd\u09a4\u09b0\u09a3" },
            { "type.ms.metric", "\u09ae\u09c7\u099f\u09cd\u09b0\u09bf\u0995 \u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae" },
            { "type.nu.native", "\u09b8\u09cd\u09a5\u09be\u09a8\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.chinese", "\u099a\u09c0\u09a8\u09be \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.ca.islamic", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.ca.iso8601", "ISO-861 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.ca.persian", "\u09ab\u09be\u09b0\u09b8\u09bf \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.cf.account", "\u09b9\u09bf\u09b8\u09be\u09ac\u09c7\u09b0 \u09ae\u09c1\u09a6\u09cd\u09b0\u09be \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "type.co.big5han", "\u09aa\u09cd\u09b0\u09a5\u09be\u0997\u09a4 \u099a\u09c0\u09a8\u09be \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae - \u09ac\u09bf\u0997\u09eb" },
            { "type.d0.npinyin", "\u09b8\u09be\u0982\u0996\u09bf\u0995" },
            { "type.nu.arabext", "\u09aa\u09cd\u09b0\u09b8\u09be\u09b0\u09bf\u09a4 \u0986\u09b0\u09ac\u09bf -\u09ad\u09be\u09b0\u09a4\u09c0\u09af\u09bc \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.armnlow", "\u0986\u09b0\u09cd\u09ae\u09c7\u09a8\u09c0\u09af\u09bc \u099b\u09cb\u099f\u09b9\u09be\u09a4\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.finance", "\u0985\u09b0\u09cd\u09a5\u09a8\u09c8\u09a4\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be\u09b8\u09c2\u099a\u0995" },
            { "type.nu.greklow", "\u0997\u09cd\u09b0\u09c0\u0995 \u099b\u09cb\u099f \u09b9\u09be\u09a4\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hanidec", "\u099a\u09c8\u09a8\u09bf\u0995 \u09a6\u09b6\u09ae\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hansfin", "\u09b8\u09b0\u09b2\u09bf\u0995\u09c3\u09a4 \u099a\u09c8\u09a8\u09bf\u0995 \u0986\u09b0\u09cd\u09a5\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.hantfin", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u09ac\u09be\u09b9\u09c0 \u099a\u09c8\u09a8\u09bf\u0995 \u0986\u09b0\u09cd\u09a5\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.jpanfin", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u0986\u09b0\u09cd\u09a5\u09bf\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mathdbl", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09a1\u09be\u09ac\u09b2-\u09b8\u09cd\u099f\u09cd\u09b0\u09be\u0995 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.tamldec", "\u09a4\u09be\u09ae\u09bf\u09b2 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.buddhist", "\u09ac\u09cc\u09a6\u09cd\u09a7 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.ca.ethiopic", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u0995 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.ca.japanese", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.cf.standard", "\u09ae\u09be\u09a8\u0995 \u09ae\u09c1\u09a6\u09cd\u09b0\u09be \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "type.co.phonetic", "\u09a7\u09cd\u09ac\u09a8\u09bf \u09a8\u09bf\u09b0\u09cd\u09a6\u09c7\u09b6\u0995 \u09ac\u09be\u099b\u09be\u0987 \u0995\u09cd\u09b0\u09ae" },
            { "type.co.reformed", "\u09b0\u09bf\u09ab\u09b0\u09cd\u09ae\u09a1 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "type.co.searchjl", "\u09b9\u09be\u0999\u09cd\u0997\u09c1\u09b2 \u09aa\u09cd\u09b0\u09be\u09a5\u09ae\u09bf\u0995 \u09ac\u09cd\u09af\u099e\u09cd\u099c\u09a8\u09ac\u09b0\u09cd\u09a3 \u09a6\u09cd\u09ac\u09be\u09b0\u09be \u0985\u09a8\u09c1\u09b8\u09a8\u09cd\u09a7\u09be\u09a8 \u0995\u09b0\u09c1\u09a8" },
            { "type.co.standard", "\u0986\u09a6\u09b0\u09cd\u09b6 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "type.ms.uksystem", "\u0987\u09ae\u09cd\u09aa\u09c7\u09b0\u09bf\u09af\u09bc\u09be\u09b2 \u09aa\u09b0\u09bf\u09ae\u09be\u09aa \u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae" },
            { "type.ms.ussystem", "\u09ae\u09be\u09b0\u09cd\u0995\u09bf\u09a8 \u09af\u09c1\u0995\u09cd\u09a4\u09b0\u09be\u09b7\u09cd\u099f\u09cd\u09b0\u09c7\u09b0 \u09aa\u09b0\u09bf\u09ae\u09be\u09aa \u09b8\u09bf\u09b8\u09cd\u099f\u09c7\u09ae" },
            { "type.nu.fullwide", "\u09aa\u09c2\u09b0\u09cd\u09a3 \u099a\u0993\u09a1\u09bc\u09be \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.lanatham", "\u099f\u09be\u0987 \u09a5\u09be\u09ae \u09a5\u09be\u09ae \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mathbold", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09ac\u09cb\u09b2\u09cd\u09a1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mathmono", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09ae\u09cb\u09a8\u09cb\u09b8\u09cd\u09aa\u09c7\u09b8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mathsanb", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09b8\u09cd\u09af\u09be\u09a8\u09cd\u09b8-\u09b6\u09c7\u09b0\u09bf\u09ab \u09ac\u09cb\u09b2\u09cd\u09a1 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mathsans", "\u0997\u09be\u09a3\u09bf\u09a4\u09bf\u0995 \u09b8\u09cd\u09af\u09be\u09a8\u09cd\u09b8-\u09b6\u09c7\u09b0\u09bf\u09ab \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mymrshan", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 \u09b6\u09be\u09a8 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.mymrtlng", "\u09ae\u09be\u09af\u09bc\u09be\u09a8\u09ae\u09be\u09b0 \u09a5\u09be\u0987 \u09b2\u09c7\u09af\u09bc\u09bf\u0982 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.nu.romanlow", "\u09b0\u09cb\u09ae\u09be\u09a8 \u099b\u09cb\u099f\u09b9\u09be\u09a4\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be" },
            { "type.ca.gregorian", "\u0997\u09cd\u09b0\u09bf\u0997\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
            { "type.co.gb2312han", "\u09b8\u09be\u09a7\u09be\u09b0\u09a3 \u099a\u09c0\u09a8\u09be \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae - \u099c\u09bf\u09ac\u09bf\u09e8\u09e9\u09e7\u09e8" },
            { "type.co.phonebook", "\u09ab\u09cb\u09a8\u09ac\u09c1\u0995 \u09b8\u099c\u09cd\u099c\u09be\u0995\u09cd\u09b0\u09ae" },
            { "type.co.dictionary", "\u0985\u09ad\u09bf\u09a7\u09be\u09a8 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "type.co.traditional", "\u09aa\u09cd\u09b0\u09a5\u09be\u0997\u09a4 \u09ac\u09be\u099b\u09be\u0987 \u09ac\u09bf\u09a8\u09cd\u09af\u09be\u09b8" },
            { "type.nu.traditional", "\u0990\u09a4\u09bf\u09b9\u09cd\u09af\u0997\u09a4 \u09b8\u0982\u0996\u09cd\u09af\u09be\u09b8\u09c2\u099a\u0995" },
            { "type.ca.islamic-tbla", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0 (\u099b\u0995\u09ac\u09a6\u09cd\u09a7, \u099c\u09cd\u09af\u09cb\u09a4\u09bf\u09b0\u09cd\u09ac\u09bf\u09a6\u09cd\u09af\u09c0\u09af\u09bc \u09af\u09c1\u0997)" },
            { "type.ca.islamic-civil", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995-\u09b8\u09bf\u09ad\u09bf\u09b2 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "type.ca.islamic-umalqura", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0 (\u0989\u09ae\u09cd\u09ae\u09be \u0986\u09b2-\u0995\u09c1\u09b0\u0986)" },
            { "type.ca.ethiopic-amete-alem", "\u0987\u09a5\u09bf\u0993\u09aa\u09bf\u0993 \u0986\u09ae\u09c7\u09a4\u09c7 \u0986\u09b2\u09c7\u09ae \u0995\u09cd\u09af\u09be\u09b2\u09c7\u09a8\u09cd\u09a1\u09be\u09b0" },
        };
        return data;
    }
}
