# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _oofimage
else:
    import _oofimage

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



from ooflib.common import ooferrorwrappers

import ooflib.SWIG.common.IO.bitoverlay
import ooflib.SWIG.common.coord
import ooflib.SWIG.common.timestamp
import ooflib.SWIG.common.ccolor
import ooflib.SWIG.common.abstractimage
import ooflib.SWIG.common.boolarray
import ooflib.SWIG.common.doublearray
import ooflib.SWIG.common.ooferror
class OOFImage(ooflib.SWIG.common.abstractimage.AbstractImage):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, name, filename):
        _oofimage.OOFImage_swiginit(self, _oofimage.new_OOFImage(name, filename))
    __swig_destroy__ = _oofimage.delete_OOFImage

    def save(self, filename):
        return _oofimage.OOFImage_save(self, filename)

    def name(self):
        return _oofimage.OOFImage_name(self)

    def rename(self, arg2):
        return _oofimage.OOFImage_rename(self, arg2)

    def comment(self):
        return _oofimage.OOFImage_comment(self)

    def setSize(self, Point):
        return _oofimage.OOFImage_setSize(self, Point)

    def size(self):
        return _oofimage.OOFImage_size(self)

    def sizeInPixels(self):
        return _oofimage.OOFImage_sizeInPixels(self)

    def pixelFromPoint(self, Point):
        return _oofimage.OOFImage_pixelFromPoint(self, Point)

    def pixelInBounds(self, iPoint):
        return _oofimage.OOFImage_pixelInBounds(self, iPoint)

    def clone(self, name):
        return _oofimage.OOFImage_clone(self, name)

    def setMicrostructure(self, arg2):
        return _oofimage.OOFImage_setMicrostructure(self, arg2)

    def getCMicrostructure(self):
        return _oofimage.OOFImage_getCMicrostructure(self)

    def removeMicrostructure(self):
        return _oofimage.OOFImage_removeMicrostructure(self)

    def getPixels(self):
        return _oofimage.OOFImage_getPixels(self)

    def flip(self, axis):
        return _oofimage.OOFImage_flip(self, axis)

    def fade(self, arg2):
        return _oofimage.OOFImage_fade(self, arg2)

    def dim(self, arg2):
        return _oofimage.OOFImage_dim(self, arg2)

    def blur(self, arg2, arg3):
        return _oofimage.OOFImage_blur(self, arg2, arg3)

    def contrast(self, arg2):
        return _oofimage.OOFImage_contrast(self, arg2)

    def despeckle(self):
        return _oofimage.OOFImage_despeckle(self)

    def edge(self, arg2):
        return _oofimage.OOFImage_edge(self, arg2)

    def enhance(self):
        return _oofimage.OOFImage_enhance(self)

    def equalize(self):
        return _oofimage.OOFImage_equalize(self)

    def medianFilter(self, arg2):
        return _oofimage.OOFImage_medianFilter(self, arg2)

    def negate(self, arg2):
        return _oofimage.OOFImage_negate(self, arg2)

    def normalize(self):
        return _oofimage.OOFImage_normalize(self)

    def reduceNoise(self, arg2):
        return _oofimage.OOFImage_reduceNoise(self, arg2)

    def sharpen(self, arg2, arg3):
        return _oofimage.OOFImage_sharpen(self, arg2, arg3)

    def gray(self):
        return _oofimage.OOFImage_gray(self)

    def evenly_illuminate(self, arg2):
        return _oofimage.OOFImage_evenly_illuminate(self, arg2)

    def compare(self, arg2, arg3):
        return _oofimage.OOFImage_compare(self, arg2, arg3)

    def makeCanvasImage(self, arg2, arg3):
        return _oofimage.OOFImage_makeCanvasImage(self, arg2, arg3)

    def _getTimeStamp(self):
        return _oofimage.OOFImage__getTimeStamp(self)

    def __getitem__(self, iPoint):
        return _oofimage.OOFImage___getitem__(self, iPoint)

# Register OOFImage in _oofimage:
_oofimage.OOFImage_swigregister(OOFImage)

def newImageFromData(name, iPoint, arg3):
    return _oofimage.newImageFromData(name, iPoint, arg3)

def threshold(arg1, arg2):
    return _oofimage.threshold(arg1, arg2)
class ImageMagickError(ooflib.SWIG.common.ooferror.ErrError):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m):
        _oofimage.ImageMagickError_swiginit(self, _oofimage.new_ImageMagickError(m))
    __swig_destroy__ = _oofimage.delete_ImageMagickError

    def __repr__(self):
        return _oofimage.ImageMagickError___repr__(self)

# Register ImageMagickError in _oofimage:
_oofimage.ImageMagickError_swigregister(ImageMagickError)


class PyImageMagickError(ooferrorwrappers.PyOOFError):
  def __init__(self, *args, **kwargs):
    self.cexcept = kwargs.get("cexcept", None)
    if self.cexcept is None:
      self.cexcept = ImageMagickError(*args, **kwargs)
  def __getattr__(self, attr):
    return getattr(self.cexcept, attr)
  def __repr__(self):
    return self.cexcept.summary()
  def __str__(self):
    return self.cexcept.summary()
ooferrorwrappers.pyErrorWrappers[ImageMagickError] = PyImageMagickError


def grayify(image):
    return _oofimage.grayify(image)

def setFromBool(arg1, arg2):
    return _oofimage.setFromBool(arg1, arg2)
# -*- python -*-

# This software was produced by NIST, an agency of the U.S. government,
# and by statute is not subject to copyright in the United States.
# Recipients of this software assume all responsibilities associated
# with its operation, modification and maintenance. However, to
# facilitate maintenance we ask that before distributing modified
# versions of this software, you first contact the authors at
# oof_manager@nist.gov. 

from ooflib.common import debug
#from ooflib.common import parallel_enable
from ooflib.common import primitives
from ooflib.image import imagecontext
import os

def readImage(filename, **kwargs):
# 'height' and 'width' keywords are optional.  If neither is
# given, the height and width are the image size in pixels.  If
# just one is given, the other is determined from the aspect
# ratio.  If both are given, the image may be distorted.

# Colons in image names are disallowed, because we use them as
# separators in the labeltree.
    basename = os.path.basename(filename).replace(':','.')

    image = OOFImage(basename, filename)
# Set physical size of image
    pixelsize = image.sizeInPixels()    # iPoint
    given_height = 'height' in kwargs
    given_width = 'width' in kwargs
    if not (given_height or given_width):
        width = float(pixelsize.x)
        height = float(pixelsize.y)
    elif given_width and given_height:
        width = float(kwargs['width'])
        height = float(kwargs['height'])
    else:
        aspect = float(pixelsize.x)/pixelsize.y
        if given_width:
            width = float(kwargs['width'])
            height = width/aspect
        elif given_height:
            height = float(kwargs['height'])
            width = height*aspect
    image.setSize(primitives.Point(width, height))

    return image

def _getTimeStamp_optional_args(self, *args):
    return self._getTimeStamp()
OOFImage.getTimeStamp = _getTimeStamp_optional_args

def getImage(imagename):
## returns the actual image
## imagename = microstructurename:image_name OR imagename = [microstructurename, image_name]
    return imagecontext.imageContexts[imagename].getObject()

def pushModification(imagename, image):
    imagecontext.imageContexts[imagename].pushModification(image)

def undoModification(imagename):
    imagecontext.imageContexts[imagename].undoModification()

def redoModification(imagename):
    imagecontext.imageContexts[imagename].redoModification()

def undoable(imagename):
    return imagecontext.imageContexts[imagename].undoable()

def redoable(imagename):
    return imagecontext.imageContexts[imagename].redoable()


# # Parallel image send/recv
# if parallel_enable.enabled():
#     def Send_Image(image, destinations, tag=0):
#         _Send_Image(image, destinations, tag)

#     def Recv_Image(origin, tag=0):
#         return _Recv_Image(origin, tag)


