/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: TuneExtensionOps.td                                                  *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace  mlir {
namespace transform {
namespace tune  {
/// Represents a tunable parameter with a set of options
/// Provides a representation for "tunables" within schedules.
/// 
///     Each op represents a single tunable, which has a `name` and a set
///     of valid `options` described by an attribute. Without a specified
///     `selected` option, this op represents a non-deterministic choice
///     that has yet to be resolved -- as such, the interpreter runtime
///     semantics is to raise a failure.
/// 
///     The non-deterministic choice is resolved through providing a
///     `selected` attribute. When provided, the interpreter runtime
///     semantics are to return the `selected` attribute as a param through
///     the op's result.
/// 
///     -----
/// 
///     In case the `options` attribute is an `ArrayAttr`, the verifier
///     checks that the provided `selected` attribute occurs in `options`.
class KnobOp;
} // namespace tune 
} // namespace transform
} // namespace  mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace  mlir {
namespace transform {
namespace tune  {

//===----------------------------------------------------------------------===//
//  mlir::transform::tune ::KnobOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class KnobOpGenericAdaptorBase {
public:
  struct Properties {
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using optionsTy = ::mlir::Attribute;
    optionsTy options;

    auto getOptions() const {
      auto &propStorage = this->options;
      return ::llvm::cast<::mlir::Attribute>(propStorage);
    }
    void setOptions(const ::mlir::Attribute &propValue) {
      this->options = propValue;
    }
    using selectedTy = ::mlir::Attribute;
    selectedTy selected;

    auto getSelected() const {
      auto &propStorage = this->selected;
      return ::llvm::dyn_cast_or_null<::mlir::Attribute>(propStorage);
    }
    void setSelected(const ::mlir::Attribute &propValue) {
      this->selected = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.name == this->name &&
        rhs.options == this->options &&
        rhs.selected == this->selected &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  KnobOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.tune.knob", odsAttrs.getContext());
  }

  KnobOpGenericAdaptorBase(KnobOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::mlir::StringAttr getName();
  ::mlir::Attribute getOptionsAttr() {
    auto attr = ::llvm::cast<::mlir::Attribute>(getProperties().options);
    return attr;
  }

  ::mlir::Attribute getOptions();
  ::mlir::Attribute getSelectedAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().selected);
    return attr;
  }

  ::std::optional<::mlir::Attribute> getSelected();
};
} // namespace detail
template <typename RangeT>
class KnobOpGenericAdaptor : public detail::KnobOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::KnobOpGenericAdaptorBase;
public:
  KnobOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  KnobOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : KnobOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  KnobOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : KnobOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  KnobOpGenericAdaptor(RangeT values, const KnobOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = KnobOp, typename = std::enable_if_t<std::is_same_v<LateInst, KnobOp>>>
  KnobOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class KnobOpAdaptor : public KnobOpGenericAdaptor<::mlir::ValueRange> {
public:
  using KnobOpGenericAdaptor::KnobOpGenericAdaptor;
  KnobOpAdaptor(KnobOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class KnobOp : public ::mlir::Op<KnobOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::transform::TransformParamTypeInterface>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = KnobOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = KnobOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("name"), ::llvm::StringRef("options"), ::llvm::StringRef("selected")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOptionsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOptionsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSelectedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSelectedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.tune.knob");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformParamTypeInterface> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformParamTypeInterface>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().name);
  }

  ::mlir::StringAttr getName();
  ::mlir::Attribute getOptionsAttr() {
    return ::llvm::cast<::mlir::Attribute>(getProperties().options);
  }

  ::mlir::Attribute getOptions();
  ::mlir::Attribute getSelectedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().selected);
  }

  ::std::optional<::mlir::Attribute> getSelected();
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setOptionsAttr(::mlir::Attribute attr) {
    getProperties().options = attr;
  }

  void setSelectedAttr(::mlir::Attribute attr) {
    getProperties().selected = attr;
  }

  ::mlir::Attribute removeSelectedAttr() {
      auto attr = getProperties().selected;
      getProperties().selected = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static KnobOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static KnobOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static KnobOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static KnobOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KnobOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KnobOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KnobOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KnobOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::DiagnosedSilenceableFailure apply(::mlir::transform::TransformRewriter &rewriter, ::mlir::transform::TransformResults &transformResults, ::mlir::transform::TransformState &state);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace tune 
} // namespace transform
} // namespace  mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID( mlir::transform::tune ::KnobOp)


#endif  // GET_OP_CLASSES

