/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.MetadataBridge;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.SubArtifact;

@Named
@Deprecated
public class DefaultArtifactDeployer
extends AbstractLogEnabled
implements ArtifactDeployer {
    @Inject
    private RepositorySystem repoSystem;
    @Inject
    private LegacySupport legacySupport;
    private Map<Object, MergeableMetadata> relatedMetadata = new ConcurrentHashMap<Object, MergeableMetadata>();

    @Override
    @Deprecated
    public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.deploy(source, artifact, deploymentRepository, localRepository);
    }

    @Override
    public void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        DeployResult result;
        RepositorySystemSession session = LegacyLocalRepositoryManager.overlay(localRepository, this.legacySupport.getRepositorySession(), this.repoSystem);
        DeployRequest request = new DeployRequest();
        request.setTrace(RequestTrace.newChild(null, (Object)this.legacySupport.getSession().getCurrentProject()));
        org.eclipse.aether.artifact.Artifact mainArtifact = RepositoryUtils.toArtifact((Artifact)artifact);
        mainArtifact = mainArtifact.setFile(source);
        request.addArtifact(mainArtifact);
        String versionKey = artifact.getGroupId() + ":" + artifact.getArtifactId();
        String snapshotKey = null;
        if (artifact.isSnapshot()) {
            snapshotKey = versionKey + ":" + artifact.getBaseVersion();
            request.addMetadata((Metadata)this.relatedMetadata.get(snapshotKey));
        }
        request.addMetadata((Metadata)this.relatedMetadata.get(versionKey));
        for (ArtifactMetadata metadata : artifact.getMetadataList()) {
            if (metadata instanceof ProjectArtifactMetadata) {
                ProjectArtifactMetadata projectArtifactMetadata = (ProjectArtifactMetadata)metadata;
                SubArtifact pomArtifact = new SubArtifact(mainArtifact, "", "pom");
                pomArtifact = pomArtifact.setFile(projectArtifactMetadata.getFile());
                request.addArtifact((org.eclipse.aether.artifact.Artifact)pomArtifact);
                continue;
            }
            if (metadata instanceof SnapshotArtifactRepositoryMetadata || metadata instanceof ArtifactRepositoryMetadata) continue;
            request.addMetadata((Metadata)new MetadataBridge(metadata));
        }
        RemoteRepository remoteRepo = RepositoryUtils.toRepo((ArtifactRepository)deploymentRepository);
        if (deploymentRepository instanceof DefaultArtifactRepository && deploymentRepository.getAuthentication() == null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(remoteRepo);
            builder.setAuthentication(session.getAuthenticationSelector().getAuthentication(remoteRepo));
            builder.setProxy(session.getProxySelector().getProxy(remoteRepo));
            remoteRepo = builder.build();
        }
        request.setRepository(remoteRepo);
        try {
            result = this.repoSystem.deploy(session, request);
        }
        catch (DeploymentException e) {
            throw new ArtifactDeploymentException(e.getMessage(), e);
        }
        for (Object metadata : result.getMetadata()) {
            if (metadata.getClass().getName().endsWith(".internal.VersionsMetadata")) {
                this.relatedMetadata.put(versionKey, (MergeableMetadata)metadata);
            }
            if (snapshotKey == null || !metadata.getClass().getName().endsWith(".internal.RemoteSnapshotMetadata")) continue;
            this.relatedMetadata.put(snapshotKey, (MergeableMetadata)metadata);
        }
        artifact.setResolvedVersion(((org.eclipse.aether.artifact.Artifact)result.getArtifacts().iterator().next()).getVersion());
    }
}

