/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.position;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.StringReader;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0017\u001a$\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013\u00a8\u0006\u001c"}, d2={"extractRange", "", "content", "range", "Lorg/eclipse/lsp4j/Range;", "offset", "", "position", "Lorg/eclipse/lsp4j/Position;", "line", "char", "Lcom/intellij/openapi/util/TextRange;", "location", "Lorg/eclipse/lsp4j/Location;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isZero", "", "(Lorg/eclipse/lsp4j/Position;)Z", "(Lorg/eclipse/lsp4j/Range;)Z", "expr", "Lcom/intellij/psi/PsiElement;", "toURIString", "Lcom/intellij/psi/PsiFile;", "changedRegion", "Lkotlin/Pair;", "oldContent", "newContent", "server"})
@SourceDebugExtension(value={"SMAP\nPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Position.kt\norg/javacs/kt/position/PositionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class PositionKt {
    @NotNull
    public static final String extractRange(@NotNull String content, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String string = content;
        Position position = range.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        int n = PositionKt.offset(content, position);
        Position position2 = range.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
        int n2 = PositionKt.offset(content, position2);
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    public static final int offset(@NotNull String content, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return PositionKt.offset(content, position.getLine(), position.getCharacter());
    }

    public static final int offset(@NotNull String content, int line, int n) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        boolean bl2 = bl = !StringsKt.contains$default((CharSequence)content, (char)'\r', (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        StringReader reader = new StringReader(content);
        int offset = 0;
        int lineOffset = 0;
        while (lineOffset < line) {
            int nextChar = reader.read();
            if (nextChar == -1) {
                throw new RuntimeException("Reached end of file before reaching line " + line);
            }
            if ((char)nextChar == '\n') {
                ++lineOffset;
            }
            ++offset;
        }
        int charOffset = 0;
        while (charOffset < n) {
            int nextChar = reader.read();
            if (nextChar == -1) {
                throw new RuntimeException("Reached end of file before reaching char " + n);
            }
            ++charOffset;
            ++offset;
        }
        return offset;
    }

    @NotNull
    public static final Position position(@NotNull String content, int offset) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StringReader reader = new StringReader(content);
        int line = 0;
        int n = 0;
        int find = 0;
        while (find < offset) {
            int nextChar = reader.read();
            if (nextChar == -1) {
                throw new RuntimeException("Reached end of file before reaching offset " + offset);
            }
            ++find;
            ++n;
            if ((char)nextChar != '\n') continue;
            ++line;
            n = 0;
        }
        return new Position(line, n);
    }

    @NotNull
    public static final Range range(@NotNull String content, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new Range(PositionKt.position(content, range.getStartOffset()), PositionKt.position(content, range.getEndOffset()));
    }

    @Nullable
    public static final Location location(@NotNull DeclarationDescriptor declaration) {
        Location psiLocation;
        Location location;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PsiElement psiElement = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)declaration);
        if (psiElement != null) {
            PsiElement p0 = psiElement;
            boolean bl = false;
            location = PositionKt.location(p0);
        } else {
            location = null;
        }
        Location location2 = psiLocation = location;
        if (location2 != null) {
            return location2;
        }
        if (declaration instanceof DeclarationDescriptorWithSource) {
            SourceFile sourceFile;
            SourceFile sourceFile2 = ((DeclarationDescriptorWithSource)declaration).getSource().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)sourceFile2, (String)"getContainingFile(...)");
            SourceFile sourceFile3 = sourceFile = sourceFile2;
            if (sourceFile3 instanceof PsiSourceFile) {
                String file = PositionKt.toURIString(((PsiSourceFile)sourceFile).getPsiFile());
                return new Location(file, new Range(new Position(0, 0), new Position(0, 0)));
            }
            if (!Intrinsics.areEqual((Object)sourceFile3, (Object)SourceFile.NO_SOURCE_FILE)) {
                Object[] objectArray = new Object[]{sourceFile};
                LoggerKt.getLOG().info("Source type of {} not recognized", objectArray);
            }
        } else {
            Object[] objectArray = new Object[]{declaration};
            LoggerKt.getLOG().info("{} does not have a source", objectArray);
        }
        return null;
    }

    public static final boolean isZero(@NotNull Position $this$isZero) {
        Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"<this>");
        return $this$isZero.getLine() == 0 && $this$isZero.getCharacter() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isZero(@NotNull Range $this$isZero) {
        Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"<this>");
        Position position = $this$isZero.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        if (!PositionKt.isZero(position)) return false;
        Position position2 = $this$isZero.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
        if (!PositionKt.isZero(position2)) return false;
        return true;
    }

    @Nullable
    public static final Location location(@NotNull PsiElement expr) {
        Location location;
        String string;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        try {
            PsiFile psiFile = expr.getContainingFile();
            string = psiFile != null ? psiFile.getText() : null;
        }
        catch (NullPointerException e) {
            string = null;
        }
        String content = string;
        PsiFile psiFile = expr.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        String file = PositionKt.toURIString(psiFile);
        String string2 = content;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            TextRange textRange = expr.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            location = new Location(file, PositionKt.range(it, textRange));
        } else {
            location = null;
        }
        return location;
    }

    @NotNull
    public static final String toURIString(@NotNull PsiFile $this$toURIString) {
        Intrinsics.checkNotNullParameter((Object)$this$toURIString, (String)"<this>");
        String string = PsiUtilsKt.toPath($this$toURIString).toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public static final Pair<TextRange, TextRange> changedRegion(@NotNull String oldContent, @NotNull String newContent) {
        Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        if (Intrinsics.areEqual((Object)oldContent, (Object)newContent)) {
            return null;
        }
        int prefix = StringsKt.commonPrefixWith$default((CharSequence)oldContent, (CharSequence)newContent, (boolean)false, (int)2, null).length();
        int suffix = StringsKt.commonSuffixWith$default((CharSequence)oldContent, (CharSequence)newContent, (boolean)false, (int)2, null).length();
        int oldEnd = Math.max(oldContent.length() - suffix, prefix);
        int newEnd = Math.max(newContent.length() - suffix, prefix);
        return new Pair((Object)new TextRange(prefix, oldEnd), (Object)new TextRange(prefix, newEnd));
    }
}

