/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.io.GridFile;
import org.infinispan.io.GridInputStream;
import org.infinispan.io.GridOutputStream;

public class GridFilesystem {
    protected final Cache<String, byte[]> data;
    protected final Cache<String, GridFile.Metadata> metadata;
    protected final int default_chunk_size;

    public GridFilesystem(Cache<String, byte[]> data, Cache<String, GridFile.Metadata> metadata, int default_chunk_size) {
        this.data = data;
        this.metadata = metadata;
        this.default_chunk_size = default_chunk_size;
    }

    public GridFilesystem(Cache<String, byte[]> data, Cache<String, GridFile.Metadata> metadata) {
        this(data, metadata, 8000);
    }

    public File getFile(String pathname) {
        return this.getFile(pathname, this.default_chunk_size);
    }

    public File getFile(String pathname, int chunk_size) {
        return new GridFile(pathname, this.metadata, chunk_size, this);
    }

    public File getFile(String parent, String child) {
        return this.getFile(parent, child, this.default_chunk_size);
    }

    public File getFile(String parent, String child, int chunk_size) {
        return new GridFile(parent, child, this.metadata, chunk_size, this);
    }

    public File getFile(File parent, String child) {
        return this.getFile(parent, child, this.default_chunk_size);
    }

    public File getFile(File parent, String child, int chunk_size) {
        return new GridFile(parent, child, this.metadata, chunk_size, this);
    }

    public OutputStream getOutput(String pathname) throws IOException {
        return this.getOutput(pathname, false, this.default_chunk_size);
    }

    public OutputStream getOutput(String pathname, boolean append) throws IOException {
        return this.getOutput(pathname, append, this.default_chunk_size);
    }

    public OutputStream getOutput(String pathname, boolean append, int chunk_size) throws IOException {
        GridFile file = (GridFile)this.getFile(pathname, chunk_size);
        if (!file.createNewFile()) {
            throw new IOException("creation of " + pathname + " failed");
        }
        return new GridOutputStream(file, append, this.data, chunk_size);
    }

    public OutputStream getOutput(GridFile file) throws IOException {
        if (!file.createNewFile()) {
            throw new IOException("creation of " + file + " failed");
        }
        return new GridOutputStream(file, false, this.data, this.default_chunk_size);
    }

    public InputStream getInput(String pathname) throws FileNotFoundException {
        GridFile file = (GridFile)this.getFile(pathname);
        if (!file.exists()) {
            throw new FileNotFoundException(pathname);
        }
        return new GridInputStream(file, this.data, this.default_chunk_size);
    }

    public InputStream getInput(File pathname) throws FileNotFoundException {
        return pathname != null ? this.getInput(pathname.getPath()) : null;
    }

    public void remove(String path, boolean synchronous) {
        if (path == null) {
            return;
        }
        GridFile.Metadata md = (GridFile.Metadata)this.metadata.get(path);
        if (md == null) {
            return;
        }
        int num_chunks = md.getLength() / md.getChunkSize() + 1;
        for (int i = 0; i < num_chunks; ++i) {
            this.data.remove(path + ".#" + i, synchronous);
        }
    }
}

