/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.CodeGenerationException;
import org.logicalcobwebs.cglib.core.CollectionUtils;
import org.logicalcobwebs.cglib.core.DuplicatesPredicate;
import org.logicalcobwebs.cglib.core.EmitUtils;
import org.logicalcobwebs.cglib.core.MethodWrapper;
import org.logicalcobwebs.cglib.core.ObjectSwitchCallback;
import org.logicalcobwebs.cglib.core.Predicate;
import org.logicalcobwebs.cglib.core.ProcessSwitchCallback;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;
import org.logicalcobwebs.cglib.core.VisibilityPredicate;
import org.logicalcobwebs.cglib.proxy.Callback;
import org.logicalcobwebs.cglib.proxy.CallbackFilter;
import org.logicalcobwebs.cglib.proxy.CallbackGenerator;
import org.logicalcobwebs.cglib.proxy.CallbackUtils;

class EnhancerEmitter
extends ClassEmitter {
    private static final String CONSTRUCTED_FIELD = "CGLIB$CONSTRUCTED";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type THREAD_LOCAL = TypeUtils.parseType("ThreadLocal");
    private static final Type FACTORY = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.Factory");
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature SET_THREAD_CALLBACKS = TypeUtils.parseSignature("void CGLIB$SET_THREAD_CALLBACKS(org.logicalcobwebs.cglib.proxy.Callback[])");
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(org.logicalcobwebs.cglib.proxy.Callback[])");
    private static final Signature MULTIARG_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(Class[], Object[], org.logicalcobwebs.cglib.proxy.Callback[])");
    private static final Signature SINGLE_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(org.logicalcobwebs.cglib.proxy.Callback)");
    private static final Signature COPY_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance()");
    private static final Signature COPY_MULTIARG_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(Class[], Object[])");
    private static final Signature SET_CALLBACK = TypeUtils.parseSignature("void setCallback(int, org.logicalcobwebs.cglib.proxy.Callback)");
    private static final Signature GET_CALLBACK = TypeUtils.parseSignature("org.logicalcobwebs.cglib.proxy.Callback getCallback(int)");
    private static final Signature SET_CALLBACKS = TypeUtils.parseSignature("void setCallbacks(org.logicalcobwebs.cglib.proxy.Callback[])");
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature("Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature("void set(Object)");
    private Class[] callbackTypes;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$logicalcobwebs$cglib$proxy$Factory;
    static /* synthetic */ Class array$Lorg$logicalcobwebs$cglib$proxy$Callback;

    public EnhancerEmitter(ClassVisitor v, String className, Class superclass, Class[] interfaces, CallbackFilter filter, Class[] callbackTypes, boolean useFactory) throws Exception {
        super(v);
        if (superclass == null) {
            superclass = class$java$lang$Object == null ? (class$java$lang$Object = EnhancerEmitter.class$("java.lang.Object")) : class$java$lang$Object;
        }
        this.callbackTypes = callbackTypes;
        this.begin_class(1, className, Type.getType(superclass), useFactory ? TypeUtils.add(TypeUtils.getTypes(interfaces), FACTORY) : TypeUtils.getTypes(interfaces), "<generated>");
        ArrayList clist = new ArrayList(Arrays.asList(superclass.getDeclaredConstructors()));
        CollectionUtils.filter(clist, (Predicate)new VisibilityPredicate(superclass, true));
        if (clist.size() == 0) {
            throw new IllegalArgumentException("No visible constructors in " + superclass);
        }
        Constructor[] constructors = clist.toArray(new Constructor[clist.size()]);
        ArrayList methods = new ArrayList();
        ReflectUtils.addAllMethods(superclass, methods);
        ArrayList interfaceMethods = new ArrayList();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] == (class$org$logicalcobwebs$cglib$proxy$Factory == null ? EnhancerEmitter.class$("org.logicalcobwebs.cglib.proxy.Factory") : class$org$logicalcobwebs$cglib$proxy$Factory)) continue;
                ReflectUtils.addAllMethods(interfaces[i], interfaceMethods);
            }
        }
        Set forcePublic = MethodWrapper.createSet(interfaceMethods);
        methods.addAll(interfaceMethods);
        CollectionUtils.filter(methods, (Predicate)new VisibilityPredicate(superclass, true));
        CollectionUtils.filter(methods, (Predicate)new DuplicatesPredicate());
        EnhancerEmitter.removeFinal(methods);
        HashMap<CallbackGenerator, ArrayList<Method>> groups = new HashMap<CallbackGenerator, ArrayList<Method>>();
        HashMap<Method, Integer> indexes = new HashMap<Method, Integer>();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            int index = filter.accept(method);
            if (index >= callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + index);
            }
            indexes.put(method, new Integer(index));
            CallbackGenerator gen = CallbackUtils.getGenerator(callbackTypes[index]);
            ArrayList<Method> group = (ArrayList<Method>)groups.get(gen);
            if (group == null) {
                group = new ArrayList<Method>(methods.size());
                groups.put(gen, group);
            }
            group.add(method);
        }
        this.declare_field(2, CONSTRUCTED_FIELD, Type.BOOLEAN_TYPE, null, null);
        this.emitMethods(groups, indexes, forcePublic);
        this.emitConstructors(constructors);
        this.emitSetThreadCallbacks();
        if (useFactory) {
            int[] keys = this.getCallbackKeys();
            this.emitNewInstanceCallbacks();
            this.emitNewInstanceCallback();
            this.emitNewInstanceMultiarg(constructors);
            this.emitNewInstanceCopy();
            this.emitNewInstanceMultiargCopy(constructors);
            this.emitGetCallback(keys);
            this.emitSetCallback(keys);
            this.emitSetCallbacks();
        }
        this.end_class();
    }

    static void setThreadCallbacks(Class type, Callback[] callbacks) {
        try {
            Method setter = type.getDeclaredMethod(SET_THREAD_CALLBACKS_NAME, array$Lorg$logicalcobwebs$cglib$proxy$Callback == null ? (array$Lorg$logicalcobwebs$cglib$proxy$Callback = EnhancerEmitter.class$("[Lorg.logicalcobwebs.cglib.proxy.Callback;")) : array$Lorg$logicalcobwebs$cglib$proxy$Callback);
            setter.invoke(null, new Object[]{callbacks});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " is not an enhanced class");
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e);
        }
    }

    private void emitConstructors(Constructor[] constructors) {
        for (int i = 0; i < constructors.length; ++i) {
            Signature sig = ReflectUtils.getSignature(constructors[i]);
            CodeEmitter e = this.begin_method(1, sig, ReflectUtils.getExceptionTypes(constructors[i]), null);
            e.load_this();
            e.dup();
            e.load_args();
            e.super_invoke_constructor(sig);
            e.push(1);
            e.putfield(CONSTRUCTED_FIELD);
            for (int j = 0; j < this.callbackTypes.length; ++j) {
                e.load_this();
                e.dup();
                e.getfield(EnhancerEmitter.getThreadLocal(j));
                e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
                e.checkcast(Type.getType(this.callbackTypes[j]));
                e.putfield(EnhancerEmitter.getCallbackField(j));
                e.getfield(EnhancerEmitter.getThreadLocal(j));
                e.aconst_null();
                e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
            }
            e.return_value();
            e.end_method();
        }
    }

    private int[] getCallbackKeys() {
        int[] keys = new int[this.callbackTypes.length];
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            keys[i] = i;
        }
        return keys;
    }

    private void emitGetCallback(int[] keys) {
        final CodeEmitter e = this.begin_method(1, GET_CALLBACK, null, null);
        e.load_this();
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                e.getfield(EnhancerEmitter.getCallbackField(key));
                e.goTo(end);
            }

            public void processDefault() {
                e.pop();
                e.aconst_null();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallback(int[] keys) {
        final CodeEmitter e = this.begin_method(1, SET_CALLBACK, null, null);
        e.load_this();
        e.load_arg(1);
        e.dup();
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                e.getfield(EnhancerEmitter.getThreadLocal(key));
                e.swap();
                e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
                e.checkcast(Type.getType(EnhancerEmitter.this.callbackTypes[key]));
                e.putfield(EnhancerEmitter.getCallbackField(key));
                e.goTo(end);
            }

            public void processDefault() {
                e.pop2();
                e.pop();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallbacks() {
        CodeEmitter e = this.begin_method(1, SET_CALLBACKS, null, null);
        this.emitSetThreadCallbacks(e);
        e.load_this();
        e.load_arg(0);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup2();
            e.aaload(i);
            e.checkcast(Type.getType(this.callbackTypes[i]));
            e.putfield(EnhancerEmitter.getCallbackField(i));
        }
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallbacks() {
        CodeEmitter e = this.begin_method(1, NEW_INSTANCE, null, null);
        e.load_arg(0);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonNewInstance(e);
    }

    private void emitNewInstanceCopy() {
        CodeEmitter e = this.begin_method(1, COPY_NEW_INSTANCE, null, null);
        this.emitCopyCallbacks(e);
        this.emitCommonNewInstance(e);
    }

    private void emitCopyCallbacks(CodeEmitter e) {
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.getfield(EnhancerEmitter.getThreadLocal(i));
            e.load_this();
            e.getfield(EnhancerEmitter.getCallbackField(i));
            e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        }
    }

    private void emitCommonNewInstance(CodeEmitter e) {
        e.new_instance_this();
        e.dup();
        e.invoke_constructor_this();
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallback() {
        CodeEmitter e = this.begin_method(1, SINGLE_NEW_INSTANCE, null, null);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                e.getfield(EnhancerEmitter.getThreadLocal(0));
                e.load_arg(0);
                e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
                break;
            }
            default: {
                e.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        this.emitCommonNewInstance(e);
    }

    private void emitNewInstanceMultiarg(Constructor[] constructors) {
        CodeEmitter e = this.begin_method(1, MULTIARG_NEW_INSTANCE, null, null);
        e.load_arg(2);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonMultiarg(constructors, e);
    }

    private void emitNewInstanceMultiargCopy(Constructor[] constructors) {
        CodeEmitter e = this.begin_method(1, COPY_MULTIARG_NEW_INSTANCE, null, null);
        this.emitCopyCallbacks(e);
        this.emitCommonMultiarg(constructors, e);
    }

    private void emitCommonMultiarg(Constructor[] constructors, final CodeEmitter e) {
        e.new_instance_this();
        e.dup();
        e.load_arg(0);
        EmitUtils.constructor_switch(e, constructors, new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                Constructor constructor = (Constructor)key;
                Type[] types = TypeUtils.getTypes(constructor.getParameterTypes());
                for (int i = 0; i < types.length; ++i) {
                    e.load_arg(1);
                    e.push(i);
                    e.aaload();
                    e.unbox(types[i]);
                }
                e.invoke_constructor_this(ReflectUtils.getSignature(constructor));
                e.goTo(end);
            }

            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitMethods(Map groups, final Map indexes, final Set forcePublic) throws Exception {
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            this.declare_field(2, EnhancerEmitter.getCallbackField(i), Type.getType(this.callbackTypes[i]), null, null);
            this.declare_field(26, EnhancerEmitter.getThreadLocal(i), THREAD_LOCAL, null, null);
        }
        HashSet<CallbackGenerator> seenGen = new HashSet<CallbackGenerator>();
        CodeEmitter e = this.begin_static();
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.new_instance(THREAD_LOCAL);
            e.dup();
            e.invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
            e.putfield(EnhancerEmitter.getThreadLocal(i));
            CallbackGenerator gen = CallbackUtils.getGenerator(this.callbackTypes[i]);
            if (seenGen.contains(gen)) continue;
            seenGen.add(gen);
            final List fmethods = (List)groups.get(gen);
            CallbackGenerator.Context context = new CallbackGenerator.Context(){

                public Iterator getMethods() {
                    return fmethods.iterator();
                }

                public int getIndex(Method method) {
                    return (Integer)indexes.get(method);
                }

                public void emitCallback(CodeEmitter e, int index) {
                    EnhancerEmitter.this.emitCurrentCallback(e, index);
                }

                public int getModifiers(Method method) {
                    int modifiers = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
                    if (forcePublic.contains(MethodWrapper.create(method))) {
                        modifiers = modifiers & 0xFFFFFFFB | 1;
                    }
                    return modifiers;
                }

                public String getUniqueName(Method method) {
                    return method.getName() + "_" + fmethods.indexOf(method);
                }
            };
            gen.generate(this, context);
            gen.generateStatic(e, context);
        }
        e.return_value();
        e.end_method();
    }

    private void emitSetThreadCallbacks() {
        CodeEmitter e = this.begin_method(9, SET_THREAD_CALLBACKS, null, null);
        this.emitSetThreadCallbacks(e);
        e.return_value();
        e.end_method();
    }

    private void emitSetThreadCallbacks(CodeEmitter e) {
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.getfield(EnhancerEmitter.getThreadLocal(i));
            e.load_arg(0);
            e.aaload(i);
            e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        }
    }

    private void emitCurrentCallback(CodeEmitter e, int index) {
        e.load_this();
        e.getfield(EnhancerEmitter.getCallbackField(index));
        e.dup();
        Label end = e.make_label();
        e.ifnonnull(end);
        e.load_this();
        e.getfield(CONSTRUCTED_FIELD);
        e.if_jump(154, end);
        e.pop();
        e.getfield(EnhancerEmitter.getThreadLocal(index));
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        e.checkcast(Type.getType(this.callbackTypes[index]));
        e.mark(end);
    }

    private static String getCallbackField(int index) {
        return "CGLIB$CALLBACK_" + index;
    }

    private static String getThreadLocal(int index) {
        return "CGLIB$TL_CALLBACK_" + index;
    }

    private static void removeFinal(List list) {
        CollectionUtils.filter(list, new Predicate(){

            public boolean evaluate(Object arg) {
                return !Modifier.isFinal(((Method)arg).getModifiers());
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

