/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.util.HashMap;
import java.util.Map;
import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.ClassAdapter;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.Constants;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;

public class ClassEmitter
extends ClassAdapter {
    private static final Signature STATIC_HOOK = TypeUtils.parseSignature("void CGLIB$STATIC_HOOK()");
    private static final String STATIC_HOOK_FLAG = "CGLIB$STATIC_HOOK_FLAG";
    private int access;
    private Type classType;
    private Type superType;
    private Map fieldInfo;
    private boolean seenStatic;
    private CodeEmitter hook;
    private boolean ended;
    private ClassVisitor outer;

    public ClassEmitter(ClassVisitor cv) {
        super(null);
        this.setTarget(cv, this);
    }

    public ClassEmitter() {
        super(null);
    }

    public void setTarget(ClassVisitor cv, ClassVisitor outer) {
        this.cv = cv;
        this.outer = outer;
        this.fieldInfo = new HashMap();
        this.seenStatic = false;
        this.hook = null;
        this.ended = false;
    }

    public void begin_class(int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        this.access = access;
        this.classType = Type.getType("L" + className.replace('.', '/') + ";");
        this.superType = superType != null ? superType : Constants.TYPE_OBJECT;
        this.cv.visit(access, this.classType.getInternalName(), this.superType.getInternalName(), TypeUtils.toInternalNames(interfaces), sourceFile);
        this.init();
    }

    public CodeEmitter getStaticHook() {
        if (TypeUtils.isInterface(this.access)) {
            throw new IllegalStateException("static hook is invalid for this class");
        }
        if (this.hook == null) {
            ClassEmitter oe = new ClassEmitter(this.outer);
            oe.declare_field(26, STATIC_HOOK_FLAG, Type.BOOLEAN_TYPE, null, null);
            CodeEmitter e = oe.begin_method(8, STATIC_HOOK, null, null);
            Label ok = e.make_label();
            e.getstatic(this.classType, STATIC_HOOK_FLAG, Type.BOOLEAN_TYPE);
            e.if_jump(153, ok);
            e.return_value();
            e.mark(ok);
            e.push(true);
            e.putstatic(this.classType, STATIC_HOOK_FLAG, Type.BOOLEAN_TYPE);
        }
        return this.hook;
    }

    protected void init() {
    }

    public int getAccess() {
        return this.access;
    }

    public Type getClassType() {
        return this.classType;
    }

    public Type getSuperType() {
        return this.superType;
    }

    public void end_class() {
        if (this.seenStatic && this.hook == null) {
            this.getStaticHook();
        }
        if (this.hook != null) {
            if (!this.seenStatic) {
                CodeVisitor v = this.outer.visitMethod(8, Constants.SIG_STATIC.getName(), Constants.SIG_STATIC.getDescriptor(), null, null);
                v.visitInsn(177);
                v.visitMaxs(0, 0);
            }
            this.ended = true;
            this.hook.return_value();
            this.hook.end_method();
        }
        this.cv.visitEnd();
    }

    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions, Attribute attrs) {
        CodeVisitor v = this.cv.visitMethod(access, sig.getName(), sig.getDescriptor(), TypeUtils.toInternalNames(exceptions), attrs);
        if (sig.equals(STATIC_HOOK)) {
            this.hook = new CodeEmitter(this, v, access, sig, exceptions){

                public boolean isStaticHook() {
                    return true;
                }

                public void visitMaxs(int maxStack, int maxLocals) {
                    if (ClassEmitter.this.ended) {
                        super.visitMaxs(maxStack, maxLocals);
                    }
                }

                public void visitInsn(int insn) {
                    if (insn != 177 || ClassEmitter.this.ended) {
                        super.visitInsn(insn);
                    }
                }
            };
            return this.hook;
        }
        CodeEmitter e = new CodeEmitter(this, v, access, sig, exceptions);
        if (sig.equals(Constants.SIG_STATIC) && !TypeUtils.isInterface(this.access)) {
            this.seenStatic = true;
            e.invoke_static_this(STATIC_HOOK);
        }
        return e;
    }

    public CodeEmitter begin_static() {
        return this.begin_method(8, Constants.SIG_STATIC, null, null);
    }

    public void declare_field(int access, String name, Type type, Object value, Attribute attrs) {
        FieldInfo existing = (FieldInfo)this.fieldInfo.get(name);
        FieldInfo info = new FieldInfo(access, name, type, value);
        if (existing != null) {
            if (!info.equals(existing)) {
                throw new IllegalArgumentException("Field \"" + name + "\" has been declared differently");
            }
        } else {
            this.fieldInfo.put(name, info);
            this.cv.visitField(access, name, type.getDescriptor(), value, attrs);
        }
    }

    public void define_attribute(Attribute attrs) {
        this.cv.visitAttribute(attrs);
    }

    boolean isFieldDeclared(String name) {
        return this.fieldInfo.get(name) != null;
    }

    FieldInfo getFieldInfo(String name) {
        FieldInfo field = (FieldInfo)this.fieldInfo.get(name);
        if (field == null) {
            throw new IllegalArgumentException("Field " + name + " is not declared in " + this.classType.getClassName());
        }
        return field;
    }

    public void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.begin_class(access, name.replace('/', '.'), TypeUtils.fromInternalName(superName), TypeUtils.fromInternalNames(interfaces), sourceFile);
    }

    public void visitEnd() {
        this.end_class();
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.declare_field(access, name, Type.getType(desc), value, attrs);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        return this.begin_method(access, new Signature(name, desc), TypeUtils.fromInternalNames(exceptions), attrs);
    }

    public void visitAttribute(Attribute attrs) {
        this.define_attribute(attrs);
    }

    static class FieldInfo {
        int access;
        String name;
        Type type;
        Object value;

        public FieldInfo(int access, String name, Type type, Object value) {
            this.access = access;
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof FieldInfo)) {
                return false;
            }
            FieldInfo other = (FieldInfo)o;
            if (this.access != other.access || !this.name.equals(other.name) || !this.type.equals(other.type)) {
                return false;
            }
            if (this.value == null ^ other.value == null) {
                return false;
            }
            return this.value == null || this.value.equals(other.value);
        }

        public int hashCode() {
            return this.access ^ this.name.hashCode() ^ this.type.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

