/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.reader.AuditReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubclassPropertyMapper
implements ExtendedPropertyMapper {
    private ExtendedPropertyMapper main;
    private ExtendedPropertyMapper parentMapper;

    public SubclassPropertyMapper(ExtendedPropertyMapper main, ExtendedPropertyMapper parentMapper) {
        this.main = main;
        this.parentMapper = parentMapper;
    }

    @Override
    public boolean map(SessionImplementor session, Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean parentDiffs = this.parentMapper.map(session, data, propertyNames, newState, oldState);
        boolean mainDiffs = this.main.map(session, data, propertyNames, newState, oldState);
        return parentDiffs || mainDiffs;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        boolean parentDiffs = this.parentMapper.mapToMapFromEntity(session, data, newObj, oldObj);
        boolean mainDiffs = this.main.mapToMapFromEntity(session, data, newObj, oldObj);
        return parentDiffs || mainDiffs;
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        this.parentMapper.mapToEntityFromMap(verCfg, obj, data, primaryKey, versionsReader, revision);
        this.main.mapToEntityFromMap(verCfg, obj, data, primaryKey, versionsReader, revision);
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        List<PersistentCollectionChangeData> parentCollectionChanges = this.parentMapper.mapCollectionChanges(referencingPropertyName, newColl, oldColl, id);
        List<PersistentCollectionChangeData> mainCollectionChanges = this.main.mapCollectionChanges(referencingPropertyName, newColl, oldColl, id);
        if (parentCollectionChanges == null) {
            return mainCollectionChanges;
        }
        if (mainCollectionChanges != null) {
            parentCollectionChanges.addAll(mainCollectionChanges);
        }
        return parentCollectionChanges;
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, String componentClassName) {
        return this.main.addComponent(propertyData, componentClassName);
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.main.addComposite(propertyData, propertyMapper);
    }

    @Override
    public void add(PropertyData propertyData) {
        this.main.add(propertyData);
    }
}

