/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixBase;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Scheme;
import java.util.Arrays;

public class HealpixMapDouble
extends HealpixBase {
    private double[] data;
    public static final double undef = -1.6375E30;

    public HealpixMapDouble() throws Exception {
        this(1L, Scheme.NESTED);
    }

    public HealpixMapDouble(long nside_in, Scheme scheme_in) throws Exception {
        super(nside_in, scheme_in);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = new double[(int)this.getNpix()];
    }

    public HealpixMapDouble(double[] data_in, Scheme scheme_in) throws Exception {
        super(HealpixMapDouble.npix2Nside(data_in.length), scheme_in);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = data_in;
    }

    @Override
    public void setNside(long nside_in) throws Exception {
        if (nside_in != this.nside) {
            super.setNside(nside_in);
            HealpixUtils.check(this.nside <= 8192L, "resolution too high");
            this.data = new double[(int)this.getNpix()];
        }
    }

    @Override
    public void setNsideAndScheme(long nside_in, Scheme scheme_in) throws Exception {
        super.setNsideAndScheme(nside_in, scheme_in);
        HealpixUtils.check(this.nside <= 8192L, "resolution too high");
        this.data = new double[(int)this.getNpix()];
    }

    public void setDataAndScheme(double[] data_in, Scheme scheme_in) throws Exception {
        super.setNsideAndScheme(HealpixMapDouble.npix2Nside(data_in.length), scheme_in);
        this.data = data_in;
    }

    public void fill(double val) {
        Arrays.fill(this.data, val);
    }

    public void swapScheme() throws Exception {
        HealpixUtils.check(this.order >= 0 && this.order <= 13, "swapping not supported for this Nside");
        for (int m = 0; m < swap_cycle[this.order].length; ++m) {
            long inew;
            int istart = swap_cycle[this.order][m];
            double pixbuf = this.data[istart];
            long iold = istart;
            long l = inew = this.scheme == Scheme.RING ? this.nest2ring(istart) : this.ring2nest(istart);
            while (inew != (long)istart) {
                this.data[(int)iold] = this.data[(int)inew];
                iold = inew;
                inew = this.scheme == Scheme.RING ? this.nest2ring(inew) : this.ring2nest(inew);
            }
            this.data[(int)iold] = pixbuf;
        }
        this.scheme = this.scheme == Scheme.RING ? Scheme.NESTED : Scheme.RING;
    }

    public double getPixel(int ipix) {
        return this.data[ipix];
    }

    public double getPixel(long ipix) {
        return this.data[(int)ipix];
    }

    public void setPixel(int ipix, double val) {
        this.data[ipix] = val;
    }

    public void setPixel(long ipix, double val) {
        this.data[(int)ipix] = val;
    }

    public double[] getData() {
        return this.data;
    }

    public void importNograde(HealpixMapDouble orig) throws Exception {
        HealpixUtils.check(this.nside == orig.nside, "importNograde: maps have different nside");
        if (orig.scheme == this.scheme) {
            System.arraycopy(orig.data, 0, this.data, 0, (int)this.npix);
        } else {
            int m = 0;
            while ((long)m < this.npix) {
                this.data[this.scheme == Scheme.NESTED ? (int)this.ring2nest((long)((long)m)) : (int)this.nest2ring((long)((long)m))] = orig.data[m];
                ++m;
            }
        }
    }

    public void importUpgrade(HealpixMapDouble orig) throws Exception {
        HealpixUtils.check(this.nside > orig.nside, "importUpgrade: this is no upgrade");
        int fact = (int)(this.nside / orig.nside);
        HealpixUtils.check(this.nside == orig.nside * (long)fact, "the larger Nside must be a multiple of the smaller one");
        int m = 0;
        while ((long)m < orig.npix) {
            HealpixBase.Xyf xyf = orig.pix2xyf(m);
            int x = xyf.ix;
            int y = xyf.iy;
            int f = xyf.face;
            for (int j = fact * y; j < fact * (y + 1); ++j) {
                for (int i = fact * x; i < fact * (x + 1); ++i) {
                    long mypix = this.xyf2pix(i, j, f);
                    this.data[(int)mypix] = orig.data[m];
                }
            }
            ++m;
        }
    }

    public void importDegrade(HealpixMapDouble orig, boolean pessimistic) throws Exception {
        HealpixUtils.check(this.nside < orig.nside, "importDegrade: this is no degrade");
        int fact = (int)(orig.nside / this.nside);
        HealpixUtils.check(orig.nside == this.nside * (long)fact, "the larger Nside must be a multiple of the smaller one");
        int minhits = pessimistic ? fact * fact : 1;
        int m = 0;
        while ((long)m < this.npix) {
            HealpixBase.Xyf xyf = this.pix2xyf(m);
            int x = xyf.ix;
            int y = xyf.iy;
            int f = xyf.face;
            int hits = 0;
            double sum = 0.0;
            for (int j = fact * y; j < fact * (y + 1); ++j) {
                for (int i = fact * x; i < fact * (x + 1); ++i) {
                    int opix = (int)orig.xyf2pix(i, j, f);
                    if (HealpixUtils.approx(orig.data[opix], -1.6375E30, 1.0E-5)) continue;
                    ++hits;
                    sum += orig.data[opix];
                }
            }
            this.data[m] = hits < minhits ? -1.6375E30 : sum / (double)hits;
            ++m;
        }
    }

    public void importGeneral(HealpixMapDouble orig, boolean pessimistic) throws Exception {
        if (orig.nside == this.nside) {
            this.importNograde(orig);
        } else if (orig.nside < this.nside) {
            this.importUpgrade(orig);
        } else {
            this.importDegrade(orig, pessimistic);
        }
    }
}

