/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixUtils;
import java.io.ByteArrayOutputStream;

public class Compressor {
    private static void interpol_encode2(long[] data, int l, int r, obitstream obs, int shift) throws Exception {
        if (r - l <= 1) {
            return;
        }
        int m = l + (r - l) / 2;
        long nval = (data[r] - data[l] >>> shift) - (long)(r - l) + 1L;
        if (nval <= 1L) {
            return;
        }
        long val = (data[m] >>> shift) - ((data[l] >>> shift) + (long)(m - l));
        int nb = 1 + HealpixUtils.ilog2(nval - 1L);
        long nshort = (1L << nb) - nval;
        if (val < nshort) {
            obs.put(val, nb - 1);
        } else {
            obs.put(val + nshort, nb);
        }
        Compressor.interpol_encode2(data, l, m, obs, shift);
        Compressor.interpol_encode2(data, m, r, obs, shift);
    }

    public static byte[] interpol_encode(long[] data, int begin, int end) throws Exception {
        obitstream obs = new obitstream();
        if (begin >= end) {
            obs.put(0L, 8);
            return obs.getData();
        }
        HealpixUtils.check(data[begin] >= 0L, "numbers must be nonnegative");
        long combo = data[begin];
        for (int i = begin + 1; i < end; ++i) {
            HealpixUtils.check(data[i - 1] < data[i], "numbers not strictly increasing");
            combo |= data[i];
        }
        int shift = Long.numberOfTrailingZeros(combo);
        long maxnum = data[end - 1] >>> shift;
        if ((long)(end - begin) > maxnum) {
            maxnum = end - begin;
        }
        int maxbits = 1 + HealpixUtils.ilog2(maxnum);
        obs.put(maxbits, 8);
        obs.put(shift, 8);
        obs.put(end - begin, maxbits);
        obs.put(data[begin] >>> shift, maxbits);
        if (end - begin == 1) {
            return obs.getData();
        }
        obs.put(data[end - 1] >>> shift, maxbits);
        Compressor.interpol_encode2(data, begin, end - 1, obs, shift);
        return obs.getData();
    }

    private static void interpol_decode2(long[] data, int l, int r, ibitstream ibs, int shift) throws Exception {
        if (r - l <= 1) {
            return;
        }
        int m = l + (r - l) / 2;
        long nval = (data[r] - data[l] >>> shift) - (long)(r - l) + 1L;
        long val = 0L;
        if (nval > 1L) {
            int nb = 1 + HealpixUtils.ilog2(nval - 1L);
            long nshort = (1L << nb) - nval;
            val = ibs.get(nb - 1);
            if (val >= nshort) {
                val = (val << 1) + ibs.get(1) - nshort;
            }
        }
        data[m] = data[l] + ((long)(m - l) + val << shift);
        Compressor.interpol_decode2(data, l, m, ibs, shift);
        Compressor.interpol_decode2(data, m, r, ibs, shift);
    }

    public static long[] interpol_decode(byte[] data) throws Exception {
        ibitstream ibs = new ibitstream(data);
        int maxbits = (int)ibs.get(8);
        if (maxbits == 0) {
            return new long[0];
        }
        int shift = (int)ibs.get(8);
        long[] v = new long[(int)ibs.get(maxbits)];
        v[0] = ibs.get(maxbits) << shift;
        if (v.length == 1) {
            return v;
        }
        v[v.length - 1] = ibs.get(maxbits) << shift;
        Compressor.interpol_decode2(v, 0, v.length - 1, ibs, shift);
        return v;
    }

    private static final class ibitstream {
        private long bitpos;
        private int curval;
        private byte[] data;

        public ibitstream(byte[] data_in) throws Exception {
            HealpixUtils.check(data_in.length > 0, "empty input array");
            this.bitpos = 0L;
            this.data = (byte[])data_in.clone();
        }

        private long get_internal(long val, int bits) {
            int bitsleft = 8 - (int)(this.bitpos & 7L);
            if (bitsleft == 8) {
                this.curval = this.data[(int)(this.bitpos >>> 3)];
                if (this.curval < 0) {
                    this.curval += 256;
                }
            }
            if (bits <= bitsleft) {
                val |= (long)(this.curval >>> bitsleft - bits) & (1L << bits) - 1L;
                this.bitpos += (long)bits;
            } else {
                val |= ((long)this.curval & (1L << bitsleft) - 1L) << bits - bitsleft;
                this.bitpos += (long)bitsleft;
                val = this.get_internal(val, bits - bitsleft);
            }
            return val;
        }

        public long get(int bits) throws Exception {
            if (bits == 0) {
                return 0L;
            }
            HealpixUtils.check(bits <= 63, "too many bits");
            HealpixUtils.check(this.bitpos + (long)bits <= 8L * (long)this.data.length, "reading past end of stream");
            long res = 0L;
            return this.get_internal(res, bits);
        }
    }

    private static final class obitstream {
        private long bitpos = 0L;
        private int curval = 0;
        private ByteArrayOutputStream strm = new ByteArrayOutputStream();

        private void put_internal(long val, int bits) {
            int bitsleft = 8 - (int)(this.bitpos & 7L);
            if (bits <= bitsleft) {
                this.curval = (int)((long)this.curval | (val & (1L << bits) - 1L) << bitsleft - bits);
                this.bitpos += (long)bits;
                if ((this.bitpos & 7L) == 0L) {
                    this.strm.write(this.curval);
                    this.curval = 0;
                }
            } else {
                this.curval = (int)((long)this.curval | val >>> bits - bitsleft & (long)((1 << bitsleft) - 1));
                this.bitpos += (long)bitsleft;
                if ((this.bitpos & 7L) == 0L) {
                    this.strm.write(this.curval);
                    this.curval = 0;
                }
                this.put_internal(val, bits - bitsleft);
            }
        }

        public void put(long val, int bits) throws Exception {
            if (bits == 0) {
                return;
            }
            HealpixUtils.check(bits <= 63, "too many bits");
            HealpixUtils.check(val - (val & (1L << bits) - 1L) == 0L, "value has too many bits");
            this.put_internal(val, bits);
        }

        public byte[] getData() throws Exception {
            if ((this.bitpos & 7L) != 0L) {
                this.strm.write(this.curval);
            }
            return this.strm.toByteArray();
        }
    }
}

