/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Pointing;
import healpix.essentials.Vec3;
import healpix.essentials.Zphi;

final class Hploc {
    public double z;
    public double phi;
    public double sth;
    public boolean have_sth;

    public Hploc() {
    }

    public Hploc(Vec3 v) {
        double xl = 1.0 / v.length();
        this.z = v.z * xl;
        this.phi = FastMath.atan2(v.y, v.x);
        if (Math.abs(this.z) > 0.99) {
            this.sth = Math.sqrt(v.x * v.x + v.y * v.y) * xl;
            this.have_sth = true;
        }
    }

    public Hploc(Zphi zphi) {
        this.z = zphi.z;
        this.phi = zphi.phi;
        this.have_sth = false;
    }

    public Hploc(Pointing ptg) throws Exception {
        HealpixUtils.check(ptg.theta >= 0.0 && ptg.theta <= Math.PI, "invalid theta value");
        this.z = FastMath.cos(ptg.theta);
        this.phi = ptg.phi;
        if (Math.abs(this.z) > 0.99) {
            this.sth = FastMath.sin(ptg.theta);
            this.have_sth = true;
        }
    }

    public Zphi toZphi() {
        return new Zphi(this.z, this.phi);
    }

    public Pointing toPointing() {
        double st = this.have_sth ? this.sth : Math.sqrt((1.0 - this.z) * (1.0 + this.z));
        return new Pointing(FastMath.atan2(st, this.z), this.phi);
    }

    public Vec3 toVec3() {
        double st = this.have_sth ? this.sth : Math.sqrt((1.0 - this.z) * (1.0 + this.z));
        return new Vec3(st * FastMath.cos(this.phi), st * FastMath.sin(this.phi), this.z);
    }
}

