/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.HealpixBase;
import healpix.essentials.Pointing;
import healpix.essentials.RangeSet;
import healpix.essentials.Scheme;
import healpix.essentials.Vec3;

public abstract class HealpixProc
extends HealpixBase {
    static final HealpixBase[] bn = new HealpixBase[30];
    static final HealpixBase[] br = new HealpixBase[30];
    static final double[] mpr = new double[30];
    static final double[] cmpr = new double[30];
    static final double[] smpr = new double[30];

    private HealpixProc() {
    }

    public static double maxPixrad(int order) {
        return bn[order].maxPixrad();
    }

    public static long ang2pixNest(int order, Pointing ptg) throws Exception {
        return bn[order].ang2pix(ptg);
    }

    public static long ang2pixRing(int order, Pointing ptg) throws Exception {
        return br[order].ang2pix(ptg);
    }

    public static Pointing pix2angNest(int order, long pix) throws Exception {
        return bn[order].pix2ang(pix);
    }

    public static Pointing pix2angRing(int order, long pix) throws Exception {
        return br[order].pix2ang(pix);
    }

    public static long vec2pixNest(int order, Vec3 vec) throws Exception {
        return bn[order].vec2pix(vec);
    }

    public static long vec2pixRing(int order, Vec3 vec) throws Exception {
        return br[order].vec2pix(vec);
    }

    public static Vec3 pix2vecNest(int order, long pix) throws Exception {
        return bn[order].pix2vec(pix);
    }

    public static Vec3 pix2vecRing(int order, long pix) throws Exception {
        return br[order].pix2vec(pix);
    }

    public static long ring2nest(int order, long pix) throws Exception {
        return bn[order].ring2nest(pix);
    }

    public static long nest2ring(int order, long pix) throws Exception {
        return bn[order].nest2ring(pix);
    }

    public static long[] neighboursNest(int order, long pix) throws Exception {
        return bn[order].neighbours(pix);
    }

    public static long[] neighboursRing(int order, long pix) throws Exception {
        return br[order].neighbours(pix);
    }

    public static Vec3[] boundariesNest(int order, long pix, int step) throws Exception {
        return bn[order].boundaries(pix, step);
    }

    public static Vec3[] boundariesRing(int order, long pix, int step) throws Exception {
        return br[order].boundaries(pix, step);
    }

    public static RangeSet queryDiscNest(int order, Pointing ptg, double radius) throws Exception {
        return bn[order].queryDisc(ptg, radius);
    }

    public static RangeSet queryDiscRing(int order, Pointing ptg, double radius) throws Exception {
        return br[order].queryDisc(ptg, radius);
    }

    public static RangeSet queryDiscInclusiveNest(int order, Pointing ptg, double radius, int fact) throws Exception {
        return bn[order].queryDiscInclusive(ptg, radius, fact);
    }

    public static RangeSet queryDiscInclusiveRing(int order, Pointing ptg, double radius, int fact) throws Exception {
        return br[order].queryDiscInclusive(ptg, radius, fact);
    }

    public static RangeSet queryPolygonNest(int order, Pointing[] vertex) throws Exception {
        return bn[order].queryPolygon(vertex);
    }

    public static RangeSet queryPolygonRing(int order, Pointing[] vertex) throws Exception {
        return br[order].queryPolygon(vertex);
    }

    public static RangeSet queryPolygonInclusiveNest(int order, Pointing[] vertex, int fact) throws Exception {
        return bn[order].queryPolygonInclusive(vertex, fact);
    }

    public static RangeSet queryPolygonInclusiveRing(int order, Pointing[] vertex, int fact) throws Exception {
        return br[order].queryPolygonInclusive(vertex, fact);
    }

    public static RangeSet queryStripNest(int order, double theta1, double theta2, boolean inclusive) throws Exception {
        return bn[order].queryStrip(theta1, theta2, inclusive);
    }

    public static RangeSet queryStripRing(int order, double theta1, double theta2, boolean inclusive) throws Exception {
        return br[order].queryStrip(theta1, theta2, inclusive);
    }

    static {
        try {
            for (int i = 0; i <= 29; ++i) {
                HealpixProc.bn[i] = new HealpixBase(1L << i, Scheme.NESTED);
                HealpixProc.br[i] = new HealpixBase(1L << i, Scheme.RING);
                HealpixProc.mpr[i] = bn[i].maxPixrad();
                HealpixProc.cmpr[i] = FastMath.cos(mpr[i]);
                HealpixProc.smpr[i] = FastMath.sin(mpr[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

