/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.security.Provider;
import java.security.Security;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public abstract class GSSManager {
    public static synchronized GSSManager getInstance() {
        String string = Security.getProperty("org.ietf.jgss.GSSManager");
        if (string == null) {
            string = "gnu.crypto.gssapi.GSSManagerImpl";
        }
        try {
            ClassLoader classLoader = GSSManager.class.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Class<?> clazz = classLoader.loadClass(string);
            return (GSSManager)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public abstract void addProviderAtEnd(Provider var1, Oid var2) throws GSSException;

    public abstract void addProviderAtFront(Provider var1, Oid var2) throws GSSException;

    public abstract GSSContext createContext(byte[] var1) throws GSSException;

    public abstract GSSContext createContext(GSSCredential var1) throws GSSException;

    public abstract GSSContext createContext(GSSName var1, Oid var2, GSSCredential var3, int var4) throws GSSException;

    public abstract GSSCredential createCredential(int var1) throws GSSException;

    public abstract GSSCredential createCredential(GSSName var1, int var2, Oid var3, int var4) throws GSSException;

    public abstract GSSCredential createCredential(GSSName var1, int var2, Oid[] var3, int var4) throws GSSException;

    public abstract GSSName createName(byte[] var1, Oid var2) throws GSSException;

    public abstract GSSName createName(byte[] var1, Oid var2, Oid var3) throws GSSException;

    public abstract GSSName createName(String var1, Oid var2) throws GSSException;

    public abstract GSSName createName(String var1, Oid var2, Oid var3) throws GSSException;

    public abstract Oid[] getMechs();

    public abstract Oid[] getMechsForName(Oid var1);

    public abstract Oid[] getNamesForMech(Oid var1) throws GSSException;
}

