/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class GSSException
extends Exception {
    private static final long serialVersionUID = -2706218945227726672L;
    public static final int BAD_BINDINGS = 1;
    public static final int BAD_MECH = 2;
    public static final int BAD_NAME = 3;
    public static final int BAD_NAMETYPE = 4;
    public static final int BAD_STATUS = 5;
    public static final int BAD_MIC = 6;
    public static final int CONTEXT_EXPIRED = 7;
    public static final int CREDENTIALS_EXPIRED = 8;
    public static final int DEFECTIVE_CREDENTIAL = 9;
    public static final int DEFECTIVE_TOKEN = 10;
    public static final int FAILURE = 11;
    public static final int NO_CONTEXT = 12;
    public static final int NO_CRED = 13;
    public static final int BAD_QOP = 14;
    public static final int UNAUTHORIZED = 15;
    public static final int UNAVAILABLE = 16;
    public static final int DUPLICATE_ELEMENT = 17;
    public static final int NAME_NOT_MN = 18;
    public static final int DUPLICATE_TOKEN = 19;
    public static final int OLD_TOKEN = 20;
    public static final int UNSEQ_TOKEN = 21;
    public static final int GAP_TOKEN = 22;
    private final int major;
    private int minor;
    private String minorString;
    private ResourceBundle messages;

    public GSSException(int n) {
        this(n, 0, null);
    }

    public GSSException(int n, int n2, String string) {
        this.major = n;
        this.minor = n2;
        this.minorString = string;
        try {
            this.messages = PropertyResourceBundle.getBundle("org/ietf/jgss/MessagesBundle");
        }
        catch (Exception exception) {
            this.messages = null;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getMajorString() {
        switch (this.major) {
            case 2: {
                return this.getMsg("GSSException.BAD_MECH", "An unsupported mechanism was requested.");
            }
            case 3: {
                return this.getMsg("GSSException.BAD_NAME", "An invalid name was supplied.");
            }
            case 4: {
                return this.getMsg("GSSException.BAD_NAMETYPE", "A supplied name was of an unsupported type.");
            }
            case 1: {
                return this.getMsg("GSSException.BAD_BINDINGS", "Incorrect channel bindings were supplied.");
            }
            case 5: {
                return this.getMsg("GSSException.BAD_STATUS", "An invalid status code was supplied.");
            }
            case 6: {
                return this.getMsg("GSSException.BAD_MIC", "A token had an invalid MIC.");
            }
            case 13: {
                return this.getMsg("GSSException.NO_CRED", "No credentials were supplied, or the credentials were unavailable or inaccessible.");
            }
            case 12: {
                return this.getMsg("GSSException.NO_CONTEXT", "Invalid context has been supplied.");
            }
            case 10: {
                return this.getMsg("GSSException.DEFECTIVE_TOKEN", "A supplied token was invalid.");
            }
            case 9: {
                return this.getMsg("GSSException.DEFECTIVE_CREDENTIAL", "A supplied credential was invalid.");
            }
            case 8: {
                return this.getMsg("GSSException.CREDENTIALS_EXPIRED", "The referenced credentials have expired.");
            }
            case 7: {
                return this.getMsg("GSSException.CONTEXT_EXPIRED", "The context has expired.");
            }
            case 11: {
                return this.getMsg("GSSException.FAILURE", "Miscellaneous failure.");
            }
            case 14: {
                return this.getMsg("GSSException.BAD_QOP", "The quality-of-protection requested could not be provided.");
            }
            case 15: {
                return this.getMsg("GSSException.UNAUTHORIZED", "The operation is forbidden by local security policy.");
            }
            case 16: {
                return this.getMsg("GSSException.UNAVAILABLE", "The operation or option is unavailable.");
            }
            case 17: {
                return this.getMsg("GSSException.DUPLICATE_ELEMENT", "The requested credential element already exists.");
            }
            case 18: {
                return this.getMsg("GSSException.NAME_NOT_MN", "The provided name was not a mechanism name.");
            }
            case 20: {
                return this.getMsg("GSSException.OLD_TOKEN", "The token's validity period has expired.");
            }
            case 19: {
                return this.getMsg("GSSException.DUPLICATE_TOKEN", "The token was a duplicate of an earlier version.");
            }
            case 21: {
                return this.getMsg("GSSException.UNSEQ_TOKEN", "A later token has already been processed.");
            }
            case 22: {
                return this.getMsg("GSSException.GAP_TOKEN", "An expected per-message token was not received.");
            }
        }
        return "Unknown or invalid error code.";
    }

    public String getMinorString() {
        return this.minorString;
    }

    public void setMinor(int n, String string) {
        this.minor = n;
        this.minorString = string;
    }

    public String toString() {
        return GSSException.class.getName() + ": " + this.getMessage();
    }

    public String getMessage() {
        if (this.minor == 0) {
            return this.getMajorString();
        }
        return this.getMajorString() + " (" + this.minorString + ")";
    }

    private String getMsg(String string, String string2) {
        if (this.messages != null) {
            try {
                return this.messages.getString(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }
}

