/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import gnu.java.lang.CPStringBuilder;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    private static final long serialVersionUID = 975798773772956428L;
    private SourceLocator locator;
    private Throwable containedException;

    public TransformerException(String string) {
        this(string, null, null);
    }

    public TransformerException(Throwable throwable) {
        this(throwable.getMessage(), null, throwable);
    }

    public TransformerException(String string, Throwable throwable) {
        this(string, null, throwable);
    }

    public TransformerException(String string, SourceLocator sourceLocator) {
        this(string, sourceLocator, null);
    }

    public TransformerException(String string, SourceLocator sourceLocator, Throwable throwable) {
        super(string);
        this.locator = sourceLocator;
        if (throwable != null) {
            this.initCause(throwable);
            this.containedException = throwable;
        }
    }

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public Throwable getCause() {
        return this.containedException;
    }

    public Throwable initCause(Throwable throwable) {
        if (this.containedException != null) {
            throw new IllegalStateException();
        }
        if (throwable == this) {
            throw new IllegalArgumentException();
        }
        this.containedException = throwable;
        return this;
    }

    public String getMessageAndLocation() {
        return this.locator == null ? this.getMessage() : this.getMessage() + ": " + this.getLocationAsString();
    }

    public String getLocationAsString() {
        if (this.locator == null) {
            return null;
        }
        String string = this.locator.getPublicId();
        String string2 = this.locator.getSystemId();
        int n = this.locator.getLineNumber();
        int n2 = this.locator.getColumnNumber();
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        if (string != null) {
            cPStringBuilder.append("publicId=");
            cPStringBuilder.append(string);
        }
        if (string2 != null) {
            if (cPStringBuilder.length() > 0) {
                cPStringBuilder.append(' ');
            }
            cPStringBuilder.append("systemId=");
            cPStringBuilder.append(string2);
        }
        if (n != -1) {
            if (cPStringBuilder.length() > 0) {
                cPStringBuilder.append(' ');
            }
            cPStringBuilder.append("lineNumber=");
            cPStringBuilder.append(n);
        }
        if (n2 != -1) {
            if (cPStringBuilder.length() > 0) {
                cPStringBuilder.append(' ');
            }
            cPStringBuilder.append("columnNumber=");
            cPStringBuilder.append(n2);
        }
        return cPStringBuilder.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.containedException != null) {
            printStream.print("caused by ");
            this.containedException.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.containedException != null) {
            printWriter.print("caused by ");
            this.containedException.printStackTrace(printWriter);
        }
    }
}

