/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import gnu.xml.stream.XMLOutputFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;

public abstract class XMLOutputFactory {
    public static final String IS_REPAIRING_NAMESPACES = "javax.xml.stream.isRepairingNamespaces";

    protected XMLOutputFactory() {
    }

    public static XMLOutputFactory newInstance() throws FactoryConfigurationError {
        return XMLOutputFactory.newInstance(null, null);
    }

    public static XMLOutputFactory newInstance(String string, ClassLoader classLoader) throws FactoryConfigurationError {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = XMLOutputFactory.class.getClassLoader();
        }
        String string2 = null;
        int n = 0;
        do {
            if ((string2 = XMLOutputFactory.getFactoryClassName(classLoader, n++)) == null) continue;
            try {
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                return (XMLOutputFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                string2 = null;
            }
            catch (Exception exception) {
                throw new FactoryConfigurationError(exception, "error instantiating class " + string2);
            }
        } while (string2 == null && n < 3);
        return new XMLOutputFactoryImpl();
    }

    private static String getFactoryClassName(ClassLoader classLoader, int n) {
        switch (n) {
            case 0: {
                return System.getProperty("javax.xml.stream.XMLOutputFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "stax.properties");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    return properties.getProperty("javax.xml.stream.XMLOutputFactory");
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    String string = "/META-INF/services/javax.xml.stream.XMLOutputFactory";
                    InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : XMLOutputFactory.class.getResourceAsStream(string);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string2 = bufferedReader.readLine();
                        bufferedReader.close();
                        return string2;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public abstract XMLStreamWriter createXMLStreamWriter(Writer var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1, String var2) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(Result var1) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(Result var1) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(OutputStream var1) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(OutputStream var1, String var2) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(Writer var1) throws XMLStreamException;

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPropertySupported(String var1);
}

