/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.java.util.EmptyEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultMutableTreeNode
implements Cloneable,
MutableTreeNode,
Serializable {
    private static final long serialVersionUID = -4298474751201349152L;
    public static final Enumeration<TreeNode> EMPTY_ENUMERATION = new EmptyEnumeration<TreeNode>();
    protected MutableTreeNode parent;
    protected Vector<MutableTreeNode> children = new Vector();
    protected transient Object userObject;
    protected boolean allowsChildren;

    public DefaultMutableTreeNode() {
        this(null, true);
    }

    public DefaultMutableTreeNode(Object object) {
        this(object, true);
    }

    public DefaultMutableTreeNode(Object object, boolean bl) {
        this.userObject = object;
        this.allowsChildren = bl;
    }

    public Object clone() {
        return new DefaultMutableTreeNode(this.userObject, this.allowsChildren);
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public void add(MutableTreeNode mutableTreeNode) {
        if (!this.allowsChildren) {
            throw new IllegalStateException();
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException();
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("Cannot add ancestor node.");
        }
        this.children.add(mutableTreeNode);
        mutableTreeNode.setParent(this);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void remove(int n) {
        MutableTreeNode mutableTreeNode = this.children.remove(n);
        mutableTreeNode.setParent(null);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        if (mutableTreeNode.getParent() != this) {
            throw new IllegalArgumentException("The given 'node' is not a child of this node.");
        }
        this.children.remove(mutableTreeNode);
        mutableTreeNode.setParent(null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (!this.allowsChildren) {
            throw new IllegalStateException();
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("Cannot insert ancestor node.");
        }
        this.children.insertElementAt(mutableTreeNode, n);
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public Enumeration children() {
        if (this.children.size() == 0) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    public TreeNode getChildAt(int n) {
        return this.children.elementAt(n);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        return this.children.indexOf(treeNode);
    }

    public void setAllowsChildren(boolean bl) {
        if (!bl) {
            this.removeAllChildren();
        }
        this.allowsChildren = bl;
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        TreeNode treeNode2;
        if (treeNode == null) {
            return false;
        }
        for (treeNode2 = this; treeNode2 != null && treeNode2 != treeNode; treeNode2 = treeNode2.getParent()) {
        }
        return treeNode2 == treeNode;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode;
        if (defaultMutableTreeNode == null) {
            return false;
        }
        for (treeNode = defaultMutableTreeNode; treeNode != null && treeNode != this; treeNode = treeNode.getParent()) {
        }
        return treeNode == this;
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode;
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            arrayList.add((DefaultMutableTreeNode)treeNode);
        }
        for (treeNode = defaultMutableTreeNode; treeNode != null; treeNode = treeNode.getParent()) {
            if (!arrayList.contains(treeNode)) continue;
            return treeNode;
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return false;
        }
        return defaultMutableTreeNode.getRoot() == this.getRoot();
    }

    public int getDepth() {
        if (!this.allowsChildren || this.children.size() == 0) {
            return 0;
        }
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(new Integer(0));
        TreeNode treeNode = this.getChildAt(0);
        int n = 0;
        int n2 = 1;
        while (!stack.empty()) {
            int n3;
            int n4;
            if (treeNode.getChildCount() != 0) {
                treeNode = treeNode.getChildAt(0);
                stack.push(new Integer(0));
                ++n2;
                continue;
            }
            if (n2 > n) {
                n = n2;
            }
            do {
                treeNode = treeNode.getParent();
                n3 = treeNode.getChildCount();
                n4 = (Integer)stack.pop() + 1;
                --n2;
            } while (n4 >= n3 && treeNode != this);
            if (n4 >= n3) continue;
            treeNode = treeNode.getChildAt(n4);
            stack.push(new Integer(n4));
            ++n2;
        }
        return n;
    }

    public int getLevel() {
        int n = -1;
        TreeNode treeNode = this;
        do {
            treeNode = treeNode.getParent();
            ++n;
        } while (treeNode != null);
        return n;
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
        if (treeNode == null) {
            if (n == 0) {
                return null;
            }
            return new TreeNode[n];
        }
        TreeNode[] treeNodeArray = this.getPathToRoot(treeNode.getParent(), n + 1);
        treeNodeArray[treeNodeArray.length - n - 1] = treeNode;
        return treeNodeArray;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] treeNodeArray = this.getPathToRoot(this, 0);
        Object[] objectArray = new Object[treeNodeArray.length];
        for (int i = 0; i < treeNodeArray.length; ++i) {
            objectArray[i] = ((DefaultMutableTreeNode)treeNodeArray[i]).getUserObject();
        }
        return objectArray;
    }

    public TreeNode getRoot() {
        TreeNode treeNode = this;
        TreeNode treeNode2 = treeNode.getParent();
        while (treeNode2 != null) {
            treeNode = treeNode2;
            treeNode2 = treeNode.getParent();
        }
        return treeNode;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public DefaultMutableTreeNode getNextNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.getChildCount() != 0) {
            return (DefaultMutableTreeNode)this.getChildAt(0);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this;
        do {
            defaultMutableTreeNode = defaultMutableTreeNode2.getNextSibling();
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
        } while (defaultMutableTreeNode == null && defaultMutableTreeNode2 != null);
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getPreviousNode() {
        if (this.parent == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.getPreviousSibling();
        if (defaultMutableTreeNode == null) {
            return (DefaultMutableTreeNode)this.parent;
        }
        if (defaultMutableTreeNode.getChildCount() != 0) {
            return defaultMutableTreeNode.getLastLeaf();
        }
        return defaultMutableTreeNode;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode treeNode) {
        TreeNode treeNode2;
        if (treeNode == null) {
            throw new IllegalArgumentException();
        }
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        vector.add(this);
        for (treeNode2 = this; treeNode2 != treeNode && treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            vector.add(0, (DefaultMutableTreeNode)treeNode2);
        }
        if (treeNode2 != treeNode) {
            throw new IllegalArgumentException();
        }
        return vector.elements();
    }

    public boolean isNodeChild(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        return treeNode.getParent() == this;
    }

    public TreeNode getFirstChild() {
        return this.children.firstElement();
    }

    public TreeNode getLastChild() {
        return this.children.lastElement();
    }

    public TreeNode getChildAfter(TreeNode treeNode) {
        if (treeNode == null || treeNode.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int n = this.getIndex(treeNode) + 1;
        if (n == this.getChildCount()) {
            return null;
        }
        return this.getChildAt(n);
    }

    public TreeNode getChildBefore(TreeNode treeNode) {
        if (treeNode == null || treeNode.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int n = this.getIndex(treeNode) - 1;
        if (n < 0) {
            return null;
        }
        return this.getChildAt(n);
    }

    public boolean isNodeSibling(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        if (treeNode == this) {
            return true;
        }
        return treeNode.getParent() == this.getParent() && this.getParent() != null;
    }

    public int getSiblingCount() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.getChildCount();
    }

    public DefaultMutableTreeNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        int n = this.parent.getIndex(this) + 1;
        if (n == this.parent.getChildCount()) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(n);
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        int n = this.parent.getIndex(this) - 1;
        if (n < 0) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(n);
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        TreeNode treeNode = this;
        while (treeNode.getChildCount() > 0) {
            treeNode = treeNode.getChildAt(0);
        }
        return treeNode;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        TreeNode treeNode = this;
        int n = treeNode.getChildCount();
        while (n > 0) {
            treeNode = treeNode.getChildAt(n - 1);
            n = treeNode.getChildCount();
        }
        return treeNode;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNextSibling();
        if (defaultMutableTreeNode != null) {
            return defaultMutableTreeNode.getFirstLeaf();
        }
        if (this.parent != null) {
            return ((DefaultMutableTreeNode)this.parent).getNextLeaf();
        }
        return null;
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getPreviousSibling();
        if (defaultMutableTreeNode != null) {
            return defaultMutableTreeNode.getLastLeaf();
        }
        if (this.parent != null) {
            return ((DefaultMutableTreeNode)this.parent).getPreviousLeaf();
        }
        return null;
    }

    public int getLeafCount() {
        int n = 0;
        Enumeration enumeration = this.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            if (!treeNode.isLeaf()) continue;
            ++n;
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PostorderEnumeration
    implements Enumeration<TreeNode> {
        Stack<TreeNode> nodes = new Stack();
        Stack<Enumeration<TreeNode>> childrenEnums = new Stack();

        PostorderEnumeration(TreeNode treeNode) {
            this.nodes.push(treeNode);
            this.childrenEnums.push(treeNode.children());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.nodes.isEmpty();
        }

        @Override
        public TreeNode nextElement() {
            if (this.nodes.isEmpty()) {
                throw new NoSuchElementException("No more elements left!");
            }
            Enumeration<TreeNode> enumeration = this.childrenEnums.peek();
            return this.traverse(enumeration);
        }

        private TreeNode traverse(Enumeration<TreeNode> enumeration) {
            if (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                this.nodes.push(treeNode);
                Enumeration enumeration2 = treeNode.children();
                this.childrenEnums.push(enumeration2);
                return this.traverse(enumeration2);
            }
            this.childrenEnums.pop();
            TreeNode treeNode = this.nodes.peek();
            this.nodes.pop();
            return treeNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PreorderEnumeration
    implements Enumeration<TreeNode> {
        TreeNode next;
        Stack<Enumeration<TreeNode>> childrenEnums = new Stack();

        PreorderEnumeration(TreeNode treeNode) {
            this.next = treeNode;
            this.childrenEnums.push(treeNode.children());
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public TreeNode nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException("No more elements left.");
            }
            TreeNode treeNode = this.next;
            Enumeration<TreeNode> enumeration = this.childrenEnums.peek();
            this.next = this.traverse(enumeration);
            return treeNode;
        }

        private TreeNode traverse(Enumeration<TreeNode> enumeration) {
            if (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                this.childrenEnums.push(treeNode.children());
                return treeNode;
            }
            this.childrenEnums.pop();
            if (this.childrenEnums.isEmpty()) {
                return null;
            }
            return this.traverse(this.childrenEnums.peek());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BreadthFirstEnumeration
    implements Enumeration<TreeNode> {
        LinkedList<TreeNode> queue = new LinkedList();

        BreadthFirstEnumeration(TreeNode treeNode) {
            this.queue.add(treeNode);
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty();
        }

        @Override
        public TreeNode nextElement() {
            if (this.queue.isEmpty()) {
                throw new NoSuchElementException("No more elements left.");
            }
            TreeNode treeNode = this.queue.removeFirst();
            Enumeration enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                this.queue.add((TreeNode)enumeration.nextElement());
            }
            return treeNode;
        }
    }
}

