/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayoutCache
implements RowMapper {
    protected NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected boolean rootVisible;
    protected int rowHeight;

    public void setNodeDimensions(NodeDimensions nodeDimensions) {
        this.nodeDimensions = nodeDimensions;
    }

    public NodeDimensions getNodeDimensions() {
        return this.nodeDimensions;
    }

    protected Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
        Rectangle rectangle2 = null;
        if (this.nodeDimensions != null) {
            rectangle2 = this.nodeDimensions.getNodeDimensions(object, n, n2, bl, rectangle);
        }
        return rectangle2;
    }

    public void setModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setRootVisible(boolean bl) {
        this.rootVisible = bl;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
        this.invalidateSizes();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(null);
        }
        this.treeSelectionModel = treeSelectionModel;
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(this);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public int getPreferredHeight() {
        int n = 0;
        int n2 = this.getRowCount();
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < n2; ++i) {
            TreePath treePath = this.getPathForRow(i);
            n += this.getBounds((TreePath)treePath, (Rectangle)rectangle).height;
        }
        return n;
    }

    public int getPreferredWidth(Rectangle rectangle) {
        int n = 0;
        Rectangle rectangle2 = new Rectangle();
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            TreePath treePath = this.getPathForRow(i);
            rectangle2.setBounds(0, 0, 0, 0);
            rectangle2 = this.getBounds(treePath, rectangle2);
            if (rectangle2.x + rectangle2.width > n) {
                n = rectangle2.x + rectangle2.width;
            }
            this.invalidatePathBounds(treePath);
        }
        return n;
    }

    public abstract boolean isExpanded(TreePath var1);

    public abstract Rectangle getBounds(TreePath var1, Rectangle var2);

    public abstract TreePath getPathForRow(int var1);

    public abstract int getRowForPath(TreePath var1);

    public abstract TreePath getPathClosestTo(int var1, int var2);

    public abstract Enumeration<TreePath> getVisiblePathsFrom(TreePath var1);

    public abstract int getVisibleChildCount(TreePath var1);

    public abstract void setExpandedState(TreePath var1, boolean var2);

    public abstract boolean getExpandedState(TreePath var1);

    public abstract int getRowCount();

    public abstract void invalidateSizes();

    public abstract void invalidatePathBounds(TreePath var1);

    public abstract void treeNodesChanged(TreeModelEvent var1);

    public abstract void treeNodesInserted(TreeModelEvent var1);

    public abstract void treeNodesRemoved(TreeModelEvent var1);

    public abstract void treeStructureChanged(TreeModelEvent var1);

    @Override
    public int[] getRowsForPaths(TreePath[] treePathArray) {
        int[] nArray = null;
        if (treePathArray != null) {
            nArray = new int[treePathArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.getRowForPath(treePathArray[i]);
            }
        }
        return nArray;
    }

    protected boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public static abstract class NodeDimensions {
        public abstract Rectangle getNodeDimensions(Object var1, int var2, int var3, boolean var4, Rectangle var5);
    }
}

