/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import gnu.javax.swing.text.html.parser.support.gnuStringIntMapper;
import java.io.Serializable;
import java.util.BitSet;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.ContentModel;
import javax.swing.text.html.parser.DTDConstants;

public final class Element
implements DTDConstants,
Serializable {
    static final gnuStringIntMapper mapper = new gnuStringIntMapper(){

        protected void create() {
            this.add("CDATA", 1);
            this.add("RCDATA", 16);
            this.add("EMPTY", 17);
            this.add("ANY", 19);
        }
    };
    private static final long serialVersionUID = -6717939384601675586L;
    public AttributeList atts;
    public BitSet exclusions;
    public BitSet inclusions;
    public ContentModel content;
    public Object data;
    public String name;
    public boolean oEnd;
    public boolean oStart;
    public int index;
    public int type;

    Element() {
    }

    public static int name2type(String string) {
        return mapper.get(string);
    }

    public AttributeList getAttribute(String string) {
        AttributeList attributeList = this.atts;
        while (attributeList != null && !string.equalsIgnoreCase(attributeList.name)) {
            attributeList = attributeList.next;
        }
        return attributeList;
    }

    public AttributeList getAttributeByValue(String string) {
        AttributeList attributeList = this.atts;
        if (string == null) {
            while (attributeList != null) {
                if (attributeList.value == null) {
                    return attributeList;
                }
                attributeList = attributeList.next;
            }
        } else {
            while (attributeList != null) {
                if (attributeList.value != null && string.equalsIgnoreCase(attributeList.value)) {
                    return attributeList;
                }
                attributeList = attributeList.next;
            }
        }
        return null;
    }

    public AttributeList getAttributes() {
        return this.atts;
    }

    public ContentModel getContent() {
        return this.content;
    }

    public boolean isEmpty() {
        return this.content == null || this.content.empty();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean omitEnd() {
        return this.oEnd;
    }

    public boolean omitStart() {
        return this.oStart;
    }

    public String toString() {
        return this.name;
    }
}

