/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.MultiAttributeSet;
import javax.swing.text.html.StyleSheet;

class ViewAttributeSet
extends MultiAttributeSet {
    private View view;
    private StyleSheet styleSheet;

    ViewAttributeSet(View view, StyleSheet styleSheet) {
        Object object;
        this.styleSheet = styleSheet;
        this.view = view;
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        Element element = view.getElement();
        AttributeSet attributeSet = element.getAttributes();
        AttributeSet attributeSet2 = this.styleSheet.translateHTMLToCSS(attributeSet);
        if (attributeSet2.getAttributeCount() > 0) {
            arrayList.add(attributeSet2);
        }
        if (element.isLeaf()) {
            object = attributeSet.getAttributeNames();
            while (object.hasMoreElements()) {
                Style style;
                Object e = object.nextElement();
                if (!(e instanceof HTML.Tag) || (style = this.styleSheet.getRule((HTML.Tag)e, element)) == null) continue;
                arrayList.add(style);
            }
        } else {
            object = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
            Style style = this.styleSheet.getRule((HTML.Tag)object, element);
            if (style != null) {
                arrayList.add(style);
            }
        }
        object = new AttributeSet[arrayList.size()];
        object = arrayList.toArray((T[])object);
        this.init((AttributeSet[])object);
    }

    public Object getAttribute(Object object) {
        AttributeSet attributeSet;
        CSS.Attribute attribute;
        Object object2 = super.getAttribute(object);
        if (object2 == null && object instanceof CSS.Attribute && (attribute = (CSS.Attribute)object).isInherited() && (attributeSet = this.getResolveParent()) != null) {
            object2 = attributeSet.getAttribute(attribute);
        }
        return object2;
    }

    public AttributeSet getResolveParent() {
        View view;
        AttributeSet attributeSet = null;
        if (this.view != null && (view = this.view.getParent()) != null) {
            attributeSet = view.getAttributes();
        }
        return attributeSet;
    }
}

