/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.Length;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

class TableView
extends BlockView
implements ViewFactory {
    private AttributeSet attributes;
    SizeRequirements[] columnRequirements;
    SizeRequirements totalColumnRequirements = new SizeRequirements();
    int[] columnOffsets;
    int[] columnSpans;
    Length[] columnWidths;
    int numColumns;
    private Length width;
    boolean gridValid = false;
    int cellSpacing;
    private Rectangle tmpRect = new Rectangle();

    public TableView(Element element) {
        super(element, 1);
    }

    public View create(Element element) {
        View view = null;
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        AttributeSet attributeSet2 = element.getParentElement().getAttributes();
        Object object2 = attributeSet2.getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.TR && object2 == HTML.Tag.TABLE) {
            view = new RowView(element);
        } else if ((object == HTML.Tag.TD || object == HTML.Tag.TH) && object2 == HTML.Tag.TR) {
            view = new CellView(element);
        } else if (object == HTML.Tag.CAPTION) {
            view = new ParagraphView(element);
        } else {
            ViewFactory viewFactory;
            View view2 = this.getParent();
            if (view2 != null && (viewFactory = view2.getViewFactory()) != null) {
                view = viewFactory.create(element);
            }
        }
        return view;
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.getStyleSheet().getViewAttributes(this);
        }
        return this.attributes;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        int n2;
        this.updateGrid();
        this.calculateColumnRequirements();
        sizeRequirements = super.calculateMinorAxisRequirements(n, sizeRequirements);
        if (this.width != null && sizeRequirements.minimum < (n2 = (int)this.width.getValue())) {
            sizeRequirements.minimum = n2;
        }
        n2 = (this.columnRequirements.length + 1) * this.cellSpacing;
        sizeRequirements.minimum += n2;
        sizeRequirements.preferred += n2;
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_ALIGN);
        sizeRequirements.alignment = 0.0f;
        if (object != null) {
            String string = object.toString();
            if (string.equals("left")) {
                sizeRequirements.alignment = 0.0f;
            } else if (string.equals("center")) {
                sizeRequirements.alignment = 0.5f;
            } else if (string.equals("right")) {
                sizeRequirements.alignment = 1.0f;
            }
        }
        sizeRequirements.maximum = sizeRequirements.preferred;
        return sizeRequirements;
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            if (!(view instanceof RowView)) continue;
            ((RowView)view).layoutChanged(n2);
        }
        this.layoutColumns(n);
        super.layoutMinorAxis(n, n2, nArray, nArray2);
    }

    private void calculateColumnRequirements() {
        int n;
        int n2 = this.getViewCount();
        this.totalColumnRequirements.minimum = 0;
        this.totalColumnRequirements.preferred = 0;
        this.totalColumnRequirements.maximum = 0;
        for (n = 0; n < n2; ++n) {
            int n3;
            View view = this.getView(n);
            int n4 = view instanceof RowView ? ((RowView)view).getViewCount() : 0;
            SizeRequirements sizeRequirements = new SizeRequirements();
            SizeRequirements sizeRequirements2 = new SizeRequirements();
            float f = 0.0f;
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                View view2 = view.getView(n3);
                if (!(view2 instanceof CellView)) continue;
                CellView cellView = (CellView)view2;
                int n6 = cellView.colSpan;
                if (n6 > 1) {
                    int n7;
                    int n8 = (int)cellView.getMinimumSpan(0);
                    int n9 = (int)cellView.getPreferredSpan(0);
                    int n10 = (int)cellView.getMaximumSpan(0);
                    int n11 = 0;
                    int n12 = 0;
                    long l = 0L;
                    for (n7 = 0; n7 < n6; ++n7) {
                        SizeRequirements sizeRequirements3 = this.columnRequirements[n5];
                        n11 += sizeRequirements3.minimum;
                        n12 += sizeRequirements3.preferred;
                        l += (long)sizeRequirements3.maximum;
                    }
                    n7 = n8 - n11;
                    int n13 = n9 - n12;
                    int n14 = (int)((long)n10 - l);
                    for (int i = 0; i < n6; ++i) {
                        SizeRequirements sizeRequirements4 = this.columnRequirements[n5];
                        if (n7 > 0) {
                            sizeRequirements4.minimum += n7 / n6;
                        }
                        if (n13 > 0) {
                            sizeRequirements4.preferred += n13 / n6;
                        }
                        if (n14 > 0) {
                            sizeRequirements4.maximum += n14 / n6;
                        }
                        if (this.columnWidths[n5] == null || !this.columnWidths[n5].isPercentage()) {
                            sizeRequirements.minimum += sizeRequirements4.minimum;
                            sizeRequirements.preferred += sizeRequirements4.preferred;
                            sizeRequirements.maximum += sizeRequirements4.maximum;
                            continue;
                        }
                        sizeRequirements2.minimum = Math.max(sizeRequirements2.minimum, (int)((float)sizeRequirements4.minimum * this.columnWidths[n5].getValue()));
                        sizeRequirements2.preferred = Math.max(sizeRequirements2.preferred, (int)((float)sizeRequirements4.preferred * this.columnWidths[n5].getValue()));
                        sizeRequirements2.maximum = Math.max(sizeRequirements2.maximum, (int)((float)sizeRequirements4.maximum * this.columnWidths[n5].getValue()));
                        f += this.columnWidths[n5].getValue();
                    }
                    n5 += n6;
                    continue;
                }
                SizeRequirements sizeRequirements5 = this.columnRequirements[n5];
                sizeRequirements5.minimum = Math.max(sizeRequirements5.minimum, (int)cellView.getMinimumSpan(0));
                sizeRequirements5.preferred = Math.max(sizeRequirements5.preferred, (int)cellView.getPreferredSpan(0));
                sizeRequirements5.maximum = Math.max(sizeRequirements5.maximum, (int)cellView.getMaximumSpan(0));
                if (this.columnWidths[n5] == null || !this.columnWidths[n5].isPercentage()) {
                    sizeRequirements.minimum += this.columnRequirements[n5].minimum;
                    sizeRequirements.preferred += this.columnRequirements[n5].preferred;
                    sizeRequirements.maximum += this.columnRequirements[n5].maximum;
                } else {
                    sizeRequirements2.minimum = Math.max(sizeRequirements2.minimum, (int)((float)sizeRequirements5.minimum / this.columnWidths[n3].getValue()));
                    sizeRequirements2.preferred = Math.max(sizeRequirements2.preferred, (int)((float)sizeRequirements5.preferred / this.columnWidths[n3].getValue()));
                    sizeRequirements2.maximum = Math.max(sizeRequirements2.maximum, (int)((float)sizeRequirements5.maximum / this.columnWidths[n3].getValue()));
                    f += this.columnWidths[n3].getValue();
                }
                ++n5;
            }
            sizeRequirements.minimum = (int)((float)sizeRequirements.minimum * (1.0f / (1.0f - f)));
            sizeRequirements.preferred = (int)((float)sizeRequirements.preferred * (1.0f / (1.0f - f)));
            sizeRequirements.maximum = (int)((float)sizeRequirements.maximum * (1.0f / (1.0f - f)));
            n3 = Math.max(sizeRequirements.minimum, sizeRequirements2.minimum);
            int n15 = Math.max(sizeRequirements.preferred, sizeRequirements2.preferred);
            int n16 = Math.max(sizeRequirements.maximum, sizeRequirements2.maximum);
            this.totalColumnRequirements.minimum = Math.max(this.totalColumnRequirements.minimum, n3);
            this.totalColumnRequirements.preferred = Math.max(this.totalColumnRequirements.preferred, n15);
            this.totalColumnRequirements.maximum = Math.max(this.totalColumnRequirements.maximum, n16);
        }
        n = this.columnRequirements.length;
        for (int i = 0; i < n; ++i) {
            if (this.columnWidths[i] == null) continue;
            this.columnRequirements[i].minimum = (int)this.columnWidths[i].getValue(this.totalColumnRequirements.minimum);
            this.columnRequirements[i].preferred = (int)this.columnWidths[i].getValue(this.totalColumnRequirements.preferred);
            this.columnRequirements[i].maximum = (int)this.columnWidths[i].getValue(this.totalColumnRequirements.maximum);
        }
    }

    private void layoutColumns(int n) {
        float f;
        long l = 0L;
        int n2 = this.columnRequirements.length;
        for (int i = 0; i < n2; ++i) {
            SizeRequirements sizeRequirements = this.columnRequirements[i];
            this.columnSpans[i] = this.columnWidths[i] != null ? (int)this.columnWidths[i].getValue(n) : sizeRequirements.preferred;
            l += (long)this.columnSpans[i];
        }
        long l2 = (long)(n - (n2 + 1) * this.cellSpacing) - l;
        float f2 = 0.0f;
        int[] nArray = null;
        if (l2 != 0L) {
            long l3 = 0L;
            nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                if (this.columnWidths[i] == null) {
                    int n3;
                    SizeRequirements sizeRequirements = this.columnRequirements[i];
                    if (l2 < 0L) {
                        n3 = sizeRequirements.minimum;
                        nArray[i] = this.columnSpans[i] - n3;
                    } else {
                        n3 = sizeRequirements.maximum;
                        nArray[i] = n3 - this.columnSpans[i];
                    }
                    l3 += (long)n3;
                    continue;
                }
                l3 += (long)this.columnSpans[i];
            }
            f = Math.abs(l3 - l);
            f2 = (float)l2 / f;
            f2 = Math.min(f2, 1.0f);
            f2 = Math.max(f2, -1.0f);
        }
        int n4 = this.cellSpacing;
        for (int i = 0; i < n2; ++i) {
            this.columnOffsets[i] = n4;
            if (l2 != 0L) {
                f = f2 * (float)nArray[i];
                int n5 = i;
                this.columnSpans[n5] = this.columnSpans[n5] + Math.round(f);
            }
            n4 = (int)Math.min((long)n4 + (long)this.columnSpans[i] + (long)this.cellSpacing, Integer.MAX_VALUE);
        }
    }

    void updateGrid() {
        if (!this.gridValid) {
            int n;
            int n2;
            AttributeSet attributeSet = this.getAttributes();
            StyleSheet styleSheet = this.getStyleSheet();
            float f = styleSheet.getEMBase(attributeSet);
            float f2 = styleSheet.getEXBase(attributeSet);
            int n3 = 0;
            int n4 = this.getViewCount();
            for (int i = 0; i < n4; ++i) {
                View view = this.getView(i);
                int n5 = 0;
                if (view instanceof RowView) {
                    int n6 = ((RowView)view).getViewCount();
                    for (n2 = 0; n2 < n6; ++n2) {
                        View view2 = view.getView(n2);
                        if (!(view2 instanceof CellView)) continue;
                        n5 += ((CellView)view2).colSpan;
                    }
                }
                n3 = Math.max(n5, n3);
            }
            this.numColumns = n3;
            this.columnWidths = new Length[n3];
            int[] nArray = new int[n3];
            for (n = 0; n < n4; ++n) {
                View view = this.getView(n);
                if (!(view instanceof RowView)) continue;
                RowView rowView = (RowView)view;
                rowView.rowIndex = n;
                rowView.overlap = new boolean[n3];
                n2 = 0;
                int n7 = rowView.getViewCount();
                int n8 = 0;
                while (n8 < n3) {
                    if (nArray[n8] > 0) {
                        int n9 = n8;
                        nArray[n9] = nArray[n9] - 1;
                        rowView.overlap[n8] = true;
                        ++n8;
                        continue;
                    }
                    if (n2 < n7) {
                        View view3 = rowView.getView(n2);
                        ++n2;
                        if (!(view3 instanceof CellView)) continue;
                        CellView cellView = (CellView)view3;
                        Object object = cellView.getAttributes().getAttribute(CSS.Attribute.WIDTH);
                        if (object != null && this.columnWidths[n8] == null && object instanceof Length) {
                            this.columnWidths[n8] = (Length)object;
                            this.columnWidths[n8].setFontBases(f, f2);
                        }
                        int n10 = cellView.rowSpan - 1;
                        for (int i = cellView.colSpan - 1; i >= 0; --i) {
                            nArray[n8] = n10;
                            ++n8;
                        }
                        continue;
                    }
                    ++n8;
                }
            }
            this.columnRequirements = new SizeRequirements[n3];
            for (n = 0; n < n3; ++n) {
                this.columnRequirements[n] = new SizeRequirements();
            }
            this.columnOffsets = new int[n3];
            this.columnSpans = new int[n3];
            this.gridValid = true;
        }
    }

    public float getMaximumSpan(int n) {
        float f = n == 0 ? super.getPreferredSpan(n) : super.getMaximumSpan(n);
        return f;
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        StyleSheet styleSheet = this.getStyleSheet();
        float f = styleSheet.getEMBase(attributeSet);
        float f2 = styleSheet.getEXBase(attributeSet);
        Object object = attributeSet.getAttribute(CSS.Attribute.BORDER_SPACING);
        if (object != null && object instanceof Length) {
            Length length = (Length)object;
            length.setFontBases(f, f2);
            this.cellSpacing = (int)length.getValue();
        }
        if ((object = attributeSet.getAttribute(CSS.Attribute.WIDTH)) != null && object instanceof Length) {
            this.width = (Length)object;
            this.width.setFontBases(f, f2);
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        sizeRequirements = super.calculateMajorAxisRequirements(n, sizeRequirements);
        int n2 = (this.getViewCount() + 1) * this.cellSpacing;
        sizeRequirements.minimum += n2;
        sizeRequirements.preferred += n2;
        sizeRequirements.maximum += n2;
        return sizeRequirements;
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3;
        int n4 = this.getViewCount();
        for (n3 = 0; n3 < n4; ++n3) {
            View view = this.getView(n3);
            if (!(view instanceof RowView)) continue;
            ((RowView)view).layoutChanged(n2);
        }
        n3 = (this.getViewCount() + 1) * this.cellSpacing;
        super.layoutMajorAxis(n - n3, n2, nArray, nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = i;
            nArray[n5] = nArray[n5] + (i + 1) * this.cellSpacing;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, this);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, this);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, this);
    }

    public void replace(int n, int n2, View[] viewArray) {
        this.gridValid = false;
        super.replace(n, n2, viewArray);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        int n = this.getViewCount();
        Rectangle rectangle2 = this.getInsideAllocation(shape);
        for (int i = 0; i < n; ++i) {
            this.tmpRect.setBounds(rectangle2);
            this.childAllocation(i, this.tmpRect);
            this.paintChild(graphics, this.tmpRect, i);
        }
    }

    class CellView
    extends BlockView {
        int colSpan;
        int rowSpan;

        CellView(Element element) {
            super(element, 1);
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            sizeRequirements = super.calculateMajorAxisRequirements(n, sizeRequirements);
            sizeRequirements.maximum = Integer.MAX_VALUE;
            return sizeRequirements;
        }

        protected void setPropertiesFromAttributes() {
            super.setPropertiesFromAttributes();
            this.colSpan = 1;
            AttributeSet attributeSet = this.getAttributes();
            Object object = attributeSet.getAttribute(HTML.Attribute.COLSPAN);
            if (object != null) {
                try {
                    this.colSpan = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.colSpan = 1;
                }
            }
            this.rowSpan = 1;
            object = attributeSet.getAttribute(HTML.Attribute.ROWSPAN);
            if (object != null) {
                try {
                    this.rowSpan = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.rowSpan = 1;
                }
            }
        }
    }

    class RowView
    extends BlockView {
        boolean[] overlap;
        int rowIndex;

        RowView(Element element) {
            super(element, 0);
        }

        public void replace(int n, int n2, View[] viewArray) {
            TableView.this.gridValid = false;
            super.replace(n, n2, viewArray);
        }

        public float getMaximumSpan(int n) {
            float f = n == 1 ? super.getPreferredSpan(n) : 2.1474836E9f;
            return f;
        }

        public float getMinimumSpan(int n) {
            float f = n == 0 ? (float)TableView.this.totalColumnRequirements.minimum : super.getMinimumSpan(n);
            return f;
        }

        public float getPreferredSpan(int n) {
            float f = n == 0 ? (float)TableView.this.totalColumnRequirements.preferred : super.getPreferredSpan(n);
            return f;
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            if (sizeRequirements == null) {
                sizeRequirements = new SizeRequirements();
            }
            int n2 = (TableView.this.columnRequirements.length + 1) * TableView.this.cellSpacing;
            sizeRequirements.minimum = TableView.this.totalColumnRequirements.minimum + n2;
            sizeRequirements.preferred = TableView.this.totalColumnRequirements.preferred + n2;
            sizeRequirements.maximum = TableView.this.totalColumnRequirements.maximum + n2;
            sizeRequirements.alignment = 0.0f;
            return sizeRequirements;
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n, n2, nArray, nArray2);
            int n3 = this.getViewCount();
            for (int i = 0; i < n3; ++i) {
                View view = this.getView(i);
                if (!(view instanceof CellView)) continue;
                CellView cellView = (CellView)view;
                if (cellView.rowSpan <= 1) continue;
                for (int j = 1; j < cellView.rowSpan; ++j) {
                    int n4 = i;
                    nArray2[n4] = nArray2[n4] + TableView.this.getSpan(n2, this.rowIndex + j);
                    int n5 = i;
                    nArray2[n5] = nArray2[n5] + TableView.this.cellSpacing;
                }
            }
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            TableView.this.updateGrid();
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = 0;
            while (n5 < TableView.this.numColumns) {
                if (!this.overlap[n5] && n3 < n4) {
                    View view = this.getView(n3);
                    if (view instanceof CellView) {
                        CellView cellView = (CellView)view;
                        nArray[n3] = TableView.this.columnOffsets[n5];
                        nArray2[n3] = 0;
                        int n6 = 0;
                        while (n6 < cellView.colSpan) {
                            int n7 = n3;
                            nArray2[n7] = nArray2[n7] + TableView.this.columnSpans[n5];
                            if (n6 < cellView.colSpan - 1) {
                                int n8 = n3;
                                nArray2[n8] = nArray2[n8] + TableView.this.cellSpacing;
                            }
                            ++n6;
                            ++n5;
                        }
                    }
                    ++n3;
                    continue;
                }
                ++n5;
            }
        }
    }
}

