/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.Length;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class ParagraphView
extends javax.swing.text.ParagraphView {
    private AttributeSet attributes;
    private StyleSheet.BoxPainter painter;
    private Length cssWidth;
    private Length cssHeight;

    public ParagraphView(Element element) {
        super(element);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.getStyleSheet().getViewAttributes(this);
        }
        return this.attributes;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        this.attributes = this.getAttributes();
        if (this.attributes != null) {
            Object object;
            super.setPropertiesFromAttributes();
            Object object2 = this.attributes.getAttribute(CSS.Attribute.TEXT_ALIGN);
            if (object2 != null) {
                object = object2.toString();
                if (((String)object).equals("left")) {
                    this.setJustification(0);
                } else if (((String)object).equals("right")) {
                    this.setJustification(2);
                } else if (((String)object).equals("center")) {
                    this.setJustification(1);
                } else if (((String)object).equals("justify")) {
                    this.setJustification(3);
                }
            }
            this.painter = this.getStyleSheet().getBoxPainter(this.attributes);
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            object = this.getStyleSheet();
            float f = ((StyleSheet)object).getEMBase(this.attributes);
            float f2 = ((StyleSheet)object).getEXBase(this.attributes);
            this.cssWidth = (Length)this.attributes.getAttribute(CSS.Attribute.WIDTH);
            if (this.cssWidth != null) {
                this.cssWidth.setFontBases(f, f2);
            }
            this.cssHeight = (Length)this.attributes.getAttribute(CSS.Attribute.WIDTH);
            if (this.cssHeight != null) {
                this.cssHeight.setFontBases(f, f2);
            }
        }
    }

    protected StyleSheet getStyleSheet() {
        Document document = this.getDocument();
        StyleSheet styleSheet = null;
        if (document instanceof HTMLDocument) {
            styleSheet = ((HTMLDocument)document).getStyleSheet();
        }
        return styleSheet;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (!this.setCSSSpan(sizeRequirements = super.calculateMinorAxisRequirements(n, sizeRequirements), n)) {
            int n2 = n == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n2;
            sizeRequirements.preferred -= n2;
            sizeRequirements.maximum -= n2;
        }
        return sizeRequirements;
    }

    private boolean setCSSSpan(SizeRequirements sizeRequirements, int n) {
        boolean bl = false;
        if (n == 0) {
            if (this.cssWidth != null && !this.cssWidth.isPercentage()) {
                sizeRequirements.minimum = (int)this.cssWidth.getValue();
                sizeRequirements.preferred = (int)this.cssWidth.getValue();
                sizeRequirements.maximum = (int)this.cssWidth.getValue();
                bl = true;
            }
        } else if (this.cssHeight != null && !this.cssWidth.isPercentage()) {
            sizeRequirements.minimum = (int)this.cssHeight.getValue();
            sizeRequirements.preferred = (int)this.cssHeight.getValue();
            sizeRequirements.maximum = (int)this.cssHeight.getValue();
            bl = true;
        }
        return bl;
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public void paint(Graphics graphics, Shape shape) {
        if (shape != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        }
        super.paint(graphics, shape);
    }

    public float getPreferredSpan(int n) {
        float f = 0.0f;
        if (this.isVisible()) {
            f = super.getPreferredSpan(n);
        }
        return f;
    }

    public float getMinimumSpan(int n) {
        float f = 0.0f;
        if (this.isVisible()) {
            f = super.getMinimumSpan(n);
        }
        return f;
    }

    public float getMaximumSpan(int n) {
        float f = 0.0f;
        if (this.isVisible()) {
            f = super.getMaximumSpan(n);
        }
        return f;
    }
}

