/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.FontMetrics;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    private AttributeSet attributes;
    private float longestWord;
    private boolean nowrap;

    public InlineView(Element element) {
        super(element);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, viewFactory);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attributes = styleSheet.getViewAttributes(this);
        this.preferenceChanged(null, true, true);
        this.setPropertiesFromAttributes();
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attributes = styleSheet.getViewAttributes(this);
        }
        return this.attributes;
    }

    public int getBreakWeight(int n, float f, float f2) {
        int n2 = this.nowrap ? 0 : super.getBreakWeight(n, f, f2);
        return n2;
    }

    public View breakView(int n, int n2, float f, float f2) {
        return super.breakView(n, n2, f, f2);
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean bl = false;
        if (object != null && object.toString().contains("underline")) {
            bl = true;
        }
        this.setUnderline(bl);
        bl = false;
        if (object != null && object.toString().contains("line-through")) {
            bl = true;
        }
        this.setStrikeThrough(bl);
        object = attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        bl = false;
        if (object != null && object.toString().contains("sub")) {
            bl = true;
        }
        this.setSubscript(bl);
        bl = false;
        if (object != null && object.toString().contains("sup")) {
            bl = true;
        }
        this.setSuperscript(bl);
        object = attributeSet.getAttribute(CSS.Attribute.WHITE_SPACE);
        this.nowrap = object != null && object.equals("nowrap");
    }

    protected StyleSheet getStyleSheet() {
        Document document = this.getDocument();
        StyleSheet styleSheet = null;
        if (document instanceof HTMLDocument) {
            styleSheet = ((HTMLDocument)document).getStyleSheet();
        }
        return styleSheet;
    }

    public float getMinimumSpan(int n) {
        float f = super.getMinimumSpan(n);
        if (n == 0) {
            f = Math.max(this.getLongestWord(), f);
        }
        return f;
    }

    private float getLongestWord() {
        if (this.longestWord == -1.0f) {
            this.longestWord = this.calculateLongestWord();
        }
        return this.longestWord;
    }

    private float calculateLongestWord() {
        float f = 0.0f;
        try {
            Document document = this.getDocument();
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            Segment segment = new Segment();
            document.getText(n, n2 - n, segment);
            BreakIterator breakIterator = BreakIterator.getWordInstance();
            breakIterator.setText(segment);
            int n3 = n;
            int n4 = n;
            int n5 = breakIterator.first();
            int n6 = breakIterator.next();
            while (n6 != -1) {
                if (n6 - n5 > n4 - n3) {
                    n3 = n5;
                    n4 = n6;
                }
                n5 = n6;
                n6 = breakIterator.next();
            }
            if (n4 - n3 > 0) {
                FontMetrics fontMetrics = this.getFontMetrics();
                int n7 = segment.offset + n3 - segment.getBeginIndex();
                f = fontMetrics.charsWidth(segment.array, n7, n4 - n3);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return f;
    }
}

