/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.ImageViewIconFactory;
import gnu.javax.swing.text.html.css.Length;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class ImageView
extends View {
    boolean loadOnDemand = false;
    Image image;
    byte imageState = 1;
    private boolean reloadImage = true;
    private boolean reloadProperties = true;
    private boolean haveWidth;
    private boolean haveHeight;
    private boolean loading;
    private int width;
    private int height;
    private ImageObserver observer;
    Length[] spans = new Length[2];
    private AttributeSet attributes;

    public ImageView(Element element) {
        super(element);
        this.observer = new Observer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadImage() {
        this.loading = true;
        this.reloadImage = false;
        this.haveWidth = false;
        this.haveHeight = false;
        this.image = null;
        this.width = 0;
        this.height = 0;
        try {
            this.loadImage();
            this.updateSize();
            Object var2_1 = null;
            this.loading = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.loading = false;
            throw throwable;
        }
    }

    public float getAlignment(int n) {
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(HTML.Attribute.ALIGN);
        if (object == null) {
            return 0.0f;
        }
        String string = object.toString();
        if (n == 0) {
            if (string.equals("middle")) {
                return 0.5f;
            }
            if (string.equals("left")) {
                return 0.0f;
            }
            if (string.equals("right")) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (n == 1) {
            if (string.equals("middle")) {
                return 0.5f;
            }
            if (string.equals("top")) {
                return 0.0f;
            }
            if (string.equals("bottom")) {
                return 1.0f;
            }
            return 0.0f;
        }
        throw new IllegalArgumentException("axis " + n);
    }

    public String getAltText() {
        Object object = this.getAttributes().getAttribute(HTML.Attribute.ALT);
        if (object != null) {
            return object.toString();
        }
        URL uRL = this.getImageURL();
        if (uRL == null) {
            return "";
        }
        return uRL.getFile();
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.getStyleSheet().getViewAttributes(this);
        }
        return this.attributes;
    }

    public Image getImage() {
        this.updateState();
        return this.image;
    }

    public URL getImageURL() {
        Element element = this.getElement();
        String string = (String)element.getAttributes().getAttribute(HTML.Attribute.SRC);
        URL uRL = null;
        if (string != null) {
            URL uRL2 = ((HTMLDocument)this.getDocument()).getBase();
            try {
                uRL = new URL(uRL2, string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public Icon getLoadingImageIcon() {
        return ImageViewIconFactory.getLoadingImageIcon();
    }

    public boolean getLoadsSynchronously() {
        return this.loadOnDemand;
    }

    public Icon getNoImageIcon() {
        return ImageViewIconFactory.getNoImageIcon();
    }

    public float getPreferredSpan(int n) {
        Image image = this.getImage();
        if (n == 0) {
            if (this.spans[n] != null) {
                return this.spans[n].getValue();
            }
            if (image != null) {
                return image.getWidth(this.getContainer());
            }
            return this.getNoImageIcon().getIconWidth();
        }
        if (n == 1) {
            if (this.spans[n] != null) {
                return this.spans[n].getValue();
            }
            if (image != null) {
                return image.getHeight(this.getContainer());
            }
            return this.getNoImageIcon().getIconHeight();
        }
        throw new IllegalArgumentException("axis " + n);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        return this.getAltText();
    }

    public void paint(Graphics graphics, Shape shape) {
        this.updateState();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        Image image = this.getImage();
        if (image != null) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.observer);
        } else {
            Icon icon = this.getNoImageIcon();
            if (icon != null) {
                icon.paintIcon(this.getContainer(), graphics, rectangle.x, rectangle.y);
            }
        }
    }

    public void setLoadsSynchronously(boolean bl) {
        this.loadOnDemand = bl;
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        StyleSheet styleSheet = this.getStyleSheet();
        float f = styleSheet.getEMBase(attributeSet);
        float f2 = styleSheet.getEXBase(attributeSet);
        this.spans[0] = (Length)attributeSet.getAttribute(CSS.Attribute.WIDTH);
        if (this.spans[0] != null) {
            this.spans[0].setFontBases(f, f2);
        }
        this.spans[1] = (Length)attributeSet.getAttribute(CSS.Attribute.HEIGHT);
        if (this.spans[1] != null) {
            this.spans[1].setFontBases(f, f2);
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return this.getStartOffset();
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        return shape;
    }

    public void setSize(float f, float f2) {
        this.updateState();
    }

    private void updateState() {
        if (this.reloadImage) {
            this.reloadImage();
        }
        if (this.reloadProperties) {
            this.setPropertiesFromAttributes();
        }
    }

    private void loadImage() {
        URL uRL = this.getImageURL();
        Image image = null;
        if (uRL != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            image = toolkit.getImage(uRL);
            toolkit.prepareImage(image, -1, -1, this.observer);
            if (image != null && this.getLoadsSynchronously()) {
                MediaTracker mediaTracker = new MediaTracker(this.getContainer());
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
            }
        }
        this.image = image;
    }

    private void updateSize() {
        int n = 0;
        int n2 = 0;
        Image image = this.getImage();
        if (image != null) {
            Length length = this.spans[0];
            if (length != null) {
                n = (int)length.getValue();
                this.haveWidth = true;
            } else {
                n = image.getWidth(this.observer);
            }
            length = this.spans[1];
            if (length != null) {
                n2 = (int)length.getValue();
                this.haveHeight = true;
            } else {
                n = image.getWidth(this.observer);
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (this.haveWidth || this.haveHeight) {
                toolkit.prepareImage(image, this.width, this.height, this.observer);
            } else {
                toolkit.prepareImage(image, -1, -1, this.observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void safePreferenceChanged(final View view, final boolean bl, final boolean bl2) {
        block6: {
            block5: {
                if (!SwingUtilities.isEventDispatchThread()) break block5;
                Document document = this.getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                try {
                    this.preferenceChanged(view, bl, bl2);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readUnlock();
                    }
                    throw throwable;
                }
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                break block6;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImageView.this.safePreferenceChanged(view, bl, bl2);
                }
            });
        }
    }

    class Observer
    implements ImageObserver {
        Observer() {
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            boolean bl = false;
            if ((n & 1) != 0 && ImageView.this.spans[0] == null) {
                bl = true;
            }
            boolean bl2 = false;
            if ((n & 2) != 0 && ImageView.this.spans[1] == null) {
                bl2 = true;
            }
            if (bl || bl2) {
                ImageView.this.safePreferenceChanged(ImageView.this, bl, bl2);
            }
            boolean bl3 = (n & 0x20) != 0;
            return bl3;
        }
    }
}

