/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.classpath.NotImplementedException;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.Option;
import javax.swing.text.html.ResetablePlainDocument;
import javax.swing.text.html.ResetableToggleButtonModel;
import javax.swing.text.html.SelectComboBoxModel;
import javax.swing.text.html.SelectListModel;
import javax.swing.text.html.StyleSheet;

public class HTMLDocument
extends DefaultStyledDocument {
    public static final String AdditionalComments = "AdditionalComments";
    URL baseURL = null;
    boolean preservesUnknownTags = true;
    int tokenThreshold = Integer.MAX_VALUE;
    HTMLEditorKit.Parser parser;
    private boolean frameDocument;
    String baseTarget;

    public HTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleSheet());
    }

    public HTMLDocument(StyleSheet styleSheet) {
        this((AbstractDocument.Content)new GapContent(4096), styleSheet);
    }

    public HTMLDocument(AbstractDocument.Content content, StyleSheet styleSheet) {
        super(content, styleSheet);
    }

    public StyleSheet getStyleSheet() {
        return (StyleSheet)this.getAttributeContext();
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.AttributeContext attributeContext = this.getAttributeContext();
        AttributeSet attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.HTML);
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, attributeSet);
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.BODY);
        AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)this.createBranchElement(branchElement, attributeSet);
        branchElement.replace(0, 0, new Element[]{branchElement2});
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.P);
        AbstractDocument.BranchElement branchElement3 = (AbstractDocument.BranchElement)this.createBranchElement(branchElement2, attributeSet);
        branchElement2.replace(0, 0, new Element[]{branchElement3});
        attributeSet = attributeContext.getEmptySet();
        attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        Element element = this.createLeafElement(branchElement3, attributeSet, 0, 1);
        branchElement3.replace(0, 0, new Element[]{element});
        return branchElement;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new RunElement(element, attributeSet, n, n2);
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BlockElement(element, attributeSet);
    }

    public HTMLEditorKit.Parser getParser() {
        return this.parser;
    }

    public void setParser(HTMLEditorKit.Parser parser) {
        this.parser = parser;
    }

    public void setTokenThreshold(int n) {
        this.tokenThreshold = n;
    }

    public int getTokenThreshold() {
        return this.tokenThreshold;
    }

    public URL getBase() {
        return this.baseURL;
    }

    public void setBase(URL uRL) {
        this.baseURL = uRL;
        this.getStyleSheet().setBase(uRL);
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    public void setPreservesUnknownTags(boolean bl) {
        this.preservesUnknownTags = bl;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent) {
        String string = hTMLFrameHyperlinkEvent.getTarget();
        Element element = hTMLFrameHyperlinkEvent.getSourceElement();
        URL uRL = hTMLFrameHyperlinkEvent.getURL();
        if (string.equals("_self")) {
            this.updateFrame(element, uRL);
        } else if (string.equals("_parent")) {
            this.updateFrameSet(element.getParentElement(), uRL);
        } else {
            Element element2 = this.findFrame(string);
            if (element2 != null) {
                this.updateFrame(element2, uRL);
            }
        }
    }

    private Element findFrame(String string) {
        String string2;
        AttributeSet attributeSet;
        ElementIterator elementIterator = new ElementIterator(this);
        Element element = null;
        while (!((element = elementIterator.next()) == null || (attributeSet = element.getAttributes()).getAttribute(StyleConstants.NameAttribute) == HTML.Tag.FRAME && (string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME)) != null && string2.equals(string))) {
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrame(Element element, URL uRL) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, element.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet = element.getAttributes();
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet;
            defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element, attributeSet2, false));
            mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
            mutableAttributeSet.addAttribute(HTML.Attribute.SRC, uRL.toString());
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    private void updateFrameSet(Element element, URL uRL) {
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<frame");
        if (uRL != null) {
            stringBuilder.append(" src=\"");
            stringBuilder.append(uRL.toString());
            stringBuilder.append("\"");
        }
        stringBuilder.append('>');
        if (this.getParser() == null) {
            this.setParser(new HTMLEditorKit().getParser());
        }
        try {
            this.setOuterHTML(element, stringBuilder.toString());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Iterator getIterator(HTML.Tag tag) {
        return new LeafIterator(tag, this);
    }

    public HTMLEditorKit.ParserCallback getReader(int n) {
        return new HTMLReader(n);
    }

    public HTMLEditorKit.ParserCallback getReader(int n, int n2, int n3, HTML.Tag tag) {
        return new HTMLReader(n, n2, n3, tag);
    }

    public HTMLEditorKit.ParserCallback getInsertingReader(int n, int n2, int n3, HTML.Tag tag, Element element) throws IllegalStateException {
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        HTMLReader hTMLReader = new HTMLReader(n, n2, n3, tag){

            public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag != HTML.Tag.BODY) {
                    super.handleStartTag(tag, mutableAttributeSet, n);
                }
            }

            public void handleEndTag(HTML.Tag tag, int n) {
                if (tag != HTML.Tag.BODY) {
                    super.handleEndTag(tag, n);
                }
            }
        };
        return hTMLReader;
    }

    public Element getElement(Element element, Object object, Object object2) {
        if (element != null) {
            if (element.getAttributes().containsAttribute(object, object2)) {
                return element;
            }
            int n = element.getElementCount();
            for (int i = 0; i < n; ++i) {
                Element element2 = element.getElement(i);
                if (element2.getAttributes().containsAttribute(object, object2)) {
                    return element2;
                }
                Element element3 = this.getElement(element2, object, object2);
                if (element3 == null) continue;
                return element3;
            }
        }
        return null;
    }

    public Element getElement(String string) {
        return this.getElement(this.getDefaultRootElement(), HTML.Attribute.ID, string);
    }

    public void setInnerHTML(Element element, String string) throws BadLocationException, IOException {
        if (element.isLeaf()) {
            throw new IllegalArgumentException("Element is a leaf");
        }
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(n2, 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
        this.remove(n, n2 - n);
    }

    public void setOuterHTML(Element element, String string) throws BadLocationException, IOException {
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        this.remove(n, n2 - n);
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(n, 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public void insertBeforeStart(Element element, String string) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(element.getStartOffset(), 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public void insertBeforeEnd(Element element, String string) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(element.getEndOffset(), 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public void insertAfterEnd(Element element, String string) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(element.getEndOffset(), 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    public void insertAfterStart(Element element, String string) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback parserCallback = this.getInsertingReader(element.getStartOffset(), 0, 0, HTML.Tag.BODY, element);
        this.getParser().parse(new StringReader(string), parserCallback, true);
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        if (attributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            attributeSet = simpleAttributeSet;
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    boolean isFrameDocument() {
        return this.frameDocument;
    }

    void setFrameDocument(boolean bl) {
        this.frameDocument = bl;
    }

    String getBaseTarget() {
        return this.baseTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSpecialClass(Element element, HTML.Attribute attribute, String string) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, element.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet = element.getAttributes();
            AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
            if (attributeSet2 != null) {
                AttributeSet attributeSet3 = attributeSet.copyAttributes();
                StyleSheet styleSheet = this.getStyleSheet();
                attributeSet2 = string != null ? styleSheet.addAttribute(attributeSet2, attribute, string) : styleSheet.removeAttribute(attributeSet2, attribute);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet;
                defaultDocumentEvent.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(element, attributeSet3, false));
                mutableAttributeSet.removeAttribute(HTML.Tag.A);
                mutableAttributeSet.addAttribute(HTML.Tag.A, attributeSet2);
                defaultDocumentEvent.end();
                this.fireChangedUpdate(defaultDocumentEvent);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        private static final int MAX_THRESHOLD = 10000;
        private static final int GROW_THRESHOLD = 5;
        protected MutableAttributeSet charAttr = new SimpleAttributeSet();
        protected Vector<DefaultStyledDocument.ElementSpec> parseBuffer = new Vector();
        private Stack<HTML.Tag> parseStack = new Stack();
        Stack charAttrStack = new Stack();
        HashMap tagToAction;
        boolean endHTMLEncountered = false;
        int popDepth;
        int pushDepth;
        int offset;
        HTML.Tag insertTag;
        boolean insertTagEncountered;
        boolean debug = false;
        boolean inPreTag = false;
        boolean inStyleTag = false;
        boolean inTextArea = false;
        ArrayList styles;
        ResetablePlainDocument textAreaDocument;
        Object selectModel;
        Option option;
        int numOptions;
        HashMap buttonGroups;
        private int threshold;

        public HTMLReader(int n) {
            this(n, 0, 0, null);
        }

        public HTMLReader(int n, int n2, int n3, HTML.Tag tag) {
            this.insertTag = tag;
            this.offset = n;
            this.popDepth = n2;
            this.pushDepth = n3;
            this.threshold = HTMLDocument.this.getTokenThreshold();
            this.initTags();
        }

        void initTags() {
            this.tagToAction = new HashMap(72);
            CharacterAction characterAction = new CharacterAction();
            HiddenAction hiddenAction = new HiddenAction();
            AreaAction areaAction = new AreaAction();
            BaseAction baseAction = new BaseAction();
            BlockAction blockAction = new BlockAction();
            SpecialAction specialAction = new SpecialAction();
            ParagraphAction paragraphAction = new ParagraphAction();
            HeadAction headAction = new HeadAction();
            FormAction formAction = new FormAction();
            IsindexAction isindexAction = new IsindexAction();
            LinkAction linkAction = new LinkAction();
            MapAction mapAction = new MapAction();
            PreAction preAction = new PreAction();
            MetaAction metaAction = new MetaAction();
            StyleAction styleAction = new StyleAction();
            TitleAction titleAction = new TitleAction();
            ConvertAction convertAction = new ConvertAction();
            this.tagToAction.put(HTML.Tag.A, characterAction);
            this.tagToAction.put(HTML.Tag.ADDRESS, characterAction);
            this.tagToAction.put(HTML.Tag.APPLET, hiddenAction);
            this.tagToAction.put(HTML.Tag.AREA, areaAction);
            this.tagToAction.put(HTML.Tag.B, characterAction);
            this.tagToAction.put(HTML.Tag.BASE, baseAction);
            this.tagToAction.put(HTML.Tag.BASEFONT, characterAction);
            this.tagToAction.put(HTML.Tag.BIG, characterAction);
            this.tagToAction.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagToAction.put(HTML.Tag.BODY, blockAction);
            this.tagToAction.put(HTML.Tag.BR, specialAction);
            this.tagToAction.put(HTML.Tag.CAPTION, blockAction);
            this.tagToAction.put(HTML.Tag.CENTER, blockAction);
            this.tagToAction.put(HTML.Tag.CITE, characterAction);
            this.tagToAction.put(HTML.Tag.CODE, characterAction);
            this.tagToAction.put(HTML.Tag.DD, blockAction);
            this.tagToAction.put(HTML.Tag.DFN, characterAction);
            this.tagToAction.put(HTML.Tag.DIR, blockAction);
            this.tagToAction.put(HTML.Tag.DIV, blockAction);
            this.tagToAction.put(HTML.Tag.DL, blockAction);
            this.tagToAction.put(HTML.Tag.DT, paragraphAction);
            this.tagToAction.put(HTML.Tag.EM, characterAction);
            this.tagToAction.put(HTML.Tag.FONT, convertAction);
            this.tagToAction.put(HTML.Tag.FORM, new FormTagAction());
            this.tagToAction.put(HTML.Tag.FRAME, specialAction);
            this.tagToAction.put(HTML.Tag.FRAMESET, blockAction);
            this.tagToAction.put(HTML.Tag.H1, paragraphAction);
            this.tagToAction.put(HTML.Tag.H2, paragraphAction);
            this.tagToAction.put(HTML.Tag.H3, paragraphAction);
            this.tagToAction.put(HTML.Tag.H4, paragraphAction);
            this.tagToAction.put(HTML.Tag.H5, paragraphAction);
            this.tagToAction.put(HTML.Tag.H6, paragraphAction);
            this.tagToAction.put(HTML.Tag.HEAD, headAction);
            this.tagToAction.put(HTML.Tag.HR, specialAction);
            this.tagToAction.put(HTML.Tag.HTML, blockAction);
            this.tagToAction.put(HTML.Tag.I, characterAction);
            this.tagToAction.put(HTML.Tag.IMG, specialAction);
            this.tagToAction.put(HTML.Tag.INPUT, formAction);
            this.tagToAction.put(HTML.Tag.ISINDEX, isindexAction);
            this.tagToAction.put(HTML.Tag.KBD, characterAction);
            this.tagToAction.put(HTML.Tag.LI, blockAction);
            this.tagToAction.put(HTML.Tag.LINK, linkAction);
            this.tagToAction.put(HTML.Tag.MAP, mapAction);
            this.tagToAction.put(HTML.Tag.MENU, blockAction);
            this.tagToAction.put(HTML.Tag.META, metaAction);
            this.tagToAction.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagToAction.put(HTML.Tag.OBJECT, specialAction);
            this.tagToAction.put(HTML.Tag.OL, blockAction);
            this.tagToAction.put(HTML.Tag.OPTION, formAction);
            this.tagToAction.put(HTML.Tag.P, paragraphAction);
            this.tagToAction.put(HTML.Tag.PARAM, hiddenAction);
            this.tagToAction.put(HTML.Tag.PRE, preAction);
            this.tagToAction.put(HTML.Tag.SAMP, characterAction);
            this.tagToAction.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagToAction.put(HTML.Tag.SELECT, formAction);
            this.tagToAction.put(HTML.Tag.SMALL, characterAction);
            this.tagToAction.put(HTML.Tag.STRIKE, characterAction);
            this.tagToAction.put(HTML.Tag.S, characterAction);
            this.tagToAction.put(HTML.Tag.STRONG, characterAction);
            this.tagToAction.put(HTML.Tag.STYLE, styleAction);
            this.tagToAction.put(HTML.Tag.SUB, characterAction);
            this.tagToAction.put(HTML.Tag.SUP, characterAction);
            this.tagToAction.put(HTML.Tag.TABLE, blockAction);
            this.tagToAction.put(HTML.Tag.TD, blockAction);
            this.tagToAction.put(HTML.Tag.TEXTAREA, formAction);
            this.tagToAction.put(HTML.Tag.TH, blockAction);
            this.tagToAction.put(HTML.Tag.TITLE, titleAction);
            this.tagToAction.put(HTML.Tag.TR, blockAction);
            this.tagToAction.put(HTML.Tag.TT, characterAction);
            this.tagToAction.put(HTML.Tag.U, characterAction);
            this.tagToAction.put(HTML.Tag.UL, blockAction);
            this.tagToAction.put(HTML.Tag.VAR, characterAction);
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.isEmpty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.pop();
            }
        }

        protected void registerTag(HTML.Tag tag, TagAction tagAction) {
            this.tagToAction.put(tag, tagAction);
        }

        public void flush() throws BadLocationException {
            this.flushImpl();
        }

        private void flushImpl() throws BadLocationException {
            int n = HTMLDocument.this.getLength();
            int n2 = this.parseBuffer.size();
            Object[] objectArray = new DefaultStyledDocument.ElementSpec[n2];
            this.parseBuffer.copyInto(objectArray);
            if (n == 0) {
                HTMLDocument.this.create((DefaultStyledDocument.ElementSpec[])objectArray);
            } else {
                HTMLDocument.this.insert(this.offset, (DefaultStyledDocument.ElementSpec[])objectArray);
            }
            this.parseBuffer.removeAllElements();
            this.offset += HTMLDocument.this.getLength() - n;
        }

        public void handleText(char[] cArray, int n) {
            if (this.shouldInsert() && cArray != null && cArray.length > 0) {
                if (this.inTextArea) {
                    this.textAreaContent(cArray);
                } else if (this.inPreTag) {
                    this.preContent(cArray);
                } else if (this.option != null) {
                    this.option.setLabel(new String(cArray));
                } else if (this.inStyleTag) {
                    if (this.styles == null) {
                        this.styles = new ArrayList();
                    }
                    this.styles.add(new String(cArray));
                } else {
                    this.addContent(cArray, 0, cArray.length);
                }
            }
        }

        private boolean shouldInsert() {
            return !this.endHTMLEncountered && (this.insertTagEncountered || this.insertTag == null);
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            TagAction tagAction;
            if (tag == this.insertTag) {
                this.insertTagEncountered = true;
            }
            if (this.shouldInsert() && (tagAction = (TagAction)this.tagToAction.get(tag)) != null) {
                tagAction.start(tag, mutableAttributeSet);
            }
        }

        public void handleComment(char[] cArray, int n) {
            TagAction tagAction;
            if (this.shouldInsert() && (tagAction = (TagAction)this.tagToAction.get(HTML.Tag.COMMENT)) != null) {
                tagAction.start(HTML.Tag.COMMENT, new SimpleAttributeSet());
                tagAction.end(HTML.Tag.COMMENT);
            }
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            if (this.shouldInsert()) {
                TagAction tagAction;
                if (tag == HTML.Tag.HTML) {
                    this.endHTMLEncountered = true;
                }
                if ((tagAction = (TagAction)this.tagToAction.get(tag)) != null) {
                    tagAction.end(tag);
                }
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            TagAction tagAction;
            if (tag == this.insertTag) {
                this.insertTagEncountered = true;
            }
            if (this.shouldInsert() && (tagAction = (TagAction)this.tagToAction.get(tag)) != null) {
                tagAction.start(tag, mutableAttributeSet);
                tagAction.end(tag);
            }
        }

        public void handleEndOfLineString(String string) {
        }

        protected void textAreaContent(char[] cArray) {
            block2: {
                try {
                    int n = this.textAreaDocument.getLength();
                    String string = new String(cArray);
                    this.textAreaDocument.setInitialText(string);
                    this.textAreaDocument.insertString(n, string, null);
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }

        protected void preContent(char[] cArray) {
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != '\n') continue;
                this.addContent(cArray, n, i - n + 1);
                this.blockClose(HTML.Tag.IMPLIED);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                this.blockOpen(HTML.Tag.IMPLIED, simpleAttributeSet);
                n = i + 1;
            }
            if (n < cArray.length) {
                this.addContent(cArray, n, cArray.length - n);
            }
        }

        protected void blockOpen(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (this.inImpliedParagraph()) {
                this.blockClose(HTML.Tag.IMPLIED);
            }
            this.parseStack.push(tag);
            AbstractDocument.AttributeContext attributeContext = HTMLDocument.this.getAttributeContext();
            AttributeSet attributeSet = mutableAttributeSet.copyAttributes();
            attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, tag);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 1);
            this.parseBuffer.addElement(elementSpec);
        }

        private boolean inParagraph() {
            boolean bl = false;
            if (!this.parseStack.isEmpty()) {
                HTML.Tag tag = this.parseStack.peek();
                bl = tag == HTML.Tag.P || tag == HTML.Tag.IMPLIED;
            }
            return bl;
        }

        private boolean inImpliedParagraph() {
            boolean bl = false;
            if (!this.parseStack.isEmpty()) {
                HTML.Tag tag = this.parseStack.peek();
                bl = tag == HTML.Tag.IMPLIED;
            }
            return bl;
        }

        protected void blockClose(HTML.Tag tag) {
            DefaultStyledDocument.ElementSpec elementSpec;
            if (this.inImpliedParagraph() && tag != HTML.Tag.IMPLIED) {
                this.blockClose(HTML.Tag.IMPLIED);
            }
            if (!this.parseStack.isEmpty()) {
                this.parseStack.pop();
            }
            DefaultStyledDocument.ElementSpec elementSpec2 = elementSpec = this.parseBuffer.size() > 0 ? this.parseBuffer.get(this.parseBuffer.size() - 1) : null;
            if (elementSpec != null && elementSpec.getType() == 1) {
                this.addContent(new char[]{' '}, 0, 1);
            }
            DefaultStyledDocument.ElementSpec elementSpec3 = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(elementSpec3);
        }

        protected void addContent(char[] cArray, int n, int n2) {
            this.addContent(cArray, n, n2, true);
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
            if (bl && !this.inParagraph()) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
            }
            AbstractDocument.AttributeContext attributeContext = HTMLDocument.this.getAttributeContext();
            AttributeSet attributeSet = null;
            attributeSet = this.charAttr != null ? this.charAttr.copyAttributes() : attributeContext.getEmptySet();
            attributeSet = attributeContext.addAttribute(attributeSet, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, cArray, n, n2);
            this.parseBuffer.addElement(elementSpec);
            if (this.parseBuffer.size() > this.threshold) {
                if (this.threshold <= 10000) {
                    this.threshold *= 5;
                }
                try {
                    this.flushImpl();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected void addSpecialElement(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            if (tag != HTML.Tag.FRAME && !this.inParagraph()) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
            }
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
            DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(mutableAttributeSet.copyAttributes(), 3, new char[]{' '}, 0, 1);
            this.parseBuffer.add(elementSpec);
        }

        class TitleAction
        extends TagAction {
            TitleAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
            }
        }

        class StyleAction
        extends TagAction {
            StyleAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inStyleTag = true;
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.inStyleTag = false;
            }
        }

        class MetaAction
        extends TagAction {
            MetaAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
            }
        }

        class MapAction
        extends TagAction {
            MapAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
            }
        }

        class LinkAction
        extends HiddenAction {
            LinkAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
                String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TYPE);
                if (string == null) {
                    string = "text/css";
                }
                if (string.equals("text/css")) {
                    String string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.REL);
                    String string3 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.MEDIA);
                    String string4 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TITLE);
                    string3 = string3 == null ? "all" : string3.toLowerCase();
                    if (string2 != null) {
                        string2 = string2.toLowerCase();
                        if ((string3.indexOf("all") != -1 || string3.indexOf("screen") != -1) && string2.equals("stylesheet")) {
                            String string5 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.HREF);
                            URL uRL = null;
                            try {
                                uRL = new URL(HTMLDocument.this.baseURL, string5);
                            }
                            catch (MalformedURLException malformedURLException) {
                                try {
                                    uRL = new URL(string5);
                                }
                                catch (MalformedURLException malformedURLException2) {
                                    uRL = null;
                                }
                            }
                            if (uRL != null) {
                                try {
                                    HTMLDocument.this.getStyleSheet().importStyleSheet(uRL);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
        }

        class HeadAction
        extends BlockAction {
            HeadAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                if (HTMLReader.this.styles != null) {
                    int n = HTMLReader.this.styles.size();
                    for (int i = 0; i < n; ++i) {
                        String string = (String)HTMLReader.this.styles.get(i);
                        HTMLDocument.this.getStyleSheet().addRule(string);
                    }
                }
                super.end(tag);
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLDocument.this.baseTarget = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TARGET);
            }
        }

        class ConvertAction
        extends TagAction {
            ConvertAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.pushCharacterStyle();
                HTMLReader.this.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
                StyleSheet styleSheet = HTMLDocument.this.getStyleSheet();
                if (tag == HTML.Tag.FONT) {
                    String string;
                    String string2;
                    String string3 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.COLOR);
                    if (string3 != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.COLOR, string3);
                    }
                    if ((string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.FACE)) != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_FAMILY, string2);
                    }
                    if ((string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.SIZE)) != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_SIZE, string);
                    }
                }
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        class AreaAction
        extends TagAction {
            AreaAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) throws NotImplementedException {
            }

            public void end(HTML.Tag tag) throws NotImplementedException {
            }
        }

        public class SpecialAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
            }
        }

        public class PreAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.inPreTag = true;
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
                mutableAttributeSet.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
                HTMLReader.this.inPreTag = false;
                HTMLReader.this.blockClose(tag);
            }
        }

        public class ParagraphAction
        extends BlockAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                super.start(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                super.end(tag);
            }
        }

        public class IsindexAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                HTMLReader.this.addSpecialElement(tag, mutableAttributeSet);
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
            }
        }

        public class HiddenAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(tag);
            }
        }

        class FormTagAction
        extends BlockAction {
            FormTagAction() {
            }

            public void end(HTML.Tag tag) {
                super.end(tag);
                HTMLReader.this.buttonGroups = null;
            }
        }

        public class FormAction
        extends SpecialAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                if (tag == HTML.Tag.INPUT) {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.TYPE);
                    if (string == null) {
                        string = "text";
                        mutableAttributeSet.addAttribute(HTML.Attribute.TYPE, string);
                    }
                    this.setModel(string, mutableAttributeSet);
                } else if (tag == HTML.Tag.TEXTAREA) {
                    HTMLReader.this.inTextArea = true;
                    HTMLReader.this.textAreaDocument = new ResetablePlainDocument();
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, HTMLReader.this.textAreaDocument);
                } else if (tag == HTML.Tag.SELECT) {
                    boolean bl;
                    int n = HTML.getIntegerAttributeValue(mutableAttributeSet, HTML.Attribute.SIZE, 1);
                    boolean bl2 = bl = mutableAttributeSet.getAttribute(HTML.Attribute.MULTIPLE) != null;
                    if (n > 1 || bl) {
                        SelectListModel selectListModel = new SelectListModel();
                        if (bl) {
                            selectListModel.getSelectionModel().setSelectionMode(2);
                        }
                        HTMLReader.this.selectModel = selectListModel;
                    } else {
                        HTMLReader.this.selectModel = new SelectComboBoxModel();
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, HTMLReader.this.selectModel);
                }
                if (tag == HTML.Tag.OPTION) {
                    HTMLReader.this.option = new Option(mutableAttributeSet);
                    if (HTMLReader.this.selectModel instanceof SelectListModel) {
                        SelectListModel selectListModel = (SelectListModel)HTMLReader.this.selectModel;
                        selectListModel.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            selectListModel.getSelectionModel().addSelectionInterval(HTMLReader.this.numOptions, HTMLReader.this.numOptions);
                            selectListModel.addInitialSelection(HTMLReader.this.numOptions);
                        }
                    } else if (HTMLReader.this.selectModel instanceof SelectComboBoxModel) {
                        SelectComboBoxModel selectComboBoxModel = (SelectComboBoxModel)HTMLReader.this.selectModel;
                        selectComboBoxModel.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            selectComboBoxModel.setSelectedItem(HTMLReader.this.option);
                            selectComboBoxModel.setInitialSelection(HTMLReader.this.option);
                        }
                    }
                    ++HTMLReader.this.numOptions;
                } else {
                    super.start(tag, mutableAttributeSet);
                }
            }

            public void end(HTML.Tag tag) {
                if (tag == HTML.Tag.OPTION) {
                    HTMLReader.this.option = null;
                } else {
                    if (tag == HTML.Tag.TEXTAREA) {
                        HTMLReader.this.inTextArea = false;
                    } else if (tag == HTML.Tag.SELECT) {
                        HTMLReader.this.selectModel = null;
                        HTMLReader.this.numOptions = 0;
                    }
                    super.end(tag);
                }
            }

            private void setModel(String string, MutableAttributeSet mutableAttributeSet) {
                if (string.equals("submit") || string.equals("reset") || string.equals("image")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new DefaultButtonModel());
                } else if (string.equals("text") || string.equals("password")) {
                    ResetablePlainDocument resetablePlainDocument;
                    block14: {
                        String string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.VALUE);
                        resetablePlainDocument = new ResetablePlainDocument();
                        if (string2 != null) {
                            resetablePlainDocument.setInitialText(string2);
                            try {
                                resetablePlainDocument.insertString(0, string2, null);
                            }
                            catch (BadLocationException badLocationException) {
                                if ($assertionsDisabled) break block14;
                                throw new AssertionError();
                            }
                        }
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, resetablePlainDocument);
                } else if (string.equals("file")) {
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, new PlainDocument());
                } else if (string.equals("checkbox") || string.equals("radio")) {
                    String string3;
                    ResetableToggleButtonModel resetableToggleButtonModel = new ResetableToggleButtonModel();
                    if (mutableAttributeSet.getAttribute(HTML.Attribute.SELECTED) != null) {
                        resetableToggleButtonModel.setSelected(true);
                        resetableToggleButtonModel.setInitial(true);
                    }
                    if (string.equals("radio") && (string3 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.NAME)) != null) {
                        ButtonGroup buttonGroup;
                        if (HTMLReader.this.buttonGroups == null) {
                            HTMLReader.this.buttonGroups = new HashMap();
                        }
                        if ((buttonGroup = (ButtonGroup)HTMLReader.this.buttonGroups.get(string3)) == null) {
                            buttonGroup = new ButtonGroup();
                            HTMLReader.this.buttonGroups.put(string3, buttonGroup);
                        }
                        resetableToggleButtonModel.setGroup(buttonGroup);
                    }
                    mutableAttributeSet.addAttribute(StyleConstants.ModelAttribute, resetableToggleButtonModel);
                }
            }
        }

        public class CharacterAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.pushCharacterStyle();
                if (tag == HTML.Tag.A) {
                    mutableAttributeSet.addAttribute(HTML.Attribute.PSEUDO_CLASS, "link");
                }
                HTMLReader.this.charAttr.addAttribute(tag, mutableAttributeSet.copyAttributes());
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        public class BlockAction
        extends TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
                HTMLReader.this.blockOpen(tag, mutableAttributeSet);
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.blockClose(tag);
            }
        }

        public class TagAction {
            public void start(HTML.Tag tag, MutableAttributeSet mutableAttributeSet) {
            }

            public void end(HTML.Tag tag) {
            }
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        public RunElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(HTMLDocument.this, element, attributeSet, n, n2);
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            String string = null;
            if (object != null) {
                string = object.toString();
            }
            if (string == null) {
                string = super.getName();
            }
            return string;
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        public BlockElement(Element element, AttributeSet attributeSet) {
            super(HTMLDocument.this, element, attributeSet);
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            String string = null;
            if (object != null) {
                string = object.toString();
            }
            if (string == null) {
                string = super.getName();
            }
            return string;
        }
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getEndOffset();

        public abstract int getStartOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract HTML.Tag getTag();
    }

    class LeafIterator
    extends Iterator {
        HTML.Tag tag;
        HTMLDocument doc;
        ElementIterator it;

        public LeafIterator(HTML.Tag tag, HTMLDocument hTMLDocument2) {
            this.doc = hTMLDocument2;
            this.tag = tag;
            this.it = new ElementIterator(this.doc);
        }

        public AttributeSet getAttributes() {
            if (this.it.current() != null) {
                return this.it.current().getAttributes();
            }
            return null;
        }

        public int getEndOffset() {
            if (this.it.current() != null) {
                return this.it.current().getEndOffset();
            }
            return -1;
        }

        public int getStartOffset() {
            if (this.it.current() != null) {
                return this.it.current().getStartOffset();
            }
            return -1;
        }

        public void next() {
            this.it.next();
            while (this.it.current() != null && !this.it.current().isLeaf()) {
                this.it.next();
            }
        }

        public boolean isValid() {
            return this.it.current() != null;
        }

        public HTML.Tag getTag() {
            return this.tag;
        }
    }
}

