/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;

public class FrameSetView
extends BoxView {
    int[][] absolute;
    int[][] relative;
    int[][] percent;
    int[] numViews = new int[2];

    FrameSetView(Element element) {
        super(element, 1);
        this.absolute = new int[2][];
        this.relative = new int[2][];
        this.percent = new int[2][];
    }

    protected void loadChildren(ViewFactory viewFactory) {
        this.parseRowsCols();
        View[] viewArray = new View[this.numViews[1]];
        for (int i = 0; i < this.numViews[1]; ++i) {
            viewArray[i] = new FrameSetRow(this.getElement(), i);
        }
        this.replace(0, 0, viewArray);
    }

    private void parseRowsCols() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.COLS);
        if (string == null) {
            string = "100%";
        }
        this.parseLayout(string, 0);
        String string2 = (String)attributeSet.getAttribute(HTML.Attribute.ROWS);
        if (string2 == null) {
            string2 = "100%";
        }
        this.parseLayout(string2, 1);
    }

    private void parseLayout(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.numViews[n] = stringTokenizer.countTokens();
        this.absolute[n] = new int[this.numViews[n]];
        this.relative[n] = new int[this.numViews[n]];
        this.percent[n] = new int[this.numViews[n]];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            int n3 = string3.indexOf(37);
            int n4 = string3.indexOf(42);
            if (n3 != -1) {
                string2 = string3.substring(0, n3);
                try {
                    this.percent[n][n2] = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (n4 != -1) {
                string2 = string3.substring(0, n4);
                try {
                    this.relative[n][n2] = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    this.absolute[n][n2] = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.numViews[1];
        int[] nArray3 = this.absolute[1];
        int[] nArray4 = this.relative[1];
        int[] nArray5 = this.percent[1];
        this.layoutViews(n, n2, nArray, nArray2, n3, nArray3, nArray4, nArray5);
    }

    void layoutViews(int n, int n2, int[] nArray, int[] nArray2, int n3, int[] nArray3, int[] nArray4, int[] nArray5) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < n3; ++n4) {
            if (nArray3[n4] > 0) {
                nArray2[n4] = nArray3[n4];
                n5 += nArray2[n4];
                continue;
            }
            if (nArray5[n4] > 0) {
                nArray2[n4] = n * nArray5[n4] / 100;
                n5 += nArray2[n4];
                continue;
            }
            if (nArray4[n4] <= 0) continue;
            n6 += nArray4[n4];
        }
        n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (n6 > 0 && nArray4[i] > 0) {
                nArray2[i] = n * (nArray4[i] / n6);
            }
            nArray[i] = n4;
            n4 += nArray2[i];
        }
    }

    private class FrameSetRow
    extends BoxView {
        private int row;

        FrameSetRow(Element element, int n) {
            super(element, 0);
            this.row = n;
        }

        protected void loadChildren(ViewFactory viewFactory) {
            Element element = this.getElement();
            View[] viewArray = new View[FrameSetView.this.numViews[0]];
            int n = this.row * FrameSetView.this.numViews[0];
            for (int i = 0; i < FrameSetView.this.numViews[0]; ++i) {
                Element element2 = element.getElement(n + i);
                viewArray[i] = viewFactory.create(element2);
            }
            this.replace(0, 0, viewArray);
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            int n3 = FrameSetView.this.numViews[0];
            int[] nArray3 = FrameSetView.this.absolute[0];
            int[] nArray4 = FrameSetView.this.relative[0];
            int[] nArray5 = FrameSetView.this.percent[0];
            FrameSetView.this.layoutViews(n, n2, nArray, nArray2, n3, nArray3, nArray4, nArray5);
        }
    }
}

