/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.Length;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class BlockView
extends BoxView {
    private AttributeSet attributes;
    StyleSheet.BoxPainter painter;
    private Length[] cssSpans = new Length[2];
    private HashMap positionInfo = new HashMap();

    public BlockView(Element element, int n) {
        super(element, n);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        if (this.setCSSSpan(sizeRequirements, n)) {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, null);
            int n2 = n == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n2;
            sizeRequirements.preferred -= n2;
            sizeRequirements.maximum -= n2;
            this.constrainSize(n, sizeRequirements, sizeRequirements2);
        } else {
            sizeRequirements = super.calculateMajorAxisRequirements(n, sizeRequirements);
        }
        return sizeRequirements;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        Object object;
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        if (this.setCSSSpan(sizeRequirements, n)) {
            object = super.calculateMinorAxisRequirements(n, null);
            int n2 = n == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            sizeRequirements.minimum -= n2;
            sizeRequirements.preferred -= n2;
            sizeRequirements.maximum -= n2;
            this.constrainSize(n, sizeRequirements, (SizeRequirements)object);
        } else {
            sizeRequirements = super.calculateMinorAxisRequirements(n, sizeRequirements);
        }
        if (n == 0 && (object = this.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN)) != null) {
            String string = object.toString().trim();
            sizeRequirements.alignment = string.equals("center") ? 0.5f : (string.equals("right") ? 1.0f : 0.0f);
        }
        return sizeRequirements;
    }

    private boolean setCSSSpan(SizeRequirements sizeRequirements, int n) {
        boolean bl = false;
        Length length = this.cssSpans[n];
        if (length != null && !length.isPercentage()) {
            sizeRequirements.minimum = (int)length.getValue();
            sizeRequirements.preferred = (int)length.getValue();
            sizeRequirements.maximum = (int)length.getValue();
            bl = true;
        }
        return bl;
    }

    private void constrainSize(int n, SizeRequirements sizeRequirements, SizeRequirements sizeRequirements2) {
        if (sizeRequirements2.minimum > sizeRequirements.minimum) {
            sizeRequirements.minimum = sizeRequirements2.minimum;
            sizeRequirements.preferred = sizeRequirements2.minimum;
            sizeRequirements.maximum = Math.max(sizeRequirements.maximum, sizeRequirements2.maximum);
        }
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            int n4 = (int)view.getMinimumSpan(n2);
            Length length = this.cssSpans[n2];
            int n5 = length != null ? (n4 = Math.max((int)length.getValue(n), n4)) : (int)view.getMaximumSpan(n2);
            if (n5 < n) {
                float f = view.getAlignment(n2);
                nArray[i] = (int)((float)(n - n5) * f);
                nArray2[i] = n5;
            } else {
                nArray[i] = 0;
                nArray2[i] = Math.max(n4, n);
            }
            this.positionView(n, n2, i, nArray, nArray2);
        }
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        super.layoutMajorAxis(n, n2, nArray, nArray2);
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            this.positionView(n, n2, i, nArray, nArray2);
        }
    }

    private void positionView(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        View view = this.getView(n3);
        PositionInfo positionInfo = (PositionInfo)this.positionInfo.get(view);
        if (positionInfo != null) {
            int n4 = -1;
            int n5 = -1;
            if (n2 == 0) {
                Length length = positionInfo.left;
                if (length != null) {
                    n4 = (int)length.getValue(n);
                }
                if ((length = positionInfo.right) != null) {
                    n5 = (int)length.getValue(n);
                }
            } else {
                Length length = positionInfo.top;
                if (length != null) {
                    n4 = (int)length.getValue(n);
                }
                if ((length = positionInfo.bottom) != null) {
                    n5 = (int)length.getValue(n);
                }
            }
            if (positionInfo.type == 2 || positionInfo.type == 3) {
                if (n4 != -1) {
                    nArray[n3] = n4;
                    if (n5 != -1) {
                        nArray2[n3] = n - n5 - nArray[n3];
                    }
                } else if (n5 != -1) {
                    nArray[n3] = n - n5 - nArray2[n3];
                }
            } else if (positionInfo.type == 1) {
                if (n4 != -1) {
                    int n6 = n3;
                    nArray[n6] = nArray[n6] + n4;
                    if (n5 != -1) {
                        nArray2[n3] = nArray2[n3] - n4 - n5 - nArray[n3];
                    }
                } else if (n5 != -1) {
                    int n7 = n3;
                    nArray[n7] = nArray[n7] - n5;
                }
            }
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, shape);
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.getStyleSheet().getViewAttributes(this);
        }
        return this.attributes;
    }

    public int getResizeWeight(int n) throws IllegalArgumentException {
        if (n == 1) {
            return 0;
        }
        if (n == 0) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getAlignment(int n) {
        if (n == 0) {
            return super.getAlignment(n);
        }
        if (n == 1) {
            if (this.getViewCount() == 0) {
                return 0.0f;
            }
            float f = this.getPreferredSpan(1);
            View view = this.getView(0);
            float f2 = view.getPreferredSpan(1);
            return f != 0.0f ? f2 * view.getAlignment(1) / f : 0.0f;
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        int n = documentEvent.getOffset();
        if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }

    public float getPreferredSpan(int n) throws IllegalArgumentException {
        if (n == 0 || n == 1) {
            return super.getPreferredSpan(n);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getMinimumSpan(int n) throws IllegalArgumentException {
        if (n == 0 || n == 1) {
            return super.getMinimumSpan(n);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    public float getMaximumSpan(int n) throws IllegalArgumentException {
        if (n == 0 || n == 1) {
            return super.getMaximumSpan(n);
        }
        throw new IllegalArgumentException("Invalid Axis");
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attributes = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attributes);
        if (this.attributes != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
        float f = styleSheet.getEMBase(this.attributes);
        float f2 = styleSheet.getEXBase(this.attributes);
        this.cssSpans[0] = (Length)this.attributes.getAttribute(CSS.Attribute.WIDTH);
        if (this.cssSpans[0] != null) {
            this.cssSpans[0].setFontBases(f, f2);
        }
        this.cssSpans[1] = (Length)this.attributes.getAttribute(CSS.Attribute.HEIGHT);
        if (this.cssSpans[1] != null) {
            this.cssSpans[1].setFontBases(f, f2);
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            View view = this.getView(n3 + n);
            this.positionInfo.remove(view);
        }
        super.replace(n, n2, viewArray);
        for (n3 = 0; n3 < viewArray.length; ++n3) {
            this.fetchLayoutInfo(viewArray[n3]);
        }
    }

    private void fetchLayoutInfo(View view) {
        int n;
        AttributeSet attributeSet = view.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.POSITION);
        if (object != null && object instanceof String && !object.equals("static") && (n = object.equals("relative") ? 1 : (object.equals("absolute") ? 2 : (object.equals("fixed") ? 3 : 0))) != 0) {
            Length length;
            Length length2;
            Length length3;
            StyleSheet styleSheet = this.getStyleSheet();
            float f = styleSheet.getEMBase(attributeSet);
            float f2 = styleSheet.getEXBase(attributeSet);
            Length length4 = (Length)attributeSet.getAttribute(CSS.Attribute.LEFT);
            if (length4 != null) {
                length4.setFontBases(f, f2);
            }
            if ((length3 = (Length)attributeSet.getAttribute(CSS.Attribute.RIGHT)) != null) {
                length3.setFontBases(f, f2);
            }
            if ((length2 = (Length)attributeSet.getAttribute(CSS.Attribute.TOP)) != null) {
                length2.setFontBases(f, f2);
            }
            if ((length = (Length)attributeSet.getAttribute(CSS.Attribute.BOTTOM)) != null) {
                length.setFontBases(f, f2);
            }
            if (length4 != null || length3 != null || length2 != null || length != null) {
                PositionInfo positionInfo = new PositionInfo(n, length4, length3, length2, length);
                this.positionInfo.put(view, positionInfo);
            }
        }
    }

    private static class PositionInfo {
        static final int STATIC = 0;
        static final int RELATIVE = 1;
        static final int ABSOLUTE = 2;
        static final int FIXED = 3;
        int type;
        Length left;
        Length right;
        Length top;
        Length bottom;

        PositionInfo(int n, Length length, Length length2, Length length3, Length length4) {
            this.type = n;
            this.left = length;
            this.right = length2;
            this.top = length3;
            this.bottom = length4;
        }
    }
}

