/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public abstract class TextAction
extends AbstractAction {
    public TextAction(String string) {
        super(string);
    }

    protected final JTextComponent getTextComponent(ActionEvent actionEvent) {
        Object object;
        JTextComponent jTextComponent = null;
        if (actionEvent != null && (object = actionEvent.getSource()) instanceof JTextComponent) {
            jTextComponent = (JTextComponent)object;
        }
        if (jTextComponent == null) {
            jTextComponent = this.getFocusedComponent();
        }
        return jTextComponent;
    }

    public static final Action[] augmentList(Action[] actionArray, Action[] actionArray2) {
        Object object;
        Action action;
        int n;
        HashMap<Object, Action> hashMap = new HashMap<Object, Action>();
        for (n = 0; n < actionArray.length; ++n) {
            action = actionArray[n];
            object = action.getValue("Name");
            hashMap.put(object != null ? object : "", action);
        }
        for (n = 0; n < actionArray2.length; ++n) {
            action = actionArray2[n];
            object = action.getValue("Name");
            hashMap.put(object != null ? object : "", action);
        }
        Action[] actionArray3 = new Action[hashMap.size()];
        int n2 = 0;
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            actionArray3[n2] = (Action)object.next();
            ++n2;
        }
        return actionArray3;
    }

    protected final JTextComponent getFocusedComponent() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getPermanentFocusOwner();
        JTextComponent jTextComponent = null;
        if (component instanceof JTextComponent) {
            jTextComponent = (JTextComponent)component;
        }
        return jTextComponent;
    }

    static abstract class VerticalMovementAction
    extends TextAction {
        int dir;

        VerticalMovementAction(String string, int n) {
            super(string);
            this.dir = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                if (jTextComponent != null) {
                    int n;
                    Caret caret = jTextComponent.getCaret();
                    Point point = caret.getMagicCaretPosition();
                    if (point != null) {
                        point.y = jTextComponent.modelToView((int)caret.getDot()).y;
                        n = jTextComponent.viewToModel(point);
                    } else {
                        n = caret.getDot();
                    }
                    n = Utilities.getNextVisualPositionFrom(jTextComponent, jTextComponent.getCaretPosition(), this.dir);
                    if (n > -1) {
                        this.actionPerformedImpl(caret, n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                throw (InternalError)new InternalError("Illegal offset").initCause(badLocationException);
            }
        }

        protected abstract void actionPerformedImpl(Caret var1, int var2) throws BadLocationException;
    }

    static abstract class HorizontalMovementAction
    extends TextAction {
        int dir;

        HorizontalMovementAction(String string, int n) {
            super(string);
            this.dir = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            try {
                if (jTextComponent != null) {
                    int n = Utilities.getNextVisualPositionFrom(jTextComponent, jTextComponent.getCaretPosition(), this.dir);
                    Caret caret = jTextComponent.getCaret();
                    this.actionPerformedImpl(caret, n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                throw (InternalError)new InternalError("Illegal offset").initCause(badLocationException);
            }
        }

        protected abstract void actionPerformedImpl(Caret var1, int var2) throws BadLocationException;
    }
}

