/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;
import javax.swing.text.EmptyAttributeSet;
import javax.swing.text.MutableAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAttributeSet
implements MutableAttributeSet,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8267656273837665219L;
    public static final AttributeSet EMPTY = new EmptyAttributeSet();
    Hashtable tab = new Hashtable();

    public SimpleAttributeSet() {
    }

    public SimpleAttributeSet(AttributeSet attributeSet) {
        this.addAttributes(attributeSet);
    }

    @Override
    public void addAttribute(Object object, Object object2) {
        this.tab.put(object, object2);
    }

    @Override
    public void addAttributes(AttributeSet attributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            this.tab.put(obj, object);
        }
    }

    public Object clone() {
        SimpleAttributeSet simpleAttributeSet;
        block2: {
            simpleAttributeSet = null;
            try {
                simpleAttributeSet = (SimpleAttributeSet)super.clone();
                simpleAttributeSet.tab = (Hashtable)this.tab.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return simpleAttributeSet;
    }

    @Override
    public boolean containsAttribute(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException("Null 'value' argument.");
        }
        if (this.tab.containsKey(object)) {
            return this.tab.get(object).equals(object2);
        }
        AttributeSet attributeSet = this.getResolveParent();
        if (attributeSet != null) {
            return attributeSet.containsAttribute(object, object2);
        }
        return false;
    }

    boolean containsAttributeLocally(Object object, Object object2) {
        return this.tab.containsKey(object) && this.tab.get(object).equals(object2);
    }

    @Override
    public boolean containsAttributes(AttributeSet attributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object obj = enumeration.nextElement();
            if (this.containsAttribute(obj, object = attributeSet.getAttribute(obj))) continue;
            return false;
        }
        return true;
    }

    @Override
    public AttributeSet copyAttributes() {
        return (AttributeSet)this.clone();
    }

    public boolean equals(Object object) {
        return object instanceof AttributeSet && this.isEqual((AttributeSet)object);
    }

    @Override
    public Object getAttribute(Object object) {
        Object v = this.tab.get(object);
        if (v != null) {
            return v;
        }
        AttributeSet attributeSet = this.getResolveParent();
        if (attributeSet != null) {
            return attributeSet.getAttribute(object);
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return this.tab.size();
    }

    @Override
    public Enumeration<?> getAttributeNames() {
        return this.tab.keys();
    }

    @Override
    public AttributeSet getResolveParent() {
        return (AttributeSet)this.tab.get(ResolveAttribute);
    }

    public int hashCode() {
        return this.tab.hashCode();
    }

    @Override
    public boolean isDefined(Object object) {
        return this.tab.containsKey(object);
    }

    public boolean isEmpty() {
        return this.tab.isEmpty();
    }

    @Override
    public boolean isEqual(AttributeSet attributeSet) {
        return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
    }

    @Override
    public void removeAttribute(Object object) {
        this.tab.remove(object);
    }

    @Override
    public void removeAttributes(AttributeSet attributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object obj = enumeration.nextElement();
            if (!this.containsAttributeLocally(obj, object = attributeSet.getAttribute(obj))) continue;
            this.removeAttribute(obj);
        }
    }

    @Override
    public void removeAttributes(Enumeration<?> enumeration) {
        while (enumeration.hasMoreElements()) {
            this.removeAttribute(enumeration.nextElement());
        }
    }

    @Override
    public void setResolveParent(AttributeSet attributeSet) {
        this.addAttribute(ResolveAttribute, attributeSet);
    }

    public String toString() {
        return this.tab.toString();
    }
}

