/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GlyphView
extends View
implements TabableView,
Cloneable {
    GlyphPainter glyphPainter;
    private int offset = 0;
    private int length = 0;
    private float tabX;
    private TabExpander tabExpander;
    private Segment cached = new Segment();

    public GlyphView(Element element) {
        super(element);
    }

    public GlyphPainter getGlyphPainter() {
        return this.glyphPainter;
    }

    public void setGlyphPainter(GlyphPainter glyphPainter) {
        this.glyphPainter = glyphPainter;
    }

    protected void checkPainter() {
        if (this.glyphPainter == null) {
            if ("true".equals(SystemProperties.getProperty("gnu.javax.swing.noGraphics2D"))) {
                this.glyphPainter = new DefaultGlyphPainter();
            } else {
                Segment segment = this.getText(this.getStartOffset(), this.getEndOffset());
                this.glyphPainter = new J2DGlyphPainter(segment.toString(), this.getFont(), new FontRenderContext(null, false, false));
            }
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        Highlighter highlighter;
        Color color;
        this.checkPainter();
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        Container container = this.getContainer();
        Color color2 = this.getForeground();
        JTextComponent jTextComponent = null;
        if (container instanceof JTextComponent && !(jTextComponent = (JTextComponent)container).isEnabled()) {
            color2 = jTextComponent.getDisabledTextColor();
        }
        if ((color = this.getBackground()) != null) {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (jTextComponent != null && (highlighter = jTextComponent.getHighlighter()) instanceof LayeredHighlighter) {
            LayeredHighlighter layeredHighlighter = (LayeredHighlighter)highlighter;
            layeredHighlighter.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, this);
        }
        graphics.setColor(color2);
        this.glyphPainter.paint(this, graphics, shape, n, n2);
        boolean bl = this.isUnderline();
        boolean bl2 = this.isStrikeThrough();
        if (bl || bl2) {
            int n3;
            View view = this.getParent();
            if (view != null && view.getEndOffset() == n2) {
                Segment segment = this.getText(n, n2);
                while (segment.count > 0 && Character.isWhitespace(segment.array[segment.count - 1])) {
                    --n2;
                    --segment.count;
                }
            }
            int n4 = rectangle.x;
            int n5 = this.getStartOffset();
            TabExpander tabExpander = this.getTabExpander();
            if (n5 != n) {
                n4 += (int)this.glyphPainter.getSpan(this, n5, n, tabExpander, n4);
            }
            int n6 = n4 + (int)this.glyphPainter.getSpan(this, n, n2, tabExpander, n4);
            int n7 = rectangle.y + rectangle.height - (int)this.glyphPainter.getDescent(this);
            if (bl) {
                n3 = n7;
                graphics.drawLine(n4, ++n3, n6, n3);
            }
            if (bl2) {
                n3 = n7;
                graphics.drawLine(n4, n3 -= (int)this.glyphPainter.getAscent(this), n6, n3);
            }
        }
    }

    public float getPreferredSpan(int n) {
        float f = 0.0f;
        this.checkPainter();
        GlyphPainter glyphPainter = this.getGlyphPainter();
        switch (n) {
            case 0: {
                TabExpander tabExpander = null;
                View view = this.getParent();
                if (view instanceof TabExpander) {
                    tabExpander = (TabExpander)((Object)view);
                }
                f = glyphPainter.getSpan(this, this.getStartOffset(), this.getEndOffset(), tabExpander, 0.0f);
                break;
            }
            case 1: {
                f = glyphPainter.getHeight(this);
                if (!this.isSuperscript()) break;
                f += f / 3.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal axis");
            }
        }
        return f;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        GlyphPainter glyphPainter = this.getGlyphPainter();
        return glyphPainter.modelToView(this, n, bias, shape);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.checkPainter();
        GlyphPainter glyphPainter = this.getGlyphPainter();
        return glyphPainter.viewToModel(this, f, f2, shape, biasArray);
    }

    public TabExpander getTabExpander() {
        return this.tabExpander;
    }

    public float getTabbedSpan(float f, TabExpander tabExpander) {
        this.checkPainter();
        TabExpander tabExpander2 = this.tabExpander;
        this.tabExpander = tabExpander;
        if (this.tabExpander != tabExpander2) {
            this.preferenceChanged(null, true, false);
        }
        this.tabX = f;
        return this.getGlyphPainter().getSpan(this, this.getStartOffset(), this.getEndOffset(), this.tabExpander, f);
    }

    public float getPartialSpan(int n, int n2) {
        this.checkPainter();
        return this.glyphPainter.getSpan(this, n, n2, this.tabExpander, this.tabX);
    }

    public int getStartOffset() {
        Element element = this.getElement();
        int n = element.getStartOffset();
        if (this.length > 0) {
            n += this.offset;
        }
        return n;
    }

    public int getEndOffset() {
        Element element = this.getElement();
        int n = this.length > 0 ? element.getStartOffset() + this.offset + this.length : element.getEndOffset();
        return n;
    }

    public Segment getText(int n, int n2) {
        try {
            this.getDocument().getText(n, n2 - n, this.cached);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)("BadLocationException should not be thrown here. p0 = " + n + ", p1 = " + n2));
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        return this.cached;
    }

    public Font getFont() {
        Document document = this.getDocument();
        Font font = null;
        if (document instanceof StyledDocument) {
            StyledDocument styledDocument = (StyledDocument)document;
            font = styledDocument.getFont(this.getAttributes());
        } else {
            Container container = this.getContainer();
            if (container != null) {
                font = container.getFont();
            }
        }
        return font;
    }

    public Color getForeground() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return (Color)attributeSet.getAttribute(StyleConstants.Background);
    }

    public boolean isStrikeThrough() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.isStrikeThrough(attributeSet);
    }

    public boolean isSubscript() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.isSubscript(attributeSet);
    }

    public boolean isSuperscript() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.isSuperscript(attributeSet);
    }

    public boolean isUnderline() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.isUnderline(attributeSet);
    }

    protected final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            AssertionError assertionError = new AssertionError((Object)"CloneNotSupportedException must not be thrown here");
            ((Throwable)((Object)assertionError)).initCause(cloneNotSupportedException);
            throw assertionError;
        }
    }

    public View breakView(int n, int n2, float f, float f2) {
        View view = this;
        if (n == 0) {
            this.checkPainter();
            int n3 = this.glyphPainter.getBoundedPosition(this, n2, f, f2);
            int n4 = this.getBreakLocation(n2, n3);
            if (n4 != -1) {
                n3 = n4;
            }
            if ((n2 != this.getStartOffset() || n3 != this.getEndOffset()) && (view = this.createFragment(n2, n3)) instanceof GlyphView) {
                view.tabX = f;
            }
        }
        return view;
    }

    public int getBreakWeight(int n, float f, float f2) {
        int n2;
        if (n == 1) {
            n2 = super.getBreakWeight(n, f, f2);
        } else {
            this.checkPainter();
            int n3 = this.getStartOffset();
            int n4 = this.glyphPainter.getBoundedPosition(this, n3, f, f2);
            n2 = n4 == 0 ? 0 : (this.getBreakLocation(n3, n4) != -1 ? 2000 : 1000);
        }
        return n2;
    }

    private int getBreakLocation(int n, int n2) {
        int n3 = -1;
        Segment segment = this.getText(n, n2);
        char c = segment.last();
        while (c != '\uffff' && n3 == -1) {
            if (Character.isWhitespace(c)) {
                n3 = segment.getIndex() - segment.getBeginIndex() + 1 + n;
            }
            c = segment.previous();
        }
        return n3;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, true);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, false);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(null, true, false);
    }

    public View createFragment(int n, int n2) {
        this.checkPainter();
        Element element = this.getElement();
        GlyphView glyphView = (GlyphView)this.clone();
        glyphView.offset = n - element.getStartOffset();
        glyphView.length = n2 - n;
        glyphView.glyphPainter = this.glyphPainter.getPainter(glyphView, n, n2);
        return glyphView;
    }

    public float getAlignment(int n) {
        float f;
        this.checkPainter();
        if (n == 1) {
            GlyphPainter glyphPainter = this.getGlyphPainter();
            float f2 = glyphPainter.getHeight(this);
            float f3 = glyphPainter.getDescent(this);
            float f4 = glyphPainter.getAscent(this);
            f = this.isSuperscript() ? 1.0f : (this.isSubscript() ? (f2 > 0.0f ? (f2 - (f3 + f4 / 2.0f)) / f2 : 0.0f) : (f2 > 0.0f ? (f2 - f3) / f2 : 0.0f));
        } else {
            f = super.getAlignment(n);
        }
        return f;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        this.checkPainter();
        GlyphPainter glyphPainter = this.getGlyphPainter();
        return glyphPainter.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    static class DefaultGlyphPainter
    extends GlyphPainter {
        FontMetrics fontMetrics;

        DefaultGlyphPainter() {
        }

        public float getHeight(GlyphView glyphView) {
            this.updateFontMetrics(glyphView);
            float f = this.fontMetrics.getHeight();
            return f;
        }

        public void paint(GlyphView glyphView, Graphics graphics, Shape shape, int n, int n2) {
            int n3;
            this.updateFontMetrics(glyphView);
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            TabExpander tabExpander = glyphView.getTabExpander();
            Segment segment = glyphView.getText(n, n2);
            int n4 = rectangle.x;
            int n5 = glyphView.getStartOffset();
            if (n5 != n) {
                n3 = Utilities.getTabbedTextWidth(segment, this.fontMetrics, n4, tabExpander, n5);
                n4 += n3;
            }
            n3 = rectangle.y + this.fontMetrics.getHeight() - this.fontMetrics.getDescent();
            graphics.setFont(this.fontMetrics.getFont());
            Utilities.drawTabbedText(segment, n4, n3, graphics, tabExpander, n);
        }

        public Shape modelToView(GlyphView glyphView, int n, Position.Bias bias, Shape shape) throws BadLocationException {
            this.updateFontMetrics(glyphView);
            Element element = glyphView.getElement();
            Segment segment = glyphView.getText(element.getStartOffset(), n);
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            TabExpander tabExpander = glyphView.getTabExpander();
            int n2 = Utilities.getTabbedTextWidth(segment, this.fontMetrics, rectangle.x, tabExpander, glyphView.getStartOffset());
            int n3 = this.fontMetrics.getHeight();
            Rectangle rectangle2 = new Rectangle(rectangle.x + n2, rectangle.y, 0, n3);
            return rectangle2;
        }

        public float getSpan(GlyphView glyphView, int n, int n2, TabExpander tabExpander, float f) {
            this.updateFontMetrics(glyphView);
            Segment segment = glyphView.getText(n, n2);
            int n3 = Utilities.getTabbedTextWidth(segment, this.fontMetrics, (int)f, tabExpander, n);
            return n3;
        }

        public float getAscent(GlyphView glyphView) {
            this.updateFontMetrics(glyphView);
            return this.fontMetrics.getAscent();
        }

        public float getDescent(GlyphView glyphView) {
            this.updateFontMetrics(glyphView);
            return this.fontMetrics.getDescent();
        }

        public int getBoundedPosition(GlyphView glyphView, int n, float f, float f2) {
            this.updateFontMetrics(glyphView);
            TabExpander tabExpander = glyphView.getTabExpander();
            Segment segment = glyphView.getText(n, glyphView.getEndOffset());
            int n2 = Utilities.getTabbedTextOffset(segment, this.fontMetrics, (int)f, (int)(f + f2), tabExpander, n, false);
            return n2 + n;
        }

        public int viewToModel(GlyphView glyphView, float f, float f2, Shape shape, Position.Bias[] biasArray) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            int n = glyphView.getStartOffset();
            int n2 = glyphView.getEndOffset();
            TabExpander tabExpander = glyphView.getTabExpander();
            Segment segment = glyphView.getText(n, n2);
            int n3 = Utilities.getTabbedTextOffset(segment, this.fontMetrics, rectangle.x, (int)f, tabExpander, n);
            int n4 = n + n3;
            if (n4 == n2) {
                --n4;
            }
            biasArray[0] = Position.Bias.Forward;
            return n4;
        }

        private void updateFontMetrics(GlyphView glyphView) {
            Font font = glyphView.getFont();
            if (this.fontMetrics == null || !font.equals(this.fontMetrics.getFont())) {
                Container container = glyphView.getContainer();
                FontMetrics fontMetrics = container != null ? container.getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
                this.fontMetrics = fontMetrics;
            }
        }
    }

    private static class J2DGlyphPainter
    extends GlyphPainter {
        TextLayout textLayout;

        J2DGlyphPainter(String string, Font font, FontRenderContext fontRenderContext) {
            this.textLayout = new TextLayout(string, font, fontRenderContext);
        }

        public GlyphPainter getPainter(GlyphView glyphView, int n, int n2) {
            return null;
        }

        public float getAscent(GlyphView glyphView) {
            return this.textLayout.getAscent();
        }

        public int getBoundedPosition(GlyphView glyphView, int n, float f, float f2) {
            int n2;
            TextHitInfo textHitInfo = this.textLayout.hitTestChar(f2, 0.0f);
            if (textHitInfo.getCharIndex() == -1 && !this.textLayout.isLeftToRight()) {
                n2 = glyphView.getEndOffset();
            } else {
                n2 = textHitInfo.isLeadingEdge() ? textHitInfo.getInsertionIndex() : textHitInfo.getInsertionIndex() - 1;
                n2 += glyphView.getStartOffset();
            }
            return n2;
        }

        public float getDescent(GlyphView glyphView) {
            return this.textLayout.getDescent();
        }

        public float getHeight(GlyphView glyphView) {
            return this.textLayout.getAscent() + this.textLayout.getDescent() + this.textLayout.getLeading();
        }

        public float getSpan(GlyphView glyphView, int n, int n2, TabExpander tabExpander, float f) {
            float f2;
            if (n == glyphView.getStartOffset() && n2 == glyphView.getEndOffset()) {
                f2 = this.textLayout.getAdvance();
            } else {
                int n3 = glyphView.getStartOffset();
                int n4 = n - n3;
                int n5 = n2 - n3;
                TextHitInfo textHitInfo = TextHitInfo.afterOffset(n4);
                TextHitInfo textHitInfo2 = TextHitInfo.afterOffset(n5);
                float f3 = this.textLayout.getCaretInfo(textHitInfo)[0];
                float f4 = this.textLayout.getCaretInfo(textHitInfo2)[0];
                f2 = Math.abs(f4 - f3);
            }
            return f2;
        }

        public Shape modelToView(GlyphView glyphView, int n, Position.Bias bias, Shape shape) throws BadLocationException {
            int n2 = n - glyphView.getStartOffset();
            Rectangle2D rectangle2D = shape.getBounds2D();
            TextHitInfo textHitInfo = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(n2) : TextHitInfo.beforeOffset(n2);
            float[] fArray = this.textLayout.getCaretInfo(textHitInfo);
            rectangle2D.setRect(rectangle2D.getX() + (double)fArray[0], rectangle2D.getY(), 1.0, rectangle2D.getHeight());
            return rectangle2D;
        }

        public void paint(GlyphView glyphView, Graphics graphics, Shape shape, int n, int n2) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Rectangle2D rectangle2D = shape instanceof Rectangle2D ? (Rectangle2D)shape : shape.getBounds2D();
                float f = (float)rectangle2D.getX();
                float f2 = (float)rectangle2D.getY() + this.textLayout.getAscent() + this.textLayout.getLeading();
                this.textLayout.draw(graphics2D, f, f2);
            }
        }

        public int viewToModel(GlyphView glyphView, float f, float f2, Shape shape, Position.Bias[] biasArray) {
            Rectangle2D rectangle2D = shape instanceof Rectangle2D ? (Rectangle2D)shape : shape.getBounds2D();
            TextHitInfo textHitInfo = this.textLayout.hitTestChar(f - (float)rectangle2D.getX(), 0.0f);
            int n = textHitInfo.getInsertionIndex();
            biasArray[0] = textHitInfo.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
            return n + glyphView.getStartOffset();
        }
    }

    public static abstract class GlyphPainter {
        public abstract float getAscent(GlyphView var1);

        public abstract float getDescent(GlyphView var1);

        public abstract float getHeight(GlyphView var1);

        public abstract int getBoundedPosition(GlyphView var1, int var2, float var3, float var4);

        public abstract void paint(GlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(GlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(GlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract float getSpan(GlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public int getNextVisualPositionFrom(GlyphView glyphView, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = n;
            switch (n2) {
                case 3: {
                    n3 = n + 1;
                    break;
                }
                case 7: {
                    n3 = n - 1;
                    break;
                }
            }
            return n3;
        }

        public GlyphPainter getPainter(GlyphView glyphView, int n, int n2) {
            return this;
        }
    }
}

