/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class GapContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = -6226052713477823730L;
    static final int DEFAULT_BUFSIZE = 10;
    char[] buffer;
    int gapStart;
    int gapEnd;
    ArrayList marks;
    private int garbageMarks;
    private Mark searchMark = new Mark(0);
    ReferenceQueue queueOfDeath;

    public GapContent() {
        this(10);
    }

    public GapContent(int n) {
        n = Math.max(n, 2);
        this.buffer = (char[])this.allocateArray(n);
        this.gapStart = 1;
        this.gapEnd = n;
        this.buffer[0] = 10;
        this.marks = new ArrayList();
        this.queueOfDeath = new ReferenceQueue();
    }

    protected Object allocateArray(int n) {
        return new char[n];
    }

    protected int getArrayLength() {
        return this.buffer.length;
    }

    public int length() {
        return this.buffer.length - (this.gapEnd - this.gapStart);
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        int n2 = this.length();
        int n3 = string.length();
        if (n < 0) {
            throw new BadLocationException("The where argument cannot be smaller than the zero", n);
        }
        if (n > n2) {
            throw new BadLocationException("The where argument cannot be greater than the content length", n);
        }
        InsertUndo insertUndo = new InsertUndo(n, n3);
        this.replace(n, 0, string.toCharArray(), n3);
        return insertUndo;
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        int n3 = this.length();
        if (n + n2 >= n3) {
            throw new BadLocationException("where + nitems cannot be greater than the content length", n + n2);
        }
        String string = this.getString(n, n2);
        UndoRemove undoRemove = new UndoRemove(n, string);
        this.replace(n, n2, null, 0);
        return undoRemove;
    }

    public String getString(int n, int n2) throws BadLocationException {
        Segment segment = new Segment();
        try {
            this.getChars(n, n2, segment);
            return new String(segment.array, segment.offset, segment.count);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            int n3 = 0;
            n3 = segment.offset < 0 || segment.offset >= segment.array.length ? segment.offset : segment.offset + segment.count;
            throw new BadLocationException("Illegal location: array.length = " + segment.array.length + ", offset = " + segment.offset + ", count = " + segment.count, n3);
        }
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        int n3 = this.length();
        if (n < 0) {
            throw new BadLocationException("the where argument may not be below zero", n);
        }
        if (n >= n3) {
            throw new BadLocationException("the where argument cannot be greater than the content length", n);
        }
        if (n + n2 > n3) {
            throw new BadLocationException("len plus where cannot be greater than the content length", n2 + n);
        }
        if (n2 < 0) {
            throw new BadLocationException("negative length not allowed: ", n2);
        }
        if (n + n2 <= this.gapStart) {
            segment.array = this.buffer;
            segment.offset = n;
            segment.count = n2;
        } else if (n > this.gapStart) {
            segment.array = this.buffer;
            segment.offset = this.gapEnd + n - this.gapStart;
            segment.count = n2;
        } else {
            int n4 = this.gapStart - n;
            if (segment.isPartialReturn()) {
                segment.array = this.buffer;
                segment.offset = n;
                segment.count = n4;
            } else {
                segment.array = new char[n2];
                segment.offset = 0;
                System.arraycopy(this.buffer, n, segment.array, 0, n4);
                System.arraycopy(this.buffer, this.gapEnd, segment.array, n4, n2 - n4);
                segment.count = n2;
            }
        }
    }

    public Position createPosition(int n) throws BadLocationException {
        GapContentPosition gapContentPosition;
        block7: {
            Mark mark;
            int n2;
            int n3;
            block6: {
                while (this.queueOfDeath.poll() != null) {
                    ++this.garbageMarks;
                }
                if (this.garbageMarks > Math.max(5, this.marks.size() / 10)) {
                    this.garbageCollect();
                }
                n3 = n;
                if (n >= this.gapStart) {
                    n3 += this.gapEnd - this.gapStart;
                }
                this.searchMark.mark = n3;
                n2 = this.search(this.searchMark);
                if (n2 >= this.marks.size()) break block6;
                mark = (Mark)this.marks.get(n2);
                if (mark.mark == n3 && (gapContentPosition = mark.getPosition()) != null) break block7;
            }
            gapContentPosition = new GapContentPosition();
            gapContentPosition.mark = mark = new Mark(n3, gapContentPosition, this.queueOfDeath);
            this.marks.add(n2, mark);
        }
        return gapContentPosition;
    }

    protected void shiftEnd(int n) {
        assert (n > this.gapEnd - this.gapStart) : "The new gap size must be greater than the old gap size";
        int n2 = this.getGapEnd();
        int n3 = this.getArrayLength();
        int n4 = n3 - n2;
        int n5 = (n + 1) * 2;
        int n6 = n5 - n4;
        char[] cArray = (char[])this.allocateArray(n5);
        System.arraycopy(this.buffer, 0, cArray, 0, Math.min(n5, n3));
        this.buffer = cArray;
        this.gapEnd = n6;
        if (n4 != 0) {
            System.arraycopy(this.buffer, n2, this.buffer, n6, n4);
        }
        int n7 = this.gapEnd - n2;
        int n8 = this.searchFirst(n2);
        int n9 = this.marks.size();
        for (int i = n8; i < n9; ++i) {
            Mark mark = (Mark)this.marks.get(i);
            mark.mark += n7;
        }
    }

    protected void shiftGap(int n) {
        int n2 = this.gapStart;
        int n3 = n - n2;
        int n4 = this.gapEnd;
        int n5 = n4 + n3;
        int n6 = n4 - n2;
        this.gapStart = n;
        this.gapEnd = n5;
        if (n3 > 0) {
            System.arraycopy(this.buffer, n4, this.buffer, n2, n3);
        } else {
            System.arraycopy(this.buffer, n, this.buffer, n5, -n3);
        }
        if (n3 > 0) {
            int n7 = this.searchFirst(n2);
            int n8 = this.marks.size();
            for (int i = n7; i < n8; ++i) {
                Mark mark = (Mark)this.marks.get(i);
                if (mark.mark < n5) {
                    mark.mark -= n6;
                    continue;
                }
                break;
            }
        } else if (n3 < 0) {
            int n9 = this.searchFirst(n);
            int n10 = this.marks.size();
            for (int i = n9; i < n10; ++i) {
                Mark mark = (Mark)this.marks.get(i);
                if (mark.mark < n4) {
                    mark.mark += n6;
                    continue;
                }
                break;
            }
        }
        this.resetMarksAtZero();
    }

    protected void shiftGapStartDown(int n) {
        if (n == this.gapStart) {
            return;
        }
        assert (n < this.gapStart) : "The new gap start must be less than the old gap start.";
        int n2 = this.searchFirst(n);
        int n3 = this.marks.size();
        for (int i = n2; i < n3; ++i) {
            Mark mark = (Mark)this.marks.get(i);
            if (mark.mark > this.gapStart) break;
            mark.mark = this.gapEnd;
        }
        this.gapStart = n;
        this.resetMarksAtZero();
    }

    protected void shiftGapEndUp(int n) {
        if (n == this.gapEnd) {
            return;
        }
        assert (n > this.gapEnd) : "The new gap end must be greater than the old gap end.";
        int n2 = this.searchFirst(this.gapEnd);
        int n3 = this.marks.size();
        for (int i = n2; i < n3; ++i) {
            Mark mark = (Mark)this.marks.get(i);
            if (mark.mark >= n) break;
            mark.mark = n;
        }
        this.gapEnd = n;
        this.resetMarksAtZero();
    }

    protected final Object getArray() {
        return this.buffer;
    }

    protected void replace(int n, int n2, Object object, int n3) {
        if (n3 == 0) {
            this.removeImpl(n, n2);
            return;
        }
        if (n2 > n3) {
            this.removeImpl(n + n3, n2 - n3);
        } else {
            int n4 = n3 - n2;
            int n5 = this.addImpl(n + n2, n4);
            System.arraycopy(object, n2, this.buffer, n5, n4);
            n3 = n2;
        }
        System.arraycopy(object, 0, this.buffer, n, n3);
    }

    private void removeImpl(int n, int n2) {
        if (n2 > 0) {
            int n3 = n + n2;
            int n4 = this.gapEnd - this.gapStart + n2;
            if (n3 <= this.gapStart) {
                if (this.gapStart != n3) {
                    this.shiftGap(n3);
                }
                this.shiftGapStartDown(this.gapStart - n2);
            } else if (n >= this.gapStart) {
                if (this.gapStart != n) {
                    this.shiftGap(n);
                }
                this.shiftGapEndUp(this.gapStart + n4);
            } else {
                this.shiftGapStartDown(n);
                this.shiftGapEndUp(this.gapStart + n4);
            }
        }
    }

    private int addImpl(int n, int n2) {
        int n3 = this.gapEnd - this.gapStart;
        if (n2 == 0) {
            if (n > this.gapStart) {
                n += n3;
            }
            return n;
        }
        this.shiftGap(n);
        if (n2 >= n3) {
            this.shiftEnd(this.getArrayLength() - n3 + n2);
            n3 = this.gapEnd - this.gapStart;
        }
        this.gapStart += n2;
        return n;
    }

    protected final int getGapStart() {
        return this.gapStart;
    }

    protected final int getGapEnd() {
        return this.gapEnd;
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        int n3;
        int n4;
        int n5 = n + n2;
        if (n < this.gapStart) {
            n4 = n == 0 ? 0 : this.searchFirst(n);
            n3 = n5 >= this.gapStart ? this.searchFirst(n5 + (this.gapEnd - this.gapStart) + 1) : this.searchFirst(n5 + 1);
        } else {
            n4 = this.searchFirst(n + (this.gapEnd - this.gapStart));
            n3 = this.searchFirst(n5 + (this.gapEnd - this.gapStart) + 1);
        }
        if (vector == null) {
            vector = new Vector<UndoPosRef>();
        }
        for (int i = n4; i < n3; ++i) {
            vector.add(new UndoPosRef((Mark)this.marks.get(i)));
        }
        return vector;
    }

    protected void resetMarksAtZero() {
        if (this.gapStart != 0) {
            return;
        }
        for (int i = 0; i < this.marks.size(); ++i) {
            Mark mark = (Mark)this.marks.get(i);
            if (mark.mark > this.gapEnd) continue;
            mark.mark = 0;
        }
    }

    protected void updateUndoPositions(Vector vector, int n, int n2) {
        for (UndoPosRef undoPosRef : vector) {
            undoPosRef.reset();
        }
        Collections.sort(this.marks);
    }

    private void dump() {
        System.err.println("GapContent debug information");
        System.err.println("buffer length: " + this.buffer.length);
        System.err.println("gap start: " + this.gapStart);
        System.err.println("gap end: " + this.gapEnd);
        for (int i = 0; i < this.buffer.length; ++i) {
            if (i == this.gapStart) {
                System.err.print('<');
            }
            if (i == this.gapEnd) {
                System.err.print('>');
            }
            if (!Character.isISOControl(this.buffer[i])) {
                System.err.print(this.buffer[i]);
                continue;
            }
            System.err.print('.');
        }
        System.err.println();
    }

    private void dumpMarks() {
        System.out.print("positionMarks: ");
        for (int i = 0; i < this.marks.size(); ++i) {
            System.out.print(((Mark)this.marks.get((int)i)).mark + ", ");
        }
        System.out.println();
    }

    int search(Mark mark) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.marks.size() - 1;
        int n4 = 0;
        if (n3 > -1) {
            int n5 = 0;
            Mark mark2 = (Mark)this.marks.get(n3);
            n5 = this.compare(mark, mark2);
            if (n5 > 0) {
                n = n3 + 1;
                bl = true;
            } else {
                while (n2 <= n3 && !bl) {
                    n4 = n2 + (n3 - n2) / 2;
                    Mark mark3 = (Mark)this.marks.get(n4);
                    n5 = this.compare(mark, mark3);
                    if (n5 == 0) {
                        n = n4;
                        bl = true;
                        continue;
                    }
                    if (n5 < 0) {
                        n3 = n4 - 1;
                        continue;
                    }
                    n2 = n4 + 1;
                }
                if (!bl) {
                    n = n5 < 0 ? n4 : n4 + 1;
                }
            }
        }
        return n;
    }

    private int searchFirst(int n) {
        this.searchMark.mark = Math.max(n, 1);
        int n2 = this.search(this.searchMark);
        for (int i = n2 - 1; i >= 0; --i) {
            Mark mark = (Mark)this.marks.get(i);
            if (mark.mark != n) break;
            --n2;
        }
        return n2;
    }

    private int compare(Mark mark, Mark mark2) {
        return mark.mark - mark2.mark;
    }

    private void garbageCollect() {
        int n = this.marks.size();
        ArrayList<Mark> arrayList = new ArrayList<Mark>();
        for (int i = 0; i < n; ++i) {
            Mark mark = (Mark)this.marks.get(i);
            if (mark.get() == null) continue;
            arrayList.add(mark);
        }
        this.marks = arrayList;
        this.garbageMarks = 0;
    }

    private class UndoRemove
    extends AbstractUndoableEdit {
        public int where;
        String text;
        private Vector positions;

        public UndoRemove(int n, String string) {
            this.where = n;
            this.text = string;
            this.positions = GapContent.this.getPositionsInRange(null, n, string.length());
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                GapContent.this.insertString(this.where, this.text);
                if (this.positions != null) {
                    GapContent.this.updateUndoPositions(this.positions, this.where, this.text.length());
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                this.text = GapContent.this.getString(this.where, this.text.length());
                this.positions = GapContent.this.getPositionsInRange(null, this.where, this.text.length());
                GapContent.this.remove(this.where, this.text.length());
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class InsertUndo
    extends AbstractUndoableEdit {
        public int where;
        public int length;
        String text;
        private Vector positions;

        public InsertUndo(int n, int n2) {
            this.where = n;
            this.length = n2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.positions = GapContent.this.getPositionsInRange(null, this.where, this.length);
                this.text = GapContent.this.getString(this.where, this.length);
                GapContent.this.remove(this.where, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                GapContent.this.insertString(this.where, this.text);
                if (this.positions != null) {
                    GapContent.this.updateUndoPositions(this.positions, this.where, this.length);
                    this.positions = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class UndoPosRef {
        private Mark mark;
        private int undoOffset;

        UndoPosRef(Mark mark) {
            this.mark = mark;
            this.undoOffset = this.mark.getOffset();
        }

        void reset() {
            this.mark.mark = this.undoOffset <= GapContent.this.gapStart ? this.undoOffset : GapContent.this.gapEnd - GapContent.this.gapStart + this.undoOffset;
        }
    }

    private class Mark
    extends WeakReference {
        int mark;

        Mark(int n) {
            super(null);
            this.mark = n;
        }

        Mark(int n, GapContentPosition gapContentPosition, ReferenceQueue referenceQueue) {
            super(gapContentPosition, referenceQueue);
            this.mark = n;
        }

        int getOffset() {
            int n = this.mark;
            if (this.mark >= GapContent.this.gapStart) {
                n -= GapContent.this.gapEnd - GapContent.this.gapStart;
            }
            return Math.max(0, n);
        }

        GapContentPosition getPosition() {
            return (GapContentPosition)this.get();
        }
    }

    class GapContentPosition
    implements Position {
        Mark mark;

        GapContentPosition() {
        }

        public int getOffset() {
            return this.mark.getOffset();
        }
    }
}

