/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Stack;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ElementIterator
implements Cloneable {
    private Element root;
    private Stack stack;

    public ElementIterator(Document document) {
        this.root = document.getDefaultRootElement();
    }

    public ElementIterator(Element element) {
        this.root = element;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Element current() {
        Element element;
        if (this.stack == null) {
            element = this.first();
        } else {
            element = null;
            if (!this.stack.isEmpty()) {
                ElementRef elementRef = (ElementRef)this.stack.peek();
                Element element2 = elementRef.element;
                int n = elementRef.index;
                element = n == -1 ? element2 : element2.getElement(n);
            }
        }
        return element;
    }

    public int depth() {
        int n = 0;
        if (this.stack != null) {
            n = this.stack.size();
        }
        return n;
    }

    public Element first() {
        Element element = null;
        if (this.root != null) {
            this.stack = new Stack();
            if (this.root.getElementCount() > 0) {
                this.stack.push(new ElementRef(this.root));
            }
            element = this.root;
        }
        return element;
    }

    public Element next() {
        Element element;
        if (this.stack == null) {
            element = this.first();
        } else {
            element = null;
            if (!this.stack.isEmpty()) {
                ElementRef elementRef = (ElementRef)this.stack.peek();
                Element element2 = elementRef.element;
                int n = elementRef.index++;
                if (element2.getElementCount() > n + 1) {
                    Element element3 = element2.getElement(n + 1);
                    if (!element3.isLeaf()) {
                        this.stack.push(new ElementRef(element3));
                    }
                    element = element3;
                    element = element3;
                } else {
                    this.stack.pop();
                    if (!this.stack.isEmpty()) {
                        ElementRef elementRef2 = (ElementRef)this.stack.peek();
                        ++elementRef2.index;
                        element = this.next();
                    }
                }
            }
        }
        return element;
    }

    public Element previous() {
        int n;
        Element element = null;
        if (this.stack != null && (n = this.stack.size()) > 0) {
            ElementRef elementRef = (ElementRef)this.stack.peek();
            Element element2 = elementRef.element;
            int n2 = elementRef.index;
            if (n2 > 0) {
                element = this.deepestLeaf(element2.getElement(--n2));
            } else if (n2 == 0) {
                element = element2;
            } else if (n2 == -1) {
                ElementRef elementRef2 = (ElementRef)this.stack.pop();
                ElementRef elementRef3 = (ElementRef)this.stack.peek();
                this.stack.push(elementRef2);
                n2 = elementRef3.index;
                element2 = elementRef3.element;
                element = n2 == -1 ? element2 : this.deepestLeaf(element2.getElement(n2));
            }
        }
        return element;
    }

    private Element deepestLeaf(Element element) {
        int n;
        Element element2 = element.isLeaf() ? element : ((n = element.getElementCount()) == 0 ? element : this.deepestLeaf(element.getElement(n - 1)));
        return element2;
    }

    private class ElementRef {
        Element element;
        int index;

        ElementRef(Element element) {
            this.element = element;
            this.index = -1;
        }
    }
}

