/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    private static final long serialVersionUID = 940485415728614849L;
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    protected ElementBuffer buffer = new ElementBuffer(this.createDefaultRoot());
    private StyleChangeListener styleChangeListener;

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleContext());
    }

    public DefaultStyledDocument(StyleContext styleContext) {
        this((AbstractDocument.Content)new GapContent(4096), styleContext);
    }

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext styleContext) {
        super(content, styleContext);
        this.setLogicalStyle(0, styleContext.getStyle("default"));
    }

    @Override
    public Style addStyle(String string, Style style) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        Style style2 = styleContext.addStyle(string, style);
        if (this.styleChangeListener == null) {
            this.styleChangeListener = new StyleChangeListener();
        }
        style2.addChangeListener(this.styleChangeListener);
        return style2;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        SectionElement sectionElement = new SectionElement();
        AbstractDocument.BranchElement branchElement = new AbstractDocument.BranchElement(sectionElement, null);
        Element[] elementArray = new Element[]{branchElement};
        sectionElement.replace(0, 0, elementArray);
        AbstractDocument.LeafElement leafElement = new AbstractDocument.LeafElement(branchElement, null, 0, 1);
        elementArray = new Element[]{leafElement};
        branchElement.replace(0, 0, elementArray);
        return sectionElement;
    }

    @Override
    public Element getCharacterElement(int n) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n2 = element.getElementIndex(n);
            element = element.getElement(n2);
        }
        return element;
    }

    @Override
    public Color getBackground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getBackground(attributeSet);
    }

    @Override
    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    @Override
    public Font getFont(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getFont(attributeSet);
    }

    @Override
    public Color getForeground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getForeground(attributeSet);
    }

    @Override
    public Style getLogicalStyle(int n) {
        Element element = this.getParagraphElement(n);
        AttributeSet attributeSet = element.getAttributes();
        AttributeSet attributeSet2 = attributeSet.getResolveParent();
        if (attributeSet2 instanceof Style) {
            return (Style)attributeSet2;
        }
        return null;
    }

    @Override
    public Element getParagraphElement(int n) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            element = element.getElement(element.getElementIndex(n));
        }
        if (element != null) {
            return element.getParentElement();
        }
        return element;
    }

    @Override
    public Style getStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyle(string);
    }

    @Override
    public void removeStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        styleContext.removeStyle(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        if (n2 == 0) {
            return;
        }
        try {
            Element element;
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            this.buffer.change(n, n2, defaultDocumentEvent);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3 && n4 != (element = this.getCharacterElement(n4)).getEndOffset()) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element, attributeSet, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n4 = element.getEndOffset();
            }
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogicalStyle(int n, Style style) {
        Element element = this.getParagraphElement(n);
        if (element == null) {
            return;
        }
        try {
            this.writeLock();
            if (!(element instanceof AbstractDocument.AbstractElement)) {
                throw new AssertionError((Object)"paragraph elements are expected to beinstances of AbstractDocument.AbstractElement");
            }
            AbstractDocument.AbstractElement abstractElement = (AbstractDocument.AbstractElement)element;
            abstractElement.setResolveParent(style);
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n2, n3 - n2, DocumentEvent.EventType.CHANGE);
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            Element element = this.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            int n4 = element.getElementIndex(n + n2 - 1);
            if (n4 < n3) {
                n4 = n3;
            }
            for (int i = n3; i <= n4; ++i) {
                Element element2 = element.getElement(i);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element2, attributeSet, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
            }
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        int n3 = n + n2;
        if (attributeSet == null) {
            attributeSet = SimpleAttributeSet.EMPTY;
        }
        Element element = this.getParagraphElement(n3);
        AttributeSet attributeSet2 = element.getAttributes();
        Element element2 = this.getParagraphElement(n);
        int n4 = element2.getElementIndex(n);
        Element element3 = element2.getElement(n4);
        AttributeSet attributeSet3 = element3.getAttributes();
        boolean bl = element3.getEndOffset() == n3;
        try {
            int n5;
            Object object;
            int n6;
            int n7;
            Segment segment = new Segment();
            ArrayList<ElementSpec> arrayList = new ArrayList<ElementSpec>();
            ElementSpec elementSpec = null;
            boolean bl2 = false;
            short s = 6;
            if (n > 0) {
                this.getText(n - 1, 1, segment);
                if (segment.array[segment.offset] == '\n') {
                    bl2 = true;
                    s = this.insertAfterNewline(element, element2, attributeSet2, arrayList, n, n3);
                    for (n7 = arrayList.size() - 1; n7 >= 0 && elementSpec == null; --n7) {
                        ElementSpec elementSpec2 = (ElementSpec)arrayList.get(n7);
                        if (elementSpec2.getType() != 1) continue;
                        elementSpec = elementSpec2;
                    }
                }
            }
            if (!bl2) {
                attributeSet2 = element2.getAttributes();
            }
            this.getText(n, n2, segment);
            n7 = segment.offset + segment.count;
            int n8 = segment.offset;
            for (int i = segment.offset; i < n7; ++i) {
                if (segment.array[i] != '\n') continue;
                n6 = i + 1;
                arrayList.add(new ElementSpec(attributeSet, 3, n6 - n8));
                arrayList.add(new ElementSpec(null, 2));
                elementSpec = new ElementSpec(attributeSet2, 1);
                arrayList.add(elementSpec);
                n8 = n6;
            }
            if (n8 < n7) {
                arrayList.add(new ElementSpec(attributeSet, 3, n7 - n8));
            }
            ElementSpec elementSpec3 = (ElementSpec)arrayList.get(0);
            n6 = this.getLength();
            if (elementSpec3.getType() == 3 && attributeSet3.isEqual(attributeSet)) {
                elementSpec3.setDirection((short)4);
            }
            if (elementSpec != null) {
                if (bl2) {
                    elementSpec.setDirection(s);
                } else if (element2.getEndOffset() != n3) {
                    elementSpec.setDirection((short)7);
                } else {
                    object = element2.getParentElement();
                    n5 = object.getElementIndex(n);
                    if (n5 + 1 < object.getElementCount() && !object.getElement(n5 + 1).isLeaf()) {
                        elementSpec.setDirection((short)5);
                    }
                }
            }
            if (bl && n3 < n6) {
                Element element4;
                object = (ElementSpec)arrayList.get(arrayList.size() - 1);
                if (((ElementSpec)object).getType() == 3 && (elementSpec == null && (element == element2 || bl2) || elementSpec != null && elementSpec.getDirection() != 6) && (element4 = element.getElement(n5 = element.getElementIndex(n3))).isLeaf() && attributeSet.isEqual(element4.getAttributes())) {
                    ((ElementSpec)object).setDirection((short)5);
                }
            } else if (!bl && elementSpec != null && elementSpec.getDirection() == 7 && ((ElementSpec)(object = (ElementSpec)arrayList.get(arrayList.size() - 1))).getType() == 3 && ((ElementSpec)object).getDirection() != 4 && attributeSet.isEqual(attributeSet3)) {
                ((ElementSpec)object).setDirection((short)5);
            }
            object = new ElementSpec[arrayList.size()];
            object = arrayList.toArray((T[])object);
            this.buffer.insert(n, n2, (ElementSpec[])object, defaultDocumentEvent);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    private short insertAfterNewline(Element element, Element element2, AttributeSet attributeSet, ArrayList arrayList, int n, int n2) {
        int n3 = 0;
        if (element.getParentElement() == element2.getParentElement()) {
            ElementSpec elementSpec = new ElementSpec(attributeSet, 2);
            arrayList.add(elementSpec);
            elementSpec = new ElementSpec(attributeSet, 1);
            arrayList.add(elementSpec);
            if (element2.getEndOffset() != n2) {
                n3 = 7;
            } else {
                Element element3 = element2.getParentElement();
                if (element3.getElementIndex(n) + 1 < element3.getElementCount()) {
                    n3 = 5;
                }
            }
        } else {
            Element element4;
            ArrayList<Element> arrayList2 = new ArrayList<Element>();
            ArrayList<Element> arrayList3 = new ArrayList<Element>();
            for (element4 = element2; element4 != null; element4 = element4.getParentElement()) {
                arrayList2.add(element4);
            }
            int n4 = -1;
            for (element4 = element; element4 != null && (n4 = arrayList2.indexOf(element4)) == 1; element4 = element4.getParentElement()) {
                arrayList3.add(element4);
            }
            if (element4 != null) {
                int n5;
                for (n5 = 0; n5 < n4; ++n5) {
                    arrayList.add(new ElementSpec(null, 2));
                }
                for (n5 = arrayList3.size() - 1; n5 >= 0; --n5) {
                    Element element5 = (Element)arrayList3.get(n5);
                    ElementSpec elementSpec = new ElementSpec(element5.getAttributes(), 1);
                    if (n5 > 0) {
                        elementSpec.setDirection((short)5);
                    }
                    arrayList.add(elementSpec);
                }
                n3 = arrayList3.size() > 0 ? 5 : 7;
            } else assert (false);
        }
        return (short)n3;
    }

    short handleInsertAfterNewline(Vector vector, int n, int n2, Element element, Element element2, AttributeSet attributeSet) {
        if (element.getParentElement() == element2.getParentElement()) {
            vector.add(new ElementSpec(attributeSet, 2));
            vector.add(new ElementSpec(attributeSet, 1));
            if (element2.getStartOffset() != n2) {
                return 7;
            }
            Element element3 = element2.getParentElement();
            if (element3.getElementCount() > element3.getElementIndex(n) + 1) {
                return 5;
            }
        }
        return 6;
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.removeUpdate(defaultDocumentEvent);
        this.buffer.remove(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength(), defaultDocumentEvent);
    }

    public Enumeration<?> getStyleNames() {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyleNames();
    }

    protected void styleChanged(Style style) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insert(int n, ElementSpec[] elementSpecArray) throws BadLocationException {
        block6: {
            block5: {
                if (elementSpecArray == null) return;
                if (elementSpecArray.length == 0) {
                    return;
                }
                try {
                    Object object;
                    int n2;
                    this.writeLock();
                    CPStringBuilder cPStringBuilder = new CPStringBuilder();
                    for (n2 = 0; n2 < elementSpecArray.length; ++n2) {
                        object = elementSpecArray[n2];
                        if (((ElementSpec)object).getArray() == null || ((ElementSpec)object).getLength() <= 0) continue;
                        cPStringBuilder.append(((ElementSpec)object).getArray(), ((ElementSpec)object).getOffset(), ((ElementSpec)object).getLength());
                    }
                    n2 = cPStringBuilder.length();
                    if (n2 == 0) {
                        Object var9_6 = null;
                        break block5;
                    }
                    object = this.getContent();
                    UndoableEdit undoableEdit = object.insertString(n, cPStringBuilder.toString());
                    AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.INSERT);
                    defaultDocumentEvent.addEdit(undoableEdit);
                    this.buffer.insert(n, n2, elementSpecArray, defaultDocumentEvent);
                    super.insertUpdate(defaultDocumentEvent, null);
                    defaultDocumentEvent.end();
                    this.fireInsertUpdate(defaultDocumentEvent);
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    this.writeUnlock();
                    throw throwable;
                }
            }
            this.writeUnlock();
            return;
        }
        Object var9_7 = null;
        this.writeUnlock();
    }

    protected void create(ElementSpec[] elementSpecArray) {
        try {
            try {
                Object object;
                int n = this.getLength();
                if (n > 0) {
                    this.remove(0, n);
                }
                this.writeLock();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < elementSpecArray.length; ++i) {
                    object = elementSpecArray[i];
                    if (((ElementSpec)object).getArray() == null || ((ElementSpec)object).getLength() <= 0) continue;
                    stringBuilder.append(((ElementSpec)object).getArray(), ((ElementSpec)object).getOffset(), ((ElementSpec)object).getLength());
                }
                AbstractDocument.Content content = this.getContent();
                object = content.insertString(0, stringBuilder.toString());
                n = stringBuilder.length();
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(0, stringBuilder.length(), DocumentEvent.EventType.INSERT);
                defaultDocumentEvent.addEdit((UndoableEdit)object);
                this.buffer.create(n, elementSpecArray, defaultDocumentEvent);
                super.insertUpdate(defaultDocumentEvent, null);
                defaultDocumentEvent.end();
                this.fireInsertUpdate(defaultDocumentEvent);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    private class StyleChangeListener
    implements ChangeListener {
        private StyleChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Style style = (Style)changeEvent.getSource();
            DefaultStyledDocument.this.styleChanged(style);
        }
    }

    protected class SectionElement
    extends AbstractDocument.BranchElement {
        public SectionElement() {
            super(null, null);
        }

        public String getName() {
            return "section";
        }
    }

    public class ElementBuffer
    implements Serializable {
        private static final long serialVersionUID = 1688745877691146623L;
        private Element root;
        private int offset;
        private int endOffset;
        private int length;
        private int pos;
        private Element fracturedParent;
        private Element fracturedChild;
        private boolean createdFracture;
        private Stack elementStack;
        private Edit[] insertPath;
        private boolean recreateLeafs;
        private ArrayList edits;
        private boolean offsetLastIndex;
        private boolean offsetLastIndexReplace;

        public ElementBuffer(Element element) {
            this.root = element;
        }

        public Element getRootElement() {
            return this.root;
        }

        public void remove(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.prepareEdit(n, n2);
            this.removeUpdate();
            this.finishEdit(defaultDocumentEvent);
        }

        protected void removeUpdate() {
            this.removeElements(this.root, this.offset, this.endOffset);
        }

        private boolean removeElements(Element element, int n, int n2) {
            boolean bl = false;
            if (!element.isLeaf()) {
                int n3 = element.getElementIndex(n);
                int n4 = element.getElementIndex(n2);
                this.elementStack.push(new Edit(element, n3));
                Edit edit = (Edit)this.elementStack.peek();
                if (n3 == n4) {
                    Element element2 = element.getElement(n3);
                    if (n <= element2.getStartOffset() && n2 >= element2.getEndOffset()) {
                        edit.removed.add(element2);
                    } else if (this.removeElements(element2, n, n2)) {
                        edit.removed.add(element2);
                    }
                } else {
                    boolean bl2;
                    Element element3 = element.getElement(n3);
                    Element element4 = element.getElement(n4);
                    boolean bl3 = bl2 = n2 < element.getEndOffset();
                    if (bl2 && this.canJoin(element3, element4)) {
                        for (int i = n3; i <= n4; ++i) {
                            edit.removed.add(element.getElement(i));
                        }
                        Element element5 = this.join(element, element3, element4, n, n2);
                        edit.added.add(element5);
                    } else {
                        int n5 = n3 + 1;
                        int n6 = n4 - 1;
                        if (element3.getStartOffset() == n || n3 == 0 && element3.getStartOffset() > n && element3.getEndOffset() <= n2) {
                            element3 = null;
                            n5 = n3;
                        }
                        if (!bl2) {
                            element4 = null;
                            ++n6;
                        } else if (element4.getStartOffset() == n2) {
                            element4 = null;
                        }
                        if (n5 <= n6) {
                            edit.index = n5;
                        }
                        for (int i = n5; i <= n6; ++i) {
                            edit.removed.add(element.getElement(i));
                        }
                        if (element3 != null && this.removeElements(element3, n, n2)) {
                            edit.removed.add(0, element3);
                            edit.index = n3;
                        }
                        if (element4 != null && this.removeElements(element4, n, n2)) {
                            edit.removed.add(element4);
                        }
                    }
                }
                this.pop();
                if (element.getElementCount() == edit.removed.size() - edit.added.size()) {
                    bl = true;
                }
            }
            return bl;
        }

        void create(int n, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            Object object;
            Object object2;
            this.prepareEdit(this.offset, n);
            Object object3 = this.root;
            int n2 = object3.getElementIndex(0);
            while (!object3.isLeaf()) {
                object2 = object3.getElement(n2);
                object = new Edit((Element)object3, n2, false);
                this.elementStack.push(object);
                object3 = object2;
                n2 = object3.getElementIndex(0);
            }
            object2 = (Edit)this.elementStack.peek();
            object = ((Edit)object2).e.getElement(((Edit)object2).index);
            ((Edit)object2).added.add(DefaultStyledDocument.this.createLeafElement(((Edit)object2).e, object.getAttributes(), DefaultStyledDocument.this.getLength(), object.getEndOffset()));
            ((Edit)object2).removed.add(object);
            while (this.elementStack.size() > 1) {
                this.pop();
            }
            int n3 = elementSpecArray.length;
            AttributeSet attributeSet = null;
            if (n3 > 0 && elementSpecArray[0].getType() == 1) {
                attributeSet = elementSpecArray[0].getAttributes();
            }
            if (attributeSet == null) {
                attributeSet = SimpleAttributeSet.EMPTY;
            }
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.root.getAttributes();
            defaultDocumentEvent.addEdit(new AttributeUndoableEdit(this.root, attributeSet, true));
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
            mutableAttributeSet.addAttributes(attributeSet);
            for (int i = 1; i < n3; ++i) {
                this.insertElement(elementSpecArray[i]);
            }
            while (this.elementStack.size() > 0) {
                this.pop();
            }
            this.finishEdit(defaultDocumentEvent);
        }

        private boolean canJoin(Element element, Element element2) {
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            if (element != null && element2 != null && (bl2 = element.isLeaf()) == (bl = element2.isLeaf())) {
                if (bl2) {
                    bl3 = element.getAttributes().isEqual(element2.getAttributes());
                } else {
                    String string = element.getName();
                    String string2 = element2.getName();
                    bl3 = string != null ? string.equals(string2) : (string2 != null ? string2.equals(string) : true);
                }
            }
            return bl3;
        }

        private Element join(Element element, Element element2, Element element3, int n, int n2) {
            Element element4 = null;
            if (element2.isLeaf() && element3.isLeaf()) {
                element4 = DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element3.getEndOffset());
            } else if (!element2.isLeaf() && !element3.isLeaf()) {
                int n3;
                Element element5;
                element4 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
                int n4 = element2.getElementIndex(n);
                int n5 = element3.getElementIndex(n2);
                Element element6 = element2.getElement(n4);
                if (element6.getStartOffset() >= n) {
                    element6 = null;
                }
                if ((element5 = element3.getElement(n5)).getStartOffset() == n2) {
                    element5 = null;
                }
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (int i = 0; i < n4; ++i) {
                    arrayList.add(this.clone(element4, element2.getElement(i)));
                }
                if (this.canJoin(element6, element5)) {
                    Element element7 = this.join(element4, element6, element5, n, n2);
                    arrayList.add(element7);
                } else {
                    if (element6 != null) {
                        arrayList.add(this.cloneAsNecessary(element4, element6, n, n2));
                    }
                    if (element5 != null) {
                        arrayList.add(this.cloneAsNecessary(element4, element5, n, n2));
                    }
                }
                int n6 = element3.getElementCount();
                int n7 = n3 = element5 == null ? n5 : n5 + 1;
                while (n3 < n6) {
                    arrayList.add(this.clone(element4, element3.getElement(n3)));
                    ++n3;
                }
                Element[] elementArray = new Element[arrayList.size()];
                elementArray = arrayList.toArray(elementArray);
                ((AbstractDocument.BranchElement)element4).replace(0, 0, elementArray);
            } else assert (false) : "Must not happen";
            return element4;
        }

        protected void changeUpdate() {
            boolean bl = this.split(this.offset, this.length);
            if (!bl) {
                while (this.elementStack.size() != 0) {
                    this.pop();
                }
                this.split(this.offset + this.length, 0);
            }
            while (this.elementStack.size() != 0) {
                this.pop();
            }
        }

        public void change(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.prepareEdit(n, n2);
            this.changeUpdate();
            this.finishEdit(defaultDocumentEvent);
        }

        public Element clone(Element element, Element element2) {
            Element element3 = element2;
            if (element2 instanceof AbstractDocument.BranchElement) {
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element2;
                AbstractDocument.BranchElement branchElement2 = new AbstractDocument.BranchElement(element, branchElement.getAttributes());
                int n = branchElement2.getElementCount();
                Element[] elementArray = new Element[n];
                for (int i = 0; i < n; ++i) {
                    elementArray[i] = this.clone(branchElement2, branchElement2.getElement(i));
                }
                branchElement2.replace(0, 0, elementArray);
                element3 = branchElement2;
            } else if (element2 instanceof AbstractDocument.LeafElement) {
                element3 = new AbstractDocument.LeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            return element3;
        }

        private Element cloneAsNecessary(Element element, Element element2, int n, int n2) {
            Element element3;
            if (element2.isLeaf()) {
                element3 = DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            } else {
                Element element4 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
                int n3 = element2.getElementCount();
                ArrayList<Element> arrayList = new ArrayList<Element>(n3);
                for (int i = 0; i < n3; ++i) {
                    Element element5 = element2.getElement(i);
                    if (element5.getStartOffset() >= n && element5.getEndOffset() <= n2) continue;
                    arrayList.add(this.cloneAsNecessary(element4, element5, n, n2));
                }
                Element[] elementArray = new Element[arrayList.size()];
                elementArray = arrayList.toArray(elementArray);
                ((AbstractDocument.BranchElement)element4).replace(0, 0, elementArray);
                element3 = element4;
            }
            return element3;
        }

        public void insert(int n, int n2, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            if (n2 > 0) {
                this.prepareEdit(n, n2);
                this.insertUpdate(elementSpecArray);
                this.finishEdit(defaultDocumentEvent);
            }
        }

        private void prepareEdit(int n, int n2) {
            this.offset = n;
            this.pos = n;
            this.endOffset = n + n2;
            this.length = n2;
            if (this.edits == null) {
                this.edits = new ArrayList();
            } else {
                this.edits.clear();
            }
            if (this.elementStack == null) {
                this.elementStack = new Stack();
            } else {
                this.elementStack.clear();
            }
            this.fracturedParent = null;
            this.fracturedChild = null;
            this.offsetLastIndex = false;
            this.offsetLastIndexReplace = false;
        }

        private void finishEdit(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            for (Edit edit : this.edits) {
                Element[] elementArray = new Element[edit.removed.size()];
                elementArray = edit.removed.toArray(elementArray);
                Element[] elementArray2 = new Element[edit.added.size()];
                elementArray2 = edit.added.toArray(elementArray2);
                int n = edit.index;
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)edit.e;
                branchElement.replace(n, elementArray.length, elementArray2);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n, elementArray, elementArray2);
                defaultDocumentEvent.addEdit(elementEdit);
            }
            this.edits.clear();
            this.elementStack.clear();
        }

        protected void insertUpdate(ElementSpec[] elementSpecArray) {
            Edit edit;
            int n;
            int n2;
            Element element = this.root;
            int n3 = element.getElementIndex(this.offset);
            while (!element.isLeaf()) {
                Element element2 = element.getElement(n3);
                n2 = element2.isLeaf() ? n3 : n3 + 1;
                Edit edit2 = new Edit(element, n2);
                this.elementStack.push(edit2);
                element = element2;
                n3 = element.getElementIndex(this.offset);
            }
            this.insertPath = new Edit[this.elementStack.size()];
            this.insertPath = this.elementStack.toArray((S[])this.insertPath);
            this.createdFracture = false;
            int n4 = 0;
            this.recreateLeafs = false;
            n2 = elementSpecArray[0].getType();
            if (n2 == 3) {
                this.insertFirstContentTag(elementSpecArray);
                this.pos += elementSpecArray[0].length;
                n4 = 1;
            } else {
                this.createFracture(elementSpecArray);
                n4 = 0;
            }
            while (n4 < elementSpecArray.length) {
                this.insertElement(elementSpecArray[n4]);
                ++n4;
            }
            if (!this.createdFracture) {
                this.fracture(-1);
            }
            while (this.elementStack.size() != 0) {
                this.pop();
            }
            if (this.offsetLastIndex && this.offsetLastIndexReplace) {
                ++this.insertPath[this.insertPath.length - 1].index;
            }
            for (n = this.insertPath.length - 1; n >= 0; --n) {
                edit = this.insertPath[n];
                if (edit.e == this.fracturedParent) {
                    edit.added.add(this.fracturedChild);
                }
                if (edit.added.size() <= 0 && edit.removed.size() <= 0 || this.edits.contains(edit)) continue;
                this.edits.add(edit);
            }
            if (this.offset == 0 && this.fracturedParent != null && elementSpecArray[0].getType() == 2) {
                for (n = 0; n < elementSpecArray.length && elementSpecArray[n].getType() == 2; ++n) {
                }
                edit = this.insertPath[this.insertPath.length - n - 1];
                --edit.index;
                edit.removed.add(0, edit.e.getElement(edit.index));
            }
        }

        private void pop() {
            Element element;
            Edit edit = (Edit)this.elementStack.peek();
            this.elementStack.pop();
            if (edit.added.size() > 0 || edit.removed.size() > 0) {
                this.edits.add(edit);
            } else if (!this.elementStack.isEmpty() && (element = edit.e).getElementCount() == 0) {
                edit = (Edit)this.elementStack.peek();
                edit.added.remove(element);
            }
        }

        private void insertElement(ElementSpec elementSpec) {
            if (this.elementStack.isEmpty()) {
                return;
            }
            Edit edit = (Edit)this.elementStack.peek();
            block0 : switch (elementSpec.getType()) {
                case 1: {
                    switch (elementSpec.getDirection()) {
                        case 7: {
                            if (!this.createdFracture) {
                                this.fracture(this.elementStack.size() - 1);
                            }
                            if (!edit.isFracture) {
                                Edit edit2 = new Edit(this.fracturedChild, 0, true);
                                this.elementStack.push(edit2);
                                break block0;
                            }
                            Element element = edit.e.getElement(0);
                            Edit edit3 = new Edit(element, 0, true);
                            this.elementStack.push(edit3);
                            break block0;
                        }
                        case 5: {
                            Element element = edit.e.getElement(edit.index);
                            if (element.isLeaf()) {
                                if (edit.index + 1 < edit.e.getElementCount()) {
                                    element = edit.e.getElement(edit.index + 1);
                                } else assert (false);
                            }
                            this.elementStack.push(new Edit(element, 0, true));
                            break block0;
                        }
                    }
                    Element element = DefaultStyledDocument.this.createBranchElement(edit.e, elementSpec.getAttributes());
                    edit.added.add(element);
                    this.elementStack.push(new Edit(element, 0));
                    break;
                }
                case 2: {
                    this.pop();
                    break;
                }
                case 3: {
                    this.insertContentTag(elementSpec, edit);
                }
            }
        }

        private void insertFirstContentTag(ElementSpec[] elementSpecArray) {
            ElementSpec elementSpec = elementSpecArray[0];
            Edit edit = (Edit)this.elementStack.peek();
            Element element = edit.e.getElement(edit.index);
            int n = this.offset + elementSpec.length;
            boolean bl = elementSpecArray.length == 1;
            switch (elementSpec.getDirection()) {
                case 4: {
                    if (element.getEndOffset() != n && !bl) {
                        Element element2 = DefaultStyledDocument.this.createLeafElement(edit.e, element.getAttributes(), element.getStartOffset(), n);
                        edit.added.add(element2);
                        edit.removed.add(element);
                        if (element.getEndOffset() != this.endOffset) {
                            this.recreateLeafs = true;
                            break;
                        }
                        this.offsetLastIndex = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                    this.offsetLastIndexReplace = true;
                    break;
                }
                case 5: {
                    if (this.offset == 0) break;
                    Element element3 = DefaultStyledDocument.this.createLeafElement(edit.e, element.getAttributes(), element.getStartOffset(), this.offset);
                    edit.added.add(element3);
                    Element element4 = edit.e.getElement(edit.index + 1);
                    element3 = bl ? DefaultStyledDocument.this.createLeafElement(edit.e, element4.getAttributes(), this.offset, element4.getEndOffset()) : DefaultStyledDocument.this.createLeafElement(edit.e, element4.getAttributes(), this.offset, n);
                    edit.added.add(element3);
                    edit.removed.add(element);
                    edit.removed.add(element4);
                    break;
                }
                default: {
                    Element element5;
                    if (element.getStartOffset() != this.offset) {
                        element5 = DefaultStyledDocument.this.createLeafElement(edit.e, element.getAttributes(), element.getStartOffset(), this.offset);
                        edit.added.add(element5);
                    }
                    edit.removed.add(element);
                    element5 = DefaultStyledDocument.this.createLeafElement(edit.e, elementSpec.getAttributes(), this.offset, n);
                    edit.added.add(element5);
                    if (element.getEndOffset() != this.endOffset) {
                        this.recreateLeafs = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                }
            }
        }

        private void insertContentTag(ElementSpec elementSpec, Edit edit) {
            int n = elementSpec.getLength();
            short s = elementSpec.getDirection();
            if (s == 5) {
                if (!edit.isFracture) {
                    Element element = null;
                    if (this.insertPath != null) {
                        for (int i = this.insertPath.length - 1; i >= 0; --i) {
                            if (this.insertPath[i] != edit) continue;
                            if (i == this.insertPath.length - 1) break;
                            element = edit.e.getElement(edit.index);
                            break;
                        }
                    }
                    if (element == null) {
                        element = edit.e.getElement(edit.index + 1);
                    }
                    Element element2 = DefaultStyledDocument.this.createLeafElement(edit.e, element.getAttributes(), this.pos, element.getEndOffset());
                    edit.added.add(element2);
                    edit.removed.add(element);
                } else {
                    Element element = edit.e.getElement(0);
                    Element element3 = DefaultStyledDocument.this.createLeafElement(edit.e, element.getAttributes(), this.pos, element.getEndOffset());
                    edit.added.add(element3);
                    edit.removed.add(element);
                }
            } else {
                Element element = DefaultStyledDocument.this.createLeafElement(edit.e, elementSpec.getAttributes(), this.pos, this.pos + n);
                edit.added.add(element);
            }
            this.pos += n;
        }

        private void createFracture(ElementSpec[] elementSpecArray) {
            Edit edit = (Edit)this.elementStack.peek();
            Element element = edit.e.getElement(edit.index);
            if (this.offset != 0) {
                Element element2 = DefaultStyledDocument.this.createLeafElement(edit.e, element.getAttributes(), element.getStartOffset(), this.offset);
                edit.added.add(element2);
            }
            edit.removed.add(element);
            if (element.getEndOffset() != this.endOffset) {
                this.recreateLeafs = true;
            } else {
                this.offsetLastIndex = true;
            }
        }

        private void fracture(int n) {
            int n2 = this.insertPath.length;
            int n3 = -1;
            boolean bl = this.recreateLeafs;
            Edit edit = this.insertPath[n2 - 1];
            boolean bl2 = edit.index + 1 < edit.e.getElementCount();
            int n4 = bl ? n2 : -1;
            int n5 = n2 - 1;
            this.createdFracture = true;
            for (int i = n2 - 2; i >= 0; --i) {
                Edit edit2 = this.insertPath[i];
                if (edit2.added.size() > 0 || i == n) {
                    n3 = i;
                    if (!bl && bl2) {
                        bl = true;
                        if (n4 == -1) {
                            n4 = n5 + 1;
                        }
                    }
                }
                if (bl2 || edit2.index >= edit2.e.getElementCount()) continue;
                bl2 = true;
                n5 = i;
            }
            if (bl) {
                if (n3 == -1) {
                    n3 = n2 - 1;
                }
                this.recreate(n3, n4);
            }
        }

        private void recreate(int n, int n2) {
            Edit edit = this.insertPath[n];
            int n3 = this.insertPath.length;
            Object object = n + 1 == n3 ? edit.e.getElement(edit.index) : edit.e.getElement(edit.index - 1);
            Element element = object.isLeaf() ? DefaultStyledDocument.this.createLeafElement(edit.e, object.getAttributes(), Math.max(this.endOffset, object.getStartOffset()), object.getEndOffset()) : DefaultStyledDocument.this.createBranchElement(edit.e, object.getAttributes());
            this.fracturedParent = edit.e;
            this.fracturedChild = element;
            Element element2 = element;
            while (++n < n2) {
                Element[] elementArray;
                int n4;
                boolean bl = n + 1 == n2;
                boolean bl2 = n + 1 == n3;
                edit = this.insertPath[n];
                object = bl ? (this.offsetLastIndex || !bl2 ? null : edit.e.getElement(edit.index)) : edit.e.getElement(edit.index - 1);
                element = object != null ? (object.isLeaf() ? DefaultStyledDocument.this.createLeafElement(element2, object.getAttributes(), Math.max(this.endOffset, object.getStartOffset()), object.getEndOffset()) : DefaultStyledDocument.this.createBranchElement(element2, object.getAttributes())) : null;
                int n5 = edit.e.getElementCount() - edit.index;
                int n6 = 1;
                if (element == null) {
                    if (bl2) {
                        --n5;
                        n4 = edit.index + 1;
                    } else {
                        n4 = edit.index;
                    }
                    n6 = 0;
                    elementArray = new Element[n5];
                } else {
                    if (!bl) {
                        ++n5;
                        n4 = edit.index;
                    } else {
                        n4 = edit.index + 1;
                    }
                    elementArray = new Element[n5];
                    elementArray[0] = element;
                }
                for (int i = n6; i < n5; ++i) {
                    Element element3 = edit.e.getElement(n4++);
                    elementArray[i] = this.recreateFracturedElement(element2, element3);
                    edit.removed.add(element3);
                }
                ((AbstractDocument.BranchElement)element2).replace(0, 0, elementArray);
                element2 = element;
            }
        }

        private Element recreateFracturedElement(Element element, Element element2) {
            Element element3;
            if (element2.isLeaf()) {
                element3 = DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), Math.max(element2.getStartOffset(), this.endOffset), element2.getEndOffset());
            } else {
                Element element4 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
                int n = element2.getElementCount();
                Element[] elementArray = new Element[n];
                for (int i = 0; i < n; ++i) {
                    elementArray[i] = this.recreateFracturedElement(element4, element2.getElement(i));
                }
                ((AbstractDocument.BranchElement)element4).replace(0, 0, elementArray);
                element3 = element4;
            }
            return element3;
        }

        private boolean split(int n, int n2) {
            boolean bl = false;
            Element element = this.root;
            int n3 = element.getElementIndex(n);
            while (!element.isLeaf()) {
                this.elementStack.push(new Edit(element, n3));
                element = element.getElement(n3);
                n3 = element.getElementIndex(n);
            }
            Edit edit = (Edit)this.elementStack.peek();
            Element element2 = edit.e.getElement(edit.index);
            if (element2.getStartOffset() < n && n < element2.getEndOffset()) {
                int n4;
                int n5 = n4 = edit.index;
                if (n + n2 < edit.e.getEndOffset() && n2 != 0) {
                    n5 = edit.e.getElementIndex(n + n2);
                    if (n5 == n4) {
                        edit.removed.add(element2);
                        element = DefaultStyledDocument.this.createLeafElement(edit.e, element2.getAttributes(), element2.getStartOffset(), n);
                        edit.added.add(element);
                        element = DefaultStyledDocument.this.createLeafElement(edit.e, element2.getAttributes(), n, n + n2);
                        edit.added.add(element);
                        element = DefaultStyledDocument.this.createLeafElement(edit.e, element2.getAttributes(), n + n2, element2.getEndOffset());
                        edit.added.add(element);
                        return true;
                    }
                    element2 = edit.e.getElement(n5);
                    if (n + n2 == element2.getStartOffset()) {
                        n5 = n4;
                    }
                    bl = true;
                }
                this.pos = n;
                element2 = edit.e.getElement(n4);
                edit.removed.add(element2);
                element = DefaultStyledDocument.this.createLeafElement(edit.e, element2.getAttributes(), element2.getStartOffset(), this.pos);
                edit.added.add(element);
                element = DefaultStyledDocument.this.createLeafElement(edit.e, element2.getAttributes(), this.pos, element2.getEndOffset());
                edit.added.add(element);
                for (int i = n4 + 1; i < n5; ++i) {
                    element2 = edit.e.getElement(i);
                    edit.removed.add(element2);
                    edit.added.add(element2);
                }
                if (n5 != n4) {
                    element2 = edit.e.getElement(n5);
                    this.pos = n + n2;
                    edit.removed.add(element2);
                    element = DefaultStyledDocument.this.createLeafElement(edit.e, element2.getAttributes(), element2.getStartOffset(), this.pos);
                    edit.added.add(element);
                    element = DefaultStyledDocument.this.createLeafElement(edit.e, element2.getAttributes(), this.pos, element2.getEndOffset());
                    edit.added.add(element);
                }
            }
            return bl;
        }

        class Edit {
            Element e;
            int index;
            ArrayList removed = new ArrayList();
            ArrayList added = new ArrayList();
            boolean isFracture;

            Edit(Element element, int n) {
                this(element, n, false);
            }

            Edit(Element element, int n, boolean bl) {
                this.e = element;
                this.index = n;
                this.isFracture = bl;
            }
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        public static final short JoinFractureDirection = 7;
        short type;
        short direction;
        int offset;
        int length;
        char[] content;
        AttributeSet attributes;

        public ElementSpec(AttributeSet attributeSet, short s) {
            this(attributeSet, s, 0);
        }

        public ElementSpec(AttributeSet attributeSet, short s, int n) {
            this(attributeSet, s, null, 0, n);
        }

        public ElementSpec(AttributeSet attributeSet, short s, char[] cArray, int n, int n2) {
            this.attributes = attributeSet;
            this.type = s;
            this.offset = n;
            this.length = n2;
            this.content = cArray;
            this.direction = (short)6;
        }

        public void setType(short s) {
            this.type = s;
        }

        public short getType() {
            return this.type;
        }

        public void setDirection(short s) {
            this.direction = s;
        }

        public short getDirection() {
            return this.direction;
        }

        public AttributeSet getAttributes() {
            return this.attributes;
        }

        public char[] getArray() {
            return this.content;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            switch (this.type) {
                case 1: {
                    cPStringBuilder.append("StartTag");
                    break;
                }
                case 2: {
                    cPStringBuilder.append("EndTag");
                    break;
                }
                case 3: {
                    cPStringBuilder.append("Content");
                    break;
                }
                default: {
                    cPStringBuilder.append("??");
                }
            }
            cPStringBuilder.append(':');
            switch (this.direction) {
                case 4: {
                    cPStringBuilder.append("JoinPrevious");
                    break;
                }
                case 5: {
                    cPStringBuilder.append("JoinNext");
                    break;
                }
                case 6: {
                    cPStringBuilder.append("Originate");
                    break;
                }
                case 7: {
                    cPStringBuilder.append("Fracture");
                    break;
                }
                default: {
                    cPStringBuilder.append("??");
                }
            }
            cPStringBuilder.append(':');
            cPStringBuilder.append(this.length);
            return cPStringBuilder.toString();
        }
    }

    public static class AttributeUndoableEdit
    extends AbstractUndoableEdit {
        protected AttributeSet copy;
        protected AttributeSet newAttributes;
        protected boolean isReplacing;
        protected Element element;

        public AttributeUndoableEdit(Element element, AttributeSet attributeSet, boolean bl) {
            this.element = element;
            this.newAttributes = attributeSet;
            this.isReplacing = bl;
            this.copy = element.getAttributes().copyAttributes();
        }

        public void undo() {
            super.undo();
            AttributeSet attributeSet = this.element.getAttributes();
            if (attributeSet instanceof MutableAttributeSet) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet;
                mutableAttributeSet.removeAttributes(attributeSet);
                mutableAttributeSet.addAttributes(this.copy);
            }
        }

        public void redo() {
            super.undo();
            AttributeSet attributeSet = this.element.getAttributes();
            if (attributeSet instanceof MutableAttributeSet) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet;
                if (this.isReplacing) {
                    mutableAttributeSet.removeAttributes(attributeSet);
                }
                mutableAttributeSet.addAttributes(this.newAttributes);
            }
        }
    }
}

