/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFormatter
extends JFormattedTextField.AbstractFormatter
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -355018354457785329L;
    boolean commitsOnValidEdit = false;
    boolean overwriteMode = true;
    boolean allowsInvalid = true;
    Class valueClass;

    @Override
    public void install(JFormattedTextField jFormattedTextField) {
        super.install(jFormattedTextField);
    }

    public boolean getCommitsOnValidEdit() {
        return this.commitsOnValidEdit;
    }

    public void setCommitsOnValidEdit(boolean bl) {
        this.commitsOnValidEdit = bl;
    }

    public boolean getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(boolean bl) {
        this.overwriteMode = bl;
    }

    public boolean getAllowsInvalid() {
        return this.allowsInvalid;
    }

    public void setAllowsInvalid(boolean bl) {
        this.allowsInvalid = bl;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class<?> clazz) {
        this.valueClass = clazz;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        Object object;
        String string2 = string;
        Class<Object> clazz = this.getValueClass();
        if (clazz == null && (object = this.getFormattedTextField()) != null) {
            clazz = ((JFormattedTextField)object).getValue().getClass();
        }
        if (clazz != null) {
            try {
                object = clazz.getConstructor(String.class);
                string2 = ((Constructor)object).newInstance(string);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                throw new ParseException(string, 0);
            }
        }
        return string2;
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return new FormatterDocumentFilter();
    }

    private class FormatterDocumentFilter
    extends DocumentFilter {
        private FormatterDocumentFilter() {
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            super.remove(filterBypass, n, n2);
            this.checkValidInput();
            this.commitIfAllowed();
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (DefaultFormatter.this.overwriteMode) {
                this.replace(filterBypass, n, string.length(), string, attributeSet);
            } else {
                super.insertString(filterBypass, n, string, attributeSet);
            }
            this.checkValidInput();
            this.commitIfAllowed();
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            super.replace(filterBypass, n, n2, string, attributeSet);
            this.checkValidInput();
            this.commitIfAllowed();
        }

        private void commitIfAllowed() {
            if (DefaultFormatter.this.commitsOnValidEdit) {
                try {
                    DefaultFormatter.this.getFormattedTextField().commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }

        private void checkValidInput() {
            block4: {
                JFormattedTextField jFormattedTextField = DefaultFormatter.this.getFormattedTextField();
                try {
                    Object object = DefaultFormatter.this.stringToValue(jFormattedTextField.getText());
                }
                catch (ParseException parseException) {
                    if (DefaultFormatter.this.allowsInvalid) break block4;
                    try {
                        jFormattedTextField.setText(DefaultFormatter.this.valueToString(jFormattedTextField.getValue()));
                    }
                    catch (ParseException parseException2) {
                        AssertionError assertionError = new AssertionError((Object)"values must be parseable");
                        ((Throwable)((Object)assertionError)).initCause(parseException2);
                        throw assertionError;
                    }
                }
            }
        }
    }
}

