/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class DefaultEditorKit
extends EditorKit {
    private static final long serialVersionUID = 9017245433028523428L;
    public static final String backwardAction = "caret-backward";
    public static final String beepAction = "beep";
    public static final String beginAction = "caret-begin";
    public static final String beginLineAction = "caret-begin-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String beginWordAction = "caret-begin-word";
    public static final String copyAction = "copy-to-clipboard";
    public static final String cutAction = "cut-to-clipboard";
    public static final String defaultKeyTypedAction = "default-typed";
    public static final String deleteNextCharAction = "delete-next";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String downAction = "caret-down";
    public static final String endAction = "caret-end";
    public static final String endLineAction = "caret-end-line";
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String endWordAction = "caret-end-word";
    public static final String forwardAction = "caret-forward";
    public static final String insertBreakAction = "insert-break";
    public static final String insertContentAction = "insert-content";
    public static final String insertTabAction = "insert-tab";
    public static final String nextWordAction = "caret-next-word";
    public static final String pageDownAction = "page-down";
    public static final String pageUpAction = "page-up";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String previousWordAction = "caret-previous-word";
    public static final String readOnlyAction = "set-read-only";
    public static final String selectAllAction = "select-all";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionDownAction = "selection-down";
    public static final String selectionEndAction = "selection-end";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionUpAction = "selection-up";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectWordAction = "select-word";
    public static final String upAction = "caret-up";
    public static final String writableAction = "set-writable";
    private static Action[] defaultActions = new Action[]{new BeepAction(), new CopyAction(), new CutAction(), new DefaultKeyTypedAction(), new InsertBreakAction(), new InsertContentAction(), new InsertTabAction(), new PasteAction(), new DeleteNextCharAction(), new DeletePrevCharAction(), new BeginLineAction(), new SelectionBeginLineAction(), new EndLineAction(), new SelectionEndLineAction(), new BackwardAction(), new SelectionBackwardAction(), new ForwardAction(), new SelectionForwardAction(), new UpAction(), new SelectionUpAction(), new DownAction(), new SelectionDownAction(), new NextWordAction(), new SelectionNextWordAction(), new PreviousWordAction(), new SelectionPreviousWordAction(), new BeginAction(), new SelectionBeginAction(), new EndAction(), new SelectionEndAction(), new BeginWordAction(), new SelectionBeginWordAction(), new EndWordAction(), new SelectionEndWordAction(), new SelectAllAction(), new SelectLineAction(), new SelectWordAction()};

    public Caret createCaret() {
        return new DefaultCaret();
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public void read(InputStream inputStream, Document document, int n) throws BadLocationException, IOException {
        this.read(new InputStreamReader(inputStream), document, n);
    }

    public void read(Reader reader, Document document, int n) throws BadLocationException, IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            cPStringBuilder.append(string);
            cPStringBuilder.append("\n");
        }
        document.insertString(n, cPStringBuilder.substring(0, cPStringBuilder.length() - 1), SimpleAttributeSet.EMPTY);
    }

    public void write(OutputStream outputStream, Document document, int n, int n2) throws BadLocationException, IOException {
        this.write(new OutputStreamWriter(outputStream), document, n, n2);
    }

    public void write(Writer writer, Document document, int n, int n2) throws BadLocationException, IOException {
        if (n < 0 || n > document.getLength()) {
            throw new BadLocationException("Tried to write to invalid location", n);
        }
        if (n + n2 > document.getLength()) {
            n2 = document.getLength() - n;
        }
        writer.write(document.getText(n, n2));
    }

    public static class InsertTabAction
    extends TextAction {
        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.replaceSelection("\t");
            }
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.replaceSelection("\n");
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null && jTextComponent.isEditable() && jTextComponent.isEnabled()) {
                char c;
                String string = actionEvent.getActionCommand();
                int n = actionEvent.getModifiers();
                if (string != null && string.length() > 0 && (n & 8) == 0 && (n & 2) == 0 && (c = string.charAt(0)) >= ' ' && c != '\u007f') {
                    jTextComponent.replaceSelection(string);
                }
            }
        }
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.paste();
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.cut();
            }
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    public static class BeepAction
    extends TextAction {
        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static class EndAction
    extends TextAction {
        EndAction() {
            super(DefaultEditorKit.endAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getDocument().getLength();
                Caret caret = jTextComponent.getCaret();
                caret.setDot(n);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class BeginAction
    extends TextAction {
        BeginAction() {
            super(DefaultEditorKit.beginAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                caret.setDot(0);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(0).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class BeginLineAction
    extends TextAction {
        BeginLineAction() {
            super(DefaultEditorKit.beginLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = Utilities.getRowStart(jTextComponent, jTextComponent.getCaretPosition());
                    if (n > -1) {
                        Caret caret = jTextComponent.getCaret();
                        caret.setDot(n);
                        caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class EndLineAction
    extends TextAction {
        EndLineAction() {
            super(DefaultEditorKit.endLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = Utilities.getRowEnd(jTextComponent, jTextComponent.getCaretPosition());
                    if (n > -1) {
                        Caret caret = jTextComponent.getCaret();
                        caret.setDot(n);
                        caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class DeleteNextCharAction
    extends TextAction {
        DeleteNextCharAction() {
            super(DefaultEditorKit.deleteNextCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getSelectionStart();
                    int n2 = jTextComponent.getSelectionEnd() - n;
                    if (n2 > 0) {
                        jTextComponent.getDocument().remove(n, n2);
                    } else if (n < jTextComponent.getDocument().getLength()) {
                        jTextComponent.getDocument().remove(n, 1);
                    }
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class DeletePrevCharAction
    extends TextAction {
        DeletePrevCharAction() {
            super(DefaultEditorKit.deletePrevCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getSelectionStart();
                    int n2 = jTextComponent.getSelectionEnd() - n;
                    if (n2 > 0) {
                        jTextComponent.getDocument().remove(n, n2);
                    } else if (n > 0) {
                        jTextComponent.getDocument().remove(--n, 1);
                        Caret caret = jTextComponent.getCaret();
                        caret.setDot(n);
                        caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class BackwardAction
    extends TextAction.HorizontalMovementAction {
        BackwardAction() {
            super(DefaultEditorKit.backwardAction, 7);
        }

        protected void actionPerformedImpl(Caret caret, int n) {
            caret.setDot(n);
        }
    }

    static class ForwardAction
    extends TextAction.HorizontalMovementAction {
        ForwardAction() {
            super(DefaultEditorKit.forwardAction, 3);
        }

        protected void actionPerformedImpl(Caret caret, int n) {
            caret.setDot(n);
        }
    }

    static class UpAction
    extends TextAction.VerticalMovementAction {
        UpAction() {
            super(DefaultEditorKit.upAction, 1);
        }

        protected void actionPerformedImpl(Caret caret, int n) {
            caret.setDot(n);
        }
    }

    static class DownAction
    extends TextAction.VerticalMovementAction {
        DownAction() {
            super(DefaultEditorKit.downAction, 5);
        }

        protected void actionPerformedImpl(Caret caret, int n) {
            caret.setDot(n);
        }
    }

    static class SelectionBackwardAction
    extends TextAction.HorizontalMovementAction {
        SelectionBackwardAction() {
            super(DefaultEditorKit.selectionBackwardAction, 7);
        }

        protected void actionPerformedImpl(Caret caret, int n) {
            caret.moveDot(n);
        }
    }

    static class SelectionForwardAction
    extends TextAction.HorizontalMovementAction {
        SelectionForwardAction() {
            super(DefaultEditorKit.selectionForwardAction, 3);
        }

        protected void actionPerformedImpl(Caret caret, int n) {
            caret.moveDot(n);
        }
    }

    static class SelectionUpAction
    extends TextAction.VerticalMovementAction {
        SelectionUpAction() {
            super(DefaultEditorKit.selectionUpAction, 1);
        }

        protected void actionPerformedImpl(Caret caret, int n) {
            caret.moveDot(n);
        }
    }

    static class SelectionDownAction
    extends TextAction.VerticalMovementAction {
        SelectionDownAction() {
            super(DefaultEditorKit.selectionDownAction, 5);
        }

        protected void actionPerformedImpl(Caret caret, int n) {
            caret.moveDot(n);
        }
    }

    static class SelectWordAction
    extends TextAction {
        SelectWordAction() {
            super(DefaultEditorKit.selectWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                try {
                    int n2 = Utilities.getWordStart(jTextComponent, n);
                    if (n == n2) {
                        caret.setDot(n2);
                        caret.moveDot(Utilities.getWordEnd(jTextComponent, n2));
                    } else {
                        int n3 = Utilities.getNextWord(jTextComponent, n);
                        int n4 = Utilities.getPreviousWord(jTextComponent, n);
                        int n5 = Utilities.getWordEnd(jTextComponent, n4);
                        if (n >= n5 && n <= n3) {
                            caret.setDot(n5);
                            caret.moveDot(n3);
                        } else {
                            caret.setDot(n4);
                            caret.moveDot(n5);
                        }
                    }
                    if (caret.getDot() != n) {
                        caret.setMagicCaretPosition(jTextComponent.modelToView(caret.getDot()).getLocation());
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class SelectLineAction
    extends TextAction {
        SelectLineAction() {
            super(DefaultEditorKit.selectLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowStart(jTextComponent, caret.getDot());
                    int n2 = Utilities.getRowEnd(jTextComponent, caret.getDot());
                    caret.setDot(n2);
                    caret.moveDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n2).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class SelectionEndLineAction
    extends TextAction {
        SelectionEndLineAction() {
            super(DefaultEditorKit.selectionEndLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowEnd(jTextComponent, caret.getDot());
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class SelectionBeginLineAction
    extends TextAction {
        SelectionBeginLineAction() {
            super(DefaultEditorKit.selectionBeginLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowStart(jTextComponent, caret.getDot());
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class SelectionEndAction
    extends TextAction {
        SelectionEndAction() {
            super(DefaultEditorKit.selectionEndAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getDocument().getLength();
                Caret caret = jTextComponent.getCaret();
                caret.moveDot(n);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class SelectionBeginAction
    extends TextAction {
        SelectionBeginAction() {
            super(DefaultEditorKit.selectionBeginAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                caret.moveDot(0);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(0).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class SelectAllAction
    extends TextAction {
        SelectAllAction() {
            super(DefaultEditorKit.selectAllAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getDocument().getLength();
                Caret caret = jTextComponent.getCaret();
                caret.setDot(0);
                caret.moveDot(n);
                try {
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class NextWordAction
    extends TextAction {
        NextWordAction() {
            super(DefaultEditorKit.nextWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getNextWord(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static class PreviousWordAction
    extends TextAction {
        PreviousWordAction() {
            super(DefaultEditorKit.previousWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getPreviousWord(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static class EndWordAction
    extends TextAction {
        EndWordAction() {
            super(DefaultEditorKit.endWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getWordEnd(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static class BeginWordAction
    extends TextAction {
        BeginWordAction() {
            super(DefaultEditorKit.beginWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getWordStart(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.setDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static class SelectionEndWordAction
    extends TextAction {
        SelectionEndWordAction() {
            super(DefaultEditorKit.selectionEndWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getWordEnd(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.moveDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static class SelectionBeginWordAction
    extends TextAction {
        SelectionBeginWordAction() {
            super(DefaultEditorKit.selectionBeginWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getWordStart(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.moveDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static class SelectionNextWordAction
    extends TextAction {
        SelectionNextWordAction() {
            super(DefaultEditorKit.selectionNextWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getNextWord(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.moveDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static class SelectionPreviousWordAction
    extends TextAction {
        SelectionPreviousWordAction() {
            super(DefaultEditorKit.selectionPreviousWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    int n = Utilities.getPreviousWord(jTextComponent, jTextComponent.getCaretPosition());
                    Caret caret = jTextComponent.getCaret();
                    caret.moveDot(n);
                    caret.setMagicCaretPosition(jTextComponent.modelToView(n).getLocation());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

