/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class ComponentView
extends View {
    private Component comp;
    private Interceptor interceptor;

    public ComponentView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        return StyleConstants.getComponent(this.getElement().getAttributes());
    }

    public float getAlignment(int n) {
        float f = 0.0f;
        if (this.interceptor != null && (n == 0 || n == 1)) {
            if (n == 0) {
                f = this.interceptor.getAlignmentX();
            } else if (n == 1) {
                f = this.interceptor.getAlignmentY();
            } else assert (false) : "Must not reach here";
        } else {
            f = super.getAlignment(n);
        }
        return f;
    }

    public final Component getComponent() {
        return this.comp;
    }

    public float getMaximumSpan(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis");
        }
        float f = 0.0f;
        if (this.interceptor != null) {
            if (n == 0) {
                f = this.interceptor.getMaximumSize().width;
            } else if (n == 1) {
                f = this.interceptor.getMaximumSize().height;
            } else assert (false) : "Must not reach here";
        }
        return f;
    }

    public float getMinimumSpan(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis");
        }
        float f = 0.0f;
        if (this.interceptor != null) {
            if (n == 0) {
                f = this.interceptor.getMinimumSize().width;
            } else if (n == 1) {
                f = this.interceptor.getMinimumSize().height;
            } else assert (false) : "Must not reach here";
        }
        return f;
    }

    public float getPreferredSpan(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis");
        }
        float f = 0.0f;
        if (this.interceptor != null) {
            if (n == 0) {
                f = this.interceptor.getPreferredSize().width;
            } else if (n == 1) {
                f = this.interceptor.getPreferredSize().height;
            } else assert (false) : "Must not reach here";
        }
        return f;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n <= n3) {
            Rectangle rectangle = shape.getBounds();
            if (n == n3) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        throw new BadLocationException("Illegal position", n);
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.interceptor != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.interceptor.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setParentImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Document document = ComponentView.this.getDocument();
                    try {
                        if (document instanceof AbstractDocument) {
                            ((AbstractDocument)document).readLock();
                        }
                        ComponentView.this.setParentImpl();
                        Container container = ComponentView.this.getContainer();
                        if (container != null) {
                            ComponentView.this.preferenceChanged(null, true, true);
                            container.repaint();
                        }
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (document instanceof AbstractDocument) {
                            ((AbstractDocument)document).readUnlock();
                        }
                        throw throwable;
                    }
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readUnlock();
                    }
                }
            });
        }
    }

    void setParentImpl() {
        Container container;
        View view = this.getParent();
        if (view != null) {
            Container container2 = this.getContainer();
            if (container2 != null) {
                Component component;
                if (this.interceptor == null && (component = this.createComponent()) != null) {
                    this.comp = component;
                    this.interceptor = new Interceptor(this.comp);
                }
                if (this.interceptor != null && this.interceptor.getParent() == null) {
                    container2.add((Component)this.interceptor, this);
                }
            }
        } else if (this.interceptor != null && (container = this.interceptor.getParent()) != null) {
            container.remove(this.interceptor);
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        int n;
        Rectangle rectangle = (Rectangle)shape;
        if (f < (float)(rectangle.x + rectangle.width / 2)) {
            biasArray[0] = Position.Bias.Forward;
            n = this.getStartOffset();
        } else {
            biasArray[0] = Position.Bias.Backward;
            n = this.getEndOffset();
        }
        return n;
    }

    private class Interceptor
    extends Container {
        Dimension min;
        Dimension pref;
        Dimension max;
        float alignX;
        float alignY;

        Interceptor(Component component) {
            this.setLayout(null);
            this.add(component);
            this.cacheComponentSizes();
        }

        public void invalidate() {
            super.invalidate();
            if (this.getParent() != null) {
                ComponentView.this.preferenceChanged(null, true, true);
            }
        }

        public void doLayout() {
            this.cacheComponentSizes();
        }

        public void reshape(int n, int n2, int n3, int n4) {
            super.reshape(n, n2, n3, n4);
            if (this.getComponentCount() > 0) {
                this.getComponent(0).setSize(n3, n4);
            }
            this.cacheComponentSizes();
        }

        public void show() {
            super.show();
            if (this.getComponentCount() > 0) {
                this.getComponent(0).setVisible(true);
            }
        }

        public void hide() {
            super.hide();
            if (this.getComponentCount() > 0) {
                this.getComponent(0).setVisible(false);
            }
        }

        public Dimension getMinimumSize() {
            this.maybeValidate();
            return this.min;
        }

        public Dimension getPreferredSize() {
            this.maybeValidate();
            return this.pref;
        }

        public Dimension getMaximumSize() {
            this.maybeValidate();
            return this.max;
        }

        public float getAlignmentX() {
            this.maybeValidate();
            return this.alignX;
        }

        public float getAlignmentY() {
            this.maybeValidate();
            return this.alignY;
        }

        private void maybeValidate() {
            if (!this.isValid()) {
                this.validate();
            }
        }

        private void cacheComponentSizes() {
            if (this.getComponentCount() > 0) {
                Component component = this.getComponent(0);
                this.min = component.getMinimumSize();
                this.pref = component.getPreferredSize();
                this.max = component.getMaximumSize();
                this.alignX = component.getAlignmentX();
                this.alignY = component.getAlignmentY();
            }
        }
    }
}

