/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BoxView
extends CompositeView {
    private int myAxis;
    private boolean[] layoutValid = new boolean[2];
    private boolean[] requirementsValid = new boolean[2];
    private int[][] spans = new int[2][];
    private int[][] offsets = new int[2][];
    private SizeRequirements[] requirements = new SizeRequirements[2];
    private int[] span = new int[2];
    private final Rectangle tmpRect = new Rectangle();
    private Rectangle clipRect = new Rectangle();

    public BoxView(Element element, int n) {
        super(element);
        this.myAxis = n;
        this.layoutValid[0] = false;
        this.layoutValid[1] = false;
        this.requirementsValid[0] = false;
        this.requirementsValid[1] = false;
        this.span[0] = 0;
        this.span[1] = 0;
        this.requirements[0] = new SizeRequirements();
        this.requirements[1] = new SizeRequirements();
        this.spans[0] = new int[0];
        this.spans[1] = new int[0];
        this.offsets[0] = new int[0];
        this.offsets[1] = new int[0];
    }

    public int getAxis() {
        return this.myAxis;
    }

    public void setAxis(int n) {
        boolean bl = n != this.myAxis;
        this.myAxis = n;
        if (bl) {
            this.preferenceChanged(null, true, true);
        }
    }

    public void layoutChanged(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis parameter.");
        }
        this.layoutValid[n] = false;
    }

    protected boolean isLayoutValid(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis parameter.");
        }
        return this.layoutValid[n];
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        View view = this.getView(n);
        view.paint(graphics, rectangle);
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        int n3 = viewArray != null ? viewArray.length : 0;
        int n4 = 1 - this.myAxis;
        this.offsets[this.myAxis] = this.replaceLayoutArray(this.offsets[this.myAxis], n, n3);
        this.spans[this.myAxis] = this.replaceLayoutArray(this.spans[this.myAxis], n, n3);
        this.layoutValid[this.myAxis] = false;
        this.requirementsValid[this.myAxis] = false;
        this.offsets[n4] = this.replaceLayoutArray(this.offsets[n4], n, n3);
        this.spans[n4] = this.replaceLayoutArray(this.spans[n4], n, n3);
        this.layoutValid[n4] = false;
        this.requirementsValid[n4] = false;
    }

    private int[] replaceLayoutArray(int[] nArray, int n, int n2) {
        int n3 = this.getViewCount();
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        System.arraycopy(nArray, n, nArray2, n + n2, n3 - n2 - n);
        return nArray2;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        rectangle = this.getInsideAllocation(rectangle);
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getView(i);
            this.tmpRect.setBounds(rectangle);
            this.childAllocation(i, this.tmpRect);
            if (!graphics.hitClip(this.tmpRect.x, this.tmpRect.y, this.tmpRect.width, this.tmpRect.height)) continue;
            this.paintChild(graphics, this.tmpRect, i);
        }
    }

    public float getPreferredSpan(int n) {
        this.updateRequirements(n);
        float f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[n].preferred + f;
    }

    public float getMaximumSpan(int n) {
        this.updateRequirements(n);
        float f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[n].maximum + f;
    }

    public float getMinimumSpan(int n) {
        this.updateRequirements(n);
        float f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[n].minimum + f;
    }

    protected SizeRequirements baselineRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.alignment = 0.5f;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.getViewCount();
        for (int i = 0; i < n8; ++i) {
            View view = this.getView(i);
            float f = view.getAlignment(n);
            int n9 = (int)view.getPreferredSpan(n);
            int n10 = (int)(f * (float)n9);
            int n11 = n9 - n10;
            n3 = Math.max(n10, n3);
            n6 = Math.max(n11, n6);
            if (view.getResizeWeight(n) > 0) {
                n9 = (int)view.getMinimumSpan(n);
                n10 = (int)(f * (float)n9);
                n11 = n9 - n10;
                n2 = Math.max(n10, n2);
                n5 = Math.max(n11, n5);
                n9 = (int)view.getMaximumSpan(n);
                n10 = (int)(f * (float)n9);
                n11 = n9 - n10;
                n4 = Math.max(n10, n4);
                n7 = Math.max(n11, n7);
                continue;
            }
            n2 = Math.max(n10, n2);
            n5 = Math.max(n11, n5);
            n4 = Math.max(n10, n4);
            n7 = Math.max(n11, n7);
        }
        sizeRequirements.preferred = (int)Math.min((long)n3 + (long)n6, Integer.MAX_VALUE);
        if (sizeRequirements.preferred > 0) {
            sizeRequirements.alignment = (float)n3 / (float)sizeRequirements.preferred;
        }
        if (sizeRequirements.alignment == 0.0f) {
            sizeRequirements.minimum = n5;
            sizeRequirements.maximum = n7;
        } else if (sizeRequirements.alignment == 1.0f) {
            sizeRequirements.minimum = n2;
            sizeRequirements.maximum = n4;
        } else {
            sizeRequirements.minimum = Math.max((int)((float)n2 / sizeRequirements.alignment), (int)((float)n5 / (1.0f - sizeRequirements.alignment)));
            sizeRequirements.maximum = Math.min((int)((float)n4 / sizeRequirements.alignment), (int)((float)n7 / (1.0f - sizeRequirements.alignment)));
        }
        return sizeRequirements;
    }

    protected void baselineLayout(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = (int)((float)n * this.getAlignment(n2));
        int n4 = n - n3;
        int n5 = this.getViewCount();
        for (int i = 0; i < n5; ++i) {
            int n6;
            View view = this.getView(i);
            float f = view.getAlignment(n2);
            if (view.getResizeWeight(n2) > 0) {
                int n7 = (int)view.getMinimumSpan(n2);
                int n8 = (int)view.getMaximumSpan(n2);
                if (f == 0.0f) {
                    n6 = Math.max(Math.min(n8, n4), n7);
                } else if (f == 1.0f) {
                    n6 = Math.max(Math.min(n8, n3), n7);
                } else {
                    int n9 = (int)Math.min((float)n3 / f, (float)n4 / (1.0f - f));
                    n6 = Math.max(Math.min(n8, n9), n7);
                }
            } else {
                n6 = (int)view.getPreferredSpan(n2);
            }
            nArray[i] = n3 - (int)((float)n6 * f);
            nArray2[i] = n6;
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = sizeRequirements;
        if (sizeRequirements2 == null) {
            sizeRequirements2 = new SizeRequirements();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            f += view.getMinimumSpan(n);
            f2 += view.getPreferredSpan(n);
            f3 += view.getMaximumSpan(n);
        }
        sizeRequirements2.minimum = (int)f;
        sizeRequirements2.preferred = (int)f2;
        sizeRequirements2.maximum = (int)f3;
        sizeRequirements2.alignment = 0.5f;
        return sizeRequirements2;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = sizeRequirements;
        if (sizeRequirements2 == null) {
            sizeRequirements2 = new SizeRequirements();
        }
        sizeRequirements2.minimum = 0;
        sizeRequirements2.preferred = 0;
        sizeRequirements2.maximum = Integer.MAX_VALUE;
        sizeRequirements2.alignment = 0.5f;
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            sizeRequirements2.minimum = Math.max((int)view.getMinimumSpan(n), sizeRequirements2.minimum);
            sizeRequirements2.preferred = Math.max((int)view.getPreferredSpan(n), sizeRequirements2.preferred);
            sizeRequirements2.maximum = Math.max((int)view.getMaximumSpan(n), sizeRequirements2.maximum);
        }
        return sizeRequirements2;
    }

    protected boolean isBefore(int n, int n2, Rectangle rectangle) {
        boolean bl = false;
        bl = this.myAxis == 0 ? n < rectangle.x : n2 < rectangle.y;
        return bl;
    }

    protected boolean isAfter(int n, int n2, Rectangle rectangle) {
        boolean bl = false;
        bl = this.myAxis == 0 ? n > rectangle.x + rectangle.width : n2 > rectangle.y + rectangle.height;
        return bl;
    }

    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        View view = null;
        int n3 = this.getViewCount();
        if (this.myAxis == 0) {
            if (n < rectangle.x + this.offsets[0][0]) {
                this.childAllocation(0, rectangle);
                view = this.getView(0);
            } else {
                for (int i = 0; i < n3 && view == null; ++i) {
                    if (n >= rectangle.x + this.offsets[0][i]) continue;
                    this.childAllocation(i - 1, rectangle);
                    view = this.getView(i - 1);
                }
            }
        } else if (n2 < rectangle.y + this.offsets[1][0]) {
            this.childAllocation(0, rectangle);
            view = this.getView(0);
        } else {
            for (int i = 0; i < n3 && view == null; ++i) {
                if (n2 >= rectangle.y + this.offsets[1][i]) continue;
                this.childAllocation(i - 1, rectangle);
                view = this.getView(i - 1);
            }
        }
        if (view == null) {
            this.childAllocation(n3 - 1, rectangle);
            view = this.getView(n3 - 1);
        }
        return view;
    }

    protected void childAllocation(int n, Rectangle rectangle) {
        rectangle.x += this.offsets[0][n];
        rectangle.y += this.offsets[1][n];
        rectangle.width = this.spans[0][n];
        rectangle.height = this.spans[1][n];
    }

    protected void layout(int n, int n2) {
        this.layoutAxis(0, n);
        this.layoutAxis(1, n2);
    }

    private void layoutAxis(int n, int n2) {
        if (this.span[n] != n2) {
            this.layoutValid[n] = false;
        }
        if (!this.layoutValid[n]) {
            this.span[n] = n2;
            this.updateRequirements(n);
            if (n == this.myAxis) {
                this.layoutMajorAxis(this.span[n], n, this.offsets[n], this.spans[n]);
            } else {
                this.layoutMinorAxis(this.span[n], n, this.offsets[n], this.spans[n]);
            }
            this.layoutValid[n] = true;
            int n3 = this.getViewCount();
            for (int i = 0; i < n3; ++i) {
                View view = this.getView(i);
                view.setSize(this.spans[0][i], this.spans[1][i]);
            }
        }
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        float f;
        long l = 0L;
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            nArray2[i] = (int)view.getPreferredSpan(n2);
            l += (long)nArray2[i];
        }
        long l2 = (long)n - l;
        float f2 = 0.0f;
        int[] nArray3 = null;
        if (l2 != 0L) {
            long l3 = 0L;
            nArray3 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                int n4;
                View view = this.getView(i);
                if (l2 < 0L) {
                    n4 = (int)view.getMinimumSpan(n2);
                    nArray3[i] = nArray2[i] - n4;
                } else {
                    n4 = (int)view.getMaximumSpan(n2);
                    nArray3[i] = n4 - nArray2[i];
                }
                l3 += (long)n4;
            }
            f = Math.abs(l3 - l);
            f2 = (float)l2 / f;
            f2 = Math.min(f2, 1.0f);
            f2 = Math.max(f2, -1.0f);
        }
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = n5;
            if (l2 != 0L) {
                f = f2 * (float)nArray3[i];
                int n6 = i;
                nArray2[n6] = nArray2[n6] + Math.round(f);
            }
            n5 = (int)Math.min((long)n5 + (long)nArray2[i], Integer.MAX_VALUE);
        }
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.getViewCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getView(i);
            int n4 = (int)view.getMaximumSpan(n2);
            if (n4 < n) {
                float f = view.getAlignment(n2);
                nArray[i] = (int)((float)(n - n4) * f);
                nArray2[i] = n4;
                continue;
            }
            int n5 = (int)view.getMinimumSpan(n2);
            nArray[i] = 0;
            nArray2[i] = Math.max(n5, n);
        }
    }

    protected boolean isAllocationValid() {
        return this.isLayoutValid(0) && this.isLayoutValid(1);
    }

    public int getWidth() {
        return this.span[0] + this.getLeftInset() + this.getRightInset();
    }

    public int getHeight() {
        return this.span[1] + this.getTopInset() + this.getBottomInset();
    }

    public void setSize(float f, float f2) {
        this.layout((int)(f - (float)this.getLeftInset() - (float)this.getRightInset()), (int)(f2 - (float)this.getTopInset() - (float)this.getBottomInset()));
    }

    protected int getSpan(int n, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        return this.spans[n][n2];
    }

    protected int getOffset(int n, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        return this.offsets[n][n2];
    }

    public float getAlignment(int n) {
        this.updateRequirements(n);
        return this.requirements[n].alignment;
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (bl) {
            this.layoutValid[0] = false;
            this.requirementsValid[0] = false;
        }
        if (bl2) {
            this.layoutValid[1] = false;
            this.requirementsValid[1] = false;
        }
        super.preferenceChanged(view, bl, bl2);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.modelToView(n, shape, bias);
    }

    public int getResizeWeight(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        this.updateRequirements(n);
        int n2 = 0;
        if (this.requirements[n].preferred != this.requirements[n].minimum || this.requirements[n].preferred != this.requirements[n].maximum) {
            n2 = 1;
        }
        return n2;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Shape shape2 = null;
        if (this.isAllocationValid() && shape != null) {
            shape2 = super.getChildAllocation(n, shape);
        }
        return shape2;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        boolean bl = this.isLayoutValid(this.myAxis);
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (bl && !this.isLayoutValid(this.myAxis)) {
            Container container = this.getContainer();
            if (shape != null && container != null) {
                int n = documentEvent.getOffset();
                int n2 = this.getViewIndexAtPosition(n);
                Rectangle rectangle = this.getInsideAllocation(shape);
                if (this.myAxis == 0) {
                    rectangle.x += this.offsets[this.myAxis][n2];
                    rectangle.width -= this.offsets[this.myAxis][n2];
                } else {
                    rectangle.y += this.offsets[this.myAxis][n2];
                    rectangle.height -= this.offsets[this.myAxis][n2];
                }
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.viewToModel(f, f2, shape, biasArray);
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        return super.flipEastAndWestAtEnds(n, bias);
    }

    private void updateRequirements(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Illegal axis: " + n);
        }
        if (!this.requirementsValid[n]) {
            this.requirements[n] = n == this.myAxis ? this.calculateMajorAxisRequirements(n, this.requirements[n]) : this.calculateMinorAxisRequirements(n, this.requirements[n]);
            this.requirementsValid[n] = true;
        }
    }
}

