/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LayoutQueue;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AsyncBoxView
extends View {
    private int majorAxis;
    private float topInset;
    private float bottomInset;
    private float leftInset;
    private boolean estimatedMajorSpan;
    private float rightInset;
    private ArrayList childStates;
    ChildState changing;
    ChildState minReq;
    ChildState prefReq;
    private boolean majorChanged;
    boolean minorChanged;
    float majorSpan;
    float minorSpan;
    private Runnable flushTask;
    protected ChildLocator locator;

    public AsyncBoxView(Element element, int n) {
        super(element);
        this.majorAxis = n;
        this.childStates = new ArrayList();
        this.flushTask = new FlushTask();
        this.locator = new ChildLocator();
        this.minorSpan = 32767.0f;
    }

    public int getMajorAxis() {
        return this.majorAxis;
    }

    public int getMinorAxis() {
        return this.majorAxis == 0 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getView(int n) {
        View view = null;
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            if (n >= 0 && n < this.childStates.size()) {
                ChildState childState = (ChildState)this.childStates.get(n);
                view = childState.getChildView();
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getViewCount() {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            return this.childStates.size();
        }
    }

    public int getViewIndex(int n, Position.Bias bias) {
        int n2;
        int n3 = -1;
        if (bias == Position.Bias.Backward) {
            n = Math.max(0, n - 1);
        }
        if ((n2 = this.childStates.size()) > 0) {
            for (int i = 0; i < n2; ++i) {
                View view = ((ChildState)this.childStates.get(i)).getChildView();
                if (view.getStartOffset() > n || view.getEndOffset() <= n) continue;
                n3 = i;
                break;
            }
        }
        return n3;
    }

    public float getTopInset() {
        return this.topInset;
    }

    public void setTopInset(float f) {
        this.topInset = f;
    }

    public float getBottomInset() {
        return this.bottomInset;
    }

    public void setBottomInset(float f) {
        this.bottomInset = f;
    }

    public float getLeftInset() {
        return this.leftInset;
    }

    public void setLeftInset(float f) {
        this.leftInset = f;
    }

    public float getRightInset() {
        return this.rightInset;
    }

    public void setRightInset(float f) {
        this.rightInset = f;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                viewArray[i] = viewFactory.create(element.getElement(i));
            }
            this.replace(0, 0, viewArray);
        }
    }

    protected float getInsetSpan(int n) {
        float f = n == 0 ? this.leftInset + this.rightInset : this.topInset + this.bottomInset;
        return f;
    }

    protected void setEstimatedMajorSpan(boolean bl) {
        this.estimatedMajorSpan = bl;
    }

    protected boolean getEstimatedMajorSpan() {
        return this.estimatedMajorSpan;
    }

    protected synchronized void minorRequirementChange(ChildState childState) {
        this.minorChanged = true;
    }

    protected void majorRequirementChange(ChildState childState, float f) {
        if (!this.estimatedMajorSpan) {
            this.majorSpan += f;
        }
        this.majorChanged = true;
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.getViewCount() == 0) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    public void setSize(float f, float f2) {
        float f3 = this.majorAxis == 0 ? f2 - this.getTopInset() - this.getBottomInset() : f - this.getLeftInset() - this.getRightInset();
        if (f3 != this.minorSpan) {
            this.minorSpan = f3;
            int n = this.getViewCount();
            LayoutQueue layoutQueue = this.getLayoutQueue();
            for (int i = 0; i < n; ++i) {
                ChildState childState = this.getChildState(i);
                childState.childSizeValid = false;
                layoutQueue.addTask(childState);
            }
            layoutQueue.addTask(this.flushTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n, int n2, View[] viewArray) {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            int n3;
            LayoutQueue layoutQueue = this.getLayoutQueue();
            for (n3 = 0; n3 < n2; ++n3) {
                this.childStates.remove(n);
            }
            for (n3 = viewArray.length - 1; n3 >= 0; --n3) {
                this.childStates.add(n, this.createChildState(viewArray[n3]));
            }
            if (viewArray.length != 0) {
                for (n3 = 0; n3 < viewArray.length; ++n3) {
                    ChildState childState = (ChildState)this.childStates.get(n3 + n);
                    childState.getChildView().setParent(this);
                    layoutQueue.addTask(childState);
                }
                layoutQueue.addTask(this.flushTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, Shape shape) {
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            this.locator.setAllocation(shape);
            this.locator.paintChildren(graphics);
        }
    }

    public float getPreferredSpan(int n) {
        float f;
        if (this.majorAxis == n) {
            f = this.majorSpan;
        } else if (this.prefReq != null) {
            View view = this.prefReq.getChildView();
            f = view.getPreferredSpan(n);
        } else {
            f = n == 0 ? this.getLeftInset() + this.getRightInset() + 30.0f : this.getTopInset() + this.getBottomInset() + 30.0f;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        ChildState childState;
        int n2 = this.getViewIndexAtPosition(n, bias);
        Shape shape2 = this.locator.getChildAllocation(n2, shape);
        ChildState childState2 = childState = this.getChildState(n2);
        synchronized (childState2) {
            View view = childState.getChildView();
            Shape shape3 = view.modelToView(n, shape2, bias);
            return shape3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        int n;
        Shape shape2;
        int n2;
        Object object = this.locator;
        synchronized (object) {
            n2 = this.locator.getViewIndexAtPoint(f, f2, shape);
            shape2 = this.locator.getChildAllocation(n2, shape);
        }
        Object object2 = object = this.getChildState(n2);
        synchronized (object2) {
            View view = ((ChildState)object).getChildView();
            n = view.viewToModel(f, f2, shape2, biasArray);
        }
        return n;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Shape shape2 = this.locator.getChildAllocation(n, shape);
        return shape2;
    }

    public float getMaximumSpan(int n) {
        float f = n == this.majorAxis ? this.getPreferredSpan(n) : 32767.0f;
        return f;
    }

    public float getMinimumSpan(int n) {
        float f;
        if (n == this.majorAxis) {
            f = this.getPreferredSpan(n);
        } else if (this.minReq != null) {
            View view = this.minReq.getChildView();
            f = view.getMinimumSpan(n);
        } else {
            f = n == 0 ? this.getLeftInset() + this.getRightInset() + 5.0f : this.getTopInset() + this.getBottomInset() + 5.0f;
        }
        return f;
    }

    public synchronized void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (view == null) {
            this.getParent().preferenceChanged(this, bl, bl2);
        } else {
            View view2;
            if (this.changing != null && (view2 = this.changing.getChildView()) == view) {
                this.changing.preferenceChanged(bl, bl2);
                return;
            }
            int n = this.getViewIndexAtPosition(view.getStartOffset(), Position.Bias.Forward);
            ChildState childState = this.getChildState(n);
            childState.preferenceChanged(bl, bl2);
            LayoutQueue layoutQueue = this.getLayoutQueue();
            layoutQueue.addTask(childState);
            layoutQueue.addTask(this.flushTask);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null) {
            int n = Math.max(elementChange.getIndex() - 1, 0);
            ChildState childState = this.getChildState(n);
            this.locator.childChanged(childState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChildState getChildState(int n) {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            return (ChildState)this.childStates.get(n);
        }
    }

    protected LayoutQueue getLayoutQueue() {
        return LayoutQueue.getDefaultQueue();
    }

    protected synchronized int getViewIndexAtPosition(int n, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            n = Math.max(0, n - 1);
        }
        Element element = this.getElement();
        return element.getElementIndex(n);
    }

    protected ChildState createChildState(View view) {
        return new ChildState(view);
    }

    protected synchronized void flushRequirementChanges() {
        View view;
        if ((this.majorChanged || this.minorChanged) && (view = this.getParent()) != null) {
            boolean bl;
            boolean bl2;
            if (this.majorAxis == 0) {
                bl2 = this.majorChanged;
                bl = this.minorChanged;
            } else {
                bl = this.majorChanged;
                bl2 = this.minorChanged;
            }
            view.preferenceChanged(this, bl2, bl);
            this.majorChanged = false;
            this.minorChanged = false;
            Container container = this.getContainer();
            if (container != null) {
                container.repaint();
            }
        }
    }

    private class FlushTask
    implements Runnable {
        private FlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Document document = AsyncBoxView.this.getDocument();
                if (document instanceof AbstractDocument) {
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readLock();
                }
                int n = AsyncBoxView.this.getViewCount();
                if (AsyncBoxView.this.minorChanged && n > 0) {
                    LayoutQueue layoutQueue = AsyncBoxView.this.getLayoutQueue();
                    ChildState childState = AsyncBoxView.this.getChildState(0);
                    ChildState childState2 = AsyncBoxView.this.getChildState(0);
                    for (int i = 1; i < n; ++i) {
                        ChildState childState3 = AsyncBoxView.this.getChildState(i);
                        if (childState3.minimum > childState.minimum) {
                            childState = childState3;
                        }
                        if (!(childState3.preferred > childState2.preferred)) continue;
                        childState2 = childState3;
                    }
                    AsyncBoxView asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.minReq = childState;
                        AsyncBoxView.this.prefReq = childState2;
                    }
                }
                AsyncBoxView.this.flushRequirementChanges();
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                Document document = AsyncBoxView.this.getDocument();
                if (document instanceof AbstractDocument) {
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readUnlock();
                }
                throw throwable;
            }
            Document document = AsyncBoxView.this.getDocument();
            if (document instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                abstractDocument.readUnlock();
            }
        }
    }

    public class ChildState
    implements Runnable {
        private View childView;
        private boolean minorValid;
        private boolean majorValid;
        boolean childSizeValid;
        float minimum;
        float preferred;
        private float majorSpan;
        private float majorOffset;
        private float minorSpan;
        private float minorOffset;
        private float maximum;

        public ChildState(View view) {
            this.childView = view;
        }

        public View getChildView() {
            return this.childView;
        }

        public boolean isLayoutValid() {
            return this.minorValid && this.majorValid && this.childSizeValid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            Document document = AsyncBoxView.this.getDocument();
            if (document instanceof AbstractDocument) {
                object = (AbstractDocument)document;
                ((AbstractDocument)object).readLock();
            }
            try {
                if (!(this.minorValid && this.majorValid && this.childSizeValid || this.childView.getParent() != AsyncBoxView.this)) {
                    object = AsyncBoxView.this;
                    synchronized (object) {
                        AsyncBoxView.this.changing = this;
                    }
                    this.update();
                    object = AsyncBoxView.this;
                    synchronized (object) {
                        AsyncBoxView.this.changing = null;
                    }
                    this.update();
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (document instanceof AbstractDocument) {
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readUnlock();
                }
                throw throwable;
            }
            if (document instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                abstractDocument.readUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            float f;
            int n = AsyncBoxView.this.getMajorAxis();
            boolean bl = false;
            ChildState childState = this;
            synchronized (childState) {
                if (!this.minorValid) {
                    int n2 = AsyncBoxView.this.getMinorAxis();
                    this.minimum = this.childView.getMinimumSpan(n2);
                    this.preferred = this.childView.getPreferredSpan(n2);
                    this.maximum = this.childView.getMaximumSpan(n2);
                    this.minorValid = true;
                    bl = true;
                }
            }
            if (bl) {
                AsyncBoxView.this.minorRequirementChange(this);
            }
            boolean bl2 = false;
            float f2 = 0.0f;
            ChildState childState2 = this;
            synchronized (childState2) {
                if (!this.majorValid) {
                    f = this.majorSpan;
                    this.majorSpan = this.childView.getPreferredSpan(n);
                    f2 = this.majorSpan - f;
                    this.majorValid = true;
                    bl2 = true;
                }
            }
            if (bl2) {
                AsyncBoxView.this.majorRequirementChange(this, f2);
                AsyncBoxView.this.locator.childChanged(this);
            }
            childState2 = this;
            synchronized (childState2) {
                if (!this.childSizeValid) {
                    float f3;
                    if (n == 0) {
                        f = this.majorSpan;
                        f3 = this.getMinorSpan();
                    } else {
                        f = this.getMinorSpan();
                        f3 = this.majorSpan;
                    }
                    this.childSizeValid = true;
                    this.childView.setSize(f, f3);
                }
            }
        }

        public float getMinorSpan() {
            float f = this.maximum < this.minorSpan ? this.maximum : Math.max(this.minimum, this.minorSpan);
            return f;
        }

        public float getMinorOffset() {
            float f;
            if (this.maximum < this.minorSpan) {
                float f2 = this.childView.getAlignment(AsyncBoxView.this.getMinorAxis());
                f = (this.minorSpan - this.maximum) * f2;
            } else {
                f = 0.0f;
            }
            return f;
        }

        public float getMajorSpan() {
            return this.majorSpan;
        }

        public float getMajorOffset() {
            return this.majorOffset;
        }

        public void setMajorOffset(float f) {
            this.majorOffset = f;
        }

        public void preferenceChanged(boolean bl, boolean bl2) {
            if (AsyncBoxView.this.getMajorAxis() == 0) {
                if (bl) {
                    this.majorValid = false;
                }
                if (bl2) {
                    this.minorValid = false;
                }
            } else {
                if (bl) {
                    this.minorValid = false;
                }
                if (bl2) {
                    this.majorValid = false;
                }
            }
            this.childSizeValid = false;
        }
    }

    public class ChildLocator {
        protected ChildState lastValidOffset;
        protected Rectangle lastAlloc = new Rectangle();
        protected Rectangle childAlloc = new Rectangle();

        public synchronized void childChanged(ChildState childState) {
            if (this.lastValidOffset == null || childState.getChildView().getStartOffset() < this.lastValidOffset.getChildView().getStartOffset()) {
                this.lastValidOffset = childState;
            }
        }

        public int getViewIndexAtPoint(float f, float f2, Shape shape) {
            this.setAllocation(shape);
            float f3 = AsyncBoxView.this.getMajorAxis() == 0 ? f - (float)this.lastAlloc.x : f2 - (float)this.lastAlloc.y;
            int n = this.getViewIndexAtVisualOffset(f3);
            return n;
        }

        public synchronized Shape getChildAllocation(int n, Shape shape) {
            if (shape == null) {
                return null;
            }
            this.setAllocation(shape);
            ChildState childState = AsyncBoxView.this.getChildState(n);
            if (childState.getChildView().getStartOffset() > this.lastValidOffset.getChildView().getStartOffset()) {
                this.updateChildOffsetsToIndex(n);
            }
            Shape shape2 = this.getChildAllocation(n);
            return shape2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void paintChildren(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            float f = AsyncBoxView.this.getMajorAxis() == 0 ? (float)(rectangle.x - this.lastAlloc.x) : (float)(rectangle.y - this.lastAlloc.y);
            int n = this.getViewIndexAtVisualOffset(f);
            int n2 = AsyncBoxView.this.getViewCount();
            float f2 = AsyncBoxView.this.getChildState(n).getMajorOffset();
            for (int i = n; i < n2; ++i) {
                ChildState childState = AsyncBoxView.this.getChildState(i);
                childState.setMajorOffset(f2);
                Shape shape = this.getChildAllocation(i);
                if (!shape.intersects(rectangle)) break;
                ChildState childState2 = childState;
                synchronized (childState2) {
                    View view = childState.getChildView();
                    view.paint(graphics, shape);
                }
                f2 += childState.getMajorSpan();
            }
        }

        protected Shape getChildAllocation(int n) {
            ChildState childState = AsyncBoxView.this.getChildState(n);
            if (!childState.isLayoutValid()) {
                childState.run();
            }
            if (AsyncBoxView.this.getMajorAxis() == 0) {
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMajorOffset();
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMinorOffset();
                this.childAlloc.width = (int)childState.getMajorSpan();
                this.childAlloc.height = (int)childState.getMinorSpan();
            } else {
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMajorOffset();
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMinorOffset();
                this.childAlloc.height = (int)childState.getMajorSpan();
                this.childAlloc.width = (int)childState.getMinorSpan();
            }
            return this.childAlloc;
        }

        protected void setAllocation(Shape shape) {
            if (shape instanceof Rectangle) {
                this.lastAlloc.setBounds((Rectangle)shape);
            } else {
                this.lastAlloc.setBounds(shape.getBounds());
            }
            AsyncBoxView.this.setSize(this.lastAlloc.width, this.lastAlloc.height);
        }

        protected int getViewIndexAtVisualOffset(float f) {
            int n = AsyncBoxView.this.getViewCount();
            if (n > 0) {
                if (this.lastValidOffset == null) {
                    this.lastValidOffset = AsyncBoxView.this.getChildState(0);
                }
                if (f > AsyncBoxView.this.majorSpan) {
                    return 0;
                }
                if (f > this.lastValidOffset.getMajorOffset()) {
                    return this.updateChildOffsets(f);
                }
                float f2 = 0.0f;
                for (int i = 0; i < n; ++i) {
                    ChildState childState = AsyncBoxView.this.getChildState(i);
                    float f3 = f2 + childState.getMajorSpan();
                    if (f < f3) {
                        return i;
                    }
                    f2 = f3;
                }
            }
            return n - 1;
        }

        private int updateChildOffsets(float f) {
            float f2;
            int n = AsyncBoxView.this.getViewCount();
            int n2 = n - 1;
            int n3 = this.lastValidOffset.getChildView().getStartOffset();
            int n4 = AsyncBoxView.this.getViewIndexAtPosition(n3, Position.Bias.Forward);
            float f3 = f2 = this.lastValidOffset.getMajorOffset();
            for (int i = n4; i < n; ++i) {
                ChildState childState = AsyncBoxView.this.getChildState(i);
                childState.setMajorOffset(f3);
                f3 += childState.getMajorSpan();
                if (!(f < f3)) continue;
                n2 = i;
                this.lastValidOffset = childState;
                break;
            }
            return n2;
        }

        private void updateChildOffsetsToIndex(int n) {
            int n2 = this.lastValidOffset.getChildView().getStartOffset();
            int n3 = AsyncBoxView.this.getViewIndexAtPosition(n2, Position.Bias.Forward);
            float f = this.lastValidOffset.getMajorOffset();
            for (int i = n3; i <= n; ++i) {
                ChildState childState = AsyncBoxView.this.getChildState(i);
                childState.setMajorOffset(f);
                f += childState.getMajorSpan();
            }
        }
    }
}

