/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JTableHeader
extends JComponent
implements TableColumnModelListener,
Accessible {
    private static final long serialVersionUID = 5144633983372967710L;
    protected TableColumnModel columnModel;
    protected TableColumn draggedColumn;
    protected int draggedDistance;
    boolean opaque;
    protected boolean reorderingAllowed;
    protected boolean resizingAllowed = true;
    protected TableColumn resizingColumn;
    protected JTable table;
    protected boolean updateTableInRealTime;
    TableCellRenderer cellRenderer;

    public JTableHeader() {
        this(null);
    }

    public JTableHeader(TableColumnModel tableColumnModel) {
        this.columnModel = tableColumnModel == null ? this.createDefaultColumnModel() : tableColumnModel;
        this.initializeLocalVars();
        this.updateUI();
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public TableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public TableColumn getResizingColumn() {
        return this.resizingColumn;
    }

    public JTable getTable() {
        return this.table;
    }

    public boolean getUpdateTableInRealTime() {
        return this.updateTableInRealTime;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        this.columnModel.removeColumnModelListener(this);
        this.columnModel = tableColumnModel;
        this.columnModel.addColumnModelListener(this);
    }

    public void setDraggedColumn(TableColumn tableColumn) {
        this.draggedColumn = tableColumn;
    }

    public void setDraggedDistance(int n) {
        this.draggedDistance = n;
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public void setReorderingAllowed(boolean bl) {
        this.reorderingAllowed = bl;
    }

    public void setResizingAllowed(boolean bl) {
        this.resizingAllowed = bl;
    }

    public void setResizingColumn(TableColumn tableColumn) {
        this.resizingColumn = tableColumn;
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void setUpdateTableInRealTime(boolean bl) {
        this.updateTableInRealTime = bl;
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new DefaultTableCellRenderer();
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.cellRenderer;
    }

    public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
        this.cellRenderer = tableCellRenderer;
    }

    public Rectangle getHeaderRect(int n) {
        Rectangle rectangle = this.getTable().getCellRect(-1, n, false);
        rectangle.height = this.getHeight();
        return rectangle;
    }

    protected String paramString() {
        return "JTableHeader";
    }

    public String getUIClassID() {
        return "TableHeaderUI";
    }

    public TableHeaderUI getUI() {
        return (TableHeaderUI)this.ui;
    }

    public void setUI(TableHeaderUI tableHeaderUI) {
        super.setUI(tableHeaderUI);
    }

    public void updateUI() {
        this.setUI((TableHeaderUI)UIManager.getUI(this));
    }

    public int columnAtPoint(Point point) {
        if (this.getBounds().contains(point)) {
            return this.columnModel.getColumnIndexAtX(point.x);
        }
        return -1;
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.resizeAndRepaint();
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    protected void initializeLocalVars() {
        this.accessibleContext = new AccessibleJTableHeader();
        this.draggedColumn = null;
        this.draggedDistance = 0;
        this.opaque = true;
        this.reorderingAllowed = true;
        this.resizingAllowed = true;
        this.resizingColumn = null;
        this.table = null;
        this.updateTableInRealTime = true;
        this.cellRenderer = this.createDefaultRenderer();
    }

    protected class AccessibleJTableHeader
    extends JComponent.AccessibleJComponent {
        protected AccessibleJTableHeader() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public int getAccessibleChildrenCount() {
            return JTableHeader.this.table.getColumnCount();
        }

        public Accessible getAccessibleChild(int n) {
            return new AccessibleJTableHeaderEntry(n, JTableHeader.this, JTableHeader.this.table);
        }

        public Accessible getAccessibleAt(Point point) {
            return this.getAccessibleChild(JTableHeader.this.columnAtPoint(point));
        }

        protected class AccessibleJTableHeaderEntry
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int columnIndex;
            private JTableHeader parent;
            private JTable table;

            public AccessibleJTableHeaderEntry(int n, JTableHeader jTableHeader, JTable jTable) {
                this.columnIndex = n;
                this.parent = jTableHeader;
                this.table = jTable;
            }

            Component getColumnHeaderRenderer() {
                TableColumn tableColumn = this.parent.getColumnModel().getColumn(this.columnIndex);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.parent.getDefaultRenderer();
                }
                return tableCellRenderer.getTableCellRendererComponent(this.table, tableColumn.headerValue, false, false, -1, this.columnIndex);
            }

            AccessibleContext getAccessibleColumnHeaderRenderer() {
                Component component = this.getColumnHeaderRenderer();
                if (component instanceof Accessible) {
                    return component.getAccessibleContext();
                }
                return null;
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.addFocusListener(focusListener);
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.contains(point);
                }
                return false;
            }

            public AccessibleAction getAccessibleAction() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext instanceof AccessibleAction) {
                    return (AccessibleAction)((Object)accessibleContext);
                }
                return null;
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getAccessibleAt(point);
                }
                return null;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return this.accessibleDescription;
            }

            public int getAccessibleIndexInParent() {
                return this.columnIndex;
            }

            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleName();
                }
                return this.accessibleName;
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return null;
            }

            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext instanceof AccessibleValue) {
                    return (AccessibleSelection)((Object)accessibleContext);
                }
                return null;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleStateSet();
                }
                return null;
            }

            public AccessibleText getAccessibleText() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleText();
                }
                return null;
            }

            public AccessibleValue getAccessibleValue() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext instanceof AccessibleValue) {
                    return (AccessibleValue)((Object)accessibleContext);
                }
                return null;
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getBackground();
                }
                return null;
            }

            public Rectangle getBounds() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getBounds();
                }
                return null;
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getCursor();
                }
                return null;
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getFont();
                }
                return null;
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getFontMetrics(font);
                }
                return null;
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getForeground();
                }
                return null;
            }

            public Locale getLocale() {
                Component component = this.getColumnHeaderRenderer();
                if (component != null) {
                    return component.getLocale();
                }
                return null;
            }

            public Point getLocation() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getLocation();
                }
                return null;
            }

            public Point getLocationOnScreen() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getLocationOnScreen();
                }
                return null;
            }

            public Dimension getSize() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.getSize();
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.isEnabled();
                }
                return false;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.isFocusTraversable();
                }
                return false;
            }

            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.isShowing();
                }
                return false;
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    return accessibleComponent.isVisible();
                }
                return false;
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.removeFocusListener(focusListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.requestFocus();
                }
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    this.accessibleDescription = string;
                }
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setBackground(color);
                }
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setBounds(rectangle);
                }
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setCursor(cursor);
                }
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setEnabled(bl);
                }
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setFont(font);
                }
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setForeground(color);
                }
            }

            public void setLocation(Point point) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setLocation(point);
                }
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setSize(dimension);
                }
            }

            public void setVisible(boolean bl) {
                AccessibleContext accessibleContext = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent != null) {
                    accessibleComponent.setVisible(bl);
                }
            }
        }
    }
}

