/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    private static final long serialVersionUID = 6580012493508960512L;
    protected Vector<TableColumn> tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;

    public DefaultTableColumnModel() {
        this.tableColumns = new Vector();
        this.selectionModel = this.createSelectionModel();
        this.selectionModel.addListSelectionListener(this);
        this.columnMargin = 1;
        this.columnSelectionAllowed = false;
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Null 'col' argument.");
        }
        this.tableColumns.add(tableColumn);
        tableColumn.addPropertyChangeListener(this);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.tableColumns.size() - 1));
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        if (n < 0) {
            return;
        }
        this.tableColumns.remove(tableColumn);
        this.fireColumnRemoved(new TableColumnModelEvent(this, n, 0));
        tableColumn.removePropertyChangeListener(this);
        this.invalidateWidthCache();
    }

    @Override
    public void moveColumn(int n, int n2) {
        int n3 = this.getColumnCount();
        if (n < 0 || n >= n3) {
            throw new IllegalArgumentException("Index 'i' out of range.");
        }
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("Index 'j' out of range.");
        }
        TableColumn tableColumn = this.tableColumns.remove(n);
        this.tableColumns.add(n2, tableColumn);
        this.fireColumnMoved(new TableColumnModelEvent(this, n, n2));
    }

    @Override
    public void setColumnMargin(int n) {
        this.columnMargin = n;
        this.fireColumnMarginChanged();
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.tableColumns.elements();
    }

    @Override
    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null identifier.");
        }
        int n = this.tableColumns.size();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.tableColumns.get(i);
            if (!object.equals(tableColumn.getIdentifier())) continue;
            return i;
        }
        throw new IllegalArgumentException("No TableColumn with that identifier.");
    }

    @Override
    public TableColumn getColumn(int n) {
        return this.tableColumns.get(n);
    }

    @Override
    public int getColumnMargin() {
        return this.columnMargin;
    }

    @Override
    public int getColumnIndexAtX(int n) {
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            int n2 = this.tableColumns.get(i).getWidth();
            if (0 <= n && n < n2) {
                return i;
            }
            n -= n2;
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException();
        }
        this.selectionModel.removeListSelectionListener(this);
        this.selectionModel = listSelectionModel;
        this.selectionModel.addListSelectionListener(this);
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        this.columnSelectionAllowed = bl;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public int[] getSelectedColumns() {
        ListSelectionModel listSelectionModel = this.selectionModel;
        int n = this.getSelectedColumnCount();
        int[] nArray = new int[n];
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        int n4 = 0;
        ArrayList arrayList = new ArrayList();
        if (n2 != -1 && n3 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    nArray[0] = n2;
                    break;
                }
                case 1: {
                    int n5 = n2;
                    while (n5 <= n3) {
                        nArray[n4++] = n5++;
                    }
                    break;
                }
                case 2: {
                    for (int i = n2; i <= n3; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        nArray[n4++] = i;
                    }
                    break;
                }
            }
        }
        return nArray;
    }

    @Override
    public int getSelectedColumnCount() {
        ListSelectionModel listSelectionModel = this.selectionModel;
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        int n3 = 0;
        if (n != -1 && n2 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = n2 - n + 1;
                    break;
                }
                case 2: {
                    for (int i = n; i <= n2; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        ++n3;
                    }
                    break;
                }
            }
        }
        return n3;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.add(TableColumnModelListener.class, tableColumnModelListener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.remove(TableColumnModelListener.class, tableColumnModelListener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        return (TableColumnModelListener[])this.listenerList.getListeners(TableColumnModelListener.class);
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        for (int i = 0; i < tableColumnModelListenerArray.length; ++i) {
            tableColumnModelListenerArray[i].columnAdded(tableColumnModelEvent);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        for (int i = 0; i < tableColumnModelListenerArray.length; ++i) {
            tableColumnModelListenerArray[i].columnRemoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        for (int i = 0; i < tableColumnModelListenerArray.length; ++i) {
            tableColumnModelListenerArray[i].columnMoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        EventListener[] eventListenerArray = this.getListeners(TableColumnModelListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((TableColumnModelListener)eventListenerArray[i]).columnSelectionChanged(listSelectionEvent);
        }
    }

    protected void fireColumnMarginChanged() {
        EventListener[] eventListenerArray = this.getListeners(TableColumnModelListener.class);
        if (this.changeEvent == null && eventListenerArray.length > 0) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((TableColumnModelListener)eventListenerArray[i]).columnMarginChanged(this.changeEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("width")) {
            this.invalidateWidthCache();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void recalcWidthCache() {
        if (this.totalColumnWidth == -1) {
            this.totalColumnWidth = 0;
            for (int i = 0; i < this.tableColumns.size(); ++i) {
                this.totalColumnWidth += this.tableColumns.get(i).getWidth();
            }
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }
}

