/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class MetalTreeUI
extends BasicTreeUI {
    private static final String LINE_STYLE_PROPERTY = "JTree.lineStyle";
    private static final String LINE_STYLE_VALUE_NONE = "None";
    private static final String LINE_STYLE_VALUE_ANGLED = "Angled";
    private static final String LINE_STYLE_VALUE_HORIZONTAL = "Horizontal";
    private static final int LINE_STYLE_NONE = 0;
    private static final int LINE_STYLE_ANGLED = 1;
    private static final int LINE_STYLE_HORIZONTAL = 2;
    private int lineStyle;
    private PropertyChangeListener lineStyleListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalTreeUI();
    }

    protected int getHorizontalLegBuffer() {
        return super.getHorizontalLegBuffer();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(LINE_STYLE_PROPERTY);
        this.decodeLineStyle(object);
        if (this.lineStyleListener == null) {
            this.lineStyleListener = new LineStyleListener();
        }
        jComponent.addPropertyChangeListener(this.lineStyleListener);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (this.lineStyleListener != null) {
            jComponent.removePropertyChangeListener(this.lineStyleListener);
        }
        this.lineStyleListener = null;
    }

    protected void decodeLineStyle(Object object) {
        this.lineStyle = object == null || object.equals(LINE_STYLE_VALUE_ANGLED) ? 1 : (object.equals(LINE_STYLE_VALUE_HORIZONTAL) ? 2 : (object.equals(LINE_STYLE_VALUE_NONE) ? 0 : 1));
    }

    protected boolean isLocationInExpandControl(int n, int n2, int n3, int n4) {
        return super.isLocationInExpandControl(this.tree.getPathForRow(n), n3, n4);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (this.lineStyle == 2) {
            this.paintHorizontalSeparators(graphics, jComponent);
        }
    }

    protected void paintHorizontalSeparators(Graphics graphics, JComponent jComponent) {
        graphics.setColor(UIManager.getColor("Tree.line"));
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y));
        int n2 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y + rectangle.height - 1));
        if (n >= 0 && n2 >= 0) {
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle2;
                TreePath treePath = this.getPathForRow(this.tree, i);
                if (treePath == null || treePath.getPathCount() != 2 || (rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i))) == null) continue;
                graphics.drawLine(rectangle.x, rectangle2.y, rectangle.x + rectangle.width, rectangle2.y);
            }
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (this.lineStyle == 1) {
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.lineStyle == 1) {
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        }
    }

    private class LineStyleListener
    implements PropertyChangeListener {
        private LineStyleListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(MetalTreeUI.LINE_STYLE_PROPERTY)) {
                MetalTreeUI.this.decodeLineStyle(propertyChangeEvent.getNewValue());
            }
        }
    }
}

