/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    JLabel title;

    public MetalInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectedTextColor = MetalLookAndFeel.getControlTextColor();
        this.selectedTitleColor = MetalLookAndFeel.getWindowTitleBackground();
        this.notSelectedTextColor = MetalLookAndFeel.getInactiveControlTextColor();
        this.notSelectedTitleColor = MetalLookAndFeel.getWindowTitleInactiveBackground();
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
        this.minIcon = MetalIconFactory.getInternalFrameAltMaximizeIcon(16);
        this.title = new JLabel(this.frame.getTitle(), MetalIconFactory.getInternalFrameDefaultMenuIcon(), 2);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectedTextColor = null;
        this.selectedTitleColor = null;
        this.notSelectedTextColor = null;
        this.notSelectedTitleColor = null;
        this.paletteCloseIcon = null;
        this.minIcon = null;
        this.title = null;
    }

    protected void createButtons() {
        super.createButtons();
        this.closeButton.setBorderPainted(false);
        this.closeButton.setContentAreaFilled(false);
        this.iconButton.setBorderPainted(false);
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setBorderPainted(false);
        this.maxButton.setContentAreaFilled(false);
    }

    protected void addSystemMenuItems(JMenu jMenu) {
    }

    protected void showSystemMenu() {
    }

    protected void addSubComponents() {
        this.add(this.title);
        this.add(this.closeButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
    }

    protected LayoutManager createLayout() {
        return new MetalTitlePaneLayout();
    }

    public void paintPalette(Graphics graphics) {
        Color color = graphics.getColor();
        Rectangle rectangle = SwingUtilities.getLocalBounds(this);
        if (UIManager.get("InternalFrame.activeTitleGradient") != null && this.frame.isSelected()) {
            MetalUtils.paintGradient(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 1, "InternalFrame.activeTitleGradient");
        }
        MetalUtils.fillMetalPattern(this, graphics, rectangle.x + 4, rectangle.y + 2, rectangle.width - this.paletteCloseIcon.getIconWidth() - 13, rectangle.height - 5, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getBlack());
        Dimension dimension = this.getSize();
        graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.setColor(color);
    }

    public void paintComponent(Graphics graphics) {
        Color color = graphics.getColor();
        if (this.isPalette) {
            this.paintPalette(graphics);
        } else {
            int n;
            this.paintTitleBackground(graphics);
            this.paintChildren(graphics);
            Dimension dimension = this.getSize();
            if (this.frame.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.drawLine(0, 0, 0, 0);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, 0);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            if (UIManager.get("InternalFrame.activeTitleGradient") != null && this.frame.isSelected()) {
                MetalUtils.paintGradient(graphics, 0, 0, this.getWidth(), this.getHeight(), 1, "InternalFrame.activeTitleGradient");
            }
            Rectangle rectangle = this.title.getBounds();
            int n2 = n = rectangle.x + rectangle.width + 5;
            if (this.iconButton.isVisible()) {
                n2 = Math.max(this.iconButton.getX(), n2);
            } else if (this.maxButton.isVisible()) {
                n2 = Math.max(this.maxButton.getX(), n2);
            } else if (this.closeButton.isVisible()) {
                n2 = Math.max(this.closeButton.getX(), n2);
            }
            if ((n2 -= 7) > n) {
                MetalUtils.fillMetalPattern(this, graphics, n, 3, n2 - n, this.getHeight() - 6, Color.white, Color.gray);
            }
        }
        graphics.setColor(color);
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
        this.title.setVisible(!this.isPalette);
        this.iconButton.setVisible(!this.isPalette && this.frame.isIconifiable());
        this.maxButton.setVisible(!this.isPalette && this.frame.isMaximizable());
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
        } else {
            this.closeButton.setIcon(this.closeIcon);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalInternalFrameTitlePanePropertyChangeHandler();
    }

    private class MetalTitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n2 = dimension.width - insets.left - insets.right;
            int n3 = dimension.height - insets.top - insets.bottom;
            int n4 = n2 - insets.right - 1;
            int n5 = insets.top + 2;
            int n6 = n3 - 4;
            if (MetalInternalFrameTitlePane.this.closeButton.isVisible()) {
                n = MetalInternalFrameTitlePane.this.closeIcon.getIconWidth();
                MetalInternalFrameTitlePane.this.closeButton.setBounds(n4 -= n + 2, n5, n, n6);
                n4 -= 6;
            }
            if (MetalInternalFrameTitlePane.this.maxButton.isVisible()) {
                n = MetalInternalFrameTitlePane.this.maxIcon.getIconWidth();
                MetalInternalFrameTitlePane.this.maxButton.setBounds(n4 -= n + 4, n5, n, n6);
            }
            if (MetalInternalFrameTitlePane.this.iconButton.isVisible()) {
                n = MetalInternalFrameTitlePane.this.minIcon.getIconWidth();
                MetalInternalFrameTitlePane.this.iconButton.setBounds(n4 -= n + 4, n5, n, n6);
                n4 -= 2;
            }
            Dimension dimension2 = MetalInternalFrameTitlePane.this.title.getPreferredSize();
            MetalInternalFrameTitlePane.this.title.setBounds(insets.left + 5, insets.top, Math.min(dimension2.width, n4 - insets.left - 10), n3);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            if (MetalInternalFrameTitlePane.this.isPalette) {
                return new Dimension(MetalInternalFrameTitlePane.this.paletteTitleHeight, MetalInternalFrameTitlePane.this.paletteTitleHeight);
            }
            return new Dimension(22, 22);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    class MetalInternalFrameTitlePanePropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        public MetalInternalFrameTitlePanePropertyChangeHandler() {
            super(MetalInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("frameIcon")) {
                MetalInternalFrameTitlePane.this.title.setIcon(MetalInternalFrameTitlePane.this.frame.getFrameIcon());
            } else if (string.equals("JInternalFrame.isPalette")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    MetalInternalFrameTitlePane.this.setPalette(true);
                } else {
                    MetalInternalFrameTitlePane.this.setPalette(false);
                }
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }
}

