/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    static final long serialVersionUID = 1463404307042803342L;
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler = new MouseHandler();
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    private Border border;
    transient int currentDividerLocation = 1;
    boolean centerOneTouchButtons;

    public BasicSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        this.setLayout(new DividerLayout());
        this.setBasicSplitPaneUI(basicSplitPaneUI);
        this.setDividerSize(this.splitPane.getDividerSize());
        this.centerOneTouchButtons = UIManager.getBoolean("SplitPane.centerOneTouchButtons");
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            this.removeMouseListener(this.mouseHandler);
            this.removeMouseMotionListener(this.mouseHandler);
            this.splitPane = null;
            this.hiddenDivider = null;
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (this.splitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
        }
        if (this.splitPane != null) {
            this.splitPane.addPropertyChangeListener(this);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
            this.hiddenDivider = this.splitPaneUI.getNonContinuousLayoutDivider();
            this.orientation = this.splitPane.getOrientation();
            if (this.splitPane.isOneTouchExpandable()) {
                this.oneTouchExpandableChanged();
            }
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        if (border != this.border) {
            Border border2 = this.border;
            this.border = border;
            this.firePropertyChange("border", border2, border);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.orientation == 1 ? new Dimension(this.getDividerSize(), 1) : new Dimension(1, this.getDividerSize());
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("oneTouchExpandable")) {
            this.oneTouchExpandableChanged();
        } else if (propertyChangeEvent.getPropertyName().equals("orientation")) {
            this.orientation = this.splitPane.getOrientation();
            this.invalidate();
            if (this.splitPane != null) {
                this.splitPane.revalidate();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("dividerSize")) {
            this.dividerSize = this.splitPane.getDividerSize();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.border != null) {
            Dimension dimension = this.getSize();
            this.border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable()) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new OneTouchAction());
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new OneTouchAction());
            }
            if (this.leftButton != null && this.rightButton != null) {
                this.add(this.leftButton);
                this.add(this.rightButton);
            }
        }
        this.invalidate();
        if (this.splitPane != null) {
            this.splitPane.revalidate();
        }
    }

    protected JButton createLeftOneTouchButton() {
        BasicOneTouchButton basicOneTouchButton = new BasicOneTouchButton(0);
        basicOneTouchButton.setMinimumSize(new Dimension(6, 6));
        basicOneTouchButton.setRequestFocusEnabled(false);
        return basicOneTouchButton;
    }

    protected JButton createRightOneTouchButton() {
        BasicOneTouchButton basicOneTouchButton = new BasicOneTouchButton(1);
        basicOneTouchButton.setMinimumSize(new Dimension(6, 6));
        basicOneTouchButton.setRequestFocusEnabled(false);
        return basicOneTouchButton;
    }

    protected void prepareForDragging() {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.startDragging();
        }
    }

    protected void dragDividerTo(int n) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.dragDividerTo(n);
        }
    }

    protected void finishDraggingTo(int n) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.finishDraggingTo(n);
        }
    }

    void moveDividerTo(int n) {
        Insets insets = this.splitPane.getInsets();
        switch (n) {
            case 1: {
                this.splitPane.setDividerLocation(this.splitPane.getLastDividerLocation());
                break;
            }
            case 0: {
                int n2 = this.orientation == 1 ? insets.left : insets.top;
                this.splitPane.setDividerLocation(n2);
                break;
            }
            case 2: {
                int n3 = this.orientation == 1 ? this.splitPane.getBounds().width - insets.right - this.dividerSize : this.splitPane.getBounds().height - insets.bottom - this.dividerSize;
                this.splitPane.setDividerLocation(n3);
            }
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        protected DividerLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (BasicSplitPaneDivider.this.leftButton != null && BasicSplitPaneDivider.this.rightButton != null && container == BasicSplitPaneDivider.this) {
                if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = BasicSplitPaneDivider.this.getInsets();
                    if (BasicSplitPaneDivider.this.orientation == 1) {
                        int n;
                        int n2;
                        int n3 = BasicSplitPaneDivider.this.getWidth() - insets.left - insets.right;
                        n3 = Math.max(n3, 0);
                        n3 = Math.min(n3, 6);
                        if (BasicSplitPaneDivider.this.centerOneTouchButtons) {
                            n2 = insets.top;
                            n = (BasicSplitPaneDivider.this.getWidth() - n3) / 2;
                        } else {
                            n = insets.left;
                            n2 = 0;
                        }
                        BasicSplitPaneDivider.this.leftButton.setBounds(n, n2 + 2, n3, n3 * 2);
                        BasicSplitPaneDivider.this.rightButton.setBounds(n, n2 + 2 + 12, n3, n3 * 2);
                    } else {
                        int n;
                        int n4;
                        int n5 = BasicSplitPaneDivider.this.getHeight() - insets.top - insets.bottom;
                        n5 = Math.max(n5, 0);
                        n5 = Math.min(n5, 6);
                        if (BasicSplitPaneDivider.this.centerOneTouchButtons) {
                            n4 = insets.left;
                            n = (BasicSplitPaneDivider.this.getHeight() - n5) / 2;
                        } else {
                            n4 = 0;
                            n = insets.top;
                        }
                        BasicSplitPaneDivider.this.leftButton.setBounds(n4 + 2, n, n5 * 2, n5);
                        BasicSplitPaneDivider.this.rightButton.setBounds(n4 + 2 + 12, n, n5 * 2, n5);
                    }
                } else {
                    BasicSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    BasicSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(BasicSplitPaneDivider.this.dividerSize, BasicSplitPaneDivider.this.dividerSize);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent mouseEvent) {
            super(mouseEvent);
            this.offset = mouseEvent.getY();
        }

        protected int getNeededLocation(int n, int n2) {
            return n2;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            return mouseEvent.getY() + BasicSplitPaneDivider.this.getY() - this.offset;
        }

        int adjust(int n, int n2) {
            return this.getNeededLocation(n, n2) + BasicSplitPaneDivider.this.getY() - this.offset;
        }
    }

    protected class DragController {
        transient int offset;

        protected DragController(MouseEvent mouseEvent) {
            this.offset = mouseEvent.getX();
        }

        protected boolean isValid() {
            return true;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            return mouseEvent.getX() + BasicSplitPaneDivider.this.getX() - this.offset;
        }

        protected int getNeededLocation(int n, int n2) {
            return n;
        }

        protected void continueDrag(int n, int n2) {
            if (this.isValid()) {
                BasicSplitPaneDivider.this.dragDividerTo(this.adjust(n, n2));
            }
        }

        protected void continueDrag(MouseEvent mouseEvent) {
            if (this.isValid()) {
                BasicSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(mouseEvent));
            }
        }

        protected void completeDrag(int n, int n2) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.adjust(n, n2));
        }

        protected void completeDrag(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
        }

        int adjust(int n, int n2) {
            return this.getNeededLocation(n, n2) + BasicSplitPaneDivider.this.getX() - this.offset;
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private transient boolean isDragging;

        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.isDragging = true;
            BasicSplitPaneDivider.this.currentDividerLocation = 1;
            BasicSplitPaneDivider.this.dragger = BasicSplitPaneDivider.this.orientation == 1 ? new DragController(mouseEvent) : new VerticalDragController(mouseEvent);
            BasicSplitPaneDivider.this.prepareForDragging();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isDragging) {
                BasicSplitPaneDivider.this.dragger.completeDrag(mouseEvent);
            }
            this.isDragging = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class OneTouchAction
    implements ActionListener {
        private OneTouchAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Insets insets = BasicSplitPaneDivider.this.splitPane.getInsets();
            int n = BasicSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int n2 = BasicSplitPaneDivider.this.splitPaneUI.getDividerLocation(BasicSplitPaneDivider.this.splitPane);
            int n3 = actionEvent.getSource() == BasicSplitPaneDivider.this.leftButton ? (BasicSplitPaneDivider.this.orientation == 0 ? (n2 >= BasicSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - BasicSplitPaneDivider.this.getHeight() ? Math.min(BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation(), n) : insets.top) : (n2 >= BasicSplitPaneDivider.this.splitPane.getWidth() - insets.right - BasicSplitPaneDivider.this.getWidth() ? Math.min(BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation(), n) : insets.left)) : (BasicSplitPaneDivider.this.orientation == 0 ? (n2 == insets.top ? Math.min(BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation(), n) : BasicSplitPaneDivider.this.splitPane.getHeight() - insets.top - BasicSplitPaneDivider.this.getHeight()) : (n2 == insets.left ? Math.min(BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation(), n) : BasicSplitPaneDivider.this.splitPane.getWidth() - insets.left - BasicSplitPaneDivider.this.getWidth()));
            if (n2 != n3) {
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(n3);
                BasicSplitPaneDivider.this.splitPane.setLastDividerLocation(n2);
            }
        }
    }

    private class BasicOneTouchButton
    extends JButton {
        static final int LEFT = 0;
        static final int RIGHT = 1;
        private int[] xpoints;
        private int[] ypoints;
        private int direction;

        BasicOneTouchButton(int n) {
            this.direction = n;
            this.xpoints = new int[3];
            this.ypoints = new int[3];
        }

        public void setBorder(Border border) {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics graphics) {
            if (BasicSplitPaneDivider.this.splitPane != null) {
                graphics.setColor(BasicSplitPaneDivider.this.splitPane.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.direction == 0) {
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int n = Math.min(this.getHeight(), 6);
                        this.xpoints[0] = 0;
                        this.xpoints[1] = n / 2;
                        this.xpoints[2] = n;
                        this.ypoints[0] = n;
                        this.ypoints[1] = 0;
                        this.ypoints[2] = n;
                    } else {
                        int n;
                        this.xpoints[0] = n = Math.min(this.getWidth(), 6);
                        this.xpoints[1] = 0;
                        this.xpoints[2] = n;
                        this.ypoints[0] = 0;
                        this.ypoints[1] = n / 2;
                        this.ypoints[2] = n;
                    }
                } else if (BasicSplitPaneDivider.this.orientation == 0) {
                    int n = Math.min(this.getHeight(), 6);
                    this.xpoints[0] = 0;
                    this.xpoints[1] = n / 2;
                    this.xpoints[2] = n;
                    this.ypoints[0] = 0;
                    this.ypoints[1] = n;
                    this.ypoints[2] = 0;
                } else {
                    int n = Math.min(this.getWidth(), 6);
                    this.xpoints[0] = 0;
                    this.xpoints[1] = n;
                    this.xpoints[2] = 0;
                    this.ypoints[0] = 0;
                    this.ypoints[1] = n / 2;
                    this.ypoints[2] = n;
                }
                graphics.setColor(Color.BLACK);
                graphics.fillPolygon(this.xpoints, this.ypoints, 3);
            }
        }
    }
}

